import { VariableContext } from "./VariableContext";
export declare class VariablesRepository {
    private readonly variablesIndexedByUuid;
    private readonly dataTypes;
    constructor(modelXml: string);
    get variables(): Map<string, VariableContext>;
    renameVariable(variableUuid: string, newName: string): void;
    addVariableToContext(variableUuid: string, variableName: string, parentUuid: string, childUuid?: string): void;
    removeVariable(variableUuid: string, removeChildren?: boolean): void;
    private loadVariables;
    private createDataTypes;
    private createVariables;
    private createVariablesFromInputData;
    private createVariablesFromBkm;
    private createVariablesFromDecision;
    private addVariable;
    private createVariableNode;
    private getTypeRef;
    private createDataType;
    private createInnerType;
    private buildProperties;
    private addLiteralExpression;
    private addInvocation;
    private addContext;
    private addContextEntry;
    private addFunctionDefinition;
    private addRelation;
    private addList;
    private addInnerExpression;
    private addInputVariable;
    private addInputVariableFromKnowledge;
}
//# sourceMappingURL=VariablesRepository.d.ts.map