"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParserHelper = void 0;
var antlr4_1 = require("antlr4");
var FEEL_1_1Parser_1 = require("./generated-parser/FEEL_1_1Parser");
var VariableSymbol_1 = require("./VariableSymbol");
var ScopeImpl_1 = require("./ScopeImpl");
var NameQueue_1 = require("./NameQueue");
var FeelVariable_1 = require("../FeelVariable");
var Scopes_1 = require("./Scopes");
var ReservedWords_1 = require("../ReservedWords");
var VariableType_1 = require("../VariableType");
var MapBackedType_1 = require("./MapBackedType");
var ParserHelper = (function () {
    function ParserHelper() {
        this.dynamicResolution = 0;
        this.scopes = new Scopes_1.Scopes();
        this.currentName = new NameQueue_1.NameQueue();
        this.currentName.push("<local>");
        this.currentScope = this.scopes.getGlobalScope();
        this._variables = new Array();
    }
    Object.defineProperty(ParserHelper.prototype, "variables", {
        get: function () {
            return this._variables;
        },
        enumerable: false,
        configurable: true
    });
    ParserHelper.prototype.pushScope = function (type) {
        this.currentScope = new ScopeImpl_1.ScopeImpl(this.currentName.peek(), this.currentScope, type);
    };
    ParserHelper.prototype.popScope = function () {
        var _a;
        this.currentScope = (_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.getParentScope();
    };
    ParserHelper.prototype.enableDynamicResolution = function () {
        this.dynamicResolution++;
    };
    ParserHelper.prototype.disableDynamicResolution = function () {
        if (this.dynamicResolution > 0) {
            this.dynamicResolution--;
        }
    };
    ParserHelper.prototype.isFeatDMN12EnhancedForLoopEnabled = function () {
        return true;
    };
    ParserHelper.prototype.startVariable = function (t) {
        var _a;
        (_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.start(t.text);
    };
    ParserHelper.prototype.popName = function () {
        this.currentName.pop();
    };
    ParserHelper.prototype.pushName = function (ctx) {
        if (ctx instanceof antlr4_1.ParserRuleContext) {
            this.currentName.push(this.getName(ctx));
        }
        else {
            this.currentName.push(ctx);
        }
    };
    ParserHelper.prototype.getName = function (ctx) {
        var key = this.getOriginalText(ctx);
        if (ctx instanceof FEEL_1_1Parser_1.KeyStringContext) {
            return key;
        }
        return key;
    };
    ParserHelper.prototype.defineVariable = function (variable, type, variableType) {
        var _a;
        var variableSymbol = new VariableSymbol_1.VariableSymbol(variable instanceof antlr4_1.ParserRuleContext ? this.getName(variable) : variable, type, variableType);
        (_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.define(variableSymbol);
    };
    ParserHelper.prototype.dismissScope = function () {
        var _a;
        if (((_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.getType()) != null && this.currentScope.getType() === undefined) {
            this.disableDynamicResolution();
        }
        this.popScope();
    };
    ParserHelper.prototype.recoverScope = function (name) {
        var e_1, _a;
        var _b, _c, _d;
        if (!name) {
            return;
        }
        var s = (_b = this.currentScope) === null || _b === void 0 ? void 0 : _b.getChildScopes().get(name);
        if (s != null) {
            this.currentScope = s;
        }
        else {
            var resolved = (_c = this.currentScope) === null || _c === void 0 ? void 0 : _c.resolve(name);
            var scopeType = resolved === null || resolved === void 0 ? void 0 : resolved.getType();
            if (resolved != null && scopeType instanceof MapBackedType_1.MapBackedType) {
                this.pushScope(scopeType);
                try {
                    for (var _e = __values(scopeType.properties), _f = _e.next(); !_f.done; _f = _e.next()) {
                        var f = _f.value;
                        (_d = this.currentScope) === null || _d === void 0 ? void 0 : _d.define(new VariableSymbol_1.VariableSymbol(f[0], f[1]));
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            else {
                this.pushScope();
            }
        }
    };
    ParserHelper.prototype.followUp = function (token, isPredict) {
        var _a, _b;
        var dynamicResolutionResult = this.isDynamicResolution();
        var follow = dynamicResolutionResult || ((_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.followUp(token.text, isPredict));
        if (dynamicResolutionResult && !isPredict) {
            (_b = this.currentScope) === null || _b === void 0 ? void 0 : _b.followUp(token.text, isPredict);
        }
        return follow !== null && follow !== void 0 ? follow : false;
    };
    ParserHelper.prototype.isDynamicResolution = function () {
        return this.dynamicResolution > 0;
    };
    ParserHelper.prototype.validateVariable = function (_n1, qn, name) {
        var _a, _b, _c, _d, _e;
        var start = _n1.start.start;
        var end = (_b = (_a = _n1.stop) === null || _a === void 0 ? void 0 : _a.stop) !== null && _b !== void 0 ? _b : 0;
        var length = end - start + 1;
        if ((_c = this.currentScope) === null || _c === void 0 ? void 0 : _c.getChildScopes().has(name)) {
            this.variables.push(new FeelVariable_1.FeelVariable(start, length, VariableType_1.VariableType.Input, name));
        }
        else {
            var symbol = (_d = this.currentScope) === null || _d === void 0 ? void 0 : _d.resolve(name);
            if (symbol) {
                if (symbol instanceof VariableSymbol_1.VariableSymbol) {
                    this.variables.push(new FeelVariable_1.FeelVariable(start, length, (_e = symbol.variableType) !== null && _e !== void 0 ? _e : VariableType_1.VariableType.Input, name));
                }
                else {
                    this.variables.push(new FeelVariable_1.FeelVariable(start, length, VariableType_1.VariableType.Input, name));
                }
            }
            else {
                if (!ReservedWords_1.ReservedWords.FeelFunctions.has(name) && !ReservedWords_1.ReservedWords.FeelKeywords.has(name)) {
                    this.variables.push(new FeelVariable_1.FeelVariable(start, length, VariableType_1.VariableType.Unknown, name));
                }
            }
        }
    };
    ParserHelper.prototype.getOriginalText = function (ctx) {
        var _a, _b;
        var a = ctx.start.start;
        var b = (_b = (_a = ctx.stop) === null || _a === void 0 ? void 0 : _a.stop) !== null && _b !== void 0 ? _b : 0;
        return ctx.start.getInputStream().getText(a, b);
    };
    ParserHelper.prototype.fphEnd = function (count) {
        return count;
    };
    ParserHelper.prototype.fphStart = function (_n1, param2) {
        return 0;
    };
    return ParserHelper;
}());
exports.ParserHelper = ParserHelper;
//# sourceMappingURL=ParserHelper.js.map