import { Scope } from "./Scope";
import { Type } from "./Type";
import { Symbol } from "./Symbol";
export declare class ScopeImpl implements Scope {
    private readonly name?;
    private readonly parentScope?;
    private readonly type?;
    private readonly childScopes;
    private readonly symbols;
    private tokenTree?;
    constructor(name?: string, parentScope?: Scope, type?: Type);
    addChildScope(scope: Scope): void;
    start(token: string): void;
    define(symbol: Symbol): boolean;
    tokenize(symbol: string): string[];
    followUp(token: string, isPredict: boolean): boolean;
    getChildScopes(): Map<string, Scope>;
    getName(): string;
    getParentScope(): Scope | undefined;
    getSymbols(): Map<string, Symbol>;
    getType(): Type | undefined;
    resolve(id: string): Symbol | undefined;
    resolve(qualifiedName: string[]): Symbol | undefined;
    private resolveId;
    private resolveQualifiedName;
    private initializeTokenTree;
    private tokenTreeFromSymbols;
}
//# sourceMappingURL=ScopeImpl.d.ts.map