"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DmnLanguageService = void 0;
var DmnDocumentData_1 = require("./DmnDocumentData");
var DmnDecision_1 = require("./DmnDecision");
var IMPORT = "import";
var INPUT_DATA = "inputData";
var XML_MIME = "text/xml";
var LOCATION_URI_ATTRIBUTE = "locationURI";
var DECISION_NAME_ATTRIBUTE = "name";
var NAMESPACE = "namespace";
var DMN_NAME = "name";
var DECISION = "decision";
var DEFINITIONS = "definitions";
var DmnLanguageService = (function () {
    function DmnLanguageService(args) {
        this.args = args;
        this.parser = new DOMParser();
        this.importTagRegExp = new RegExp("([a-z]*:)?(".concat(IMPORT, ")"));
        this.inputDataRegEx = new RegExp("([a-z]*:)?(".concat(INPUT_DATA, ")"));
        this.decisionsTagRegExp = new RegExp("([a-z]*:)?(".concat(DECISION, ")"));
        this.definitionsTagRegExp = new RegExp("([a-z]*:)?(".concat(DEFINITIONS, ")"));
    }
    DmnLanguageService.prototype.getImportedModelRelativePath = function (model) {
        var _a;
        var xmlContent = this.parser.parseFromString(model, XML_MIME);
        var importTag = this.importTagRegExp.exec(model);
        var importedModels = xmlContent.getElementsByTagName((_a = importTag === null || importTag === void 0 ? void 0 : importTag[0]) !== null && _a !== void 0 ? _a : IMPORT);
        return Array.from(importedModels)
            .map(function (importedModel) { return importedModel.getAttribute(LOCATION_URI_ATTRIBUTE); })
            .filter(function (e) { return e !== null; });
    };
    DmnLanguageService.prototype.getImportedModelRelativePaths = function (models) {
        var _this = this;
        if (Array.isArray(models)) {
            return models.flatMap(function (model) { return _this.getImportedModelRelativePath(model); });
        }
        return this.getImportedModelRelativePath(models);
    };
    DmnLanguageService.prototype.getPathFromNodeId = function (resourceContents, nodeId) {
        var e_1, _a, e_2, _b;
        var _c, _d, _e;
        try {
            for (var resourceContents_1 = __values(resourceContents), resourceContents_1_1 = resourceContents_1.next(); !resourceContents_1_1.done; resourceContents_1_1 = resourceContents_1.next()) {
                var resourceContent = resourceContents_1_1.value;
                var xmlContent = this.parser.parseFromString((_c = resourceContent.content) !== null && _c !== void 0 ? _c : "", XML_MIME);
                var inputDataTag = this.inputDataRegEx.exec((_d = resourceContent.content) !== null && _d !== void 0 ? _d : "");
                var inputs = xmlContent.getElementsByTagName((_e = inputDataTag === null || inputDataTag === void 0 ? void 0 : inputDataTag[0]) !== null && _e !== void 0 ? _e : INPUT_DATA);
                try {
                    for (var _f = (e_2 = void 0, __values(Array.from(inputs))), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var input = _g.value;
                        if (input.id === nodeId) {
                            return resourceContent.relativePath;
                        }
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (resourceContents_1_1 && !resourceContents_1_1.done && (_a = resourceContents_1.return)) _a.call(resourceContents_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return "";
    };
    DmnLanguageService.prototype.getDmnDocumentData = function (dmnContent) {
        var xmlContent = this.parser.parseFromString(dmnContent, XML_MIME);
        var definitionsTag = this.definitionsTagRegExp.exec(dmnContent);
        var definitions = xmlContent.getElementsByTagName(definitionsTag ? definitionsTag[0] : DEFINITIONS);
        var definition = definitions[0];
        var namespace = definition.getAttribute(NAMESPACE);
        var dmnModelName = definition.getAttribute(DMN_NAME);
        var dmnDecisions = this.decisionsTagRegExp.exec(dmnContent);
        var dmnDecisionsContent = xmlContent.getElementsByTagName(dmnDecisions ? dmnDecisions[0] : DECISION);
        var decisions = Array.from(dmnDecisionsContent)
            .map(function (decision) { return decision.getAttribute(DECISION_NAME_ATTRIBUTE); })
            .flatMap(function (decisionName) { return (decisionName ? [new DmnDecision_1.DmnDecision(decisionName)] : []); });
        return new DmnDocumentData_1.DmnDocumentData(namespace !== null && namespace !== void 0 ? namespace : "", dmnModelName !== null && dmnModelName !== void 0 ? dmnModelName : "", decisions);
    };
    DmnLanguageService.prototype.getAllImportedModelsResources = function (modelsContent) {
        return __awaiter(this, void 0, void 0, function () {
            var importedModelRelativePaths, importedModels, importedModelsContent, _a;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        importedModelRelativePaths = this.getImportedModelRelativePaths(modelsContent);
                        if (!(importedModelRelativePaths && importedModelRelativePaths.length > 0)) return [3, 4];
                        return [4, Promise.all(importedModelRelativePaths.map(function (importedModelRelativePath) {
                                return _this.args.getDmnImportedModel(importedModelRelativePath);
                            }))];
                    case 1:
                        importedModels = (_b.sent()).filter(function (e) { return e !== undefined; });
                        importedModelsContent = this.getImportedModelRelativePaths(importedModels.map(function (importedModel) { var _a; return (_a = importedModel.content) !== null && _a !== void 0 ? _a : ""; }));
                        if (!(importedModelsContent.length > 0)) return [3, 3];
                        _a = [__spreadArray([], __read(importedModels), false)];
                        return [4, this.getAllImportedModelsResources(importedModelsContent)];
                    case 2: return [2, __spreadArray.apply(void 0, _a.concat([__read.apply(void 0, [(_b.sent())]), false]))];
                    case 3: return [2, __spreadArray([], __read(importedModels), false)];
                    case 4: return [2, []];
                }
            });
        });
    };
    return DmnLanguageService;
}());
exports.DmnLanguageService = DmnLanguageService;
//# sourceMappingURL=DmnLanguageService.js.map