"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMarshaller = void 0;
var xml_parser_ts_1 = require("@kie-tools/xml-parser-ts");
var meta_1 = require("./schemas/dmn-1_0/ts-gen/meta");
var meta_2 = require("./schemas/dmn-1_1/ts-gen/meta");
var meta_3 = require("./schemas/dmn-1_2/ts-gen/meta");
var meta_4 = require("./schemas/dmn-1_3/ts-gen/meta");
var meta_5 = require("./schemas/dmn-1_4/ts-gen/meta");
var meta_6 = require("./schemas/dmn-1_5/ts-gen/meta");
require("./kie-extensions");
function getMarshaller(xml) {
    var domdoc = xml_parser_ts_1.domParser.getDomDocument(xml);
    var instanceNs = (0, xml_parser_ts_1.getInstanceNs)(domdoc);
    if (instanceNs.get(meta_1.ns.get("")) !== undefined) {
        var p_1 = (0, xml_parser_ts_1.getParser)({
            ns: meta_1.ns,
            meta: meta_1.meta,
            subs: meta_1.subs,
            elements: meta_1.elements,
            root: meta_1.root,
        });
        return {
            instanceNs: instanceNs,
            version: "1.0",
            root: meta_1.root,
            meta: meta_1.meta,
            parser: { parse: function () { return p_1.parse({ xml: xml, domdoc: domdoc, instanceNs: instanceNs }).json; } },
            builder: { build: function (json) { return p_1.build({ json: json, instanceNs: instanceNs }); } },
        };
    }
    else if (instanceNs.get(meta_2.ns.get("")) !== undefined) {
        var p_2 = (0, xml_parser_ts_1.getParser)({
            ns: meta_2.ns,
            meta: meta_2.meta,
            subs: meta_2.subs,
            elements: meta_2.elements,
            root: meta_2.root,
        });
        return {
            instanceNs: instanceNs,
            version: "1.1",
            root: meta_2.root,
            meta: meta_2.meta,
            parser: { parse: function () { return p_2.parse({ xml: xml, domdoc: domdoc, instanceNs: instanceNs }).json; } },
            builder: { build: function (json) { return p_2.build({ json: json, instanceNs: instanceNs }); } },
        };
    }
    else if (instanceNs.get(meta_3.ns.get("")) !== undefined) {
        var p_3 = (0, xml_parser_ts_1.getParser)({
            ns: meta_3.ns,
            meta: meta_3.meta,
            subs: meta_3.subs,
            elements: meta_3.elements,
            root: meta_3.root,
        });
        return {
            instanceNs: instanceNs,
            version: "1.2",
            root: meta_3.root,
            meta: meta_3.meta,
            parser: { parse: function () { return p_3.parse({ xml: xml, domdoc: domdoc, instanceNs: instanceNs }).json; } },
            builder: { build: function (json) { return p_3.build({ json: json, instanceNs: instanceNs }); } },
        };
    }
    else if (instanceNs.get(meta_4.ns.get("")) !== undefined) {
        var p_4 = (0, xml_parser_ts_1.getParser)({
            ns: meta_4.ns,
            meta: meta_4.meta,
            subs: meta_4.subs,
            elements: meta_4.elements,
            root: meta_4.root,
        });
        return {
            instanceNs: instanceNs,
            version: "1.3",
            root: meta_4.root,
            meta: meta_4.meta,
            parser: { parse: function () { return p_4.parse({ xml: xml, domdoc: domdoc, instanceNs: instanceNs }).json; } },
            builder: { build: function (json) { return p_4.build({ json: json, instanceNs: instanceNs }); } },
        };
    }
    else if (instanceNs.get(meta_5.ns.get("")) !== undefined) {
        var p_5 = (0, xml_parser_ts_1.getParser)({
            ns: meta_5.ns,
            meta: meta_5.meta,
            subs: meta_5.subs,
            elements: meta_5.elements,
            root: meta_5.root,
        });
        return {
            instanceNs: instanceNs,
            version: "1.4",
            root: meta_5.root,
            meta: meta_5.meta,
            parser: { parse: function () { return p_5.parse({ xml: xml, domdoc: domdoc, instanceNs: instanceNs }).json; } },
            builder: { build: function (json) { return p_5.build({ json: json, instanceNs: instanceNs }); } },
        };
    }
    else if (instanceNs.get(meta_6.ns.get("")) !== undefined) {
        var p_6 = (0, xml_parser_ts_1.getParser)({
            ns: meta_6.ns,
            meta: meta_6.meta,
            subs: meta_6.subs,
            elements: meta_6.elements,
            root: meta_6.root,
        });
        return {
            instanceNs: instanceNs,
            version: "1.5",
            root: meta_6.root,
            meta: meta_6.meta,
            parser: { parse: function () { return p_6.parse({ xml: xml, domdoc: domdoc, instanceNs: instanceNs }).json; } },
            builder: { build: function (json) { return p_6.build({ json: json, instanceNs: instanceNs }); } },
        };
    }
    else {
        throw new Error("Unknown version declared for DMN. Instance NS --> '".concat(JSON.stringify(__spreadArray([], __read(instanceNs.entries()), false)), "'."));
    }
}
exports.getMarshaller = getMarshaller;
//# sourceMappingURL=index.js.map