"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.meta = exports.elements = exports.subs = exports.ns = exports.root = void 0;
exports.root = {
    element: "definitions",
    type: "DMN12__tDefinitions"
};
exports.ns = new Map([
    ["http://www.omg.org/spec/DMN/20180521/MODEL/", ""],
    ["", "http://www.omg.org/spec/DMN/20180521/MODEL/"],
    ["http://www.omg.org/spec/DMN/20180521/DMNDI/", "dmndi:"],
    ["dmndi:", "http://www.omg.org/spec/DMN/20180521/DMNDI/"],
    ["http://www.omg.org/spec/DMN/20180521/DC/", "dc:"],
    ["dc:", "http://www.omg.org/spec/DMN/20180521/DC/"],
    ["http://www.omg.org/spec/DMN/20180521/DI/", "di:"],
    ["di:", "http://www.omg.org/spec/DMN/20180521/DI/"],
]);
exports.subs = {
    "": {
        "namedElement": "DMNElement",
        "informationRequirement": "DMNElement",
        "knowledgeRequirement": "DMNElement",
        "authorityRequirement": "DMNElement",
        "artifact": "DMNElement",
        "contextEntry": "DMNElement",
        "definitions": "namedElement",
        "import": "namedElement",
        "elementCollection": "namedElement",
        "drgElement": "namedElement",
        "itemDefinition": "namedElement",
        "informationItem": "namedElement",
        "decision": "drgElement",
        "invocable": "drgElement",
        "inputData": "drgElement",
        "knowledgeSource": "drgElement",
        "performanceIndicator": "businessContextElement",
        "organizationUnit": "businessContextElement",
        "businessKnowledgeModel": "invocable",
        "decisionService": "invocable",
        "literalExpression": "expression",
        "invocation": "expression",
        "decisionTable": "expression",
        "context": "expression",
        "functionDefinition": "expression",
        "relation": "expression",
        "list": "expression",
        "textAnnotation": "artifact",
        "association": "artifact",
    },
    "dmndi:": {
        "dmndi:DMNShape": "dmndi:DMNDiagramElement",
        "dmndi:DMNEdge": "dmndi:DMNDiagramElement",
        "dmndi:DMNStyle": "di:Style",
    },
    "dc:": {},
    "di:": {},
};
exports.elements = {
    "DMNElement": "DMN12__tDMNElement",
    "namedElement": "DMN12__tNamedElement",
    "definitions": "DMN12__tDefinitions",
    "import": "DMN12__tImport",
    "elementCollection": "DMN12__tElementCollection",
    "drgElement": "DMN12__tDRGElement",
    "decision": "DMN12__tDecision",
    "businessContextElement": "DMN12__tBusinessContextElement",
    "performanceIndicator": "DMN12__tPerformanceIndicator",
    "organizationUnit": "DMN12__tOrganizationUnit",
    "invocable": "DMN12__tInvocable",
    "businessKnowledgeModel": "DMN12__tBusinessKnowledgeModel",
    "inputData": "DMN12__tInputData",
    "knowledgeSource": "DMN12__tKnowledgeSource",
    "informationRequirement": "DMN12__tInformationRequirement",
    "knowledgeRequirement": "DMN12__tKnowledgeRequirement",
    "authorityRequirement": "DMN12__tAuthorityRequirement",
    "expression": "DMN12__tExpression",
    "itemDefinition": "DMN12__tItemDefinition",
    "literalExpression": "DMN12__tLiteralExpression",
    "invocation": "DMN12__tInvocation",
    "informationItem": "DMN12__tInformationItem",
    "decisionTable": "DMN12__tDecisionTable",
    "artifact": "DMN12__tArtifact",
    "textAnnotation": "DMN12__tTextAnnotation",
    "association": "DMN12__tAssociation",
    "context": "DMN12__tContext",
    "contextEntry": "DMN12__tContextEntry",
    "functionDefinition": "DMN12__tFunctionDefinition",
    "relation": "DMN12__tRelation",
    "list": "DMN12__tList",
    "decisionService": "DMN12__tDecisionService",
    "dmndi:DMNDI": "DMNDI12__DMNDI",
    "dmndi:DMNDiagram": "DMNDI12__DMNDiagram",
    "dmndi:DMNDiagramElement": "DMNDI12__DiagramElement",
    "dmndi:DMNShape": "DMNDI12__DMNShape",
    "dmndi:DMNEdge": "DMNDI12__DMNEdge",
    "dmndi:DMNStyle": "DMNDI12__DMNStyle",
    "dmndi:DMNLabel": "DMNDI12__DMNLabel",
    "dmndi:DMNDecisionServiceDividerLine": "DMNDI12__DMNDecisionServiceDividerLine",
    "dc:Color": "DC__Color",
    "dc:Point": "DC__Point",
    "dc:Bounds": "DC__Bounds",
    "dc:Dimension": "DC__Dimension",
    "di:Style": "DI__Style",
};
exports.meta = {
    "DMN12__tDMNElement__extensionElements": {},
    "DMN12__tDMNElement": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tDMNElement__extensionElements", isArray: false },
    },
    "DMN12__tNamedElement__extensionElements": {},
    "DMN12__tNamedElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tNamedElement__extensionElements", isArray: false },
    },
    "DMN12__tDMNElementReference": {
        "@_href": { type: "string", isArray: false },
    },
    "DMN12__tDefinitions__extensionElements": {},
    "DMN12__tDefinitions": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "@_typeLanguage": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_exporter": { type: "string", isArray: false },
        "@_exporterVersion": { type: "string", isArray: false },
        "import": { type: "DMN12__tImport", isArray: true },
        "itemDefinition": { type: "DMN12__tItemDefinition", isArray: true },
        "drgElement": { type: "DMN12__tDRGElement", isArray: true },
        "artifact": { type: "DMN12__tArtifact", isArray: true },
        "elementCollection": { type: "DMN12__tElementCollection", isArray: true },
        "businessContextElement": { type: "DMN12__tBusinessContextElement", isArray: true },
        "dmndi:DMNDI": { type: "DMNDI12__DMNDI", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tDefinitions__extensionElements", isArray: false },
    },
    "DMN12__tImport__extensionElements": {},
    "DMN12__tImport": {
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tImport__extensionElements", isArray: false },
    },
    "DMN12__tElementCollection__extensionElements": {},
    "DMN12__tElementCollection": {
        "drgElement": { type: "DMN12__tDMNElementReference", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tElementCollection__extensionElements", isArray: false },
    },
    "DMN12__tDRGElement__extensionElements": {},
    "DMN12__tDRGElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tDRGElement__extensionElements", isArray: false },
    },
    "DMN12__tDecision__extensionElements": {},
    "DMN12__tDecision": {
        "question": { type: "string", isArray: false },
        "allowedAnswers": { type: "string", isArray: false },
        "variable": { type: "DMN12__tInformationItem", isArray: false },
        "informationRequirement": { type: "DMN12__tInformationRequirement", isArray: true },
        "knowledgeRequirement": { type: "DMN12__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "DMN12__tAuthorityRequirement", isArray: true },
        "supportedObjective": { type: "DMN12__tDMNElementReference", isArray: true },
        "impactedPerformanceIndicator": { type: "DMN12__tDMNElementReference", isArray: true },
        "decisionMaker": { type: "DMN12__tDMNElementReference", isArray: true },
        "decisionOwner": { type: "DMN12__tDMNElementReference", isArray: true },
        "usingProcess": { type: "DMN12__tDMNElementReference", isArray: true },
        "usingTask": { type: "DMN12__tDMNElementReference", isArray: true },
        "expression": { type: "DMN12__tExpression", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tDecision__extensionElements", isArray: false },
    },
    "DMN12__tBusinessContextElement__extensionElements": {},
    "DMN12__tBusinessContextElement": {
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tBusinessContextElement__extensionElements", isArray: false },
    },
    "DMN12__tPerformanceIndicator__extensionElements": {},
    "DMN12__tPerformanceIndicator": {
        "impactingDecision": { type: "DMN12__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tPerformanceIndicator__extensionElements", isArray: false },
    },
    "DMN12__tOrganizationUnit__extensionElements": {},
    "DMN12__tOrganizationUnit": {
        "decisionMade": { type: "DMN12__tDMNElementReference", isArray: true },
        "decisionOwned": { type: "DMN12__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tOrganizationUnit__extensionElements", isArray: false },
    },
    "DMN12__tInvocable__extensionElements": {},
    "DMN12__tInvocable": {
        "variable": { type: "DMN12__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tInvocable__extensionElements", isArray: false },
    },
    "DMN12__tBusinessKnowledgeModel__extensionElements": {},
    "DMN12__tBusinessKnowledgeModel": {
        "encapsulatedLogic": { type: "DMN12__tFunctionDefinition", isArray: false },
        "knowledgeRequirement": { type: "DMN12__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "DMN12__tAuthorityRequirement", isArray: true },
        "variable": { type: "DMN12__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tBusinessKnowledgeModel__extensionElements", isArray: false },
    },
    "DMN12__tInputData__extensionElements": {},
    "DMN12__tInputData": {
        "variable": { type: "DMN12__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tInputData__extensionElements", isArray: false },
    },
    "DMN12__tKnowledgeSource__extensionElements": {},
    "DMN12__tKnowledgeSource": {
        "@_locationURI": { type: "string", isArray: false },
        "authorityRequirement": { type: "DMN12__tAuthorityRequirement", isArray: true },
        "type": { type: "string", isArray: false },
        "owner": { type: "DMN12__tDMNElementReference", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tKnowledgeSource__extensionElements", isArray: false },
    },
    "DMN12__tInformationRequirement__extensionElements": {},
    "DMN12__tInformationRequirement": {
        "requiredDecision": { type: "DMN12__tDMNElementReference", isArray: false },
        "requiredInput": { type: "DMN12__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tInformationRequirement__extensionElements", isArray: false },
    },
    "DMN12__tKnowledgeRequirement__extensionElements": {},
    "DMN12__tKnowledgeRequirement": {
        "requiredKnowledge": { type: "DMN12__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tKnowledgeRequirement__extensionElements", isArray: false },
    },
    "DMN12__tAuthorityRequirement__extensionElements": {},
    "DMN12__tAuthorityRequirement": {
        "requiredDecision": { type: "DMN12__tDMNElementReference", isArray: false },
        "requiredInput": { type: "DMN12__tDMNElementReference", isArray: false },
        "requiredAuthority": { type: "DMN12__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tAuthorityRequirement__extensionElements", isArray: false },
    },
    "DMN12__tExpression__extensionElements": {},
    "DMN12__tExpression": {
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tExpression__extensionElements", isArray: false },
    },
    "DMN12__tItemDefinition__extensionElements": {},
    "DMN12__tItemDefinition": {
        "@_typeLanguage": { type: "string", isArray: false },
        "@_isCollection": { type: "boolean", isArray: false },
        "itemComponent": { type: "DMN12__tItemDefinition", isArray: true },
        "typeRef": { type: "string", isArray: false },
        "allowedValues": { type: "DMN12__tUnaryTests", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tItemDefinition__extensionElements", isArray: false },
    },
    "DMN12__tLiteralExpression__extensionElements": {},
    "DMN12__tLiteralExpression": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "importedValues": { type: "DMN12__tImportedValues", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tLiteralExpression__extensionElements", isArray: false },
    },
    "DMN12__tInvocation__extensionElements": {},
    "DMN12__tInvocation": {
        "expression": { type: "DMN12__tExpression", isArray: false },
        "binding": { type: "DMN12__tBinding", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tInvocation__extensionElements", isArray: false },
    },
    "DMN12__tBinding": {
        "parameter": { type: "DMN12__tInformationItem", isArray: false },
        "expression": { type: "DMN12__tExpression", isArray: false },
    },
    "DMN12__tInformationItem__extensionElements": {},
    "DMN12__tInformationItem": {
        "@_typeRef": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tInformationItem__extensionElements", isArray: false },
    },
    "DMN12__tDecisionTable__extensionElements": {},
    "DMN12__tDecisionTable": {
        "@_hitPolicy": { type: "DMN12__tHitPolicy", isArray: false },
        "@_aggregation": { type: "DMN12__tBuiltinAggregator", isArray: false },
        "@_preferredOrientation": { type: "DMN12__tDecisionTableOrientation", isArray: false },
        "@_outputLabel": { type: "string", isArray: false },
        "input": { type: "DMN12__tInputClause", isArray: true },
        "output": { type: "DMN12__tOutputClause", isArray: true },
        "annotation": { type: "DMN12__tRuleAnnotationClause", isArray: true },
        "rule": { type: "DMN12__tDecisionRule", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tDecisionTable__extensionElements", isArray: false },
    },
    "DMN12__tInputClause__extensionElements": {},
    "DMN12__tInputClause": {
        "inputExpression": { type: "DMN12__tLiteralExpression", isArray: false },
        "inputValues": { type: "DMN12__tUnaryTests", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tInputClause__extensionElements", isArray: false },
    },
    "DMN12__tOutputClause__extensionElements": {},
    "DMN12__tOutputClause": {
        "@_name": { type: "string", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "outputValues": { type: "DMN12__tUnaryTests", isArray: false },
        "defaultOutputEntry": { type: "DMN12__tLiteralExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tOutputClause__extensionElements", isArray: false },
    },
    "DMN12__tRuleAnnotationClause": {
        "@_name": { type: "string", isArray: false },
    },
    "DMN12__tDecisionRule__extensionElements": {},
    "DMN12__tDecisionRule": {
        "inputEntry": { type: "DMN12__tUnaryTests", isArray: true },
        "outputEntry": { type: "DMN12__tLiteralExpression", isArray: true },
        "annotationEntry": { type: "DMN12__tRuleAnnotation", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tDecisionRule__extensionElements", isArray: false },
    },
    "DMN12__tRuleAnnotation": {
        "text": { type: "string", isArray: false },
    },
    "DMN12__tImportedValues__extensionElements": {},
    "DMN12__tImportedValues": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "importedElement": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tImportedValues__extensionElements", isArray: false },
    },
    "DMN12__tArtifact__extensionElements": {},
    "DMN12__tArtifact": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tArtifact__extensionElements", isArray: false },
    },
    "DMN12__tTextAnnotation__extensionElements": {},
    "DMN12__tTextAnnotation": {
        "@_textFormat": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tTextAnnotation__extensionElements", isArray: false },
    },
    "DMN12__tAssociation__extensionElements": {},
    "DMN12__tAssociation": {
        "@_associationDirection": { type: "DMN12__tAssociationDirection", isArray: false },
        "sourceRef": { type: "DMN12__tDMNElementReference", isArray: false },
        "targetRef": { type: "DMN12__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tAssociation__extensionElements", isArray: false },
    },
    "DMN12__tContext__extensionElements": {},
    "DMN12__tContext": {
        "contextEntry": { type: "DMN12__tContextEntry", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tContext__extensionElements", isArray: false },
    },
    "DMN12__tContextEntry__extensionElements": {},
    "DMN12__tContextEntry": {
        "variable": { type: "DMN12__tInformationItem", isArray: false },
        "expression": { type: "DMN12__tExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tContextEntry__extensionElements", isArray: false },
    },
    "DMN12__tFunctionDefinition__extensionElements": {},
    "DMN12__tFunctionDefinition": {
        "@_kind": { type: "DMN12__tFunctionKind", isArray: false },
        "formalParameter": { type: "DMN12__tInformationItem", isArray: true },
        "expression": { type: "DMN12__tExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tFunctionDefinition__extensionElements", isArray: false },
    },
    "DMN12__tRelation__extensionElements": {},
    "DMN12__tRelation": {
        "column": { type: "DMN12__tInformationItem", isArray: true },
        "row": { type: "DMN12__tList", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tRelation__extensionElements", isArray: false },
    },
    "DMN12__tList__extensionElements": {},
    "DMN12__tList": {
        "expression": { type: "DMN12__tExpression", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tList__extensionElements", isArray: false },
    },
    "DMN12__tUnaryTests__extensionElements": {},
    "DMN12__tUnaryTests": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tUnaryTests__extensionElements", isArray: false },
    },
    "DMN12__tDecisionService__extensionElements": {},
    "DMN12__tDecisionService": {
        "outputDecision": { type: "DMN12__tDMNElementReference", isArray: true },
        "encapsulatedDecision": { type: "DMN12__tDMNElementReference", isArray: true },
        "inputDecision": { type: "DMN12__tDMNElementReference", isArray: true },
        "inputData": { type: "DMN12__tDMNElementReference", isArray: true },
        "variable": { type: "DMN12__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN12__tDecisionService__extensionElements", isArray: false },
    },
    "DMNDI12__DMNDI": {
        "dmndi:DMNDiagram": { type: "DMNDI12__DMNDiagram", isArray: true },
        "dmndi:DMNStyle": { type: "DMNDI12__DMNStyle", isArray: true },
    },
    "DMNDI12__DMNDiagram__extension": {},
    "DMNDI12__DMNDiagram": {
        "dmndi:Size": { type: "DC__Dimension", isArray: false },
        "dmndi:DMNDiagramElement": { type: "DI__DiagramElement", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_documentation": { type: "string", isArray: false },
        "@_resolution": { type: "float", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI12__DMNDiagram__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI12__DMNShape__extension": {},
    "DMNDI12__DMNShape": {
        "@_dmnElementRef": { type: "string", isArray: false },
        "@_isListedInputData": { type: "boolean", isArray: false },
        "@_isCollapsed": { type: "boolean", isArray: false },
        "dmndi:DMNLabel": { type: "DMNDI12__DMNLabel", isArray: false },
        "dmndi:DMNDecisionServiceDividerLine": { type: "DMNDI12__DMNDecisionServiceDividerLine", isArray: false },
        "dc:Bounds": { type: "DC__Bounds", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI12__DMNShape__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI12__DMNDecisionServiceDividerLine__extension": {},
    "DMNDI12__DMNDecisionServiceDividerLine": {
        "di:waypoint": { type: "DC__Point", isArray: true },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI12__DMNDecisionServiceDividerLine__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI12__DMNEdge__extension": {},
    "DMNDI12__DMNEdge": {
        "@_dmnElementRef": { type: "string", isArray: false },
        "dmndi:DMNLabel": { type: "DMNDI12__DMNLabel", isArray: false },
        "di:waypoint": { type: "DC__Point", isArray: true },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI12__DMNEdge__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI12__DMNLabel__extension": {},
    "DMNDI12__DMNLabel": {
        "dmndi:Text": { type: "string", isArray: false },
        "dc:Bounds": { type: "DC__Bounds", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI12__DMNLabel__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI12__DMNStyle__extension": {},
    "DMNDI12__DMNStyle": {
        "@_fontFamily": { type: "string", isArray: false },
        "@_fontSize": { type: "float", isArray: false },
        "@_fontItalic": { type: "boolean", isArray: false },
        "@_fontBold": { type: "boolean", isArray: false },
        "@_fontUnderline": { type: "boolean", isArray: false },
        "@_fontStrikeThrough": { type: "boolean", isArray: false },
        "@_labelHorizontalAlignement": { type: "DC__AlignmentKind", isArray: false },
        "@_labelVerticalAlignment": { type: "DC__AlignmentKind", isArray: false },
        "dmndi:FillColor": { type: "DC__Color", isArray: false },
        "dmndi:StrokeColor": { type: "DC__Color", isArray: false },
        "dmndi:FontColor": { type: "DC__Color", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI12__DMNStyle__extension", isArray: false },
    },
    "DC__Color": {
        "@_red": { type: "integer", isArray: false },
        "@_green": { type: "integer", isArray: false },
        "@_blue": { type: "integer", isArray: false },
    },
    "DC__Point": {
        "@_x": { type: "float", isArray: false },
        "@_y": { type: "float", isArray: false },
    },
    "DC__Dimension": {
        "@_width": { type: "float", isArray: false },
        "@_height": { type: "float", isArray: false },
    },
    "DC__Bounds": {
        "@_x": { type: "float", isArray: false },
        "@_y": { type: "float", isArray: false },
        "@_width": { type: "float", isArray: false },
        "@_height": { type: "float", isArray: false },
    },
    "DI__DiagramElement__extension": {},
    "DI__Diagram__extension": {},
    "DI__Shape__extension": {},
    "DI__Edge__extension": {},
    "DI__Style__extension": {},
};
//# sourceMappingURL=meta.js.map