"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.meta = exports.elements = exports.subs = exports.ns = exports.root = void 0;
exports.root = {
    element: "definitions",
    type: "DMN15__tDefinitions"
};
exports.ns = new Map([
    ["https://www.omg.org/spec/DMN/20230324/MODEL/", ""],
    ["", "https://www.omg.org/spec/DMN/20230324/MODEL/"],
    ["https://www.omg.org/spec/DMN/20230324/DMNDI/", "dmndi:"],
    ["dmndi:", "https://www.omg.org/spec/DMN/20230324/DMNDI/"],
    ["http://www.omg.org/spec/DMN/20180521/DC/", "dc:"],
    ["dc:", "http://www.omg.org/spec/DMN/20180521/DC/"],
    ["http://www.omg.org/spec/DMN/20180521/DI/", "di:"],
    ["di:", "http://www.omg.org/spec/DMN/20180521/DI/"],
]);
exports.subs = {
    "": {
        "namedElement": "DMNElement",
        "informationRequirement": "DMNElement",
        "knowledgeRequirement": "DMNElement",
        "authorityRequirement": "DMNElement",
        "functionItem": "DMNElement",
        "artifact": "DMNElement",
        "contextEntry": "DMNElement",
        "definitions": "namedElement",
        "import": "namedElement",
        "elementCollection": "namedElement",
        "drgElement": "namedElement",
        "itemDefinition": "namedElement",
        "informationItem": "namedElement",
        "decision": "drgElement",
        "invocable": "drgElement",
        "inputData": "drgElement",
        "knowledgeSource": "drgElement",
        "performanceIndicator": "businessContextElement",
        "organizationUnit": "businessContextElement",
        "businessKnowledgeModel": "invocable",
        "decisionService": "invocable",
        "literalExpression": "expression",
        "invocation": "expression",
        "decisionTable": "expression",
        "context": "expression",
        "functionDefinition": "expression",
        "relation": "expression",
        "list": "expression",
        "for": "expression",
        "every": "expression",
        "some": "expression",
        "conditional": "expression",
        "filter": "expression",
        "group": "artifact",
        "textAnnotation": "artifact",
        "association": "artifact",
    },
    "dmndi:": {
        "dmndi:DMNShape": "dmndi:DMNDiagramElement",
        "dmndi:DMNEdge": "dmndi:DMNDiagramElement",
        "dmndi:DMNStyle": "di:Style",
    },
    "dc:": {},
    "di:": {},
};
exports.elements = {
    "DMNElement": "DMN15__tDMNElement",
    "namedElement": "DMN15__tNamedElement",
    "definitions": "DMN15__tDefinitions",
    "import": "DMN15__tImport",
    "elementCollection": "DMN15__tElementCollection",
    "drgElement": "DMN15__tDRGElement",
    "decision": "DMN15__tDecision",
    "businessContextElement": "DMN15__tBusinessContextElement",
    "performanceIndicator": "DMN15__tPerformanceIndicator",
    "organizationUnit": "DMN15__tOrganizationUnit",
    "invocable": "DMN15__tInvocable",
    "businessKnowledgeModel": "DMN15__tBusinessKnowledgeModel",
    "inputData": "DMN15__tInputData",
    "knowledgeSource": "DMN15__tKnowledgeSource",
    "informationRequirement": "DMN15__tInformationRequirement",
    "knowledgeRequirement": "DMN15__tKnowledgeRequirement",
    "authorityRequirement": "DMN15__tAuthorityRequirement",
    "expression": "DMN15__tExpression",
    "itemDefinition": "DMN15__tItemDefinition",
    "functionItem": "DMN15__tFunctionItem",
    "literalExpression": "DMN15__tLiteralExpression",
    "invocation": "DMN15__tInvocation",
    "informationItem": "DMN15__tInformationItem",
    "decisionTable": "DMN15__tDecisionTable",
    "artifact": "DMN15__tArtifact",
    "group": "DMN15__tGroup",
    "textAnnotation": "DMN15__tTextAnnotation",
    "association": "DMN15__tAssociation",
    "context": "DMN15__tContext",
    "contextEntry": "DMN15__tContextEntry",
    "functionDefinition": "DMN15__tFunctionDefinition",
    "relation": "DMN15__tRelation",
    "list": "DMN15__tList",
    "decisionService": "DMN15__tDecisionService",
    "for": "DMN15__tFor",
    "every": "DMN15__tQuantified",
    "some": "DMN15__tQuantified",
    "conditional": "DMN15__tConditional",
    "filter": "DMN15__tFilter",
    "dmndi:DMNDI": "DMNDI15__DMNDI",
    "dmndi:DMNDiagram": "DMNDI15__DMNDiagram",
    "dmndi:DMNDiagramElement": "DMNDI15__DiagramElement",
    "dmndi:DMNShape": "DMNDI15__DMNShape",
    "dmndi:DMNEdge": "DMNDI15__DMNEdge",
    "dmndi:DMNStyle": "DMNDI15__DMNStyle",
    "dmndi:DMNLabel": "DMNDI15__DMNLabel",
    "dmndi:DMNDecisionServiceDividerLine": "DMNDI15__DMNDecisionServiceDividerLine",
    "dc:Color": "DC__Color",
    "dc:Point": "DC__Point",
    "dc:Bounds": "DC__Bounds",
    "dc:Dimension": "DC__Dimension",
    "di:Style": "DI__Style",
};
exports.meta = {
    "DMN15__tDMNElement__extensionElements": {},
    "DMN15__tDMNElement": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tDMNElement__extensionElements", isArray: false },
    },
    "DMN15__tNamedElement__extensionElements": {},
    "DMN15__tNamedElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tNamedElement__extensionElements", isArray: false },
    },
    "DMN15__tDMNElementReference": {
        "@_href": { type: "string", isArray: false },
    },
    "DMN15__tDefinitions__extensionElements": {},
    "DMN15__tDefinitions": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "@_typeLanguage": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_exporter": { type: "string", isArray: false },
        "@_exporterVersion": { type: "string", isArray: false },
        "import": { type: "DMN15__tImport", isArray: true },
        "itemDefinition": { type: "DMN15__tItemDefinition", isArray: true },
        "drgElement": { type: "DMN15__tDRGElement", isArray: true },
        "artifact": { type: "DMN15__tArtifact", isArray: true },
        "elementCollection": { type: "DMN15__tElementCollection", isArray: true },
        "businessContextElement": { type: "DMN15__tBusinessContextElement", isArray: true },
        "dmndi:DMNDI": { type: "DMNDI15__DMNDI", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tDefinitions__extensionElements", isArray: false },
    },
    "DMN15__tImport__extensionElements": {},
    "DMN15__tImport": {
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tImport__extensionElements", isArray: false },
    },
    "DMN15__tElementCollection__extensionElements": {},
    "DMN15__tElementCollection": {
        "drgElement": { type: "DMN15__tDMNElementReference", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tElementCollection__extensionElements", isArray: false },
    },
    "DMN15__tDRGElement__extensionElements": {},
    "DMN15__tDRGElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tDRGElement__extensionElements", isArray: false },
    },
    "DMN15__tDecision__extensionElements": {},
    "DMN15__tDecision": {
        "question": { type: "string", isArray: false },
        "allowedAnswers": { type: "string", isArray: false },
        "variable": { type: "DMN15__tInformationItem", isArray: false },
        "informationRequirement": { type: "DMN15__tInformationRequirement", isArray: true },
        "knowledgeRequirement": { type: "DMN15__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "DMN15__tAuthorityRequirement", isArray: true },
        "supportedObjective": { type: "DMN15__tDMNElementReference", isArray: true },
        "impactedPerformanceIndicator": { type: "DMN15__tDMNElementReference", isArray: true },
        "decisionMaker": { type: "DMN15__tDMNElementReference", isArray: true },
        "decisionOwner": { type: "DMN15__tDMNElementReference", isArray: true },
        "usingProcess": { type: "DMN15__tDMNElementReference", isArray: true },
        "usingTask": { type: "DMN15__tDMNElementReference", isArray: true },
        "expression": { type: "DMN15__tExpression", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tDecision__extensionElements", isArray: false },
    },
    "DMN15__tBusinessContextElement__extensionElements": {},
    "DMN15__tBusinessContextElement": {
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tBusinessContextElement__extensionElements", isArray: false },
    },
    "DMN15__tPerformanceIndicator__extensionElements": {},
    "DMN15__tPerformanceIndicator": {
        "impactingDecision": { type: "DMN15__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tPerformanceIndicator__extensionElements", isArray: false },
    },
    "DMN15__tOrganizationUnit__extensionElements": {},
    "DMN15__tOrganizationUnit": {
        "decisionMade": { type: "DMN15__tDMNElementReference", isArray: true },
        "decisionOwned": { type: "DMN15__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tOrganizationUnit__extensionElements", isArray: false },
    },
    "DMN15__tInvocable__extensionElements": {},
    "DMN15__tInvocable": {
        "variable": { type: "DMN15__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tInvocable__extensionElements", isArray: false },
    },
    "DMN15__tBusinessKnowledgeModel__extensionElements": {},
    "DMN15__tBusinessKnowledgeModel": {
        "encapsulatedLogic": { type: "DMN15__tFunctionDefinition", isArray: false },
        "knowledgeRequirement": { type: "DMN15__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "DMN15__tAuthorityRequirement", isArray: true },
        "variable": { type: "DMN15__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tBusinessKnowledgeModel__extensionElements", isArray: false },
    },
    "DMN15__tInputData__extensionElements": {},
    "DMN15__tInputData": {
        "variable": { type: "DMN15__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tInputData__extensionElements", isArray: false },
    },
    "DMN15__tKnowledgeSource__extensionElements": {},
    "DMN15__tKnowledgeSource": {
        "@_locationURI": { type: "string", isArray: false },
        "authorityRequirement": { type: "DMN15__tAuthorityRequirement", isArray: true },
        "type": { type: "string", isArray: false },
        "owner": { type: "DMN15__tDMNElementReference", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tKnowledgeSource__extensionElements", isArray: false },
    },
    "DMN15__tInformationRequirement__extensionElements": {},
    "DMN15__tInformationRequirement": {
        "requiredDecision": { type: "DMN15__tDMNElementReference", isArray: false },
        "requiredInput": { type: "DMN15__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tInformationRequirement__extensionElements", isArray: false },
    },
    "DMN15__tKnowledgeRequirement__extensionElements": {},
    "DMN15__tKnowledgeRequirement": {
        "requiredKnowledge": { type: "DMN15__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tKnowledgeRequirement__extensionElements", isArray: false },
    },
    "DMN15__tAuthorityRequirement__extensionElements": {},
    "DMN15__tAuthorityRequirement": {
        "requiredDecision": { type: "DMN15__tDMNElementReference", isArray: false },
        "requiredInput": { type: "DMN15__tDMNElementReference", isArray: false },
        "requiredAuthority": { type: "DMN15__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tAuthorityRequirement__extensionElements", isArray: false },
    },
    "DMN15__tExpression__extensionElements": {},
    "DMN15__tExpression": {
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tExpression__extensionElements", isArray: false },
    },
    "DMN15__tItemDefinition__extensionElements": {},
    "DMN15__tItemDefinition": {
        "@_typeLanguage": { type: "string", isArray: false },
        "@_isCollection": { type: "boolean", isArray: false },
        "itemComponent": { type: "DMN15__tItemDefinition", isArray: true },
        "functionItem": { type: "DMN15__tFunctionItem", isArray: false },
        "typeRef": { type: "string", isArray: false },
        "allowedValues": { type: "DMN15__tUnaryTests", isArray: false },
        "typeConstraint": { type: "DMN15__tUnaryTests", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tItemDefinition__extensionElements", isArray: false },
    },
    "DMN15__tFunctionItem__extensionElements": {},
    "DMN15__tFunctionItem": {
        "@_outputTypeRef": { type: "string", isArray: false },
        "parameters": { type: "DMN15__tInformationItem", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tFunctionItem__extensionElements", isArray: false },
    },
    "DMN15__tLiteralExpression__extensionElements": {},
    "DMN15__tLiteralExpression": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "importedValues": { type: "DMN15__tImportedValues", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tLiteralExpression__extensionElements", isArray: false },
    },
    "DMN15__tInvocation__extensionElements": {},
    "DMN15__tInvocation": {
        "expression": { type: "DMN15__tExpression", isArray: false },
        "binding": { type: "DMN15__tBinding", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tInvocation__extensionElements", isArray: false },
    },
    "DMN15__tBinding": {
        "parameter": { type: "DMN15__tInformationItem", isArray: false },
        "expression": { type: "DMN15__tExpression", isArray: false },
    },
    "DMN15__tInformationItem__extensionElements": {},
    "DMN15__tInformationItem": {
        "@_typeRef": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tInformationItem__extensionElements", isArray: false },
    },
    "DMN15__tDecisionTable__extensionElements": {},
    "DMN15__tDecisionTable": {
        "@_hitPolicy": { type: "DMN15__tHitPolicy", isArray: false },
        "@_aggregation": { type: "DMN15__tBuiltinAggregator", isArray: false },
        "@_preferredOrientation": { type: "DMN15__tDecisionTableOrientation", isArray: false },
        "@_outputLabel": { type: "string", isArray: false },
        "input": { type: "DMN15__tInputClause", isArray: true },
        "output": { type: "DMN15__tOutputClause", isArray: true },
        "annotation": { type: "DMN15__tRuleAnnotationClause", isArray: true },
        "rule": { type: "DMN15__tDecisionRule", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tDecisionTable__extensionElements", isArray: false },
    },
    "DMN15__tInputClause__extensionElements": {},
    "DMN15__tInputClause": {
        "inputExpression": { type: "DMN15__tLiteralExpression", isArray: false },
        "inputValues": { type: "DMN15__tUnaryTests", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tInputClause__extensionElements", isArray: false },
    },
    "DMN15__tOutputClause__extensionElements": {},
    "DMN15__tOutputClause": {
        "@_name": { type: "string", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "outputValues": { type: "DMN15__tUnaryTests", isArray: false },
        "defaultOutputEntry": { type: "DMN15__tLiteralExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tOutputClause__extensionElements", isArray: false },
    },
    "DMN15__tRuleAnnotationClause": {
        "@_name": { type: "string", isArray: false },
    },
    "DMN15__tDecisionRule__extensionElements": {},
    "DMN15__tDecisionRule": {
        "inputEntry": { type: "DMN15__tUnaryTests", isArray: true },
        "outputEntry": { type: "DMN15__tLiteralExpression", isArray: true },
        "annotationEntry": { type: "DMN15__tRuleAnnotation", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tDecisionRule__extensionElements", isArray: false },
    },
    "DMN15__tRuleAnnotation": {
        "text": { type: "string", isArray: false },
    },
    "DMN15__tImportedValues__extensionElements": {},
    "DMN15__tImportedValues": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "importedElement": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tImportedValues__extensionElements", isArray: false },
    },
    "DMN15__tArtifact__extensionElements": {},
    "DMN15__tArtifact": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tArtifact__extensionElements", isArray: false },
    },
    "DMN15__tGroup__extensionElements": {},
    "DMN15__tGroup": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tGroup__extensionElements", isArray: false },
    },
    "DMN15__tTextAnnotation__extensionElements": {},
    "DMN15__tTextAnnotation": {
        "@_textFormat": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tTextAnnotation__extensionElements", isArray: false },
    },
    "DMN15__tAssociation__extensionElements": {},
    "DMN15__tAssociation": {
        "@_associationDirection": { type: "DMN15__tAssociationDirection", isArray: false },
        "sourceRef": { type: "DMN15__tDMNElementReference", isArray: false },
        "targetRef": { type: "DMN15__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tAssociation__extensionElements", isArray: false },
    },
    "DMN15__tContext__extensionElements": {},
    "DMN15__tContext": {
        "contextEntry": { type: "DMN15__tContextEntry", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tContext__extensionElements", isArray: false },
    },
    "DMN15__tContextEntry__extensionElements": {},
    "DMN15__tContextEntry": {
        "variable": { type: "DMN15__tInformationItem", isArray: false },
        "expression": { type: "DMN15__tExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tContextEntry__extensionElements", isArray: false },
    },
    "DMN15__tFunctionDefinition__extensionElements": {},
    "DMN15__tFunctionDefinition": {
        "@_kind": { type: "DMN15__tFunctionKind", isArray: false },
        "formalParameter": { type: "DMN15__tInformationItem", isArray: true },
        "expression": { type: "DMN15__tExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tFunctionDefinition__extensionElements", isArray: false },
    },
    "DMN15__tRelation__extensionElements": {},
    "DMN15__tRelation": {
        "column": { type: "DMN15__tInformationItem", isArray: true },
        "row": { type: "DMN15__tList", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tRelation__extensionElements", isArray: false },
    },
    "DMN15__tList__extensionElements": {},
    "DMN15__tList": {
        "expression": { type: "DMN15__tExpression", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tList__extensionElements", isArray: false },
    },
    "DMN15__tUnaryTests__extensionElements": {},
    "DMN15__tUnaryTests": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tUnaryTests__extensionElements", isArray: false },
    },
    "DMN15__tDecisionService__extensionElements": {},
    "DMN15__tDecisionService": {
        "outputDecision": { type: "DMN15__tDMNElementReference", isArray: true },
        "encapsulatedDecision": { type: "DMN15__tDMNElementReference", isArray: true },
        "inputDecision": { type: "DMN15__tDMNElementReference", isArray: true },
        "inputData": { type: "DMN15__tDMNElementReference", isArray: true },
        "variable": { type: "DMN15__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tDecisionService__extensionElements", isArray: false },
    },
    "DMN15__tChildExpression": {
        "@_id": { type: "string", isArray: false },
        "expression": { type: "DMN15__tExpression", isArray: false },
    },
    "DMN15__tTypedChildExpression": {
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "expression": { type: "DMN15__tExpression", isArray: false },
    },
    "DMN15__tIterator__extensionElements": {},
    "DMN15__tIterator": {
        "@_iteratorVariable": { type: "string", isArray: false },
        "in": { type: "DMN15__tTypedChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tIterator__extensionElements", isArray: false },
    },
    "DMN15__tFor__extensionElements": {},
    "DMN15__tFor": {
        "return": { type: "DMN15__tChildExpression", isArray: false },
        "@_iteratorVariable": { type: "string", isArray: false },
        "in": { type: "DMN15__tTypedChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tFor__extensionElements", isArray: false },
    },
    "DMN15__tQuantified__extensionElements": {},
    "DMN15__tQuantified": {
        "satisfies": { type: "DMN15__tChildExpression", isArray: false },
        "@_iteratorVariable": { type: "string", isArray: false },
        "in": { type: "DMN15__tTypedChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tQuantified__extensionElements", isArray: false },
    },
    "DMN15__tConditional__extensionElements": {},
    "DMN15__tConditional": {
        "if": { type: "DMN15__tChildExpression", isArray: false },
        "then": { type: "DMN15__tChildExpression", isArray: false },
        "else": { type: "DMN15__tChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tConditional__extensionElements", isArray: false },
    },
    "DMN15__tFilter__extensionElements": {},
    "DMN15__tFilter": {
        "in": { type: "DMN15__tChildExpression", isArray: false },
        "match": { type: "DMN15__tChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN15__tFilter__extensionElements", isArray: false },
    },
    "DMNDI15__DMNDI": {
        "dmndi:DMNDiagram": { type: "DMNDI15__DMNDiagram", isArray: true },
        "dmndi:DMNStyle": { type: "DMNDI15__DMNStyle", isArray: true },
    },
    "DMNDI15__DMNDiagram__extension": {},
    "DMNDI15__DMNDiagram": {
        "@_useAlternativeInputDataShape": { type: "boolean", isArray: false },
        "dmndi:Size": { type: "DC__Dimension", isArray: false },
        "dmndi:DMNDiagramElement": { type: "DI__DiagramElement", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_documentation": { type: "string", isArray: false },
        "@_resolution": { type: "float", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI15__DMNDiagram__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI15__DMNShape__extension": {},
    "DMNDI15__DMNShape": {
        "@_dmnElementRef": { type: "string", isArray: false },
        "@_isListedInputData": { type: "boolean", isArray: false },
        "@_isCollapsed": { type: "boolean", isArray: false },
        "dmndi:DMNLabel": { type: "DMNDI15__DMNLabel", isArray: false },
        "dmndi:DMNDecisionServiceDividerLine": { type: "DMNDI15__DMNDecisionServiceDividerLine", isArray: false },
        "dc:Bounds": { type: "DC__Bounds", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI15__DMNShape__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI15__DMNDecisionServiceDividerLine__extension": {},
    "DMNDI15__DMNDecisionServiceDividerLine": {
        "di:waypoint": { type: "DC__Point", isArray: true },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI15__DMNDecisionServiceDividerLine__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI15__DMNEdge__extension": {},
    "DMNDI15__DMNEdge": {
        "@_dmnElementRef": { type: "string", isArray: false },
        "@_sourceElement": { type: "string", isArray: false },
        "@_targetElement": { type: "string", isArray: false },
        "dmndi:DMNLabel": { type: "DMNDI15__DMNLabel", isArray: false },
        "di:waypoint": { type: "DC__Point", isArray: true },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI15__DMNEdge__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI15__DMNLabel__extension": {},
    "DMNDI15__DMNLabel": {
        "dmndi:Text": { type: "string", isArray: false },
        "dc:Bounds": { type: "DC__Bounds", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI15__DMNLabel__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI15__DMNStyle__extension": {},
    "DMNDI15__DMNStyle": {
        "@_fontFamily": { type: "string", isArray: false },
        "@_fontSize": { type: "float", isArray: false },
        "@_fontItalic": { type: "boolean", isArray: false },
        "@_fontBold": { type: "boolean", isArray: false },
        "@_fontUnderline": { type: "boolean", isArray: false },
        "@_fontStrikeThrough": { type: "boolean", isArray: false },
        "@_labelHorizontalAlignement": { type: "DC__AlignmentKind", isArray: false },
        "@_labelVerticalAlignment": { type: "DC__AlignmentKind", isArray: false },
        "dmndi:FillColor": { type: "DC__Color", isArray: false },
        "dmndi:StrokeColor": { type: "DC__Color", isArray: false },
        "dmndi:FontColor": { type: "DC__Color", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI15__DMNStyle__extension", isArray: false },
    },
    "DC__Color": {
        "@_red": { type: "integer", isArray: false },
        "@_green": { type: "integer", isArray: false },
        "@_blue": { type: "integer", isArray: false },
    },
    "DC__Point": {
        "@_x": { type: "float", isArray: false },
        "@_y": { type: "float", isArray: false },
    },
    "DC__Dimension": {
        "@_width": { type: "float", isArray: false },
        "@_height": { type: "float", isArray: false },
    },
    "DC__Bounds": {
        "@_x": { type: "float", isArray: false },
        "@_y": { type: "float", isArray: false },
        "@_width": { type: "float", isArray: false },
        "@_height": { type: "float", isArray: false },
    },
    "DI__DiagramElement__extension": {},
    "DI__Diagram__extension": {},
    "DI__Shape__extension": {},
    "DI__Edge__extension": {},
    "DI__Style__extension": {},
};
//# sourceMappingURL=meta.js.map