
export const root = {
    element: "Definitions",
    type: "dmn3__tDefinitions" 
};

export const ns = new Map<string, string>([
    ["http://www.omg.org/spec/DMN/20130901", ""],
    ["", "http://www.omg.org/spec/DMN/20130901"],
]);

export const subs = {
  "": {
    "Context": "Expression",
    "FunctionDefinition": "Expression",
    "Relation": "Expression",
    "List": "Expression",
    "LiteralExpression": "Expression",
    "Invocation": "Expression",
    "DecisionTable": "Expression",
    "Decision": "DRGElement",
    "BusinessKnowledgeModel": "DRGElement",
    "InputData": "DRGElement",
    "KnowledgeSource": "DRGElement",
    "PerformanceIndicator": "BusinessContextElement",
    "OrganizationUnit": "BusinessContextElement",
  },
};

export const elements = {
  "Context": "dmn3__tContext",
  "FunctionDefinition": "dmn3__tFunctionDefinition",
  "Relation": "dmn3__tRelation",
  "List": "dmn3__tList",
  "DMNElement": "dmn3__tDMNElement",
  "Definitions": "dmn3__tDefinitions",
  "Import": "dmn3__tImport",
  "ElementCollection": "dmn3__tElementCollection",
  "DRGElement": "dmn3__tDRGElement",
  "Decision": "dmn3__tDecision",
  "BusinessContextElement": "dmn3__tBusinessContextElement",
  "PerformanceIndicator": "dmn3__tPerformanceIndicator",
  "OrganizationUnit": "dmn3__tOrganizationUnit",
  "BusinessKnowledgeModel": "dmn3__tBusinessKnowledgeModel",
  "InputData": "dmn3__tInputData",
  "KnowledgeSource": "dmn3__tKnowledgeSource",
  "Expression": "dmn3__tExpression",
  "ItemDefinition": "dmn3__tItemDefinition",
  "LiteralExpression": "dmn3__tLiteralExpression",
  "Invocation": "dmn3__tInvocation",
  "InformationItem": "dmn3__tInformationItem",
  "DecisionTable": "dmn3__tDecisionTable",
};

export const meta = {
    "dmn3__tContext": {
        "contextEntry": { type: "dmn3__tContextEntry", isArray: true },
        "inputVariable": { type: "string", isArray: true },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tContextEntry": {
        "InformationItem": { type: "dmn3__tInformationItem", isArray: false },
        "Expression": { type: "dmn3__tExpression", isArray: false },
    },
    "dmn3__tFunctionDefinition": {
        "InformationItem": { type: "dmn3__tInformationItem", isArray: true },
        "Expression": { type: "dmn3__tExpression", isArray: false },
        "inputVariable": { type: "string", isArray: true },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tRelation": {
        "column": { type: "dmn3__tContextEntry", isArray: true },
        "List": { type: "dmn3__tList", isArray: true },
        "inputVariable": { type: "string", isArray: true },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tList": {
        "Expression": { type: "dmn3__tExpression", isArray: true },
        "inputVariable": { type: "string", isArray: true },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tDMNElement": {
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tNamedDMNElement": {
    },
    "dmn3__tDMNElementReference": {
        "@_href": { type: "string", isArray: false },
    },
    "dmn3__tDefinitions": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "@_typeLanguage": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "Import": { type: "dmn3__tImport", isArray: true },
        "ItemDefinition": { type: "dmn3__tItemDefinition", isArray: true },
        "DRGElement": { type: "dmn3__tDRGElement", isArray: true },
        "ElementCollection": { type: "dmn3__tElementCollection", isArray: true },
        "BusinessContextElement": { type: "dmn3__tBusinessContextElement", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tImport": {
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
    },
    "dmn3__tElementCollection": {
        "drgElement": { type: "dmn3__tDMNElementReference", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tDRGElement": {
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tDecision": {
        "question": { type: "string", isArray: false },
        "allowedAnswers": { type: "string", isArray: false },
        "outputDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "informationRequirement": { type: "dmn3__tInformationRequirement", isArray: true },
        "knowledgeRequirement": { type: "dmn3__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "dmn3__tAuthorityRequirement", isArray: true },
        "supportedObjective": { type: "dmn3__tDMNElementReference", isArray: true },
        "impactedPerformanceIndicator": { type: "dmn3__tDMNElementReference", isArray: true },
        "decisionMaker": { type: "dmn3__tDMNElementReference", isArray: true },
        "decisionOwner": { type: "dmn3__tDMNElementReference", isArray: true },
        "usingProcess": { type: "dmn3__tDMNElementReference", isArray: true },
        "usingTask": { type: "dmn3__tDMNElementReference", isArray: true },
        "Expression": { type: "dmn3__tExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tBusinessContextElement": {
        "@_URI": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tPerformanceIndicator": {
        "impactingDecision": { type: "dmn3__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tOrganizationUnit": {
        "decisionMade": { type: "dmn3__tDMNElementReference", isArray: true },
        "decisionOwned": { type: "dmn3__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tBusinessKnowledgeModel": {
        "InformationItem": { type: "dmn3__tInformationItem", isArray: true },
        "Expression": { type: "dmn3__tExpression", isArray: false },
        "knowledgeRequirement": { type: "dmn3__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "dmn3__tAuthorityRequirement", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tInputData": {
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tKnowledgeSource": {
        "@_locationURI": { type: "string", isArray: false },
        "authorityRequirement": { type: "dmn3__tAuthorityRequirement", isArray: true },
        "type": { type: "string", isArray: false },
        "owner": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tInformationRequirement": {
        "InformationItem": { type: "dmn3__tInformationItem", isArray: false },
    },
    "dmn3__tKnowledgeRequirement": {
        "requiredKnowledge": { type: "dmn3__tDMNElementReference", isArray: false },
    },
    "dmn3__tAuthorityRequirement": {
    },
    "dmn3__tExpression": {
        "inputVariable": { type: "string", isArray: true },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tItemDefinition": {
        "@_typeLanguage": { type: "string", isArray: false },
        "@_isCollection": { type: "boolean", isArray: false },
        "itemComponent": { type: "dmn3__tItemComponent", isArray: true },
        "allowedValue": { type: "dmn3__tExpression", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tItemComponent": {
        "@_name": { type: "string", isArray: false },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
    },
    "dmn3__tLiteralExpression__text": {
    },
    "dmn3__tLiteralExpression": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "dmn3__tLiteralExpression__text", isArray: false },
        "Import": { type: "dmn3__tImport", isArray: false },
        "inputVariable": { type: "string", isArray: true },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tInvocation": {
        "binding": { type: "dmn3__tBinding", isArray: true },
        "inputVariable": { type: "string", isArray: true },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tBinding": {
        "Expression": { type: "dmn3__tExpression", isArray: false },
        "parameter": { type: "dmn3__tDMNElementReference", isArray: false },
    },
    "dmn3__tInformationItem": {
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
    },
    "dmn3__tDecisionTable": {
        "@_hitPolicy": { type: "dmn3__HitPolicy", isArray: false },
        "@_aggregation": { type: "dmn3__BuiltinAggregator", isArray: false },
        "@_preferedOrientation": { type: "dmn3__DecisionTableOrientation", isArray: false },
        "@_isComplete": { type: "boolean", isArray: false },
        "@_isConsistent": { type: "boolean", isArray: false },
        "clause": { type: "dmn3__tClause", isArray: true },
        "rule": { type: "dmn3__tDecisionRule", isArray: true },
        "inputVariable": { type: "string", isArray: true },
        "itemDefinition": { type: "dmn3__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
    },
    "dmn3__tClause": {
        "@_name": { type: "string", isArray: false },
        "@_isOrdered": { type: "boolean", isArray: false },
    },
    "dmn3__tDecisionRule": {
        "condition": { type: "string", isArray: true },
        "conclusion": { type: "string", isArray: true },
    },
}
