
export const root = {
    element: "definitions",
    type: "dmn__tDefinitions" 
};

export const ns = new Map<string, string>([
    ["http://www.omg.org/spec/DMN/20151101/dmn.xsd", ""],
    ["", "http://www.omg.org/spec/DMN/20151101/dmn.xsd"],
]);

export const subs = {
  "": {
    "namedElement": "DMNElement",
    "artifact": "DMNElement",
    "definitions": "namedElement",
    "elementCollection": "namedElement",
    "drgElement": "namedElement",
    "itemDefinition": "namedElement",
    "informationItem": "namedElement",
    "decisionService": "namedElement",
    "decision": "drgElement",
    "businessKnowledgeModel": "drgElement",
    "inputData": "drgElement",
    "knowledgeSource": "drgElement",
    "performanceIndicator": "businessContextElement",
    "organizationUnit": "businessContextElement",
    "literalExpression": "expression",
    "invocation": "expression",
    "decisionTable": "expression",
    "context": "expression",
    "functionDefinition": "expression",
    "relation": "expression",
    "list": "expression",
    "textAnnotation": "artifact",
    "association": "artifact",
  },
};

export const elements = {
  "DMNElement": "dmn__tDMNElement",
  "namedElement": "dmn__tNamedElement",
  "definitions": "dmn__tDefinitions",
  "import": "dmn__tImport",
  "elementCollection": "dmn__tElementCollection",
  "drgElement": "dmn__tDRGElement",
  "decision": "dmn__tDecision",
  "businessContextElement": "dmn__tBusinessContextElement",
  "performanceIndicator": "dmn__tPerformanceIndicator",
  "organizationUnit": "dmn__tOrganizationUnit",
  "businessKnowledgeModel": "dmn__tBusinessKnowledgeModel",
  "inputData": "dmn__tInputData",
  "knowledgeSource": "dmn__tKnowledgeSource",
  "expression": "dmn__tExpression",
  "itemDefinition": "dmn__tItemDefinition",
  "literalExpression": "dmn__tLiteralExpression",
  "invocation": "dmn__tInvocation",
  "informationItem": "dmn__tInformationItem",
  "decisionTable": "dmn__tDecisionTable",
  "artifact": "dmn__tArtifact",
  "textAnnotation": "dmn__tTextAnnotation",
  "association": "dmn__tAssociation",
  "context": "dmn__tContext",
  "functionDefinition": "dmn__tFunctionDefinition",
  "relation": "dmn__tRelation",
  "list": "dmn__tList",
  "decisionService": "dmn__tDecisionService",
};

export const meta = {
    "dmn__tDMNElement__extensionElements": {
    },
    "dmn__tDMNElement": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tDMNElement__extensionElements", isArray: false },
    },
    "dmn__tDMNElementReference": {
        "@_href": { type: "string", isArray: false },
    },
    "dmn__tDefinitions__extensionElements": {
    },
    "dmn__tDefinitions": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "@_typeLanguage": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_exporter": { type: "string", isArray: false },
        "@_exporterVersion": { type: "string", isArray: false },
        "import": { type: "dmn__tImport", isArray: true },
        "itemDefinition": { type: "dmn__tItemDefinition", isArray: true },
        "drgElement": { type: "dmn__tDRGElement", isArray: true },
        "artifact": { type: "dmn__tArtifact", isArray: true },
        "elementCollection": { type: "dmn__tElementCollection", isArray: true },
        "businessContextElement": { type: "dmn__tBusinessContextElement", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tDefinitions__extensionElements", isArray: false },
    },
    "dmn__tImport": {
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
    },
    "dmn__tElementCollection__extensionElements": {
    },
    "dmn__tElementCollection": {
        "drgElement": { type: "dmn__tDMNElementReference", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tElementCollection__extensionElements", isArray: false },
    },
    "dmn__tDRGElement__extensionElements": {
    },
    "dmn__tDRGElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tDRGElement__extensionElements", isArray: false },
    },
    "dmn__tDecision__extensionElements": {
    },
    "dmn__tDecision": {
        "question": { type: "string", isArray: false },
        "allowedAnswers": { type: "string", isArray: false },
        "variable": { type: "dmn__tInformationItem", isArray: false },
        "informationRequirement": { type: "dmn__tInformationRequirement", isArray: true },
        "knowledgeRequirement": { type: "dmn__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "dmn__tAuthorityRequirement", isArray: true },
        "supportedObjective": { type: "dmn__tDMNElementReference", isArray: true },
        "impactedPerformanceIndicator": { type: "dmn__tDMNElementReference", isArray: true },
        "decisionMaker": { type: "dmn__tDMNElementReference", isArray: true },
        "decisionOwner": { type: "dmn__tDMNElementReference", isArray: true },
        "usingProcess": { type: "dmn__tDMNElementReference", isArray: true },
        "usingTask": { type: "dmn__tDMNElementReference", isArray: true },
        "expression": { type: "dmn__tExpression", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tDecision__extensionElements", isArray: false },
    },
    "dmn__tBusinessContextElement__extensionElements": {
    },
    "dmn__tBusinessContextElement": {
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tBusinessContextElement__extensionElements", isArray: false },
    },
    "dmn__tPerformanceIndicator__extensionElements": {
    },
    "dmn__tPerformanceIndicator": {
        "impactingDecision": { type: "dmn__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tPerformanceIndicator__extensionElements", isArray: false },
    },
    "dmn__tOrganizationUnit__extensionElements": {
    },
    "dmn__tOrganizationUnit": {
        "decisionMade": { type: "dmn__tDMNElementReference", isArray: true },
        "decisionOwned": { type: "dmn__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tOrganizationUnit__extensionElements", isArray: false },
    },
    "dmn__tBusinessKnowledgeModel__extensionElements": {
    },
    "dmn__tBusinessKnowledgeModel": {
        "encapsulatedLogic": { type: "dmn__tFunctionDefinition", isArray: false },
        "variable": { type: "dmn__tInformationItem", isArray: false },
        "knowledgeRequirement": { type: "dmn__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "dmn__tAuthorityRequirement", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tBusinessKnowledgeModel__extensionElements", isArray: false },
    },
    "dmn__tInputData__extensionElements": {
    },
    "dmn__tInputData": {
        "variable": { type: "dmn__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tInputData__extensionElements", isArray: false },
    },
    "dmn__tKnowledgeSource__extensionElements": {
    },
    "dmn__tKnowledgeSource": {
        "@_locationURI": { type: "string", isArray: false },
        "authorityRequirement": { type: "dmn__tAuthorityRequirement", isArray: true },
        "type": { type: "string", isArray: false },
        "owner": { type: "dmn__tDMNElementReference", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tKnowledgeSource__extensionElements", isArray: false },
    },
    "dmn__tInformationRequirement": {
    },
    "dmn__tKnowledgeRequirement": {
        "requiredKnowledge": { type: "dmn__tDMNElementReference", isArray: false },
    },
    "dmn__tAuthorityRequirement": {
    },
    "dmn__tExpression__extensionElements": {
    },
    "dmn__tExpression": {
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tExpression__extensionElements", isArray: false },
    },
    "dmn__tItemDefinition__extensionElements": {
    },
    "dmn__tItemDefinition": {
        "@_typeLanguage": { type: "string", isArray: false },
        "@_isCollection": { type: "boolean", isArray: false },
        "itemComponent": { type: "dmn__tItemDefinition", isArray: true },
        "typeRef": { type: "string", isArray: false },
        "allowedValues": { type: "dmn__tUnaryTests", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tItemDefinition__extensionElements", isArray: false },
    },
    "dmn__tLiteralExpression__extensionElements": {
    },
    "dmn__tLiteralExpression": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "importedValues": { type: "dmn__tImportedValues", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tLiteralExpression__extensionElements", isArray: false },
    },
    "dmn__tInvocation__extensionElements": {
    },
    "dmn__tInvocation": {
        "expression": { type: "dmn__tExpression", isArray: false },
        "binding": { type: "dmn__tBinding", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tInvocation__extensionElements", isArray: false },
    },
    "dmn__tBinding": {
        "parameter": { type: "dmn__tInformationItem", isArray: false },
        "expression": { type: "dmn__tExpression", isArray: false },
    },
    "dmn__tInformationItem__extensionElements": {
    },
    "dmn__tInformationItem": {
        "@_typeRef": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tInformationItem__extensionElements", isArray: false },
    },
    "dmn__tDecisionTable__extensionElements": {
    },
    "dmn__tDecisionTable": {
        "@_hitPolicy": { type: "dmn__tHitPolicy", isArray: false },
        "@_aggregation": { type: "dmn__tBuiltinAggregator", isArray: false },
        "@_preferredOrientation": { type: "dmn__tDecisionTableOrientation", isArray: false },
        "@_outputLabel": { type: "string", isArray: false },
        "input": { type: "dmn__tInputClause", isArray: true },
        "output": { type: "dmn__tOutputClause", isArray: true },
        "rule": { type: "dmn__tDecisionRule", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tDecisionTable__extensionElements", isArray: false },
    },
    "dmn__tDecisionRule__extensionElements": {
    },
    "dmn__tDecisionRule": {
        "inputEntry": { type: "dmn__tUnaryTests", isArray: true },
        "outputEntry": { type: "dmn__tLiteralExpression", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tDecisionRule__extensionElements", isArray: false },
    },
    "dmn__tImportedValues": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "importedElement": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
    },
    "dmn__tArtifact__extensionElements": {
    },
    "dmn__tArtifact": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tArtifact__extensionElements", isArray: false },
    },
    "dmn__tTextAnnotation__extensionElements": {
    },
    "dmn__tTextAnnotation": {
        "@_textFormat": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tTextAnnotation__extensionElements", isArray: false },
    },
    "dmn__tAssociation__extensionElements": {
    },
    "dmn__tAssociation": {
        "@_associationDirection": { type: "dmn__tAssociationDirection", isArray: false },
        "sourceRef": { type: "dmn__tDMNElementReference", isArray: false },
        "targetRef": { type: "dmn__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tAssociation__extensionElements", isArray: false },
    },
    "dmn__tOutputClause__extensionElements": {
    },
    "dmn__tOutputClause": {
        "@_name": { type: "string", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "outputValues": { type: "dmn__tUnaryTests", isArray: false },
        "defaultOutputEntry": { type: "dmn__tLiteralExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tOutputClause__extensionElements", isArray: false },
    },
    "dmn__tInputClause__extensionElements": {
    },
    "dmn__tInputClause": {
        "inputExpression": { type: "dmn__tLiteralExpression", isArray: false },
        "inputValues": { type: "dmn__tUnaryTests", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tInputClause__extensionElements", isArray: false },
    },
    "dmn__tContext__extensionElements": {
    },
    "dmn__tContext": {
        "contextEntry": { type: "dmn__tContextEntry", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tContext__extensionElements", isArray: false },
    },
    "dmn__tContextEntry": {
        "variable": { type: "dmn__tInformationItem", isArray: false },
        "expression": { type: "dmn__tExpression", isArray: false },
    },
    "dmn__tFunctionDefinition__extensionElements": {
    },
    "dmn__tFunctionDefinition": {
        "formalParameter": { type: "dmn__tInformationItem", isArray: true },
        "expression": { type: "dmn__tExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tFunctionDefinition__extensionElements", isArray: false },
    },
    "dmn__tRelation__extensionElements": {
    },
    "dmn__tRelation": {
        "column": { type: "dmn__tInformationItem", isArray: true },
        "row": { type: "dmn__tList", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tRelation__extensionElements", isArray: false },
    },
    "dmn__tList__extensionElements": {
    },
    "dmn__tList": {
        "expression": { type: "dmn__tExpression", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tList__extensionElements", isArray: false },
    },
    "dmn__tUnaryTests__extensionElements": {
    },
    "dmn__tUnaryTests": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tUnaryTests__extensionElements", isArray: false },
    },
    "dmn__tNamedElement__extensionElements": {
    },
    "dmn__tNamedElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tNamedElement__extensionElements", isArray: false },
    },
    "dmn__tDecisionService__extensionElements": {
    },
    "dmn__tDecisionService": {
        "outputDecision": { type: "dmn__tDMNElementReference", isArray: true },
        "encapsulatedDecision": { type: "dmn__tDMNElementReference", isArray: true },
        "inputDecision": { type: "dmn__tDMNElementReference", isArray: true },
        "inputData": { type: "dmn__tDMNElementReference", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "dmn__tDecisionService__extensionElements", isArray: false },
    },
}
