
export const root = {
    element: "definitions",
    type: "DMN13__tDefinitions" 
};

export const ns = new Map<string, string>([
    ["https://www.omg.org/spec/DMN/20191111/MODEL/", ""],
    ["", "https://www.omg.org/spec/DMN/20191111/MODEL/"],
    ["https://www.omg.org/spec/DMN/20191111/DMNDI/", "dmndi:"],
    ["dmndi:", "https://www.omg.org/spec/DMN/20191111/DMNDI/"],
    ["http://www.omg.org/spec/DMN/20180521/DC/", "dc:"],
    ["dc:", "http://www.omg.org/spec/DMN/20180521/DC/"],
    ["http://www.omg.org/spec/DMN/20180521/DI/", "di:"],
    ["di:", "http://www.omg.org/spec/DMN/20180521/DI/"],
]);

export const subs = {
  "": {
    "namedElement": "DMNElement",
    "informationRequirement": "DMNElement",
    "knowledgeRequirement": "DMNElement",
    "authorityRequirement": "DMNElement",
    "functionItem": "DMNElement",
    "artifact": "DMNElement",
    "contextEntry": "DMNElement",
    "definitions": "namedElement",
    "import": "namedElement",
    "elementCollection": "namedElement",
    "drgElement": "namedElement",
    "itemDefinition": "namedElement",
    "informationItem": "namedElement",
    "decision": "drgElement",
    "invocable": "drgElement",
    "inputData": "drgElement",
    "knowledgeSource": "drgElement",
    "performanceIndicator": "businessContextElement",
    "organizationUnit": "businessContextElement",
    "businessKnowledgeModel": "invocable",
    "decisionService": "invocable",
    "literalExpression": "expression",
    "invocation": "expression",
    "decisionTable": "expression",
    "context": "expression",
    "functionDefinition": "expression",
    "relation": "expression",
    "list": "expression",
    "group": "artifact",
    "textAnnotation": "artifact",
    "association": "artifact",
  },
  "dmndi:": {
    "dmndi:DMNShape": "dmndi:DMNDiagramElement",
    "dmndi:DMNEdge": "dmndi:DMNDiagramElement",
    "dmndi:DMNStyle": "di:Style",
  },
  "dc:": {

  },
  "di:": {

  },
};

export const elements = {
  "DMNElement": "DMN13__tDMNElement",
  "namedElement": "DMN13__tNamedElement",
  "definitions": "DMN13__tDefinitions",
  "import": "DMN13__tImport",
  "elementCollection": "DMN13__tElementCollection",
  "drgElement": "DMN13__tDRGElement",
  "decision": "DMN13__tDecision",
  "businessContextElement": "DMN13__tBusinessContextElement",
  "performanceIndicator": "DMN13__tPerformanceIndicator",
  "organizationUnit": "DMN13__tOrganizationUnit",
  "invocable": "DMN13__tInvocable",
  "businessKnowledgeModel": "DMN13__tBusinessKnowledgeModel",
  "inputData": "DMN13__tInputData",
  "knowledgeSource": "DMN13__tKnowledgeSource",
  "informationRequirement": "DMN13__tInformationRequirement",
  "knowledgeRequirement": "DMN13__tKnowledgeRequirement",
  "authorityRequirement": "DMN13__tAuthorityRequirement",
  "expression": "DMN13__tExpression",
  "itemDefinition": "DMN13__tItemDefinition",
  "functionItem": "DMN13__tFunctionItem",
  "literalExpression": "DMN13__tLiteralExpression",
  "invocation": "DMN13__tInvocation",
  "informationItem": "DMN13__tInformationItem",
  "decisionTable": "DMN13__tDecisionTable",
  "artifact": "DMN13__tArtifact",
  "group": "DMN13__tGroup",
  "textAnnotation": "DMN13__tTextAnnotation",
  "association": "DMN13__tAssociation",
  "context": "DMN13__tContext",
  "contextEntry": "DMN13__tContextEntry",
  "functionDefinition": "DMN13__tFunctionDefinition",
  "relation": "DMN13__tRelation",
  "list": "DMN13__tList",
  "decisionService": "DMN13__tDecisionService",
  "dmndi:DMNDI": "DMNDI13__DMNDI",
  "dmndi:DMNDiagram": "DMNDI13__DMNDiagram",
  "dmndi:DMNDiagramElement": "DMNDI13__DiagramElement",
  "dmndi:DMNShape": "DMNDI13__DMNShape",
  "dmndi:DMNEdge": "DMNDI13__DMNEdge",
  "dmndi:DMNStyle": "DMNDI13__DMNStyle",
  "dmndi:DMNLabel": "DMNDI13__DMNLabel",
  "dmndi:DMNDecisionServiceDividerLine": "DMNDI13__DMNDecisionServiceDividerLine",
  "dc:Color": "DC__Color",
  "dc:Point": "DC__Point",
  "dc:Bounds": "DC__Bounds",
  "dc:Dimension": "DC__Dimension",
  "di:Style": "DI__Style",
};

export const meta = {
    "DMN13__tDMNElement__extensionElements": {
    },
    "DMN13__tDMNElement": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tDMNElement__extensionElements", isArray: false },
    },
    "DMN13__tNamedElement__extensionElements": {
    },
    "DMN13__tNamedElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tNamedElement__extensionElements", isArray: false },
    },
    "DMN13__tDMNElementReference": {
        "@_href": { type: "string", isArray: false },
    },
    "DMN13__tDefinitions__extensionElements": {
    },
    "DMN13__tDefinitions": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "@_typeLanguage": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_exporter": { type: "string", isArray: false },
        "@_exporterVersion": { type: "string", isArray: false },
        "import": { type: "DMN13__tImport", isArray: true },
        "itemDefinition": { type: "DMN13__tItemDefinition", isArray: true },
        "drgElement": { type: "DMN13__tDRGElement", isArray: true },
        "artifact": { type: "DMN13__tArtifact", isArray: true },
        "elementCollection": { type: "DMN13__tElementCollection", isArray: true },
        "businessContextElement": { type: "DMN13__tBusinessContextElement", isArray: true },
        "dmndi:DMNDI": { type: "DMNDI13__DMNDI", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tDefinitions__extensionElements", isArray: false },
    },
    "DMN13__tImport__extensionElements": {
    },
    "DMN13__tImport": {
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tImport__extensionElements", isArray: false },
    },
    "DMN13__tElementCollection__extensionElements": {
    },
    "DMN13__tElementCollection": {
        "drgElement": { type: "DMN13__tDMNElementReference", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tElementCollection__extensionElements", isArray: false },
    },
    "DMN13__tDRGElement__extensionElements": {
    },
    "DMN13__tDRGElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tDRGElement__extensionElements", isArray: false },
    },
    "DMN13__tDecision__extensionElements": {
    },
    "DMN13__tDecision": {
        "question": { type: "string", isArray: false },
        "allowedAnswers": { type: "string", isArray: false },
        "variable": { type: "DMN13__tInformationItem", isArray: false },
        "informationRequirement": { type: "DMN13__tInformationRequirement", isArray: true },
        "knowledgeRequirement": { type: "DMN13__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "DMN13__tAuthorityRequirement", isArray: true },
        "supportedObjective": { type: "DMN13__tDMNElementReference", isArray: true },
        "impactedPerformanceIndicator": { type: "DMN13__tDMNElementReference", isArray: true },
        "decisionMaker": { type: "DMN13__tDMNElementReference", isArray: true },
        "decisionOwner": { type: "DMN13__tDMNElementReference", isArray: true },
        "usingProcess": { type: "DMN13__tDMNElementReference", isArray: true },
        "usingTask": { type: "DMN13__tDMNElementReference", isArray: true },
        "expression": { type: "DMN13__tExpression", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tDecision__extensionElements", isArray: false },
    },
    "DMN13__tBusinessContextElement__extensionElements": {
    },
    "DMN13__tBusinessContextElement": {
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tBusinessContextElement__extensionElements", isArray: false },
    },
    "DMN13__tPerformanceIndicator__extensionElements": {
    },
    "DMN13__tPerformanceIndicator": {
        "impactingDecision": { type: "DMN13__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tPerformanceIndicator__extensionElements", isArray: false },
    },
    "DMN13__tOrganizationUnit__extensionElements": {
    },
    "DMN13__tOrganizationUnit": {
        "decisionMade": { type: "DMN13__tDMNElementReference", isArray: true },
        "decisionOwned": { type: "DMN13__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tOrganizationUnit__extensionElements", isArray: false },
    },
    "DMN13__tInvocable__extensionElements": {
    },
    "DMN13__tInvocable": {
        "variable": { type: "DMN13__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tInvocable__extensionElements", isArray: false },
    },
    "DMN13__tBusinessKnowledgeModel__extensionElements": {
    },
    "DMN13__tBusinessKnowledgeModel": {
        "encapsulatedLogic": { type: "DMN13__tFunctionDefinition", isArray: false },
        "knowledgeRequirement": { type: "DMN13__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "DMN13__tAuthorityRequirement", isArray: true },
        "variable": { type: "DMN13__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tBusinessKnowledgeModel__extensionElements", isArray: false },
    },
    "DMN13__tInputData__extensionElements": {
    },
    "DMN13__tInputData": {
        "variable": { type: "DMN13__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tInputData__extensionElements", isArray: false },
    },
    "DMN13__tKnowledgeSource__extensionElements": {
    },
    "DMN13__tKnowledgeSource": {
        "@_locationURI": { type: "string", isArray: false },
        "authorityRequirement": { type: "DMN13__tAuthorityRequirement", isArray: true },
        "type": { type: "string", isArray: false },
        "owner": { type: "DMN13__tDMNElementReference", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tKnowledgeSource__extensionElements", isArray: false },
    },
    "DMN13__tInformationRequirement__extensionElements": {
    },
    "DMN13__tInformationRequirement": {
        "requiredDecision": { type: "DMN13__tDMNElementReference", isArray: false },
        "requiredInput": { type: "DMN13__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tInformationRequirement__extensionElements", isArray: false },
    },
    "DMN13__tKnowledgeRequirement__extensionElements": {
    },
    "DMN13__tKnowledgeRequirement": {
        "requiredKnowledge": { type: "DMN13__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tKnowledgeRequirement__extensionElements", isArray: false },
    },
    "DMN13__tAuthorityRequirement__extensionElements": {
    },
    "DMN13__tAuthorityRequirement": {
        "requiredDecision": { type: "DMN13__tDMNElementReference", isArray: false },
        "requiredInput": { type: "DMN13__tDMNElementReference", isArray: false },
        "requiredAuthority": { type: "DMN13__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tAuthorityRequirement__extensionElements", isArray: false },
    },
    "DMN13__tExpression__extensionElements": {
    },
    "DMN13__tExpression": {
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tExpression__extensionElements", isArray: false },
    },
    "DMN13__tItemDefinition__extensionElements": {
    },
    "DMN13__tItemDefinition": {
        "@_typeLanguage": { type: "string", isArray: false },
        "@_isCollection": { type: "boolean", isArray: false },
        "itemComponent": { type: "DMN13__tItemDefinition", isArray: true },
        "functionItem": { type: "DMN13__tFunctionItem", isArray: false },
        "typeRef": { type: "string", isArray: false },
        "allowedValues": { type: "DMN13__tUnaryTests", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tItemDefinition__extensionElements", isArray: false },
    },
    "DMN13__tFunctionItem__extensionElements": {
    },
    "DMN13__tFunctionItem": {
        "@_outputTypeRef": { type: "string", isArray: false },
        "parameters": { type: "DMN13__tInformationItem", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tFunctionItem__extensionElements", isArray: false },
    },
    "DMN13__tLiteralExpression__extensionElements": {
    },
    "DMN13__tLiteralExpression": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "importedValues": { type: "DMN13__tImportedValues", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tLiteralExpression__extensionElements", isArray: false },
    },
    "DMN13__tInvocation__extensionElements": {
    },
    "DMN13__tInvocation": {
        "expression": { type: "DMN13__tExpression", isArray: false },
        "binding": { type: "DMN13__tBinding", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tInvocation__extensionElements", isArray: false },
    },
    "DMN13__tBinding": {
        "parameter": { type: "DMN13__tInformationItem", isArray: false },
        "expression": { type: "DMN13__tExpression", isArray: false },
    },
    "DMN13__tInformationItem__extensionElements": {
    },
    "DMN13__tInformationItem": {
        "@_typeRef": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tInformationItem__extensionElements", isArray: false },
    },
    "DMN13__tDecisionTable__extensionElements": {
    },
    "DMN13__tDecisionTable": {
        "@_hitPolicy": { type: "DMN13__tHitPolicy", isArray: false },
        "@_aggregation": { type: "DMN13__tBuiltinAggregator", isArray: false },
        "@_preferredOrientation": { type: "DMN13__tDecisionTableOrientation", isArray: false },
        "@_outputLabel": { type: "string", isArray: false },
        "input": { type: "DMN13__tInputClause", isArray: true },
        "output": { type: "DMN13__tOutputClause", isArray: true },
        "annotation": { type: "DMN13__tRuleAnnotationClause", isArray: true },
        "rule": { type: "DMN13__tDecisionRule", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tDecisionTable__extensionElements", isArray: false },
    },
    "DMN13__tInputClause__extensionElements": {
    },
    "DMN13__tInputClause": {
        "inputExpression": { type: "DMN13__tLiteralExpression", isArray: false },
        "inputValues": { type: "DMN13__tUnaryTests", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tInputClause__extensionElements", isArray: false },
    },
    "DMN13__tOutputClause__extensionElements": {
    },
    "DMN13__tOutputClause": {
        "@_name": { type: "string", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "outputValues": { type: "DMN13__tUnaryTests", isArray: false },
        "defaultOutputEntry": { type: "DMN13__tLiteralExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tOutputClause__extensionElements", isArray: false },
    },
    "DMN13__tRuleAnnotationClause": {
        "@_name": { type: "string", isArray: false },
    },
    "DMN13__tDecisionRule__extensionElements": {
    },
    "DMN13__tDecisionRule": {
        "inputEntry": { type: "DMN13__tUnaryTests", isArray: true },
        "outputEntry": { type: "DMN13__tLiteralExpression", isArray: true },
        "annotationEntry": { type: "DMN13__tRuleAnnotation", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tDecisionRule__extensionElements", isArray: false },
    },
    "DMN13__tRuleAnnotation": {
        "text": { type: "string", isArray: false },
    },
    "DMN13__tImportedValues__extensionElements": {
    },
    "DMN13__tImportedValues": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "importedElement": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tImportedValues__extensionElements", isArray: false },
    },
    "DMN13__tArtifact__extensionElements": {
    },
    "DMN13__tArtifact": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tArtifact__extensionElements", isArray: false },
    },
    "DMN13__tGroup__extensionElements": {
    },
    "DMN13__tGroup": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tGroup__extensionElements", isArray: false },
    },
    "DMN13__tTextAnnotation__extensionElements": {
    },
    "DMN13__tTextAnnotation": {
        "@_textFormat": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tTextAnnotation__extensionElements", isArray: false },
    },
    "DMN13__tAssociation__extensionElements": {
    },
    "DMN13__tAssociation": {
        "@_associationDirection": { type: "DMN13__tAssociationDirection", isArray: false },
        "sourceRef": { type: "DMN13__tDMNElementReference", isArray: false },
        "targetRef": { type: "DMN13__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tAssociation__extensionElements", isArray: false },
    },
    "DMN13__tContext__extensionElements": {
    },
    "DMN13__tContext": {
        "contextEntry": { type: "DMN13__tContextEntry", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tContext__extensionElements", isArray: false },
    },
    "DMN13__tContextEntry__extensionElements": {
    },
    "DMN13__tContextEntry": {
        "variable": { type: "DMN13__tInformationItem", isArray: false },
        "expression": { type: "DMN13__tExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tContextEntry__extensionElements", isArray: false },
    },
    "DMN13__tFunctionDefinition__extensionElements": {
    },
    "DMN13__tFunctionDefinition": {
        "@_kind": { type: "DMN13__tFunctionKind", isArray: false },
        "formalParameter": { type: "DMN13__tInformationItem", isArray: true },
        "expression": { type: "DMN13__tExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tFunctionDefinition__extensionElements", isArray: false },
    },
    "DMN13__tRelation__extensionElements": {
    },
    "DMN13__tRelation": {
        "column": { type: "DMN13__tInformationItem", isArray: true },
        "row": { type: "DMN13__tList", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tRelation__extensionElements", isArray: false },
    },
    "DMN13__tList__extensionElements": {
    },
    "DMN13__tList": {
        "expression": { type: "DMN13__tExpression", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tList__extensionElements", isArray: false },
    },
    "DMN13__tUnaryTests__extensionElements": {
    },
    "DMN13__tUnaryTests": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tUnaryTests__extensionElements", isArray: false },
    },
    "DMN13__tDecisionService__extensionElements": {
    },
    "DMN13__tDecisionService": {
        "outputDecision": { type: "DMN13__tDMNElementReference", isArray: true },
        "encapsulatedDecision": { type: "DMN13__tDMNElementReference", isArray: true },
        "inputDecision": { type: "DMN13__tDMNElementReference", isArray: true },
        "inputData": { type: "DMN13__tDMNElementReference", isArray: true },
        "variable": { type: "DMN13__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN13__tDecisionService__extensionElements", isArray: false },
    },
    "DMNDI13__DMNDI": {
        "dmndi:DMNDiagram": { type: "DMNDI13__DMNDiagram", isArray: true },
        "dmndi:DMNStyle": { type: "DMNDI13__DMNStyle", isArray: true },
    },
    "DMNDI13__DMNDiagram__extension": {
    },
    "DMNDI13__DMNDiagram": {
        "dmndi:Size": { type: "DC__Dimension", isArray: false },
        "dmndi:DMNDiagramElement": { type: "DI__DiagramElement", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_documentation": { type: "string", isArray: false },
        "@_resolution": { type: "float", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNDiagram__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNShape__extension": {
    },
    "DMNDI13__DMNShape": {
        "@_dmnElementRef": { type: "string", isArray: false },
        "@_isListedInputData": { type: "boolean", isArray: false },
        "@_isCollapsed": { type: "boolean", isArray: false },
        "dmndi:DMNLabel": { type: "DMNDI13__DMNLabel", isArray: false },
        "dmndi:DMNDecisionServiceDividerLine": { type: "DMNDI13__DMNDecisionServiceDividerLine", isArray: false },
        "dc:Bounds": { type: "DC__Bounds", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNShape__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNDecisionServiceDividerLine__extension": {
    },
    "DMNDI13__DMNDecisionServiceDividerLine": {
        "di:waypoint": { type: "DC__Point", isArray: true },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNDecisionServiceDividerLine__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNEdge__extension": {
    },
    "DMNDI13__DMNEdge": {
        "@_dmnElementRef": { type: "string", isArray: false },
        "@_sourceElement": { type: "string", isArray: false },
        "@_targetElement": { type: "string", isArray: false },
        "dmndi:DMNLabel": { type: "DMNDI13__DMNLabel", isArray: false },
        "di:waypoint": { type: "DC__Point", isArray: true },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNEdge__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNLabel__extension": {
    },
    "DMNDI13__DMNLabel": {
        "dmndi:Text": { type: "string", isArray: false },
        "dc:Bounds": { type: "DC__Bounds", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNLabel__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNStyle__extension": {
    },
    "DMNDI13__DMNStyle": {
        "@_fontFamily": { type: "string", isArray: false },
        "@_fontSize": { type: "float", isArray: false },
        "@_fontItalic": { type: "boolean", isArray: false },
        "@_fontBold": { type: "boolean", isArray: false },
        "@_fontUnderline": { type: "boolean", isArray: false },
        "@_fontStrikeThrough": { type: "boolean", isArray: false },
        "@_labelHorizontalAlignement": { type: "DC__AlignmentKind", isArray: false },
        "@_labelVerticalAlignment": { type: "DC__AlignmentKind", isArray: false },
        "dmndi:FillColor": { type: "DC__Color", isArray: false },
        "dmndi:StrokeColor": { type: "DC__Color", isArray: false },
        "dmndi:FontColor": { type: "DC__Color", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNStyle__extension", isArray: false },
    },
    "DC__Color": {
        "@_red": { type: "integer", isArray: false },
        "@_green": { type: "integer", isArray: false },
        "@_blue": { type: "integer", isArray: false },
    },
    "DC__Point": {
        "@_x": { type: "float", isArray: false },
        "@_y": { type: "float", isArray: false },
    },
    "DC__Dimension": {
        "@_width": { type: "float", isArray: false },
        "@_height": { type: "float", isArray: false },
    },
    "DC__Bounds": {
        "@_x": { type: "float", isArray: false },
        "@_y": { type: "float", isArray: false },
        "@_width": { type: "float", isArray: false },
        "@_height": { type: "float", isArray: false },
    },
    "DI__DiagramElement__extension": {
    },
    "DI__Diagram__extension": {
    },
    "DI__Shape__extension": {
    },
    "DI__Edge__extension": {
    },
    "DI__Style__extension": {
    },
}
