
export const root = {
    element: "definitions",
    type: "DMN14__tDefinitions" 
};

export const ns = new Map<string, string>([
    ["https://www.omg.org/spec/DMN/20211108/MODEL/", ""],
    ["", "https://www.omg.org/spec/DMN/20211108/MODEL/"],
    ["https://www.omg.org/spec/DMN/20191111/DMNDI/", "dmndi:"],
    ["dmndi:", "https://www.omg.org/spec/DMN/20191111/DMNDI/"],
    ["http://www.omg.org/spec/DMN/20180521/DC/", "dc:"],
    ["dc:", "http://www.omg.org/spec/DMN/20180521/DC/"],
    ["http://www.omg.org/spec/DMN/20180521/DI/", "di:"],
    ["di:", "http://www.omg.org/spec/DMN/20180521/DI/"],
]);

export const subs = {
  "": {
    "namedElement": "DMNElement",
    "informationRequirement": "DMNElement",
    "knowledgeRequirement": "DMNElement",
    "authorityRequirement": "DMNElement",
    "functionItem": "DMNElement",
    "artifact": "DMNElement",
    "contextEntry": "DMNElement",
    "definitions": "namedElement",
    "import": "namedElement",
    "elementCollection": "namedElement",
    "drgElement": "namedElement",
    "itemDefinition": "namedElement",
    "informationItem": "namedElement",
    "decision": "drgElement",
    "invocable": "drgElement",
    "inputData": "drgElement",
    "knowledgeSource": "drgElement",
    "performanceIndicator": "businessContextElement",
    "organizationUnit": "businessContextElement",
    "businessKnowledgeModel": "invocable",
    "decisionService": "invocable",
    "literalExpression": "expression",
    "invocation": "expression",
    "decisionTable": "expression",
    "context": "expression",
    "functionDefinition": "expression",
    "relation": "expression",
    "list": "expression",
    "for": "expression",
    "every": "expression",
    "some": "expression",
    "conditional": "expression",
    "filter": "expression",
    "group": "artifact",
    "textAnnotation": "artifact",
    "association": "artifact",
  },
  "dmndi:": {
    "dmndi:DMNShape": "dmndi:DMNDiagramElement",
    "dmndi:DMNEdge": "dmndi:DMNDiagramElement",
    "dmndi:DMNStyle": "di:Style",
  },
  "dc:": {

  },
  "di:": {

  },
};

export const elements = {
  "DMNElement": "DMN14__tDMNElement",
  "namedElement": "DMN14__tNamedElement",
  "definitions": "DMN14__tDefinitions",
  "import": "DMN14__tImport",
  "elementCollection": "DMN14__tElementCollection",
  "drgElement": "DMN14__tDRGElement",
  "decision": "DMN14__tDecision",
  "businessContextElement": "DMN14__tBusinessContextElement",
  "performanceIndicator": "DMN14__tPerformanceIndicator",
  "organizationUnit": "DMN14__tOrganizationUnit",
  "invocable": "DMN14__tInvocable",
  "businessKnowledgeModel": "DMN14__tBusinessKnowledgeModel",
  "inputData": "DMN14__tInputData",
  "knowledgeSource": "DMN14__tKnowledgeSource",
  "informationRequirement": "DMN14__tInformationRequirement",
  "knowledgeRequirement": "DMN14__tKnowledgeRequirement",
  "authorityRequirement": "DMN14__tAuthorityRequirement",
  "expression": "DMN14__tExpression",
  "itemDefinition": "DMN14__tItemDefinition",
  "functionItem": "DMN14__tFunctionItem",
  "literalExpression": "DMN14__tLiteralExpression",
  "invocation": "DMN14__tInvocation",
  "informationItem": "DMN14__tInformationItem",
  "decisionTable": "DMN14__tDecisionTable",
  "artifact": "DMN14__tArtifact",
  "group": "DMN14__tGroup",
  "textAnnotation": "DMN14__tTextAnnotation",
  "association": "DMN14__tAssociation",
  "context": "DMN14__tContext",
  "contextEntry": "DMN14__tContextEntry",
  "functionDefinition": "DMN14__tFunctionDefinition",
  "relation": "DMN14__tRelation",
  "list": "DMN14__tList",
  "decisionService": "DMN14__tDecisionService",
  "for": "DMN14__tFor",
  "every": "DMN14__tQuantified",
  "some": "DMN14__tQuantified",
  "conditional": "DMN14__tConditional",
  "filter": "DMN14__tFilter",
  "dmndi:DMNDI": "DMNDI13__DMNDI",
  "dmndi:DMNDiagram": "DMNDI13__DMNDiagram",
  "dmndi:DMNDiagramElement": "DMNDI13__DiagramElement",
  "dmndi:DMNShape": "DMNDI13__DMNShape",
  "dmndi:DMNEdge": "DMNDI13__DMNEdge",
  "dmndi:DMNStyle": "DMNDI13__DMNStyle",
  "dmndi:DMNLabel": "DMNDI13__DMNLabel",
  "dmndi:DMNDecisionServiceDividerLine": "DMNDI13__DMNDecisionServiceDividerLine",
  "dc:Color": "DC__Color",
  "dc:Point": "DC__Point",
  "dc:Bounds": "DC__Bounds",
  "dc:Dimension": "DC__Dimension",
  "di:Style": "DI__Style",
};

export const meta = {
    "DMN14__tDMNElement__extensionElements": {
    },
    "DMN14__tDMNElement": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tDMNElement__extensionElements", isArray: false },
    },
    "DMN14__tNamedElement__extensionElements": {
    },
    "DMN14__tNamedElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tNamedElement__extensionElements", isArray: false },
    },
    "DMN14__tDMNElementReference": {
        "@_href": { type: "string", isArray: false },
    },
    "DMN14__tDefinitions__extensionElements": {
    },
    "DMN14__tDefinitions": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "@_typeLanguage": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_exporter": { type: "string", isArray: false },
        "@_exporterVersion": { type: "string", isArray: false },
        "import": { type: "DMN14__tImport", isArray: true },
        "itemDefinition": { type: "DMN14__tItemDefinition", isArray: true },
        "drgElement": { type: "DMN14__tDRGElement", isArray: true },
        "artifact": { type: "DMN14__tArtifact", isArray: true },
        "elementCollection": { type: "DMN14__tElementCollection", isArray: true },
        "businessContextElement": { type: "DMN14__tBusinessContextElement", isArray: true },
        "dmndi:DMNDI": { type: "DMNDI13__DMNDI", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tDefinitions__extensionElements", isArray: false },
    },
    "DMN14__tImport__extensionElements": {
    },
    "DMN14__tImport": {
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tImport__extensionElements", isArray: false },
    },
    "DMN14__tElementCollection__extensionElements": {
    },
    "DMN14__tElementCollection": {
        "drgElement": { type: "DMN14__tDMNElementReference", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tElementCollection__extensionElements", isArray: false },
    },
    "DMN14__tDRGElement__extensionElements": {
    },
    "DMN14__tDRGElement": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tDRGElement__extensionElements", isArray: false },
    },
    "DMN14__tDecision__extensionElements": {
    },
    "DMN14__tDecision": {
        "question": { type: "string", isArray: false },
        "allowedAnswers": { type: "string", isArray: false },
        "variable": { type: "DMN14__tInformationItem", isArray: false },
        "informationRequirement": { type: "DMN14__tInformationRequirement", isArray: true },
        "knowledgeRequirement": { type: "DMN14__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "DMN14__tAuthorityRequirement", isArray: true },
        "supportedObjective": { type: "DMN14__tDMNElementReference", isArray: true },
        "impactedPerformanceIndicator": { type: "DMN14__tDMNElementReference", isArray: true },
        "decisionMaker": { type: "DMN14__tDMNElementReference", isArray: true },
        "decisionOwner": { type: "DMN14__tDMNElementReference", isArray: true },
        "usingProcess": { type: "DMN14__tDMNElementReference", isArray: true },
        "usingTask": { type: "DMN14__tDMNElementReference", isArray: true },
        "expression": { type: "DMN14__tExpression", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tDecision__extensionElements", isArray: false },
    },
    "DMN14__tBusinessContextElement__extensionElements": {
    },
    "DMN14__tBusinessContextElement": {
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tBusinessContextElement__extensionElements", isArray: false },
    },
    "DMN14__tPerformanceIndicator__extensionElements": {
    },
    "DMN14__tPerformanceIndicator": {
        "impactingDecision": { type: "DMN14__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tPerformanceIndicator__extensionElements", isArray: false },
    },
    "DMN14__tOrganizationUnit__extensionElements": {
    },
    "DMN14__tOrganizationUnit": {
        "decisionMade": { type: "DMN14__tDMNElementReference", isArray: true },
        "decisionOwned": { type: "DMN14__tDMNElementReference", isArray: true },
        "@_URI": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tOrganizationUnit__extensionElements", isArray: false },
    },
    "DMN14__tInvocable__extensionElements": {
    },
    "DMN14__tInvocable": {
        "variable": { type: "DMN14__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tInvocable__extensionElements", isArray: false },
    },
    "DMN14__tBusinessKnowledgeModel__extensionElements": {
    },
    "DMN14__tBusinessKnowledgeModel": {
        "encapsulatedLogic": { type: "DMN14__tFunctionDefinition", isArray: false },
        "knowledgeRequirement": { type: "DMN14__tKnowledgeRequirement", isArray: true },
        "authorityRequirement": { type: "DMN14__tAuthorityRequirement", isArray: true },
        "variable": { type: "DMN14__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tBusinessKnowledgeModel__extensionElements", isArray: false },
    },
    "DMN14__tInputData__extensionElements": {
    },
    "DMN14__tInputData": {
        "variable": { type: "DMN14__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tInputData__extensionElements", isArray: false },
    },
    "DMN14__tKnowledgeSource__extensionElements": {
    },
    "DMN14__tKnowledgeSource": {
        "@_locationURI": { type: "string", isArray: false },
        "authorityRequirement": { type: "DMN14__tAuthorityRequirement", isArray: true },
        "type": { type: "string", isArray: false },
        "owner": { type: "DMN14__tDMNElementReference", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tKnowledgeSource__extensionElements", isArray: false },
    },
    "DMN14__tInformationRequirement__extensionElements": {
    },
    "DMN14__tInformationRequirement": {
        "requiredDecision": { type: "DMN14__tDMNElementReference", isArray: false },
        "requiredInput": { type: "DMN14__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tInformationRequirement__extensionElements", isArray: false },
    },
    "DMN14__tKnowledgeRequirement__extensionElements": {
    },
    "DMN14__tKnowledgeRequirement": {
        "requiredKnowledge": { type: "DMN14__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tKnowledgeRequirement__extensionElements", isArray: false },
    },
    "DMN14__tAuthorityRequirement__extensionElements": {
    },
    "DMN14__tAuthorityRequirement": {
        "requiredDecision": { type: "DMN14__tDMNElementReference", isArray: false },
        "requiredInput": { type: "DMN14__tDMNElementReference", isArray: false },
        "requiredAuthority": { type: "DMN14__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tAuthorityRequirement__extensionElements", isArray: false },
    },
    "DMN14__tExpression__extensionElements": {
    },
    "DMN14__tExpression": {
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tExpression__extensionElements", isArray: false },
    },
    "DMN14__tItemDefinition__extensionElements": {
    },
    "DMN14__tItemDefinition": {
        "@_typeLanguage": { type: "string", isArray: false },
        "@_isCollection": { type: "boolean", isArray: false },
        "itemComponent": { type: "DMN14__tItemDefinition", isArray: true },
        "functionItem": { type: "DMN14__tFunctionItem", isArray: false },
        "typeRef": { type: "string", isArray: false },
        "allowedValues": { type: "DMN14__tUnaryTests", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tItemDefinition__extensionElements", isArray: false },
    },
    "DMN14__tFunctionItem__extensionElements": {
    },
    "DMN14__tFunctionItem": {
        "@_outputTypeRef": { type: "string", isArray: false },
        "parameters": { type: "DMN14__tInformationItem", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tFunctionItem__extensionElements", isArray: false },
    },
    "DMN14__tLiteralExpression__extensionElements": {
    },
    "DMN14__tLiteralExpression": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "importedValues": { type: "DMN14__tImportedValues", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tLiteralExpression__extensionElements", isArray: false },
    },
    "DMN14__tInvocation__extensionElements": {
    },
    "DMN14__tInvocation": {
        "expression": { type: "DMN14__tExpression", isArray: false },
        "binding": { type: "DMN14__tBinding", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tInvocation__extensionElements", isArray: false },
    },
    "DMN14__tBinding": {
        "parameter": { type: "DMN14__tInformationItem", isArray: false },
        "expression": { type: "DMN14__tExpression", isArray: false },
    },
    "DMN14__tInformationItem__extensionElements": {
    },
    "DMN14__tInformationItem": {
        "@_typeRef": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tInformationItem__extensionElements", isArray: false },
    },
    "DMN14__tDecisionTable__extensionElements": {
    },
    "DMN14__tDecisionTable": {
        "@_hitPolicy": { type: "DMN14__tHitPolicy", isArray: false },
        "@_aggregation": { type: "DMN14__tBuiltinAggregator", isArray: false },
        "@_preferredOrientation": { type: "DMN14__tDecisionTableOrientation", isArray: false },
        "@_outputLabel": { type: "string", isArray: false },
        "input": { type: "DMN14__tInputClause", isArray: true },
        "output": { type: "DMN14__tOutputClause", isArray: true },
        "annotation": { type: "DMN14__tRuleAnnotationClause", isArray: true },
        "rule": { type: "DMN14__tDecisionRule", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tDecisionTable__extensionElements", isArray: false },
    },
    "DMN14__tInputClause__extensionElements": {
    },
    "DMN14__tInputClause": {
        "inputExpression": { type: "DMN14__tLiteralExpression", isArray: false },
        "inputValues": { type: "DMN14__tUnaryTests", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tInputClause__extensionElements", isArray: false },
    },
    "DMN14__tOutputClause__extensionElements": {
    },
    "DMN14__tOutputClause": {
        "@_name": { type: "string", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "outputValues": { type: "DMN14__tUnaryTests", isArray: false },
        "defaultOutputEntry": { type: "DMN14__tLiteralExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tOutputClause__extensionElements", isArray: false },
    },
    "DMN14__tRuleAnnotationClause": {
        "@_name": { type: "string", isArray: false },
    },
    "DMN14__tDecisionRule__extensionElements": {
    },
    "DMN14__tDecisionRule": {
        "inputEntry": { type: "DMN14__tUnaryTests", isArray: true },
        "outputEntry": { type: "DMN14__tLiteralExpression", isArray: true },
        "annotationEntry": { type: "DMN14__tRuleAnnotation", isArray: true },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tDecisionRule__extensionElements", isArray: false },
    },
    "DMN14__tRuleAnnotation": {
        "text": { type: "string", isArray: false },
    },
    "DMN14__tImportedValues__extensionElements": {
    },
    "DMN14__tImportedValues": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "importedElement": { type: "string", isArray: false },
        "@_namespace": { type: "string", isArray: false },
        "@_locationURI": { type: "string", isArray: false },
        "@_importType": { type: "string", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tImportedValues__extensionElements", isArray: false },
    },
    "DMN14__tArtifact__extensionElements": {
    },
    "DMN14__tArtifact": {
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tArtifact__extensionElements", isArray: false },
    },
    "DMN14__tGroup__extensionElements": {
    },
    "DMN14__tGroup": {
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tGroup__extensionElements", isArray: false },
    },
    "DMN14__tTextAnnotation__extensionElements": {
    },
    "DMN14__tTextAnnotation": {
        "@_textFormat": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tTextAnnotation__extensionElements", isArray: false },
    },
    "DMN14__tAssociation__extensionElements": {
    },
    "DMN14__tAssociation": {
        "@_associationDirection": { type: "DMN14__tAssociationDirection", isArray: false },
        "sourceRef": { type: "DMN14__tDMNElementReference", isArray: false },
        "targetRef": { type: "DMN14__tDMNElementReference", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tAssociation__extensionElements", isArray: false },
    },
    "DMN14__tContext__extensionElements": {
    },
    "DMN14__tContext": {
        "contextEntry": { type: "DMN14__tContextEntry", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tContext__extensionElements", isArray: false },
    },
    "DMN14__tContextEntry__extensionElements": {
    },
    "DMN14__tContextEntry": {
        "variable": { type: "DMN14__tInformationItem", isArray: false },
        "expression": { type: "DMN14__tExpression", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tContextEntry__extensionElements", isArray: false },
    },
    "DMN14__tFunctionDefinition__extensionElements": {
    },
    "DMN14__tFunctionDefinition": {
        "@_kind": { type: "DMN14__tFunctionKind", isArray: false },
        "formalParameter": { type: "DMN14__tInformationItem", isArray: true },
        "expression": { type: "DMN14__tExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tFunctionDefinition__extensionElements", isArray: false },
    },
    "DMN14__tRelation__extensionElements": {
    },
    "DMN14__tRelation": {
        "column": { type: "DMN14__tInformationItem", isArray: true },
        "row": { type: "DMN14__tList", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tRelation__extensionElements", isArray: false },
    },
    "DMN14__tList__extensionElements": {
    },
    "DMN14__tList": {
        "expression": { type: "DMN14__tExpression", isArray: true },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tList__extensionElements", isArray: false },
    },
    "DMN14__tUnaryTests__extensionElements": {
    },
    "DMN14__tUnaryTests": {
        "@_expressionLanguage": { type: "string", isArray: false },
        "text": { type: "string", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tUnaryTests__extensionElements", isArray: false },
    },
    "DMN14__tDecisionService__extensionElements": {
    },
    "DMN14__tDecisionService": {
        "outputDecision": { type: "DMN14__tDMNElementReference", isArray: true },
        "encapsulatedDecision": { type: "DMN14__tDMNElementReference", isArray: true },
        "inputDecision": { type: "DMN14__tDMNElementReference", isArray: true },
        "inputData": { type: "DMN14__tDMNElementReference", isArray: true },
        "variable": { type: "DMN14__tInformationItem", isArray: false },
        "@_name": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tDecisionService__extensionElements", isArray: false },
    },
    "DMN14__tChildExpression": {
        "@_id": { type: "string", isArray: false },
        "expression": { type: "DMN14__tExpression", isArray: false },
    },
    "DMN14__tTypedChildExpression": {
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "expression": { type: "DMN14__tExpression", isArray: false },
    },
    "DMN14__tIterator__extensionElements": {
    },
    "DMN14__tIterator": {
        "@_iteratorVariable": { type: "string", isArray: false },
        "in": { type: "DMN14__tTypedChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tIterator__extensionElements", isArray: false },
    },
    "DMN14__tFor__extensionElements": {
    },
    "DMN14__tFor": {
        "return": { type: "DMN14__tChildExpression", isArray: false },
        "@_iteratorVariable": { type: "string", isArray: false },
        "in": { type: "DMN14__tTypedChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tFor__extensionElements", isArray: false },
    },
    "DMN14__tQuantified__extensionElements": {
    },
    "DMN14__tQuantified": {
        "satisfies": { type: "DMN14__tChildExpression", isArray: false },
        "@_iteratorVariable": { type: "string", isArray: false },
        "in": { type: "DMN14__tTypedChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tQuantified__extensionElements", isArray: false },
    },
    "DMN14__tConditional__extensionElements": {
    },
    "DMN14__tConditional": {
        "if": { type: "DMN14__tChildExpression", isArray: false },
        "then": { type: "DMN14__tChildExpression", isArray: false },
        "else": { type: "DMN14__tChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tConditional__extensionElements", isArray: false },
    },
    "DMN14__tFilter__extensionElements": {
    },
    "DMN14__tFilter": {
        "in": { type: "DMN14__tChildExpression", isArray: false },
        "match": { type: "DMN14__tChildExpression", isArray: false },
        "@_typeRef": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "@_label": { type: "string", isArray: false },
        "description": { type: "string", isArray: false },
        "extensionElements": { type: "DMN14__tFilter__extensionElements", isArray: false },
    },
    "DMNDI13__DMNDI": {
        "dmndi:DMNDiagram": { type: "DMNDI13__DMNDiagram", isArray: true },
        "dmndi:DMNStyle": { type: "DMNDI13__DMNStyle", isArray: true },
    },
    "DMNDI13__DMNDiagram__extension": {
    },
    "DMNDI13__DMNDiagram": {
        "dmndi:Size": { type: "DC__Dimension", isArray: false },
        "dmndi:DMNDiagramElement": { type: "DI__DiagramElement", isArray: true },
        "@_name": { type: "string", isArray: false },
        "@_documentation": { type: "string", isArray: false },
        "@_resolution": { type: "float", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNDiagram__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNShape__extension": {
    },
    "DMNDI13__DMNShape": {
        "@_dmnElementRef": { type: "string", isArray: false },
        "@_isListedInputData": { type: "boolean", isArray: false },
        "@_isCollapsed": { type: "boolean", isArray: false },
        "dmndi:DMNLabel": { type: "DMNDI13__DMNLabel", isArray: false },
        "dmndi:DMNDecisionServiceDividerLine": { type: "DMNDI13__DMNDecisionServiceDividerLine", isArray: false },
        "dc:Bounds": { type: "DC__Bounds", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNShape__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNDecisionServiceDividerLine__extension": {
    },
    "DMNDI13__DMNDecisionServiceDividerLine": {
        "di:waypoint": { type: "DC__Point", isArray: true },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNDecisionServiceDividerLine__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNEdge__extension": {
    },
    "DMNDI13__DMNEdge": {
        "@_dmnElementRef": { type: "string", isArray: false },
        "@_sourceElement": { type: "string", isArray: false },
        "@_targetElement": { type: "string", isArray: false },
        "dmndi:DMNLabel": { type: "DMNDI13__DMNLabel", isArray: false },
        "di:waypoint": { type: "DC__Point", isArray: true },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNEdge__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNLabel__extension": {
    },
    "DMNDI13__DMNLabel": {
        "dmndi:Text": { type: "string", isArray: false },
        "dc:Bounds": { type: "DC__Bounds", isArray: false },
        "@_sharedStyle": { type: "string", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNLabel__extension", isArray: false },
        "di:Style": { type: "DI__Style", isArray: false },
    },
    "DMNDI13__DMNStyle__extension": {
    },
    "DMNDI13__DMNStyle": {
        "@_fontFamily": { type: "string", isArray: false },
        "@_fontSize": { type: "float", isArray: false },
        "@_fontItalic": { type: "boolean", isArray: false },
        "@_fontBold": { type: "boolean", isArray: false },
        "@_fontUnderline": { type: "boolean", isArray: false },
        "@_fontStrikeThrough": { type: "boolean", isArray: false },
        "@_labelHorizontalAlignement": { type: "DC__AlignmentKind", isArray: false },
        "@_labelVerticalAlignment": { type: "DC__AlignmentKind", isArray: false },
        "dmndi:FillColor": { type: "DC__Color", isArray: false },
        "dmndi:StrokeColor": { type: "DC__Color", isArray: false },
        "dmndi:FontColor": { type: "DC__Color", isArray: false },
        "@_id": { type: "string", isArray: false },
        "di:extension": { type: "DMNDI13__DMNStyle__extension", isArray: false },
    },
    "DC__Color": {
        "@_red": { type: "integer", isArray: false },
        "@_green": { type: "integer", isArray: false },
        "@_blue": { type: "integer", isArray: false },
    },
    "DC__Point": {
        "@_x": { type: "float", isArray: false },
        "@_y": { type: "float", isArray: false },
    },
    "DC__Dimension": {
        "@_width": { type: "float", isArray: false },
        "@_height": { type: "float", isArray: false },
    },
    "DC__Bounds": {
        "@_x": { type: "float", isArray: false },
        "@_y": { type: "float", isArray: false },
        "@_width": { type: "float", isArray: false },
        "@_height": { type: "float", isArray: false },
    },
    "DI__DiagramElement__extension": {
    },
    "DI__Diagram__extension": {
    },
    "DI__Shape__extension": {
    },
    "DI__Edge__extension": {
    },
    "DI__Style__extension": {
    },
}
