/// <reference types="node" />
export declare type XmlParserTs<T extends object> = {
    parse: (args: {
        xml: string | Buffer;
        domdoc?: Document;
        instanceNs?: Map<string, string>;
    }) => {
        json: T;
        instanceNs: Map<string, string>;
    };
    build: (args: {
        json: T;
        instanceNs: Map<string, string>;
    }) => string;
};
export declare type XmlParserTsRootElementBaseType = Partial<{
    [k: `@_xmlns:${string}`]: string;
}> & {
    "@_xmlns"?: string;
};
export declare type MetaTypeDef = {
    type: string;
    isArray: boolean;
};
export declare type Meta = Record<string, Record<string, MetaTypeDef>>;
export declare type Root = {
    element: string;
    type: string;
};
export declare type Subs = Record<string, Record<string, string>>;
export declare type Elements = Record<string, string>;
export declare const domParser: {
    getDomDocument: (xml: string | Buffer) => Document;
};
export declare function getInstanceNs(domdoc: Document): Map<string, string>;
export declare function getParser<T extends object>(args: {
    meta: Meta;
    subs: Subs;
    elements: Elements;
    ns: Map<string, string>;
    root: Root;
}): XmlParserTs<T>;
export declare function parse(args: {
    node: Node;
    nodeType: Record<string, MetaTypeDef | undefined> | undefined;
    ns: Map<string, string>;
    instanceNs: Map<string, string>;
    meta: Meta;
    elements: Elements;
    subs: Subs;
}): any;
export declare function build(args: {
    json: any;
    ns: Map<string, string>;
    instanceNs: Map<string, string>;
    indent: string;
}): string;
export declare type NamespacedProperty<P extends string, K> = K extends string ? K extends `@_${string}` | `${string}:${string}` ? K : `${P}:${K}` : never;
export declare type Namespaced<P extends string, T> = {
    [K in keyof T as NamespacedProperty<P, K>]: NonNullable<T[K]> extends Array<infer R> ? Array<Namespaced<P, R>> : T[K];
};
export declare function mergeMetas(base: Meta, extensionMetasByPrefix: [string, Meta][]): any;
//# sourceMappingURL=index.d.ts.map