"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeMetas = exports.build = exports.parse = exports.getParser = exports.getInstanceNs = exports.domParser = void 0;
exports.domParser = {
    getDomDocument: function (xml) {
        var domdoc = new DOMParser().parseFromString(xml.toString(), "application/xml");
        return domdoc;
    },
};
function getInstanceNs(domdoc) {
    var nsMap = new Map(__spreadArray([], __read(domdoc.documentElement.attributes), false).flatMap(function (attr) {
        if (!attr.name.startsWith("xmlns")) {
            return [];
        }
        var nsUri = attr.value;
        var s = attr.name.split(":");
        if (s.length === 1) {
            return [
                [nsUri, ""],
                ["", nsUri],
            ];
        }
        else if (s.length === 2) {
            return [
                [nsUri, "".concat(s[1], ":")],
                ["".concat(s[1], ":"), nsUri],
            ];
        }
        else {
            throw new Error("Invalid xmlns mapping attribute '".concat(attr.name, "'"));
        }
    }));
    return nsMap;
}
exports.getInstanceNs = getInstanceNs;
function getParser(args) {
    return {
        parse: function (_a) {
            var _b;
            var xml = _a.xml, domdoc = _a.domdoc, instanceNs = _a.instanceNs;
            domdoc = domdoc !== null && domdoc !== void 0 ? domdoc : exports.domParser.getDomDocument(xml);
            instanceNs = instanceNs !== null && instanceNs !== void 0 ? instanceNs : getInstanceNs(domdoc);
            var rootType = (_b = {}, _b[args.root.element] = { type: args.root.type, isArray: false }, _b);
            var json = parse(__assign(__assign({}, args), { instanceNs: instanceNs, node: domdoc, nodeType: rootType }));
            return { json: json, instanceNs: instanceNs };
        },
        build: function (_a) {
            var json = _a.json, instanceNs = _a.instanceNs;
            var xml = build({ json: json, ns: args.ns, instanceNs: instanceNs, indent: "" });
            return xml;
        },
    };
}
exports.getParser = getParser;
function parse(args) {
    var _a, _b, _c, _d, _e, _f, _g;
    var _h;
    var json = {};
    var children = args.node.childNodes;
    for (var ii = 0; ii < children.length; ii++) {
        var elemNode = children[ii];
        if (elemNode.nodeType === 1) {
            var _j = resolveElement(elemNode.nodeName, args.nodeType, args), nsedName = _j.nsedName, subsedName = _j.subsedName;
            var elemPropType = (_a = args.nodeType) === null || _a === void 0 ? void 0 : _a[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName];
            var elemType = (_b = args.meta[args.elements[nsedName]]) !== null && _b !== void 0 ? _b : (elemPropType
                ? args.meta[elemPropType.type]
                : undefined);
            var elemValue = void 0;
            if ((elemPropType === null || elemPropType === void 0 ? void 0 : elemPropType.type) === "string") {
                elemValue = (_c = elemNode.textContent) !== null && _c !== void 0 ? _c : "";
            }
            else if ((elemPropType === null || elemPropType === void 0 ? void 0 : elemPropType.type) === "boolean") {
                elemValue = parseBoolean((_d = elemNode.textContent) !== null && _d !== void 0 ? _d : "");
            }
            else if ((elemPropType === null || elemPropType === void 0 ? void 0 : elemPropType.type) === "float") {
                elemValue = parseFloat((_e = elemNode.textContent) !== null && _e !== void 0 ? _e : "");
            }
            else if ((elemPropType === null || elemPropType === void 0 ? void 0 : elemPropType.type) === "integer") {
                elemValue = parseFloat((_f = elemNode.textContent) !== null && _f !== void 0 ? _f : "");
            }
            else {
                elemValue = parse(__assign(__assign({}, args), { node: elemNode, nodeType: elemType }));
                if (subsedName !== nsedName) {
                    elemValue["__$$element"] = nsedName;
                }
            }
            var attrs = elemNode.attributes;
            for (var i = 0; i < attrs.length; i++) {
                var attr = attrs[i];
                var attrPropType = elemType === null || elemType === void 0 ? void 0 : elemType["@_".concat(attr.name)];
                var attrValue = void 0;
                if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "string") {
                    attrValue = attr.value;
                }
                else if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "boolean") {
                    attrValue = parseBoolean(attr.value);
                }
                else if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "float") {
                    attrValue = parseFloat(attr.value);
                }
                else if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "integer") {
                    attrValue = parseFloat(attr.value);
                }
                else if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "allNNI") {
                    attrValue = parseAllNNI(attr.value);
                }
                else {
                    attrValue = attr.value;
                }
                elemValue["@_".concat(attr.name)] = attrValue;
            }
            var currentValue = json[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName];
            if (elemPropType === null || elemPropType === void 0 ? void 0 : elemPropType.isArray) {
                (_g = json[_h = subsedName !== null && subsedName !== void 0 ? subsedName : nsedName]) !== null && _g !== void 0 ? _g : (json[_h] = []);
                json[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName].push(elemValue);
            }
            else if (currentValue) {
                if (elemPropType && !elemPropType.isArray) {
                    console.warn("[xml-parser-ts] Accumulating values on known non-array property '".concat(subsedName, "' (").concat(nsedName, ") of type '").concat(elemPropType.type, "'."));
                }
                if (Array.isArray(currentValue)) {
                    currentValue.push(elemValue);
                }
                else {
                    json[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName] = [currentValue, elemValue];
                }
            }
            else {
                json[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName] = elemValue;
            }
        }
    }
    return json;
}
exports.parse = parse;
function resolveElement(name, parentType, _a) {
    var _b, _c;
    var ns = _a.ns, instanceNs = _a.instanceNs, subs = _a.subs;
    var nameNs = undefined;
    var nameName = undefined;
    var s = name.split(":");
    if (s.length === 1) {
        nameNs = (_b = ns.get(instanceNs.get(""))) !== null && _b !== void 0 ? _b : "";
        nameName = s[0];
    }
    else if (s.length === 2) {
        nameNs = (_c = ns.get(instanceNs.get("".concat(s[0], ":")))) !== null && _c !== void 0 ? _c : "".concat(s[0], ":");
        nameName = s[1];
    }
    else {
        throw new Error(name);
    }
    var nsedName = "".concat(nameNs).concat(nameName);
    var nsedSubs = subs[nameNs];
    var subsedName = nsedName;
    while (nsedSubs && !(parentType === null || parentType === void 0 ? void 0 : parentType[subsedName])) {
        if (subsedName === undefined) {
            break;
        }
        subsedName = nsedSubs[subsedName];
    }
    return { nsedName: nsedName, subsedName: subsedName };
}
function parseInt(attrValue) {
    var i;
    try {
        i = Number.parseInt(attrValue);
    }
    catch (e) {
        throw new Error("Cannot parse integer value '".concat(attrValue, "'"));
    }
    if (Number.isNaN(i)) {
        throw new Error("Stopping NaN from propagating. Tried to parse from (integer) '".concat(attrValue, "'"));
    }
    return i;
}
function parseFloat(attrValue) {
    var f;
    try {
        f = Number.parseFloat(attrValue);
    }
    catch (e) {
        throw new Error("Cannot parse float value '".concat(attrValue, "'"));
    }
    if (Number.isNaN(f)) {
        throw new Error("Stopping NaN from propagating. Tried to parse from (float) '".concat(attrValue, "'"));
    }
    return f;
}
function parseAllNNI(attrValue) {
    try {
        return attrValue === "unbounded" ? "unbounded" : parseInt(attrValue);
    }
    catch (e) {
        throw new Error("Cannot parse allNNI value '".concat(attrValue, "'"));
    }
}
function parseBoolean(attrValue) {
    if (attrValue === "true") {
        return true;
    }
    else if (attrValue === "false") {
        return false;
    }
    else {
        throw new Error("Cannot parse boolean value '".concat(attrValue, "'"));
    }
}
var ampEntity = { regex: new RegExp("&", "g"), replacement: "&amp;" };
var gtEntity = { regex: new RegExp(">", "g"), replacement: "&gt;" };
var ltEntity = { regex: new RegExp("<", "g"), replacement: "&lt;" };
var aposEntity = { regex: new RegExp("'", "g"), replacement: "&apos;" };
var quotEntity = { regex: new RegExp("\"", "g"), replacement: "&quot;" };
function applyEntities(value) {
    return "".concat(value)
        .replace(ampEntity.regex, ampEntity.replacement)
        .replace(gtEntity.regex, gtEntity.replacement)
        .replace(ltEntity.regex, ltEntity.replacement)
        .replace(aposEntity.regex, aposEntity.replacement)
        .replace(quotEntity.regex, quotEntity.replacement);
}
function buildAttrs(json) {
    var isEmpty = true;
    var attrs = " ";
    for (var propName in json) {
        if (propName[0] === "@") {
            attrs += "".concat(propName.substring(2), "=\"").concat(applyEntities(json[propName]), "\" ");
        }
        else if (propName !== "__$$element") {
            isEmpty = false;
        }
    }
    if (typeof json !== "object") {
        isEmpty = false;
    }
    return { attrs: attrs.substring(0, attrs.length - 1), isEmpty: isEmpty };
}
function build(args) {
    var e_1, _a;
    var _b, _c;
    var json = args.json, ns = args.ns, instanceNs = args.instanceNs, indent = args.indent;
    if (typeof json !== "object" || json === null) {
        throw new Error("Can't build XML from a non-object value. '".concat(json, "'."));
    }
    var xml = "";
    for (var _propName in json) {
        var propName = applyEntities(_propName);
        var propValue = json[propName];
        if (propName[0] === "@") {
            continue;
        }
        else if (propName === "__$$element") {
            continue;
        }
        else if (propName[0] === "?") {
            xml += "".concat(indent, "<").concat(propName).concat(buildAttrs(propValue).attrs, " ?>\n");
        }
        else if (propValue === undefined || propValue === null || propValue === "") {
            var elementName = applyInstanceNs({ ns: ns, instanceNs: instanceNs, propName: propName });
            xml += "".concat(indent, "<").concat(elementName, " />\n");
        }
        else if (typeof propValue !== "object") {
            var elementName = applyInstanceNs({ ns: ns, instanceNs: instanceNs, propName: propName });
            xml += "".concat(indent, "<").concat(elementName, ">").concat(applyEntities(propValue), "</").concat(elementName, ">\n");
        }
        else if (Array.isArray(propValue)) {
            try {
                for (var propValue_1 = (e_1 = void 0, __values(propValue)), propValue_1_1 = propValue_1.next(); !propValue_1_1.done; propValue_1_1 = propValue_1.next()) {
                    var item = propValue_1_1.value;
                    var elementName = applyInstanceNs({ ns: ns, instanceNs: instanceNs, propName: (_b = item["__$$element"]) !== null && _b !== void 0 ? _b : propName });
                    var _d = buildAttrs(item), attrs = _d.attrs, isEmpty = _d.isEmpty;
                    xml += "".concat(indent, "<").concat(elementName).concat(attrs);
                    if (isEmpty) {
                        xml += " />\n";
                    }
                    else if (typeof item === "object") {
                        xml += ">\n".concat(build(__assign(__assign({}, args), { json: item, indent: "".concat(indent, "  ") })));
                        xml += "".concat(indent, "</").concat(elementName, ">\n");
                    }
                    else {
                        xml += ">".concat(applyEntities(item), "</").concat(elementName, ">\n");
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (propValue_1_1 && !propValue_1_1.done && (_a = propValue_1.return)) _a.call(propValue_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        else {
            var item = propValue;
            var elementName = applyInstanceNs({ ns: ns, instanceNs: instanceNs, propName: (_c = item["__$$element"]) !== null && _c !== void 0 ? _c : propName });
            var _e = buildAttrs(item), attrs = _e.attrs, isEmpty = _e.isEmpty;
            xml += "".concat(indent, "<").concat(elementName).concat(attrs);
            if (isEmpty) {
                xml += " />\n";
            }
            else if (typeof item === "object") {
                xml += ">\n".concat(build(__assign(__assign({}, args), { json: item, indent: "".concat(indent, "  ") })));
                xml += "".concat(indent, "</").concat(elementName, ">\n");
            }
            else {
                xml += ">".concat(applyEntities(item), "</").concat(elementName, ">\n");
            }
        }
    }
    return xml;
}
exports.build = build;
function applyInstanceNs(_a) {
    var _b, _c, _d;
    var propName = _a.propName, ns = _a.ns, instanceNs = _a.instanceNs;
    var s = propName.split(":");
    if (s.length === 1) {
        var newPropertyNs = (_b = instanceNs.get(ns.get(""))) !== null && _b !== void 0 ? _b : "";
        return "".concat(newPropertyNs).concat(propName);
    }
    else if (s.length === 2) {
        var propertyNs = "".concat(s[0], ":");
        var newPropertyNs = (_d = instanceNs.get((_c = ns.get(propertyNs)) !== null && _c !== void 0 ? _c : "obviously non-existent key")) !== null && _d !== void 0 ? _d : propertyNs;
        return "".concat(newPropertyNs).concat(s[1]);
    }
    else {
        throw new Error("Invalid tag name '".concat(propName, "'."));
    }
}
function mergeMetas(base, extensionMetasByPrefix) {
    var prefixedMetas = extensionMetasByPrefix.reduce(function (acc, _a) {
        var _b = __read(_a, 2), k = _b[0], m = _b[1];
        return __assign(__assign({}, acc), Object.keys(m).reduce(function (macc, t) {
            macc[t] = Object.keys(m[t]).reduce(function (tacc, p) {
                if (p.includes(":") || p.startsWith("@_")) {
                    tacc[p] = m[t][p];
                }
                else {
                    tacc["".concat(k).concat(p)] = m[t][p];
                }
                return tacc;
            }, {});
            return macc;
        }, {}));
    }, {});
    return __assign(__assign({}, base), prefixedMetas);
}
exports.mergeMetas = mergeMetas;
//# sourceMappingURL=index.js.map