'use strict';

exports.__esModule = true;

var _inherits = require('inherits');

var _inherits2 = _interopRequireDefault(_inherits);

var _compiler = require('../../../schema/compiler');

var _compiler2 = _interopRequireDefault(_compiler);

var _utils = require('../utils');

var utils = _interopRequireWildcard(_utils);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function SchemaCompiler_Oracle() {
  _compiler2.default.apply(this, arguments);
}
// Oracle Schema Compiler
// -------

(0, _inherits2.default)(SchemaCompiler_Oracle, _compiler2.default);

// Rename a table on the schema.
SchemaCompiler_Oracle.prototype.renameTable = function (tableName, to) {
  this.pushQuery('rename ' + this.formatter.wrap(tableName) + ' to ' + this.formatter.wrap(to));
};

// Check whether a table exists on the query.
SchemaCompiler_Oracle.prototype.hasTable = function (tableName) {
  this.pushQuery({
    sql: 'select TABLE_NAME from USER_TABLES where TABLE_NAME = ' + this.formatter.parameter(tableName),
    output: function output(resp) {
      return resp.length > 0;
    }
  });
};

// Check whether a column exists on the schema.
SchemaCompiler_Oracle.prototype.hasColumn = function (tableName, column) {
  var sql = 'select COLUMN_NAME from USER_TAB_COLUMNS ' + ('where TABLE_NAME = ' + this.formatter.parameter(tableName) + ' ') + ('and COLUMN_NAME = ' + this.formatter.parameter(column));
  this.pushQuery({ sql: sql, output: function output(resp) {
      return resp.length > 0;
    } });
};

SchemaCompiler_Oracle.prototype.dropSequenceIfExists = function (sequenceName) {
  this.pushQuery(utils.wrapSqlWithCatch('drop sequence ' + this.formatter.wrap(sequenceName), -2289));
};

SchemaCompiler_Oracle.prototype._dropRelatedSequenceIfExists = function (tableName) {
  // removing the sequence that was possibly generated by increments() column
  var sequenceName = utils.generateCombinedName('seq', tableName);
  this.dropSequenceIfExists(sequenceName);
};

SchemaCompiler_Oracle.prototype.dropTable = function (tableName) {
  this.pushQuery('drop table ' + this.formatter.wrap(tableName));

  // removing the sequence that was possibly generated by increments() column
  this._dropRelatedSequenceIfExists(tableName);
};

SchemaCompiler_Oracle.prototype.dropTableIfExists = function (tableName) {
  this.pushQuery(utils.wrapSqlWithCatch('drop table ' + this.formatter.wrap(tableName), -942));

  // removing the sequence that was possibly generated by increments() column
  this._dropRelatedSequenceIfExists(tableName);
};

exports.default = SchemaCompiler_Oracle;
module.exports = exports['default'];