export function noop(): any;
export function contain(array1: readonly any[], array2: readonly any[]): boolean;
export function intersection<T>(array1: readonly T[], array2: readonly T[]): T[];
export function difference<S>(array1: readonly S[], array2: readonly any[]): S[];
export function union<T>(array1: readonly T[], array2: readonly T[]): T[];
export function deduplicate<T>(array: readonly T[]): T[];
export function remove<T>(list: T[], item: T): boolean;
export function valueMap<T, U>(object: Dict<T>, transform: (value: T, key: string) => U): Dict<U>;
export function isInteger(source: any): boolean;
export function sleep(ms: number): Promise<void>;
export function enumKeys<T extends string>(data: Record<T, string | number>): T[];
export function defineEnumProperty<T extends object>(object: T, key: keyof T, value: T[keyof T]): void;
export function clone<T extends unknown>(source: T): T;
export function merge<T extends object>(head: T, base: T): T;
export function pick<T, K extends keyof T>(source: T, keys?: Iterable<K>, forced?: boolean): Pick<T, K>;
export function omit<T, K extends keyof T>(source: T, keys?: Iterable<K>): Omit<T, K>;
export function defineProperty<T, K extends keyof T>(object: T, key: K, value: T[K]): void;
export function defineProperty<T, K extends keyof any>(object: T, key: K, value: any): void;
export function assertProperty<O, K extends keyof O>(config: O, key: K): O[K];
export function coerce(val: any): string;
export function isNullable(value: any): boolean;
export function makeArray<T>(source: T | T[]): T[];
export function renameProperty<O extends object, K extends keyof O, T extends string>(config: O, key: K, oldKey: T): void;
type Global = NodeJS.Global & Window & typeof globalThis;
type GlobalClass = {
    [K in keyof Global]: Global[K] extends new (...args: any[]) => infer T ? T : never;
};
export function isType<K extends keyof GlobalClass>(type: K, value: any): value is GlobalClass[K];
export type Dict<T = any> = {
    [key: string]: T;
};
export type Get<T extends {}, K> = K extends keyof T ? T[K] : never;
export type Extract<S, T, U = S> = S extends T ? U : never;
export type MaybeArray<T> = [T] extends [unknown[]] ? T : T | T[];
export type Promisify<T> = [T] extends [Promise<unknown>] ? T : Promise<T>;
export type Awaitable<T> = [T] extends [Promise<unknown>] ? T : T | Promise<T>;
export type Intersect<U> = (U extends any ? (arg: U) => void : never) extends ((arg: infer I) => void) ? I : never;
export type Observed<T, R = any> = T & {
    $diff: Partial<T>;
    $update: () => R;
    $merge: (value: Partial<T>) => Observed<T, R>;
};
type UpdateFunction<T, R> = (diff: Partial<T>) => R;
export function observe<T extends object>(target: T, label?: string | number): Observed<T, void>;
export function observe<T extends object, R>(target: T, update: UpdateFunction<T, R>, label?: string | number): Observed<T, R>;
/**
 * random operations
 */
export class Random {
    private value;
    constructor(value?: number);
    bool(probability: number): boolean;
    /**
     * random real
     * @param start start number
     * @param end end number
     * @returns a random real in the interval [start, end)
     */
    real(end: number): number;
    real(start: number, end: number): number;
    /**
     * random integer
     * @param start start number
     * @param end end number
     * @returns a random integer in the interval [start, end)
     */
    int(end: number): number;
    int(start: number, end: number): number;
    pick<T>(source: readonly T[]): T;
    splice<T>(source: T[]): T;
    weightedPick<T extends string>(weights: Readonly<Record<T, number>>): T;
}
export namespace Random {
    function id(length?: number, radix?: number): string;
    /**
     * random real
     * @param start start number
     * @param end end number
     * @returns a random real in the interval [start, end)
     */
    function real(end: number): number;
    function real(start: number, end: number): number;
    /**
     * random integer
     * @param start start number
     * @param end end number
     * @returns a random integer in the interval [start, end)
     */
    function int(end: number): number;
    function int(start: number, end: number): number;
    function pick<T>(source: readonly T[]): T;
    function shuffle<T>(source: readonly T[]): T[];
    function multiPick<T>(source: T[], count: number): T[];
    function weightedPick<T extends string>(weights: Readonly<Record<T, number>>): T;
    function bool(probability: number): boolean;
}
export interface segment {
    type: string;
    data: segment.Data;
}
export function segment(type: string, data?: segment.Data): string;
type primitive = string | number | boolean;
export namespace segment {
    type Chain = segment.Parsed[];
    type Data = Dict<primitive>;
    type Transformer = string | ((data: Dict<string>, index: number, chain: Chain) => string);
    type AsyncTransformer = string | ((data: Dict<string>, index: number, chain: Chain) => Awaitable<string>);
    interface Parsed extends segment {
        data: Dict<string>;
        capture?: RegExpExecArray;
    }
    function escape(source: any, inline?: boolean): string;
    function unescape(source: string): string;
    function join(chain: segment[]): string;
    interface FindOptions {
        type?: string;
        caret?: boolean;
    }
    function from(source: string, options?: FindOptions): segment.Parsed;
    function parse(source: string): Chain;
    function transform(source: string | Chain, rules: Dict<Transformer>, dropOthers?: boolean): string;
    function transformAsync(source: string | Chain, rules: Dict<AsyncTransformer>): Promise<string>;
    type Factory<T> = (value: T, data?: segment.Data) => string;
    const at: Factory<primitive>;
    const sharp: Factory<primitive>;
    const quote: Factory<primitive>;
    const image: Factory<string | ArrayBuffer | Buffer>;
    const video: Factory<string | ArrayBuffer | Buffer>;
    const audio: Factory<string | ArrayBuffer | Buffer>;
    const file: Factory<string | ArrayBuffer | Buffer>;
}
export { segment as s };
export const camelCase: <T>(source: T) => T;
export const paramCase: <T>(source: T) => T;
export const snakeCase: <T>(source: T) => T;
export const camelize: <T>(source: T) => T;
export const hyphenate: <T>(source: T) => T;
declare namespace Letter {
    interface LowerToUpper {
        a: 'A';
        b: 'B';
        c: 'C';
        d: 'D';
        e: 'E';
        f: 'F';
        g: 'G';
        h: 'H';
        i: 'I';
        j: 'J';
        k: 'K';
        l: 'L';
        m: 'M';
        n: 'N';
        o: 'O';
        p: 'P';
        q: 'Q';
        r: 'R';
        s: 'S';
        t: 'T';
        u: 'U';
        v: 'V';
        w: 'W';
        x: 'X';
        y: 'Y';
        z: 'Z';
    }
    interface UpperToLower {
        A: 'a';
        B: 'b';
        C: 'c';
        D: 'd';
        E: 'e';
        F: 'f';
        G: 'g';
        H: 'h';
        I: 'i';
        J: 'j';
        K: 'k';
        L: 'l';
        M: 'm';
        N: 'n';
        O: 'o';
        P: 'p';
        Q: 'q';
        R: 'r';
        S: 's';
        T: 't';
        U: 'u';
        V: 'v';
        W: 'w';
        X: 'x';
        Y: 'y';
        Z: 'z';
    }
    export type Upper = keyof UpperToLower;
    export type Lower = keyof LowerToUpper;
    export type ToUpper<S extends string> = S extends Lower ? LowerToUpper[S] : S;
    export type ToLower<S extends string, P extends string = ''> = S extends Upper ? `${P}${UpperToLower[S]}` : S;
}
export type camelize<S extends string> = S extends `${infer L}-${infer M}${infer R}` ? `${L}${Letter.ToUpper<M>}${camelize<R>}` : S;
export type hyphenate<S extends string> = S extends `${infer L}${infer R}` ? `${Letter.ToLower<L, '-'>}${hyphenate<R>}` : S;
export function capitalize(source: string): string;
export function uncapitalize(source: string): string;
export const interpolate: (template: string, context: object, pattern?: RegExp) => string;
export function escapeRegExp(source: string): string;
export function trimSlash(source: string): string;
export function sanitize(source: string): string;
export function template(path: string | string[], ...params: any[]): string;
export namespace template {
    type Node = string | Store;
    interface Store {
        [K: string]: Node;
    }
    function set(path: string, value: Node): void;
    function get(path: string): string;
    function format(source: string, ...params: any[]): string;
    function quote(content: any): string;
    function brace(items: any[]): string;
}
export { template as t };
export namespace Time {
    const millisecond = 1;
    const second = 1000;
    const minute: number;
    const hour: number;
    const day: number;
    const week: number;
    function setTimezoneOffset(offset: number): void;
    function getTimezoneOffset(): number;
    function getDateNumber(date?: number | Date, offset?: number): number;
    function fromDateNumber(value: number, offset?: number): Date;
    function parseTime(source: string): number;
    function parseDate(date: string): Date;
    function formatTimeShort(ms: number): string;
    function formatTime(ms: number): string;
    function template(template: string, time?: Date): string;
    function formatTimeInterval(time: Date, interval?: number): string;
}
export namespace Logger {
    interface LevelConfig {
        base: number;
        [K: string]: Level;
    }
    type Level = number | LevelConfig;
    type Function = (format: any, ...param: any[]) => void;
    type Type = 'success' | 'error' | 'info' | 'warn' | 'debug';
    type Formatter = (this: Logger, value: any) => string;
    interface Target {
        /**
         * - 0: no color support
         * - 1: 16 color support
         * - 2: 256 color support
         * - 3: truecolor support
         */
        colors?: number;
        showDiff?: boolean;
        showTime?: string;
        print(text: string): void;
    }
}
export interface Logger extends Record<Logger.Type, Logger.Function> {
}
export class Logger {
    static readonly SILENT = 0;
    static readonly SUCCESS = 1;
    static readonly ERROR = 1;
    static readonly INFO = 2;
    static readonly WARN = 2;
    static readonly DEBUG = 3;
    static timestamp: number;
    static colors: number[];
    static instances: Record<string, Logger>;
    static targets: Logger.Target[];
    static levels: Logger.LevelConfig;
    static formatters: Record<string, Logger.Formatter>;
    static color(code: number, value: any, decoration?: string): string;
    static code(name: string): number;
    name: string;
    level: number;
    private code;
    constructor(name: string);
    extend(namespace: string): Logger;
}
