import { LRLanguage, LanguageSupport } from '@codemirror/language';
import { Completion } from '@codemirror/autocomplete';

declare const feelLanguage: LRLanguage;
declare const unaryTestsLanguage: LRLanguage;
declare const expressionLanguage: LRLanguage;
declare function feel(config?: {
    dialect?: 'expression' | 'unaryTests';
    context?: Record<string, any>;
}): LanguageSupport;

declare const snippets: readonly Completion[];

export { expressionLanguage, feel, feelLanguage, snippets, unaryTestsLanguage };
