"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _awaitAsyncGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/awaitAsyncGenerator"));

var _wrapAsyncGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/wrapAsyncGenerator"));

var _asyncIterator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncIterator"));

/**
 * Executes the query represented by a path.
 *
 * Requires:
 * - a queryEngine property in the path settings
 * - a sparql property on the path proxy
 */
class ExecuteQueryHandler {
  handle(pathData, path) {
    var _this = this;

    return (0, _wrapAsyncGenerator2.default)(function* () {
      // Retrieve the query engine and query
      const {
        queryEngine
      } = pathData.settings;
      if (!queryEngine) throw new Error(`${pathData} has no queryEngine setting`);
      const query = yield (0, _awaitAsyncGenerator2.default)(path.sparql);
      if (!query) throw new Error(`${pathData} has no sparql property`); // Extract the term from every query result

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;

      var _iteratorError;

      try {
        for (var _iterator = (0, _asyncIterator2.default)(queryEngine.execute(query)), _step, _value; _step = yield (0, _awaitAsyncGenerator2.default)(_iterator.next()), _iteratorNormalCompletion = _step.done, _value = yield (0, _awaitAsyncGenerator2.default)(_step.value), !_iteratorNormalCompletion; _iteratorNormalCompletion = true) {
          const bindings = _value;
          yield _this.extractTerm(bindings, pathData);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            yield (0, _awaitAsyncGenerator2.default)(_iterator.return());
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    })();
  }
  /**
   * Extracts the first term from a query result binding as a new path.
   */


  extractTerm(binding, pathData) {
    // Extract the first term from the binding map
    if (binding.size !== 1) throw new Error('Only single-variable queries are supported');
    const term = binding.values().next().value; // Each result is a new path that starts from the given term as subject

    return pathData.extendPath({
      subject: term
    }, null);
  }

}

exports.default = ExecuteQueryHandler;