"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toHandler = toHandler;
exports.toResolver = toResolver;
exports.default = void 0;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _PathProxy = _interopRequireDefault(require("./PathProxy"));

var _JSONLDResolver = _interopRequireDefault(require("./JSONLDResolver"));

var _defaultHandlers = _interopRequireDefault(require("./defaultHandlers"));

/**
 * A PathFactory creates paths with default settings.
 */
class PathFactory {
  constructor(settings, data) {
    // Store settings and data
    this._settings = settings = (0, _objectSpread2.default)({}, settings);
    this._data = data = (0, _objectSpread2.default)({}, data); // Prepare the handlers

    const handlers = settings.handlers || _defaultHandlers.default;

    for (const key in handlers) handlers[key] = toHandler(handlers[key]);

    for (const key of Object.getOwnPropertySymbols(handlers)) handlers[key] = toHandler(handlers[key]); // Prepare the resolvers


    const resolvers = (settings.resolvers || []).map(toResolver);
    if (settings.context) resolvers.push(new _JSONLDResolver.default(settings.context)); // Instantiate PathProxy that will create the paths

    this._pathProxy = new _PathProxy.default({
      handlers,
      resolvers
    }); // Remove PathProxy settings from the settings object

    delete settings.handlers;
    delete settings.resolvers;
    delete settings.context;
  }
  /**
   * Creates a path with the given (optional) settings and data.
   */


  create(settings = {}, data) {
    // The settings parameter is optional
    if (!data) [data, settings] = [settings, null]; // Apply defaults on settings and data

    return this._pathProxy.createPath(Object.assign(Object.create(null), this._settings, settings), Object.assign(Object.create(null), this._data, data));
  }

}

exports.default = PathFactory;
PathFactory.defaultHandlers = _defaultHandlers.default;
/**
 * Converts a handler function into a handler object.
 */

function toHandler(handle) {
  return typeof handle.handle === 'function' ? handle : {
    handle
  };
}
/**
 * Converts a resolver function into a catch-all resolver object.
 */


function toResolver(resolve) {
  return typeof resolve.resolve === 'function' ? resolve : {
    supports,
    resolve
  };
} // Catch-all resolvers support everything


function supports() {
  return true;
}