"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/**
 * Returns a function that deletes all existing values
 * for the path, and then adds the given values to the path.
 *
 * Requires:
 * - a delete function on the path proxy.
 * - an add function on the path proxy.
 */
class SetFunctionHandler {
  handle(pathData, path) {
    return (...args) => path.delete().add(...args);
  }

}

exports.default = SetFunctionHandler;