"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _DataHandler = _interopRequireDefault(require("./DataHandler"));

var _SubjectHandler = _interopRequireDefault(require("./SubjectHandler"));

var _PathExpressionHandler = _interopRequireDefault(require("./PathExpressionHandler"));

var _SparqlHandler = _interopRequireDefault(require("./SparqlHandler"));

var _ExecuteQueryHandler = _interopRequireDefault(require("./ExecuteQueryHandler"));

var _MutationExpressionsHandler = _interopRequireDefault(require("./MutationExpressionsHandler"));

var _InsertFunctionHandler = _interopRequireDefault(require("./InsertFunctionHandler"));

var _SetFunctionHandler = _interopRequireDefault(require("./SetFunctionHandler"));

var _ReplaceFunctionHandler = _interopRequireDefault(require("./ReplaceFunctionHandler"));

var _DeleteFunctionHandler = _interopRequireDefault(require("./DeleteFunctionHandler"));

var _StringToLDflexHandler = _interopRequireDefault(require("./StringToLDflexHandler"));

var _iterableUtils = require("./iterableUtils");

var _promiseUtils = require("./promiseUtils");

/**
 * A map with default property handlers.
 */
var _default = {
  // Flag to loaders that exported paths are not ES6 modules
  __esModule: () => undefined,
  // Add Promise behavior
  then: ({
    subject
  }, pathProxy) => {
    // If a direct subject is set (zero-length path), resolve it
    if (subject) // If the subject is not a promise, it has already been resolved;
      // consumers should not await it, but access its properties directly.
      // This avoids infinite `then` chains when awaiting this path.
      return subject.then && (0, _promiseUtils.getThen)(() => pathProxy.subject); // Otherwise, return the first result of this path

    return (0, _promiseUtils.getThen)(() => (0, _iterableUtils.getFirstItem)(pathProxy.results));
  },
  // Add async iterable behavior
  [Symbol.asyncIterator]: ({
    subject
  }, pathProxy) => // Return a one-item iterator of the subject or,
  // if no subject is present, all results of this path
  () => subject ? (0, _iterableUtils.iteratorFor)(pathProxy.subject) : pathProxy.results[Symbol.asyncIterator](),
  // Add read and query functionality
  subject: new _SubjectHandler.default(),
  pathExpression: new _PathExpressionHandler.default(),
  sparql: new _SparqlHandler.default(),
  results: new _ExecuteQueryHandler.default(),
  // Add write functionality
  mutationExpressions: new _MutationExpressionsHandler.default(),
  add: new _InsertFunctionHandler.default(),
  set: new _SetFunctionHandler.default(),
  replace: new _ReplaceFunctionHandler.default(),
  delete: new _DeleteFunctionHandler.default(),
  // Add RDFJS term handling
  termType: _DataHandler.default.sync('subject', 'termType'),
  value: _DataHandler.default.sync('subject', 'value'),
  equals: _DataHandler.default.sync('subject', 'equals'),
  language: _DataHandler.default.sync('subject', 'language'),
  datatype: _DataHandler.default.sync('subject', 'datatype'),
  toString: _DataHandler.default.syncFunction('subject', 'value'),
  toPrimitive: _DataHandler.default.syncFunction('subject', 'value'),
  // Parse a string into an LDflex object
  resolve: new _StringToLDflexHandler.default()
};
exports.default = _default;