"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFirstItem = getFirstItem;
exports.iteratorFor = iteratorFor;
const done = {};
/**
 * Gets the first element of the iterable.
 */

function getFirstItem(iterable) {
  const iterator = iterable[Symbol.asyncIterator]();
  return iterator.next().then(item => item.value);
}
/**
 * Creates an async iterator with the item as only element.
 */


function iteratorFor(item) {
  return {
    async next() {
      if (item !== done) {
        const value = await item;
        item = done;
        return {
          value
        };
      }

      return {
        done: true
      };
    }

  };
}