var global = Function("return this;")();
/*!
  * Ender: open module JavaScript framework (client-lib)
  * copyright Dustin Diaz & Jacob Thornton 2011 (@ded @fat)
  * http://ender.no.de
  * License MIT
  */
!function (context) {

  // a global object for node.js module compatiblity
  // ============================================

  context['global'] = context

  // Implements simple module system
  // losely based on CommonJS Modules spec v1.1.1
  // ============================================

  var modules = {}
    , old = context.$

  function require (identifier) {
    // modules can be required from ender's build system, or found on the window
    var module = modules[identifier] || window[identifier]
    if (!module) throw new Error("Requested module '" + identifier + "' has not been defined.")
    return module
  }

  function provide (name, what) {
    return (modules[name] = what)
  }

  context['provide'] = provide
  context['require'] = require

  function aug(o, o2) {
    for (var k in o2) k != 'noConflict' && k != '_VERSION' && (o[k] = o2[k])
    return o
  }

  function boosh(s, r, els) {
    // string || node || nodelist || window
    if (typeof s == 'string' || s.nodeName || (s.length && 'item' in s) || s == window) {
      els = ender._select(s, r)
      els.selector = s
    } else els = isFinite(s.length) ? s : [s]
    return aug(els, boosh)
  }

  function ender(s, r) {
    return boosh(s, r)
  }

  aug(ender, {
      _VERSION: '0.3.6'
    , fn: boosh // for easy compat to jQuery plugins
    , ender: function (o, chain) {
        aug(chain ? boosh : ender, o)
      }
    , _select: function (s, r) {
        return (r || document).querySelectorAll(s)
      }
  })

  aug(boosh, {
    forEach: function (fn, scope, i) {
      // opt out of native forEach so we can intentionally call our own scope
      // defaulting to the current item and be able to return self
      for (i = 0, l = this.length; i < l; ++i) i in this && fn.call(scope || this[i], this[i], i, this)
      // return self for chaining
      return this
    },
    $: ender // handy reference to self
  })

  ender.noConflict = function () {
    context.$ = old
    return this
  }

  if (typeof module !== 'undefined' && module.exports) module.exports = ender
  // use subscript notation as extern for Closure compilation
  context['ender'] = context['$'] = context['ender'] || ender

}(this);
// pakmanager:leaflet-sidebar
(function (context) {
  
  var module = { exports: {} }, exports = module.exports
    , $ = require("ender")
    ;
  
  L.Control.Sidebar = L.Control.extend({
    
        includes: L.Mixin.Events,
    
        options: {
            closeButton: true,
            position: 'left',
            autoPan: true,
        },
    
        initialize: function (placeholder, options) {
            L.setOptions(this, options);
    
            // Find content container
            var content = this._contentContainer = L.DomUtil.get(placeholder);
    
            // Remove the content container from its original parent
            content.parentNode.removeChild(content);
    
            var l = 'leaflet-';
    
            // Create sidebar container
            var container = this._container =
                L.DomUtil.create('div', l + 'sidebar ' + this.options.position);
    
            // Style and attach content container
            L.DomUtil.addClass(content, l + 'control');
            container.appendChild(content);
    
            // Create close button and attach it if configured
            if (this.options.closeButton) {
                var close = this._closeButton =
                    L.DomUtil.create('a', 'close', container);
                close.innerHTML = '&times;';
            }
        },
    
        addTo: function (map) {
            var container = this._container;
            var content = this._contentContainer;
    
            // Attach event to close button
            if (this.options.closeButton) {
                var close = this._closeButton;
    
                L.DomEvent.on(close, 'click', this.hide, this);
            }
    
            L.DomEvent
                .on(container, 'transitionend',
                    this._handleTransitionEvent, this)
                .on(container, 'webkitTransitionEnd',
                    this._handleTransitionEvent, this);
    
            // Attach sidebar container to controls container
            var controlContainer = map._controlContainer;
            controlContainer.insertBefore(container, controlContainer.firstChild);
    
            this._map = map;
    
            // Make sure we don't drag the map when we interact with the content
            var stop = L.DomEvent.stopPropagation;
            L.DomEvent
                .on(content, 'contextmenu', stop)
                .on(content, 'click', stop)
                .on(content, 'mousedown', stop)
                .on(content, 'touchstart', stop)
                .on(content, 'dblclick', stop)
                .on(content, 'mousewheel', stop)
                .on(content, 'MozMousePixelScroll', stop);
    
            return this;
        },
    
        removeFrom: function (map) {
            //if the control is visible, hide it before removing it.
            this.hide();
    
            var content = this._contentContainer;
    
            // Remove sidebar container from controls container
            var controlContainer = map._controlContainer;
            controlContainer.removeChild(this._container);
    
            //disassociate the map object
            this._map = null;
    
            // Unregister events to prevent memory leak
            var stop = L.DomEvent.stopPropagation;
            L.DomEvent
                .off(content, 'contextmenu', stop)
                .off(content, 'click', stop)
                .off(content, 'mousedown', stop)
                .off(content, 'touchstart', stop)
                .off(content, 'dblclick', stop)
                .off(content, 'mousewheel', stop)
                .off(content, 'MozMousePixelScroll', stop);
    
            L.DomEvent
                .off(container, 'transitionend',
                    this._handleTransitionEvent, this)
                .off(container, 'webkitTransitionEnd',
                    this._handleTransitionEvent, this);
    
            if (this._closeButton && this._close) {
                var close = this._closeButton;
    
                L.DomEvent.off(close, 'click', this.hide, this);
            }
    
            return this;
        },
    
        isVisible: function () {
            return L.DomUtil.hasClass(this._container, 'visible');
        },
    
        show: function () {
            if (!this.isVisible()) {
                L.DomUtil.addClass(this._container, 'visible');
                if (this.options.autoPan) {
                    this._map.panBy([-this.getOffset() / 2, 0], {
                        duration: 0.5
                    });
                }
                this.fire('show');
            }
        },
    
        hide: function (e) {
            if (this.isVisible()) {
                L.DomUtil.removeClass(this._container, 'visible');
                if (this.options.autoPan) {
                    this._map.panBy([this.getOffset() / 2, 0], {
                        duration: 0.5
                    });
                }
                this.fire('hide');
            }
            if(e) {
                L.DomEvent.stopPropagation(e);
            }
        },
    
        toggle: function () {
            if (this.isVisible()) {
                this.hide();
            } else {
                this.show();
            }
        },
    
        getContainer: function () {
            return this._contentContainer;
        },
    
        getCloseButton: function () {
            return this._closeButton;
        },
    
        setContent: function (content) {
            this.getContainer().innerHTML = content;
            return this;
        },
    
        getOffset: function () {
            if (this.options.position === 'right') {
                return -this._container.offsetWidth;
            } else {
                return this._container.offsetWidth;
            }
        },
    
        _handleTransitionEvent: function (e) {
            if (e.propertyName == 'left' || e.propertyName == 'right')
                this.fire(this.isVisible() ? 'shown' : 'hidden');
        }
    });
    
    L.control.sidebar = function (placeholder, options) {
        return new L.Control.Sidebar(placeholder, options);
    };
    
  provide("leaflet-sidebar", module.exports);
}(global));