/*!
* Leaflet.TileLayer.Swiss v2.1.0
* Plugin for displaying Swiss map tiles
* © Roman Karavia | MIT License
* leaflet-tilelayer-swiss.karavia.ch
*/
"use strict";function _interopDefault(t){return t&&"object"==typeof t&&"default"in t?t.default:t}var L$1=_interopDefault(require("leaflet")),lv03="EPSG:21781",lv95="EPSG:2056";void 0===Number.isFinite&&(Number.isFinite=function(t){return"number"==typeof t&&isFinite(t)});var t=1e-12;function n(t){if(!Array.isArray(t))throw new Error("Expected input to be an array.");if(t.length<2)throw new Error("Expected input to be an array with length >= 2, got "+t.length+".");if(t.some((function(t){return!Number.isFinite(t)})))throw new Error("Expected all coordinates to be finite numbers.")}function r(t,n,a){return(a/60+n)/60+t}function o(t){return 180*t/Math.PI}function M(t){return t*Math.PI/180}function s(t,n){return{apply:function(a){var o=a[0],r=a[1],e=a.slice(2);return[o+t,r+n].concat(e)},unapply:function(a){var o=a[0],r=a[1],e=a.slice(2);return[o-t,r-n].concat(e)}}}var u=s(6e5,2e5),c=u.apply,p=u.unapply,l=s(26e5,12e5),v=l.apply,w=l.unapply,b=674.374,I=15.056,P=405.346;function m(n,a){var r=1/a,e=2*r-Math.pow(r,2);return{fromCartesian:function(a){for(var r,i,s,h=a[0],u=a[1],c=a[2],l=Math.atan(u/h),M=Math.sqrt(Math.pow(h,2)+Math.pow(u,2)),p=Math.atan(c/((1-e)*M));!(Math.abs(i-r)<t);)r=i,i=n/Math.sqrt(1-e*Math.pow(Math.sin(p),2)),s=M/Math.cos(p)-i,p=Math.atan(c/((1-e*i/(i+s))*M));var f=o(p);return[o(l),f,s]},toCartesian:function(t){var a=t[0],o=t[2];void 0===o&&(o=0);var r=M(t[1]),i=M(a),s=n/Math.sqrt(1-e*Math.pow(Math.sin(r),2));return[(s+o)*Math.cos(r)*Math.cos(i),(s+o)*Math.cos(r)*Math.sin(i),(s*(1-e)+o)*Math.sin(r)]}}}var d=m(6377397.155,299.15281285),x=d.fromCartesian,q=d.toCartesian,C=m(6378137,298.257223563),E=C.fromCartesian,F=C.toCartesian,N=1/299.15281285,A=M(r(46,57,8.66)),k=M(r(7,26,22.5)),z=2*N-Math.pow(N,2),B=6377397.155*Math.sqrt(1-z)/(1-z*Math.pow(Math.sin(A),2)),D=Math.sqrt(1+z/(1-z)*Math.pow(Math.cos(A),4)),G=Math.asin(Math.sin(A)/D),H=Math.sqrt(z),J=Math.log(Math.tan(Math.PI/4+G/2))-D*Math.log(Math.tan(Math.PI/4+A/2))+D*H/2*Math.log((1+H*Math.sin(A))/(1-H*Math.sin(A)));function K(t){var n,a,o,r,e,i,s,h,u,c=[(n=F(t))[0]-b,n[1]-I,n[2]-P],l=x(c),p=(a=l[0],o=M(l[1]),r=M(a),e=D*Math.log(Math.tan(Math.PI/4+o/2))-D*H/2*Math.log((1+H*Math.sin(o))/(1-H*Math.sin(o)))+J,i=2*(Math.atan(Math.exp(e))-Math.PI/4),s=D*(r-k),h=Math.asin(Math.cos(G)*Math.sin(i)-Math.sin(G)*Math.cos(i)*Math.cos(s)),u=Math.atan(Math.sin(s)/(Math.sin(G)*Math.tan(i)+Math.cos(G)*Math.cos(s))),[B*u,B/2*Math.log((1+Math.sin(h))/(1-Math.sin(h)))]);return t.length>2?p.concat([l[2]]):p}function L(n){var a=function(a){for(var r,e,i=n[0],s=2*(Math.atan(Math.exp(n[1]/B))-Math.PI/4),h=i/B,u=Math.asin(Math.cos(G)*Math.sin(s)+Math.sin(G)*Math.cos(s)*Math.cos(h)),c=Math.atan(Math.sin(h)/(Math.cos(G)*Math.cos(h)-Math.sin(G)*Math.tan(s))),l=k+c/D,M=u;!(Math.abs(e-r)<t);)r=e,e=(Math.log(Math.tan(Math.PI/4+u/2))-J)/D+H*Math.log(Math.tan(Math.PI/4+Math.asin(H*Math.sin(M))/2)),M=2*Math.atan(Math.exp(e))-Math.PI/2;var p=o(M);return[o(l),p]}();a.push(n[2]);var r,e=[(r=q(a))[0]+b,r[1]+I,r[2]+P],i=E(e);return n.length>2?i:i.slice(0,2)}var O={project:function(t){return n(t),c(K(t))},unproject:function(t){return n(t),L(p(t))}};function Q(t){return n(t),v(K(t))}function R(t){return n(t),L(w(t))}var S={project:Q,unproject:R},LV03_BOUNDS=L$1.bounds([42e4,3e4],[9e5,35e4]),LV95_BOUNDS=L$1.bounds([242e4,103e4],[29e5,135e4]);function leafletProjection(t,n){return{bounds:n,project:function(n){var a=n.lng,o=n.lat,r=t.project([a,o]),e=r[0],i=r[1];return L$1.point(e,i)},unproject:function(n){var a=n.x,o=n.y,r=t.unproject([a,o]),e=r[0],i=r[1];return L$1.latLng(i,e)}}}var lv03$1=leafletProjection(O,LV03_BOUNDS),lv95$1=leafletProjection(S,LV95_BOUNDS),RESOLUTIONS=[4e3,3750,3500,3250,3e3,2750,2500,2250,2e3,1750,1500,1250,1e3,750,650,500,250,100,50,20,10,5,2.5,2,1.5,1,.5,.25,.1];function fromZoom(t){if(t<0)return RESOLUTIONS[0];if(t>RESOLUTIONS.length-1)return RESOLUTIONS[RESOLUTIONS.length-1];var n=Math.floor(t);if(n===t)return RESOLUTIONS[t];var a=RESOLUTIONS[n],o=RESOLUTIONS[n+1]/a;return a*Math.pow(o,t-n)}function toZoom(t){for(var n=-1,a=0;a<RESOLUTIONS.length;a+=1)if(t>=RESOLUTIONS[a]){n=a;break}if(0===n)return 0;if(-1===n)return RESOLUTIONS.length-1;if(RESOLUTIONS[n]===t)return n;var o=RESOLUTIONS[n-1],r=RESOLUTIONS[n];return n+Math.log(r/t)/Math.log(o/r)}var CRS=L$1.Class.extend({includes:L$1.CRS,initialize:function(t){this.code=t.code,this.projection=t.projection;var n=this.projection.bounds.getBottomLeft();this.transformation=new L$1.Transformation(1,-n.x,-1,n.y),this.infinite=!1},scale:function(t){return 1/fromZoom(t)},zoom:function(t){return toZoom(1/t)},distance:function(t,n){var a=this.project(t),o=this.project(n);return a.distanceTo(o)}}),lv03$2=new CRS({code:lv03,projection:lv03$1}),lv95$2=new CRS({code:lv95,projection:lv95$1}),tileBounds=L$1.latLngBounds(lv95$2.unproject(lv95$2.projection.bounds.min),lv95$2.unproject(lv95$2.projection.bounds.max)),switzerlandBounds=L$1.latLngBounds(lv95$2.unproject(L$1.point(2485e3,1075e3)),lv95$2.unproject(L$1.point(2835e3,1295e3))),urlsByCrs={};urlsByCrs[lv03]="https://wmts{s}.geo.admin.ch/1.0.0/{layer}/default/{timestamp}/21781/{z}/{y}/{x}.{format}",urlsByCrs[lv95]="https://wmts{s}.geo.admin.ch/1.0.0/{layer}/default/{timestamp}/2056/{z}/{x}/{y}.{format}";var SwissLayer=L$1.TileLayer.extend({options:{attribution:'© <a href="https://www.swisstopo.ch/" target="_blank">Swisstopo</a>',bounds:tileBounds,crs:lv95$2,format:"jpeg",layer:"ch.swisstopo.pixelkarte-farbe",minZoom:14,maxNativeZoom:27,maxZoom:28,subdomains:"0123456789",timestamp:"current"},initialize:function(t){L$1.setOptions(this,t);var n=this.options.url||urlsByCrs[this.options.crs.code];L$1.TileLayer.prototype.initialize.call(this,n,this.options)}});L$1.CRS.EPSG21781=lv03$2,L$1.CRS.EPSG2056=lv95$2,L$1.TileLayer.Swiss=SwissLayer,L$1.tileLayer.swiss=function(t){return new SwissLayer(t)},L$1.Map.addInitHook((function(){this.options.maxBounds||this.options.crs!==lv03$2&&this.options.crs!==lv95$2||this.setMaxBounds(tileBounds)})),L$1.Map.include({fitSwitzerland:function(){this.fitBounds(switzerlandBounds)}}),module.exports=SwissLayer;
//# sourceMappingURL=Leaflet.TileLayer.Swiss.cjs.js.map
