/*!
* Leaflet.TileLayer.Swiss v2.1.0
* Plugin for displaying Swiss map tiles
* © Roman Karavia | MIT License
* leaflet-tilelayer-swiss.karavia.ch
*/
import t from"leaflet";void 0===Number.isFinite&&(Number.isFinite=function(t){return"number"==typeof t&&isFinite(t)});var n=1e-12;function a(t){if(!Array.isArray(t))throw new Error("Expected input to be an array.");if(t.length<2)throw new Error("Expected input to be an array with length >= 2, got "+t.length+".");if(t.some((function(t){return!Number.isFinite(t)})))throw new Error("Expected all coordinates to be finite numbers.")}function o(t,n,a){return(a/60+n)/60+t}function r(t){return 180*t/Math.PI}function e(t){return t*Math.PI/180}function i(t,n){return{apply:function(a){var o=a[0],r=a[1],e=a.slice(2);return[o+t,r+n].concat(e)},unapply:function(a){var o=a[0],r=a[1],e=a.slice(2);return[o-t,r-n].concat(e)}}}var s=i(6e5,2e5),h=s.apply,u=s.unapply,c=i(26e5,12e5),M=c.apply,p=c.unapply,f=674.374,l=15.056,d=405.346;function m(t,a){var o=1/a,i=2*o-Math.pow(o,2);return{fromCartesian:function(a){for(var o,e,s,h=a[0],u=a[1],c=a[2],M=Math.atan(u/h),p=Math.sqrt(Math.pow(h,2)+Math.pow(u,2)),f=Math.atan(c/((1-i)*p));!(Math.abs(e-o)<n);)o=e,e=t/Math.sqrt(1-i*Math.pow(Math.sin(f),2)),s=p/Math.cos(f)-e,f=Math.atan(c/((1-i*e/(e+s))*p));var l=r(f);return[r(M),l,s]},toCartesian:function(n){var a=n[0],o=n[2];void 0===o&&(o=0);var r=e(n[1]),s=e(a),h=t/Math.sqrt(1-i*Math.pow(Math.sin(r),2));return[(h+o)*Math.cos(r)*Math.cos(s),(h+o)*Math.cos(r)*Math.sin(s),(h*(1-i)+o)*Math.sin(r)]}}}var v=m(6377397.155,299.15281285),w=v.fromCartesian,g=v.toCartesian,y=m(6378137,298.257223563),b=y.fromCartesian,j=y.toCartesian,x=1/299.15281285,P=e(o(46,57,8.66)),E=e(o(7,26,22.5)),S=2*x-Math.pow(x,2),I=6377397.155*Math.sqrt(1-S)/(1-S*Math.pow(Math.sin(P),2)),C=Math.sqrt(1+S/(1-S)*Math.pow(Math.cos(P),4)),L=Math.asin(Math.sin(P)/C),z=Math.sqrt(S),q=Math.log(Math.tan(Math.PI/4+L/2))-C*Math.log(Math.tan(Math.PI/4+P/2))+C*z/2*Math.log((1+z*Math.sin(P))/(1-z*Math.sin(P)));function B(t){var n,a,o,r,i,s,h,u,c,M=[(n=j(t))[0]-f,n[1]-l,n[2]-d],p=w(M),m=(a=p[0],o=e(p[1]),r=e(a),i=C*Math.log(Math.tan(Math.PI/4+o/2))-C*z/2*Math.log((1+z*Math.sin(o))/(1-z*Math.sin(o)))+q,s=2*(Math.atan(Math.exp(i))-Math.PI/4),h=C*(r-E),u=Math.asin(Math.cos(L)*Math.sin(s)-Math.sin(L)*Math.cos(s)*Math.cos(h)),c=Math.atan(Math.sin(h)/(Math.sin(L)*Math.tan(s)+Math.cos(L)*Math.cos(h))),[I*c,I/2*Math.log((1+Math.sin(u))/(1-Math.sin(u)))]);return t.length>2?m.concat([p[2]]):m}function G(t){var a=function(a){for(var o,e,i=t[0],s=2*(Math.atan(Math.exp(t[1]/I))-Math.PI/4),h=i/I,u=Math.asin(Math.cos(L)*Math.sin(s)+Math.sin(L)*Math.cos(s)*Math.cos(h)),c=Math.atan(Math.sin(h)/(Math.cos(L)*Math.cos(h)-Math.sin(L)*Math.tan(s))),M=E+c/C,p=u;!(Math.abs(e-o)<n);)o=e,e=(Math.log(Math.tan(Math.PI/4+u/2))-q)/C+z*Math.log(Math.tan(Math.PI/4+Math.asin(z*Math.sin(p))/2)),p=2*Math.atan(Math.exp(e))-Math.PI/2;var f=r(p);return[r(M),f]}();a.push(t[2]);var o,e=[(o=g(a))[0]+f,o[1]+l,o[2]+d],i=b(e);return t.length>2?i:i.slice(0,2)}var T={project:function(t){return a(t),h(B(t))},unproject:function(t){return a(t),G(u(t))}};var k={project:function(t){return a(t),M(B(t))},unproject:function(t){return a(t),G(p(t))}},F=t.bounds([42e4,3e4],[9e5,35e4]),N=t.bounds([242e4,103e4],[29e5,135e4]);function R(n,a){return{bounds:a,project:function(a){var o=a.lng,r=a.lat,e=n.project([o,r]),i=e[0],s=e[1];return t.point(i,s)},unproject:function(a){var o=a.x,r=a.y,e=n.unproject([o,r]),i=e[0],s=e[1];return t.latLng(s,i)}}}var Z=R(T,F),A=R(k,N),H=[4e3,3750,3500,3250,3e3,2750,2500,2250,2e3,1750,1500,1250,1e3,750,650,500,250,100,50,20,10,5,2.5,2,1.5,1,.5,.25,.1];var O=t.Class.extend({includes:t.CRS,initialize:function(n){this.code=n.code,this.projection=n.projection;var a=this.projection.bounds.getBottomLeft();this.transformation=new t.Transformation(1,-a.x,-1,a.y),this.infinite=!1},scale:function(t){return 1/function(t){if(t<0)return H[0];if(t>H.length-1)return H[H.length-1];var n=Math.floor(t);if(n===t)return H[t];var a=H[n],o=H[n+1]/a;return a*Math.pow(o,t-n)}(t)},zoom:function(t){return function(t){for(var n=-1,a=0;a<H.length;a+=1)if(t>=H[a]){n=a;break}if(0===n)return 0;if(-1===n)return H.length-1;if(H[n]===t)return n;var o=H[n-1],r=H[n];return n+Math.log(r/t)/Math.log(o/r)}(1/t)},distance:function(t,n){var a=this.project(t),o=this.project(n);return a.distanceTo(o)}}),_=new O({code:"EPSG:21781",projection:Z}),D=new O({code:"EPSG:2056",projection:A}),J=t.latLngBounds(D.unproject(D.projection.bounds.min),D.unproject(D.projection.bounds.max)),K=t.latLngBounds(D.unproject(t.point(2485e3,1075e3)),D.unproject(t.point(2835e3,1295e3))),Q={"EPSG:21781":"https://wmts{s}.geo.admin.ch/1.0.0/{layer}/default/{timestamp}/21781/{z}/{y}/{x}.{format}","EPSG:2056":"https://wmts{s}.geo.admin.ch/1.0.0/{layer}/default/{timestamp}/2056/{z}/{x}/{y}.{format}"},U=t.TileLayer.extend({options:{attribution:'© <a href="https://www.swisstopo.ch/" target="_blank">Swisstopo</a>',bounds:J,crs:D,format:"jpeg",layer:"ch.swisstopo.pixelkarte-farbe",minZoom:14,maxNativeZoom:27,maxZoom:28,subdomains:"0123456789",timestamp:"current"},initialize:function(n){t.setOptions(this,n);var a=this.options.url||Q[this.options.crs.code];t.TileLayer.prototype.initialize.call(this,a,this.options)}});t.CRS.EPSG21781=_,t.CRS.EPSG2056=D,t.TileLayer.Swiss=U,t.tileLayer.swiss=function(t){return new U(t)},t.Map.addInitHook((function(){this.options.maxBounds||this.options.crs!==_&&this.options.crs!==D||this.setMaxBounds(J)})),t.Map.include({fitSwitzerland:function(){this.fitBounds(K)}});export default U;
//# sourceMappingURL=Leaflet.TileLayer.Swiss.esm.js.map
