Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var path = tslib_1.__importStar(require("path"));
var abstract_plugin_loader_js_1 = tslib_1.__importDefault(require("../less/environment/abstract-plugin-loader.js"));
/**
 * Node Plugin Loader
 */
var PluginLoader = /** @class */ (function (_super) {
    tslib_1.__extends(PluginLoader, _super);
    function PluginLoader(less) {
        var _this = _super.call(this) || this;
        _this.less = less;
        _this.require = function (prefix) {
            prefix = path.dirname(prefix);
            return function (id) {
                var str = id.substr(0, 2);
                if (str === '..' || str === './') {
                    return require(path.join(prefix, id));
                }
                else {
                    return require(id);
                }
            };
        };
        return _this;
    }
    PluginLoader.prototype.loadPlugin = function (filename, basePath, context, environment, fileManager) {
        var prefix = filename.slice(0, 1);
        var explicit = prefix === '.' || prefix === '/' || filename.slice(-3).toLowerCase() === '.js';
        if (!explicit) {
            context.prefixes = ['less-plugin-', ''];
        }
        if (context.syncImport) {
            return fileManager.loadFileSync(filename, basePath, context, environment);
        }
        return new Promise(function (fulfill, reject) {
            fileManager.loadFile(filename, basePath, context, environment).then(function (data) {
                try {
                    fulfill(data);
                }
                catch (e) {
                    console.log(e);
                    reject(e);
                }
            }).catch(function (err) {
                reject(err);
            });
        });
    };
    PluginLoader.prototype.loadPluginSync = function (filename, basePath, context, environment, fileManager) {
        context.syncImport = true;
        return this.loadPlugin(filename, basePath, context, environment, fileManager);
    };
    return PluginLoader;
}(abstract_plugin_loader_js_1.default));
exports.default = PluginLoader;
//# sourceMappingURL=plugin-loader.js.map