Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var node_1 = tslib_1.__importDefault(require("./node"));
var Assignment = /** @class */ (function (_super) {
    tslib_1.__extends(Assignment, _super);
    function Assignment(key, val) {
        var _this = _super.call(this) || this;
        _this.key = key;
        _this.value = val;
        return _this;
    }
    Assignment.prototype.accept = function (visitor) {
        this.value = visitor.visit(this.value);
    };
    Assignment.prototype.eval = function (context) {
        if (this.value.eval) {
            return new Assignment(this.key, this.value.eval(context));
        }
        return this;
    };
    Assignment.prototype.genCSS = function (context, output) {
        output.add(this.key + "=");
        if (this.value.genCSS) {
            this.value.genCSS(context, output);
        }
        else {
            output.add(this.value);
        }
    };
    return Assignment;
}(node_1.default));
Assignment.prototype.type = 'Assignment';
exports.default = Assignment;
//# sourceMappingURL=assignment.js.map