Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var node_1 = tslib_1.__importDefault(require("./node"));
var Attribute = /** @class */ (function (_super) {
    tslib_1.__extends(Attribute, _super);
    function Attribute(key, op, value) {
        var _this = _super.call(this) || this;
        _this.key = key;
        _this.op = op;
        _this.value = value;
        return _this;
    }
    Attribute.prototype.eval = function (context) {
        return new Attribute(this.key.eval ? this.key.eval(context) : this.key, this.op, (this.value && this.value.eval) ? this.value.eval(context) : this.value);
    };
    Attribute.prototype.genCSS = function (context, output) {
        output.add(this.toCSS(context));
    };
    Attribute.prototype.toCSS = function (context) {
        var value = this.key.toCSS ? this.key.toCSS(context) : this.key;
        if (this.op) {
            value += this.op;
            value += (this.value.toCSS ? this.value.toCSS(context) : this.value);
        }
        return "[" + value + "]";
    };
    return Attribute;
}(node_1.default));
Attribute.prototype.type = 'Attribute';
exports.default = Attribute;
//# sourceMappingURL=attribute.js.map