Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var node_1 = tslib_1.__importDefault(require("./node"));
var _noSpaceCombinators = {
    '': true,
    ' ': true,
    '|': true
};
var Combinator = /** @class */ (function (_super) {
    tslib_1.__extends(Combinator, _super);
    function Combinator(value) {
        var _this = _super.call(this) || this;
        if (value === ' ') {
            _this.value = ' ';
            _this.emptyOrWhitespace = true;
        }
        else {
            _this.value = value ? value.trim() : '';
            _this.emptyOrWhitespace = _this.value === '';
        }
        return _this;
    }
    Combinator.prototype.genCSS = function (context, output) {
        var spaceOrEmpty = (context.compress || _noSpaceCombinators[this.value]) ? '' : ' ';
        output.add(spaceOrEmpty + this.value + spaceOrEmpty);
    };
    return Combinator;
}(node_1.default));
Combinator.prototype.type = 'Combinator';
exports.default = Combinator;
//# sourceMappingURL=combinator.js.map