Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var node_1 = tslib_1.__importDefault(require("./node"));
var debug_info_1 = tslib_1.__importDefault(require("./debug-info"));
var Comment = /** @class */ (function (_super) {
    tslib_1.__extends(Comment, _super);
    function Comment(value, isLineComment, index, currentFileInfo) {
        var _this = _super.call(this) || this;
        _this.value = value;
        _this.isLineComment = isLineComment;
        _this._index = index;
        _this._fileInfo = currentFileInfo;
        _this.allowRoot = true;
        return _this;
    }
    Comment.prototype.genCSS = function (context, output) {
        if (this.debugInfo) {
            output.add(debug_info_1.default(context, this), this.fileInfo(), this.getIndex());
        }
        output.add(this.value);
    };
    Comment.prototype.isSilent = function (context) {
        var isCompressed = context.compress && this.value[2] !== '!';
        return this.isLineComment || isCompressed;
    };
    return Comment;
}(node_1.default));
Comment.prototype.type = 'Comment';
exports.default = Comment;
//# sourceMappingURL=comment.js.map