Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var node_1 = tslib_1.__importDefault(require("./node"));
var Condition = /** @class */ (function (_super) {
    tslib_1.__extends(Condition, _super);
    function Condition(op, l, r, i, negate) {
        var _this = _super.call(this) || this;
        _this.op = op.trim();
        _this.lvalue = l;
        _this.rvalue = r;
        _this._index = i;
        _this.negate = negate;
        return _this;
    }
    Condition.prototype.accept = function (visitor) {
        this.lvalue = visitor.visit(this.lvalue);
        this.rvalue = visitor.visit(this.rvalue);
    };
    Condition.prototype.eval = function (context) {
        var result = (function (op, a, b) {
            switch (op) {
                case 'and': return a && b;
                case 'or': return a || b;
                default:
                    switch (node_1.default.compare(a, b)) {
                        case -1:
                            return op === '<' || op === '=<' || op === '<=';
                        case 0:
                            return op === '=' || op === '>=' || op === '=<' || op === '<=';
                        case 1:
                            return op === '>' || op === '>=';
                        default:
                            return false;
                    }
            }
        })(this.op, this.lvalue.eval(context), this.rvalue.eval(context));
        return this.negate ? !result : result;
    };
    return Condition;
}(node_1.default));
Condition.prototype.type = 'Condition';
exports.default = Condition;
//# sourceMappingURL=condition.js.map