Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var node_1 = tslib_1.__importDefault(require("./node"));
var value_1 = tslib_1.__importDefault(require("./value"));
var keyword_1 = tslib_1.__importDefault(require("./keyword"));
var anonymous_1 = tslib_1.__importDefault(require("./anonymous"));
var Constants = tslib_1.__importStar(require("../constants"));
var MATH = Constants.Math;
var Declaration = /** @class */ (function (_super) {
    tslib_1.__extends(Declaration, _super);
    function Declaration(name, value, important, merge, index, currentFileInfo, inline, variable) {
        var _this = _super.call(this) || this;
        _this.name = name;
        _this.value = (value instanceof node_1.default) ? value : new value_1.default([value ? new anonymous_1.default(value) : null]);
        _this.important = important ? " " + important.trim() : '';
        _this.merge = merge;
        _this._index = index;
        _this._fileInfo = currentFileInfo;
        _this.inline = inline || false;
        _this.variable = (variable !== undefined) ? variable
            : (name.charAt && (name.charAt(0) === '@'));
        _this.allowRoot = true;
        _this.setParent(_this.value, _this);
        return _this;
    }
    Declaration.prototype.genCSS = function (context, output) {
        output.add(this.name + (context.compress ? ':' : ': '), this.fileInfo(), this.getIndex());
        try {
            this.value.genCSS(context, output);
        }
        catch (e) {
            e.index = this._index;
            e.filename = this._fileInfo.filename;
            throw e;
        }
        output.add(this.important + ((this.inline || (context.lastRule && context.compress)) ? '' : ';'), this._fileInfo, this._index);
    };
    Declaration.prototype.eval = function (context) {
        var mathBypass = false;
        var prevMath;
        var name = this.name;
        var evaldValue;
        var variable = this.variable;
        if (typeof name !== 'string') {
            // expand 'primitive' name directly to get
            // things faster (~10% for benchmark.less):
            name = (name.length === 1) && (name[0] instanceof keyword_1.default) ?
                name[0].value : evalName(context, name);
            variable = false; // never treat expanded interpolation as new variable name
        }
        // @todo remove when parens-division is default
        if (name === 'font' && context.math === MATH.ALWAYS) {
            mathBypass = true;
            prevMath = context.math;
            context.math = MATH.PARENS_DIVISION;
        }
        try {
            context.importantScope.push({});
            evaldValue = this.value.eval(context);
            if (!this.variable && evaldValue.type === 'DetachedRuleset') {
                throw { message: 'Rulesets cannot be evaluated on a property.',
                    index: this.getIndex(), filename: this.fileInfo().filename };
            }
            var important = this.important;
            var importantResult = context.importantScope.pop();
            if (!important && importantResult.important) {
                important = importantResult.important;
            }
            return new Declaration(name, evaldValue, important, this.merge, this.getIndex(), this.fileInfo(), this.inline, variable);
        }
        catch (e) {
            if (typeof e.index !== 'number') {
                e.index = this.getIndex();
                e.filename = this.fileInfo().filename;
            }
            throw e;
        }
        finally {
            if (mathBypass) {
                context.math = prevMath;
            }
        }
    };
    Declaration.prototype.makeImportant = function () {
        return new Declaration(this.name, this.value, '!important', this.merge, this.getIndex(), this.fileInfo(), this.inline);
    };
    return Declaration;
}(node_1.default));
function evalName(context, name) {
    var value = '';
    var i;
    var n = name.length;
    var output = { add: function (s) { value += s; } };
    for (i = 0; i < n; i++) {
        name[i].eval(context).genCSS(context, output);
    }
    return value;
}
Declaration.prototype.type = 'Declaration';
exports.default = Declaration;
//# sourceMappingURL=declaration.js.map