Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var node_1 = tslib_1.__importDefault(require("./node"));
var contexts_1 = tslib_1.__importDefault(require("../contexts"));
var utils = tslib_1.__importStar(require("../utils"));
var DetachedRuleset = /** @class */ (function (_super) {
    tslib_1.__extends(DetachedRuleset, _super);
    function DetachedRuleset(ruleset, frames) {
        var _this = _super.call(this) || this;
        _this.ruleset = ruleset;
        _this.frames = frames;
        _this.setParent(_this.ruleset, _this);
        return _this;
    }
    DetachedRuleset.prototype.accept = function (visitor) {
        this.ruleset = visitor.visit(this.ruleset);
    };
    DetachedRuleset.prototype.eval = function (context) {
        var frames = this.frames || utils.copyArray(context.frames);
        return new DetachedRuleset(this.ruleset, frames);
    };
    DetachedRuleset.prototype.callEval = function (context) {
        return this.ruleset.eval(this.frames ? new contexts_1.default.Eval(context, this.frames.concat(context.frames)) : context);
    };
    return DetachedRuleset;
}(node_1.default));
DetachedRuleset.prototype.type = 'DetachedRuleset';
DetachedRuleset.prototype.evalFirst = true;
exports.default = DetachedRuleset;
//# sourceMappingURL=detached-ruleset.js.map