Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var node_1 = tslib_1.__importDefault(require("./node"));
var paren_1 = tslib_1.__importDefault(require("./paren"));
var comment_1 = tslib_1.__importDefault(require("./comment"));
var dimension_1 = tslib_1.__importDefault(require("./dimension"));
var Constants = tslib_1.__importStar(require("../constants"));
var MATH = Constants.Math;
var Expression = /** @class */ (function (_super) {
    tslib_1.__extends(Expression, _super);
    function Expression(value, noSpacing) {
        var _this = _super.call(this) || this;
        _this.value = value;
        _this.noSpacing = noSpacing;
        if (!value) {
            throw new Error('Expression requires an array parameter');
        }
        return _this;
    }
    Expression.prototype.accept = function (visitor) {
        this.value = visitor.visitArray(this.value);
    };
    Expression.prototype.eval = function (context) {
        var returnValue;
        var mathOn = context.isMathOn();
        var inParenthesis = this.parens &&
            (context.math !== MATH.STRICT_LEGACY || !this.parensInOp);
        var doubleParen = false;
        if (inParenthesis) {
            context.inParenthesis();
        }
        if (this.value.length > 1) {
            returnValue = new Expression(this.value.map(function (e) {
                if (!e.eval) {
                    return e;
                }
                return e.eval(context);
            }), this.noSpacing);
        }
        else if (this.value.length === 1) {
            if (this.value[0].parens && !this.value[0].parensInOp && !context.inCalc) {
                doubleParen = true;
            }
            returnValue = this.value[0].eval(context);
        }
        else {
            returnValue = this;
        }
        if (inParenthesis) {
            context.outOfParenthesis();
        }
        if (this.parens && this.parensInOp && !mathOn && !doubleParen
            && (!(returnValue instanceof dimension_1.default))) {
            returnValue = new paren_1.default(returnValue);
        }
        return returnValue;
    };
    Expression.prototype.genCSS = function (context, output) {
        for (var i = 0; i < this.value.length; i++) {
            this.value[i].genCSS(context, output);
            if (!this.noSpacing && i + 1 < this.value.length) {
                output.add(' ');
            }
        }
    };
    Expression.prototype.throwAwayComments = function () {
        this.value = this.value.filter(function (v) { return !(v instanceof comment_1.default); });
    };
    return Expression;
}(node_1.default));
Expression.prototype.type = 'Expression';
exports.default = Expression;
//# sourceMappingURL=expression.js.map