Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var js_eval_node_1 = tslib_1.__importDefault(require("./js-eval-node"));
var dimension_1 = tslib_1.__importDefault(require("./dimension"));
var quoted_1 = tslib_1.__importDefault(require("./quoted"));
var anonymous_1 = tslib_1.__importDefault(require("./anonymous"));
var JavaScript = /** @class */ (function (_super) {
    tslib_1.__extends(JavaScript, _super);
    function JavaScript(string, escaped, index, currentFileInfo) {
        var _this = _super.call(this) || this;
        _this.escaped = escaped;
        _this.expression = string;
        _this._index = index;
        _this._fileInfo = currentFileInfo;
        return _this;
    }
    JavaScript.prototype.eval = function (context) {
        var result = this.evaluateJavaScript(this.expression, context);
        var type = typeof result;
        if (type === 'number' && !isNaN(result)) {
            return new dimension_1.default(result);
        }
        else if (type === 'string') {
            return new quoted_1.default("\"" + result + "\"", result, this.escaped, this._index);
        }
        else if (Array.isArray(result)) {
            return new anonymous_1.default(result.join(', '));
        }
        else {
            return new anonymous_1.default(result);
        }
    };
    return JavaScript;
}(js_eval_node_1.default));
JavaScript.prototype.type = 'JavaScript';
exports.default = JavaScript;
//# sourceMappingURL=javascript.js.map