/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { LexicalCommand } from './LexicalEditor';
import type { LexicalNode } from './LexicalNode';
import type { BaseSelection } from './LexicalSelection';
import type { ElementFormatType } from './nodes/LexicalElementNode';
import type { TextFormatType } from './nodes/LexicalTextNode';
export type PasteCommandType = ClipboardEvent | InputEvent | KeyboardEvent;
export declare function createCommand<T>(type?: string): LexicalCommand<T>;
export declare const SELECTION_CHANGE_COMMAND: LexicalCommand<void>;
export declare const SELECTION_INSERT_CLIPBOARD_NODES_COMMAND: LexicalCommand<{
    nodes: Array<LexicalNode>;
    selection: BaseSelection;
}>;
export declare const CLICK_COMMAND: LexicalCommand<MouseEvent>;
/**
 * Dispatched to delete a character, the payload will be `true` if the deletion
 * is backwards (backspace or delete on macOS) and `false` if forwards
 * (delete or Fn+Delete on macOS).
 */
export declare const DELETE_CHARACTER_COMMAND: LexicalCommand<boolean>;
/**
 * Dispatched to insert a line break. With a false payload the
 * cursor moves to the new line (Shift+Enter), with a true payload the cursor
 * does not move (Ctrl+O on macOS).
 */
export declare const INSERT_LINE_BREAK_COMMAND: LexicalCommand<boolean>;
export declare const INSERT_PARAGRAPH_COMMAND: LexicalCommand<void>;
export declare const CONTROLLED_TEXT_INSERTION_COMMAND: LexicalCommand<InputEvent | string>;
export declare const PASTE_COMMAND: LexicalCommand<PasteCommandType>;
export declare const REMOVE_TEXT_COMMAND: LexicalCommand<InputEvent | null>;
/**
 * Dispatched to delete a word, the payload will be `true` if the deletion is
 * backwards (Ctrl+Backspace or Opt+Delete on macOS), and `false` if
 * forwards (Ctrl+Delete or Fn+Opt+Delete on macOS).
 */
export declare const DELETE_WORD_COMMAND: LexicalCommand<boolean>;
/**
 * Dispatched to delete a line, the payload will be `true` if the deletion is
 * backwards (Cmd+Delete on macOS), and `false` if forwards
 * (Fn+Cmd+Delete on macOS).
 */
export declare const DELETE_LINE_COMMAND: LexicalCommand<boolean>;
/**
 * Dispatched to format the selected text.
 */
export declare const FORMAT_TEXT_COMMAND: LexicalCommand<TextFormatType>;
/**
 * Dispatched on undo (Cmd+Z on macOS, Ctrl+Z elsewhere).
 */
export declare const UNDO_COMMAND: LexicalCommand<void>;
/**
 * Dispatched on redo (Shift+Cmd+Z on macOS, Shift+Ctrl+Z or Ctrl+Y elsewhere).
 */
export declare const REDO_COMMAND: LexicalCommand<void>;
/**
 * Dispatched when any key is pressed.
 */
export declare const KEY_DOWN_COMMAND: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched when the `'ArrowRight'` key is pressed.
 * The shift modifier key may also be down.
 */
export declare const KEY_ARROW_RIGHT_COMMAND: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched when the move to end keyboard shortcut is pressed,
 * (Cmd+Right on macOS; Ctrl+Right elsewhere).
 */
export declare const MOVE_TO_END: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched when the `'ArrowLeft'` key is pressed.
 * The shift modifier key may also be down.
 */
export declare const KEY_ARROW_LEFT_COMMAND: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched when the move to start keyboard shortcut is pressed,
 * (Cmd+Left on macOS; Ctrl+Left elsewhere).
 */
export declare const MOVE_TO_START: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched when the `'ArrowUp'` key is pressed.
 * The shift and/or alt (option) modifier keys may also be down.
 */
export declare const KEY_ARROW_UP_COMMAND: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched when the `'ArrowUp'` key is pressed.
 * The shift and/or alt (option) modifier keys may also be down.
 */
export declare const KEY_ARROW_DOWN_COMMAND: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched when the enter key is pressed, may also be called with a null
 * payload when the intent is to insert a newline. The shift modifier key
 * must be down, any other modifier keys may also be down.
 */
export declare const KEY_ENTER_COMMAND: LexicalCommand<KeyboardEvent | null>;
/**
 * Dispatched whenever the space (`' '`) key is pressed, any modifier
 * keys may be down.
 */
export declare const KEY_SPACE_COMMAND: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched whenever the `'Backspace'` key is pressed, the shift
 * modifier key may be down.
 */
export declare const KEY_BACKSPACE_COMMAND: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched whenever the `'Escape'` key is pressed, any modifier
 * keys may be down.
 */
export declare const KEY_ESCAPE_COMMAND: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched whenever the `'Delete'` key is pressed (Fn+Delete on macOS).
 */
export declare const KEY_DELETE_COMMAND: LexicalCommand<KeyboardEvent>;
/**
 * Dispatched whenever the `'Tab'` key is pressed. The shift modifier key
 * may be down.
 */
export declare const KEY_TAB_COMMAND: LexicalCommand<KeyboardEvent>;
export declare const INSERT_TAB_COMMAND: LexicalCommand<void>;
export declare const INDENT_CONTENT_COMMAND: LexicalCommand<void>;
export declare const OUTDENT_CONTENT_COMMAND: LexicalCommand<void>;
export declare const DROP_COMMAND: LexicalCommand<DragEvent>;
export declare const FORMAT_ELEMENT_COMMAND: LexicalCommand<ElementFormatType>;
export declare const DRAGSTART_COMMAND: LexicalCommand<DragEvent>;
export declare const DRAGOVER_COMMAND: LexicalCommand<DragEvent>;
export declare const DRAGEND_COMMAND: LexicalCommand<DragEvent>;
/**
 * Dispatched on a copy event, either via the clipboard or a KeyboardEvent
 * (Cmd+C on macOS, Ctrl+C elsewhere).
 */
export declare const COPY_COMMAND: LexicalCommand<ClipboardEvent | KeyboardEvent | null>;
/**
 * Dispatched on a cut event, either via the clipboard or a KeyboardEvent
 * (Cmd+X on macOS, Ctrl+X elsewhere).
 */
export declare const CUT_COMMAND: LexicalCommand<ClipboardEvent | KeyboardEvent | null>;
/**
 * Dispatched on the select all keyboard shortcut
 * (Cmd+A on macOS, Ctrl+A elsehwere).
 */
export declare const SELECT_ALL_COMMAND: LexicalCommand<KeyboardEvent>;
export declare const CLEAR_EDITOR_COMMAND: LexicalCommand<void>;
export declare const CLEAR_HISTORY_COMMAND: LexicalCommand<void>;
export declare const CAN_REDO_COMMAND: LexicalCommand<boolean>;
export declare const CAN_UNDO_COMMAND: LexicalCommand<boolean>;
export declare const FOCUS_COMMAND: LexicalCommand<FocusEvent>;
export declare const BLUR_COMMAND: LexicalCommand<FocusEvent>;
/**
 * @deprecated in v0.31.0, use KEY_DOWN_COMMAND and check for modifiers
 * directly.
 *
 * Dispatched after any KeyboardEvent when modifiers are pressed
 */
export declare const KEY_MODIFIER_COMMAND: LexicalCommand<KeyboardEvent>;
