import { ExternalTokenizer, ContextTracker, LRParser } from '@lezer/lr';
import { styleTags, tags } from '@lezer/highlight';

// This file was generated by lezer-generator. You probably shouldn't edit it.
const propertyIdentifier = 119,
  identifier = 120,
  nameIdentifier = 121,
  insertSemi = 122,
  expression0 = 126,
  ForExpression = 4,
  forExpressionStart = 129,
  ForInExpression = 7,
  Name = 8,
  Identifier = 9,
  AdditionalIdentifier = 10,
  forExpressionBodyStart = 137,
  IfExpression = 18,
  ifExpressionStart = 138,
  QuantifiedExpression = 22,
  quantifiedExpressionStart = 139,
  QuantifiedInExpression = 26,
  PositiveUnaryTest = 36,
  ArithmeticExpression = 40,
  arithmeticPlusStart = 143,
  arithmeticTimesStart = 144,
  arithmeticExpStart = 145,
  arithmeticUnaryStart = 146,
  VariableName = 47,
  PathExpression = 67,
  pathExpressionStart = 151,
  FilterExpression = 69,
  filterExpressionStart = 152,
  FunctionInvocation = 71,
  functionInvocationStart = 153,
  ParameterName = 75,
  nil = 158,
  NumericLiteral = 78,
  StringLiteral = 79,
  BooleanLiteral = 80,
  List = 88,
  listStart = 169,
  FunctionDefinition = 89,
  functionDefinitionStart = 171,
  Context = 96,
  contextStart = 173,
  ContextEntry = 97,
  PropertyName = 99,
  PropertyIdentifier = 100;

/* global console,process */

const LOG_PARSE = typeof process != 'undefined' && process.env && /\bfparse(:dbg)?\b/.test(process.env.LOG);
const LOG_PARSE_DEBUG = typeof process != 'undefined' && process.env && /\bfparse:dbg\b/.test(process.env.LOG);
const LOG_VARS = typeof process != 'undefined' && process.env && /\bcontext\b/.test(process.env.LOG);

const spaceChars = [
  9, 11, 12, 32, 133, 160,
  5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198,
  8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288
];

const newlineChars = chars('\n\r');

const additionalNameChars = chars("'./-+*");

/**
 * @param { string } str
 * @return { number[] }
 */
function chars(str) {
  return Array.from(str).map(s => s.charCodeAt(0));
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isStartChar(ch) {
  return (
    ch === 63 // ?
  ) || (
    ch === 95 // _
  ) || (
    ch >= 65 && ch <= 90 // A-Z
  ) || (
    ch >= 97 && ch <= 122 // a-z
  ) || (
    ch >= 161 && !isPartChar(ch) && !isSpace(ch)
  );
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isAdditional(ch) {
  return additionalNameChars.includes(ch);
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isPartChar(ch) {
  return (
    ch >= 48 && ch <= 57 // 0-9
  ) || (
    ch === 0xB7
  ) || (
    ch >= 0x0300 && ch <= 0x036F
  ) || (
    ch >= 0x203F && ch <= 0x2040
  );
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isSpace(ch) {
  return spaceChars.includes(ch);
}

// eslint-disable-next-line
function indent(str, spaces) {
  return spaces.concat(
    str.split(/\n/g).join('\n' + spaces)
  );
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param  { number } [offset]
 * @param { boolean } [includeOperators]
 *
 * @return { { token: string, offset: number } | null }
 */
function parseAdditionalSymbol(input, offset = 0) {

  const next = input.peek(offset);

  if (isAdditional(next)) {
    return {
      offset: 1,
      token: String.fromCharCode(next)
    };
  }

  return null;
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param { number } [offset]
 * @param { boolean } [namePart]
 *
 * @return { { token: string, offset: number } | null }
 */
function parseIdentifier(input, offset = 0, namePart = false) {
  for (let inside = false, chars = [], i = 0;; i++) {
    const next = input.peek(offset + i);

    if (isStartChar(next) || ((inside || namePart) && isPartChar(next))) {
      if (!inside) {
        inside = true;
      }

      chars.push(next);
    } else {

      if (chars.length) {
        return {
          token: String.fromCharCode(...chars),
          offset: i
        };
      }

      return null;
    }
  }
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param  { number } offset
 *
 * @return { { token: string, offset: number } | null }
 */
function parseSpaces(input, offset) {

  for (let inside = false, i = 0;; i++) {
    let next = input.peek(offset + i);

    if (isSpace(next)) {
      if (!inside) {
        inside = true;
      }
    } else {
      if (inside) {
        return {
          token: ' ',
          offset: i
        };
      }

      return null;
    }
  }
}

/**
 * Parse a name from the input and return the first match, if any.
 *
 * @param { import('@lezer/lr').InputStream } input
 * @param { Variables } variables
 *
 * @return { { token: string, offset: number, term: number } | null }
 */
function parseName(input, variables) {
  const contextKeys = variables.contextKeys();

  const start = variables.tokens;

  for (let i = 0, tokens = [], nextMatch = null;;) {

    const namePart = (start.length + tokens.length) > 0;
    const maybeSpace = tokens.length > 0;

    const match = (
      parseIdentifier(input, i, namePart) ||
      namePart && parseAdditionalSymbol(input, i) ||
      maybeSpace && parseSpaces(input, i)
    );

    // match is required
    if (!match) {
      return nextMatch;
    }

    const {
      token,
      offset
    } = match;

    i += offset;

    if (token === ' ') {
      continue;
    }

    tokens = [ ...tokens, token ];

    const name = [ ...start, ...tokens ].join(' ');

    if (contextKeys.some(el => el === name)) {
      const token = tokens[0];

      nextMatch = {
        token,
        offset: token.length,
        term: nameIdentifier
      };
    }

    if (dateTimeIdentifiers.some(el => el === name)) {
      const token = tokens[0];

      // parse date time identifiers as normal
      // identifiers to allow specialization to kick in
      //
      // cf. https://github.com/nikku/lezer-feel/issues/8
      nextMatch = {
        token,
        offset: token.length,
        term: identifier
      };
    }

    if (
      !contextKeys.some(el => el.startsWith(name)) &&
      !dateTimeIdentifiers.some(el => el.startsWith(name))
    ) {
      return nextMatch;
    }
  }

}

const identifiersMap = {
  [ identifier ]: 'identifier',
  [ nameIdentifier ]: 'nameIdentifier'
};

const identifiers = new ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <identifier | nameIdentifier>', input.pos);

  const nameMatch = parseName(input, stack.context);

  const start = stack.context.tokens;

  const match = nameMatch || parseIdentifier(input, 0, start.length > 0);

  if (match) {
    input.advance(match.offset);
    input.acceptToken(nameMatch ? nameMatch.term : identifier);

    LOG_PARSE && console.log('%s: MATCH <%s> <%s>', input.pos, nameMatch ? identifiersMap[nameMatch.term] : 'identifier', match.token);
  }
}, { contextual: true });


const propertyIdentifiers = new ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <propertyIdentifier>', input.pos);

  const start = stack.context.tokens;

  const match = parseIdentifier(input, 0, start.length > 0);

  if (match) {
    input.advance(match.offset);
    input.acceptToken(propertyIdentifier);

    LOG_PARSE && console.log('%s: MATCH <propertyIdentifier> <%s>', input.pos, match.token);
  }
});


const insertSemicolon = new ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <insertSemi>', input.pos);

  let offset;
  let insert = false;

  for (offset = 0;; offset++) {
    const char = input.peek(offset);

    if (spaceChars.includes(char)) {
      continue;
    }

    if (newlineChars.includes(char)) {
      insert = true;
    }

    break;
  }

  if (insert) {

    const identifier = parseIdentifier(input, offset + 1);
    const spaces = parseSpaces(input, offset + 1);

    if (spaces || identifier && /^(then|else|return|satisfies)$/.test(identifier.token)) {
      return;
    }

    LOG_PARSE && console.log('%s: MATCH <insertSemi>', input.pos);
    input.acceptToken(insertSemi);
  }
});

const prefixedContextStarts = {
  [ functionInvocationStart ]: 'FunctionInvocation',
  [ filterExpressionStart ]: 'FilterExpression',
  [ pathExpressionStart ]: 'PathExpression'
};

const contextStarts = {
  [ contextStart ]: 'Context',
  [ functionDefinitionStart ]: 'FunctionDefinition',
  [ forExpressionStart ]: 'ForExpression',
  [ listStart ]: 'List',
  [ ifExpressionStart ]: 'IfExpression',
  [ quantifiedExpressionStart ]: 'QuantifiedExpression'
};

const contextEnds = {
  [ Context ]: 'Context',
  [ FunctionDefinition ]: 'FunctionDefinition',
  [ ForExpression ]: 'ForExpression',
  [ List ]: 'List',
  [ IfExpression ]: 'IfExpression',
  [ QuantifiedExpression ]: 'QuantifiedExpression',
  [ PathExpression ]: 'PathExpression',
  [ FunctionInvocation ]: 'FunctionInvocation',
  [ FilterExpression ]: 'FilterExpression',
  [ ArithmeticExpression ]: 'ArithmeticExpression'
};

class ValueProducer {

  /**
   * @param { Function } fn
   */
  constructor(fn) {
    this.fn = fn;
  }

  get(variables) {
    return this.fn(variables);
  }

  /**
   * @param { Function }
   *
   * @return { ValueProducer }
   */
  static of(fn) {
    return new ValueProducer(fn);
  }

}

const dateTimeLiterals = {
  'date and time': 1,
  'date': 1,
  'time': 1,
  'duration': 1
};

const dateTimeIdentifiers = Object.keys(dateTimeLiterals);

class Variables {

  constructor({
    name = 'Expressions',
    tokens = [],
    children = [],
    parent = null,
    context = { },
    value,
    raw
  } = {}) {
    this.name = name;
    this.tokens = tokens;
    this.children = children;
    this.parent = parent;
    this.context = context;
    this.value = value;
    this.raw = raw;
  }

  enterScope(name) {

    const childScope = this.of({
      name,
      parent: this
    });

    LOG_VARS && console.log('[%s] enter', childScope.path, childScope.context);

    return childScope;
  }

  exitScope(str) {

    if (!this.parent) {
      LOG_VARS && console.log('[%s] NO exit %o\n%s', this.path, this.context, indent(str, '  '));

      return this;
    }

    LOG_VARS && console.log('[%s] exit %o\n%s', this.path, this.context, indent(str, '  '));

    return this.parent.pushChild(this);
  }

  token(part) {

    LOG_VARS && console.log('[%s] token <%s> + <%s>', this.path, this.tokens.join(' '), part);

    return this.assign({
      tokens: [ ...this.tokens, part ]
    });
  }

  literal(value) {

    LOG_VARS && console.log('[%s] literal %o', this.path, value);

    return this.pushChild(this.of({
      name: 'Literal',
      value
    }));
  }

  /**
   * Return computed scope value
   *
   * @return {any}
   */
  computedValue() {
    for (let scope = this;;scope = last(scope.children)) {

      if (!scope) {
        return null;
      }

      if (scope.value) {
        return scope.value;
      }
    }
  }

  contextKeys() {
    return Object.keys(this.context).map(normalizeContextKey);
  }

  get path() {
    return this.parent?.path?.concat(' > ', this.name) || this.name;
  }

  /**
   * Return value of variable.
   *
   * @param { string } variable
   * @return { any } value
   */
  get(variable) {

    const names = [ variable, variable && normalizeContextKey(variable) ];

    const contextKey = Object.keys(this.context).find(
      key => names.includes(normalizeContextKey(key))
    );

    if (typeof contextKey === 'undefined') {
      return undefined;
    }

    const val = this.context[contextKey];

    if (val instanceof ValueProducer) {
      return val.get(this);
    } else {
      return val;
    }
  }

  resolveName() {

    const variable = this.tokens.join(' ');
    const tokens = [];

    const parentScope = this.assign({
      tokens
    });

    const variableScope = this.of({
      name: 'VariableName',
      parent: parentScope,
      value: this.get(variable),
      raw: variable
    });

    LOG_VARS && console.log('[%s] resolve name <%s=%s>', variableScope.path, variable, this.get(variable));

    return parentScope.pushChild(variableScope);
  }

  pushChild(child) {

    if (!child) {
      return this;
    }

    const parent = this.assign({
      children: [ ...this.children, child ]
    });

    child.parent = parent;

    return parent;
  }

  pushChildren(children) {

    let parent = this;

    for (const child of children) {
      parent = parent.pushChild(child);
    }

    return parent;
  }

  declareName() {

    if (this.tokens.length === 0) {
      throw Error('no tokens to declare name');
    }

    const variableName = this.tokens.join(' ');

    LOG_VARS && console.log('[%s] declareName <%s>', this.path, variableName);

    return this.assign({
      tokens: []
    }).pushChild(
      this.of({
        name: 'Name',
        value: variableName
      })
    );
  }

  define(name, value) {

    if (typeof name !== 'string') {
      LOG_VARS && console.log('[%s] no define <%s=%s>', this.path, name, value);

      return this;
    }

    LOG_VARS && console.log('[%s] define <%s=%s>', this.path, name, value);

    const context = {
      ...this.context,
      [name]: value
    };

    return this.assign({
      context
    });
  }

  /**
   * @param { Record<string, any> } [options]
   *
   * @return { Variables }
   */
  assign(options = {}) {

    return Variables.of({
      ...this,
      ...options
    });
  }

  /**
   * @param { Record<string, any> } [options]
   *
   * @return { Variables }
   */
  of(options = {}) {

    const defaultOptions = {
      context: this.context,
      parent: this.parent
    };

    return Variables.of({
      ...defaultOptions,
      ...options
    });
  }

  static of(options) {
    const {
      name,
      tokens = [],
      children = [],
      parent = null,
      context = {},
      value,
      raw
    } = options;

    return new Variables({
      name,
      tokens: [ ...tokens ],
      children: [ ...children ],
      context: {
        ...context
      },
      parent,
      value,
      raw
    });
  }

}

/**
 * @param { string } name
 *
 * @return { string } normalizedName
 */
function normalizeContextKey(name) {
  return name.replace(/\s*([./\-'+*])\s*/g, ' $1 ').replace(/\s{2,}/g, ' ').trim();
}

/**
 * Wrap children of variables under the given named child.
 *
 * @param { Variables } variables
 * @param { string } name
 * @param { string } code
 * @return { Variables }
 */
function wrap(variables, scopeName, code) {

  const parts = variables.children.filter(c => c.name !== scopeName);
  const children = variables.children.filter(c => c.name === scopeName);

  const namePart = parts[0];
  const valuePart = parts[Math.max(1, parts.length - 1)];

  const name = namePart.computedValue();
  const value = valuePart?.computedValue() || null;

  return variables
    .assign({
      children
    })
    .enterScope(scopeName)
    .pushChildren(parts)
    .exitScope(code)
    .define(name, value);
}

/**
 * @param { any } context
 *
 * @return { ContextTracker<Variables> }
 */
function trackVariables(context = {}) {

  const start = Variables.of({
    context
  });

  return new ContextTracker({
    start,
    reduce(variables, term, stack, input) {

      if (term === IfExpression) {
        const [ thenPart, elsePart ] = variables.children.slice(-2);

        variables = variables.assign({
          value: {
            ...thenPart?.computedValue(),
            ...elsePart?.computedValue()
          }
        });
      }

      if (term === List) {
        variables = variables.assign({
          value: variables.children.reduce((value, child) => {
            return {
              ...value,
              ...child?.computedValue()
            };
          }, {})
        });
      }

      if (term === FilterExpression) {
        const [ sourcePart, _ ] = variables.children.slice(-2);

        variables = variables.assign({
          value: sourcePart?.computedValue()
        });
      }

      if (term === FunctionInvocation) {

        const [
          name,
          ...args
        ] = variables.children;

        // preserve type information through `get value(context, key)` utility
        if (name?.raw === 'get value') {
          variables = getContextValue(variables, args);
        }
      }

      const start = contextStarts[term];

      if (start) {
        return variables.enterScope(start);
      }

      const prefixedStart = prefixedContextStarts[term];

      // pull <expression> into new <prefixedStart> context
      if (prefixedStart) {

        const {
          children: currentChildren,
          context: currentContext,
        } = variables;

        const children = currentChildren.slice(0, -1);
        const lastChild = last(currentChildren);

        let newContext = null;

        if (term === pathExpressionStart) {
          newContext = lastChild?.computedValue();
        }

        if (term === filterExpressionStart) {
          newContext = {
            ...currentContext,
            ...lastChild?.computedValue(),
            item: lastChild?.computedValue()
          };
        }

        return variables.assign({
          children
        }).enterScope(prefixedStart).pushChild(lastChild).assign({
          context: newContext || currentContext
        });
      }

      const code = input.read(input.pos, stack.pos);

      const end = contextEnds[term];

      if (end) {
        return variables.exitScope(code);
      }

      if (term === ContextEntry) {
        const parts = variables.children.filter(c => c.name !== 'ContextEntry');

        const name = parts[0];
        const value = last(parts);

        return wrap(variables, 'ContextEntry', code).assign(
          {
            value: {
              ...variables.value,
              [name.computedValue()] : value?.computedValue()
            }
          }
        );
      }

      if (
        term === ForInExpression ||
        term === QuantifiedInExpression
      ) {
        return wrap(variables, 'InExpression', code);
      }

      // define <partial> within ForExpression body
      if (term === forExpressionBodyStart) {

        return variables.define(
          'partial',
          ValueProducer.of(variables => {
            return last(variables.children)?.computedValue();
          })
        );
      }

      if (
        term === ParameterName
      ) {
        const name = last(variables.children).computedValue();

        // TODO: attach type information
        return variables.define(name, 1);
      }

      // pull <expression> into ArithmeticExpression child
      if (
        term === arithmeticPlusStart ||
        term === arithmeticTimesStart ||
        term === arithmeticExpStart
      ) {
        const children = variables.children.slice(0, -1);
        const lastChild = last(variables.children);

        return variables.assign({
          children
        }).enterScope('ArithmeticExpression').pushChild(lastChild);
      }

      if (term === arithmeticUnaryStart) {
        return variables.enterScope('ArithmeticExpression');
      }

      if (
        term === Identifier ||
        term === AdditionalIdentifier ||
        term === PropertyIdentifier
      ) {
        return variables.token(code);
      }

      if (
        term === StringLiteral
      ) {
        return variables.literal(code.replace(/^"|"$/g, ''));
      }

      if (term === BooleanLiteral) {
        return variables.literal(code === 'true' ? true : false);
      }

      if (term === NumericLiteral) {
        return variables.literal(parseFloat(code));
      }

      if (term === nil) {
        return variables.literal(null);
      }

      if (
        term === VariableName
      ) {
        return variables.resolveName();
      }

      if (
        term === Name ||
        term === PropertyName
      ) {
        return variables.declareName();
      }

      if (
        term === expression0 ||
        term === PositiveUnaryTest
      ) {
        if (variables.tokens.length > 0) {
          throw new Error('uncleared name');
        }
      }

      if (term === expression0) {

        let parent = variables;

        while (parent.parent) {
          parent = parent.exitScope(code);
        }

        return parent;
      }

      return variables;
    }
  });
}

const variableTracker = trackVariables({});


// helpers //////////////

function getContextValue(variables, args) {

  if (!args.length) {
    return variables.assign({
      value: null
    });
  }

  if (args[0].name === 'Name') {
    args = extractNamedArgs(args, [ 'm', 'key' ]);
  }

  if (args.length !== 2) {
    return variables.assign({
      value: null
    });
  }

  const [
    context,
    key
  ] = args;

  const keyValue = key?.computedValue();
  const contextValue = context?.computedValue();

  if (
    (!contextValue || typeof contextValue !== 'object') || typeof keyValue !== 'string'
  ) {
    return variables.assign({
      value: null
    });
  }

  return variables.assign({
    value: [ normalizeContextKey(keyValue), keyValue ].reduce((value, keyValue) => {
      if (keyValue in contextValue) {
        return contextValue[keyValue];
      }

      return value;
    }, null)
  });
}

function extractNamedArgs(args, argNames) {

  const context = {};

  for (let i = 0; i < args.length; i += 2) {
    const [ name, value ] = args.slice(i, i + 2);

    context[name.value] = value;
  }

  return argNames.map(name => context[name]);
}

function last(arr) {
  return arr[arr.length - 1];
}

const feelHighlighting = styleTags({
  StringLiteral: tags.string,
  NumericLiteral: tags.number,
  BooleanLiteral: tags.bool,
  'AtLiteral!': tags.special(tags.string),
  CompareOp: tags.compareOperator,
  ArithOp: tags.arithmeticOperator,
  'for if then else some every satisfies between return': tags.controlKeyword,
  'in instance of and or': tags.operatorKeyword,
  function: tags.definitionKeyword,
  as: tags.keyword,
  'Type/...': tags.typeName,
  Wildcard: tags.special,
  null: tags.null,
  LineComment: tags.lineComment,
  BlockComment: tags.blockComment,
  'VariableName! "?"': tags.variableName,
  'DateTimeConstructor! SpecialFunctionName!': tags.function(tags.special(tags.variableName)),
  'List Interval': tags.list,
  Context: tags.definition(tags.literal),
  'Name!': tags.definition(tags.variableName),
  'Key/Name! ContextEntryType/Name!': tags.definition(tags.propertyName),
  'PathExpression/VariableName!': tags.function(tags.propertyName),
  'FormalParameter/ParameterName!': tags.function(tags.definition(tags.variableName)),
  '( )': tags.paren,
  '[ ]': tags.squareBracket,
  '{ }': tags.brace,
  '.': tags.derefOperator,
  ', ;': tags.separator,
  '..': tags.punctuation
});

// This file was generated by lezer-generator. You probably shouldn't edit it.
const spec_identifier = {__proto__:null,for:10, in:30, return:34, if:38, then:40, else:42, some:46, every:48, satisfies:55, or:58, and:62, between:70, instance:86, of:89, days:99, time:101, duration:103, years:105, months:107, date:109, list:115, context:121, function:128, null:154, true:324, false:324, "?":168, external:184, not:207};
const parser = LRParser.deserialize({
  version: 14,
  states: "IWO`QYOOO$gQYOOOOQU'#Ce'#CeO$qQYO'#C`O%zQ^O'#FOOOQQ'#Fd'#FdO'dQYO'#FdO`QYO'#DUOOQU'#Em'#EmO)QQ^O'#D]OOQO'#Fk'#FkO,PQWO'#DuOOQU'#D|'#D|OOQU'#D}'#D}OOQU'#EO'#EOO,UOWO'#ERO,PQWO'#EPOOQU'#EP'#EPOOQU'#Fq'#FqOOQU'#Fo'#FoOOQQ'#Fv'#FvO.yQYO'#FvO0wQYO'#FvOOQU'#ET'#ETO2sQYO'#EVOOQU'#FQ'#FQO4UQ^O'#FQO5hQYO'#EWO5rQWO'#EXOOQP'#GP'#GPO5wQXO'#E`OOQU'#Fz'#FzOOQU'#FP'#FPOOQQ'#Eh'#EhQ`QYOOOOQQ'#FR'#FROOQQ'#F['#F[O2sQYO'#CnOOQQ'#F]'#F]O$qQYO'#CrO6SQYO'#DvOOQU'#Fp'#FpO6XQYO'#EQOOQO'#EQ'#EQO2sQYO'#EUO`QYO'#ETOOQO'#F}'#F}O7bQYO'#DQO8UQWO'#F`OOQO'#DS'#DSO8aQYO'#FdQOQWOOO8hQWOOO9[QYO'#CdO9iQYO'#FTOOQQ'#Cc'#CcO9nQYO'#FSOOQQ'#Cb'#CbO9vQYO,58zO`QYO,59hOOQQ'#Fa'#FaOOQQ'#Fb'#FbOOQQ'#Fc'#FcO`QYO,59pO`QYO,59pO`QYO,59pOOQQ'#Fi'#FiO$qQYO,5:]OOQQ'#Fj'#FjO2sQYO,5:_OOQQ,5;j,5;jO`QYO,59dO`QYO,59fO2sQYO,59hO;fQYO,59hO;mQYO,59rOOQU,5:h,5:hO;rQ^O,59pOOQU-E8k-E8kO>qQYO'#FlOOQU,5:a,5:aOOQU,5:m,5:mOOQU,5:k,5:kO>{QYO,5:qOOQU,5;l,5;lO?SQYO'#FnO?aQWO,5:rO?fQYO,5:sOOQP'#Ed'#EdO@YQXO'#EcOOQO'#Eb'#EbO@aQWO'#EaO@fQWO'#GQO@nQWO,5:zOOQQ-E8f-E8fO@sQYO,59YO9iQYO'#F_OOQQ'#Cv'#CvO@zQYO'#F^OOQQ'#Cu'#CuOASQYO,59^OAXQYO,5:bOA^QYO,5:lOAcQYO,5:pOAjQ^O,5:oO2sQYO'#ElOCSQWO,5;zO2sQYOOOOQR'#Cf'#CfOOQQ'#Ei'#EiOCyQYO,59OO2sQYO,5;oOOQQ'#FW'#FWO$qQYO'#EjODZQYO,5;nO`QYO1G.fOOQQ'#FZ'#FZOEjQ^O1G/SOI]Q^O1G/[OIgQ^O1G/[OK_Q^O1G/[OOQU1G/w1G/wOLtQYO1G/yOMyQ^O1G/OO!!aQ^O1G/QO!$}QYO1G/SO!%UQYO1G/SOOQU1G/S1G/SO!&tQYO1G/^O!'`Q^O'#CdOOQO'#Dy'#DyO!(rQWO'#DxO!(wQWO'#FmOOQO'#Dw'#DwOOQO'#Dz'#DzO!)PQWO,5<WOOQU'#Fy'#FyOOQU1G0]1G0]O2sQYO'#ErO!)UQWO,5<YOOQU'#F|'#F|OOQU1G0^1G0^O!)aQWO'#EZO!)lQWO'#GOOOQO'#EY'#EYO!)tQWO1G0_OOQP'#Et'#EtO!)yQXO,5:}O2sQYO,5:{O!*QQXO'#EuO!*YQWO,5<lOOQU1G0f1G0fO2sQYO1G.tO2sQYO,5;yO$qQYO'#EkO!*bQYO,5;xO`QYO1G.xO!*jQYO1G/|OOQO1G0W1G0WO2sQYO1G0[OOQO,5;W,5;WOOQO-E8j-E8jO!*oQWOOOOQQ-E8g-E8gO!*tQYO'#ClOOQQ1G1Z1G1ZOOQQ,5;U,5;UOOQQ-E8h-E8hO!+RQ^O7+$QOOQU7+%e7+%eO`QYO7+$nO!,kQWO7+$nO!,pQ^O'#D[OOQU'#DZ'#DZO!/oQYO'#D^O!/tQYO'#D^O!/yQYO'#D^O!0OQ`O'#DfO!0TQ`O'#DiO!0YQ`O'#DmOOQU7+$x7+$xO2sQYO,5:dO$qQYO'#EqO!0_QWO,5<XOOQU1G1r1G1rO!0gQYO,5;^OOQO-E8p-E8pO!&tQYO,5:uO$qQYO'#EsO!0tQWO,5<jO!0|QYO7+%yOOQP-E8r-E8rO!1TQYO1G0gOOQO,5;a,5;aOOQO-E8s-E8sO!1_QYO7+$`O!1fQYO1G1eOOQQ,5;V,5;VOOQQ-E8i-E8iO!1pQ^O7+$dOOQO7+%h7+%hO!4WQYO7+%vO2sQYO,59WO!5lQ^O<<HYOOQU<<HY<<HYO$qQYO'#EnO!7OQ^O,59vO!9}QYO,59xO!:SQYO,59xO!:XQYO,59xO!:^QYO,5:QO$qQYO,5:TO!:xQbO,5:XO!;PQYO1G0OOOQO,5;],5;]OOQO-E8o-E8oOOQO1G0a1G0aOOQO,5;_,5;_OOQO-E8q-E8qO!;ZQ^O'#E]OOQU<<Ie<<IeO`QYO<<IeO`QYO<<GzO!<sQ^O'#FjOOQU'#Fw'#FwOOQU<<Ib<<IbO!?rQYO1G.rOOQU,5;Y,5;YOOQU-E8l-E8lO!?|QYO1G/dOOQU1G/d1G/dO!@RQbO'#D]O!@dQ`O'#D[O!@oQ`O1G/lO!@tQWO'#DlO!@yQ`O'#FeOOQO'#Dk'#DkO!ARQ`O1G/oOOQO'#Dp'#DpO!AWQ`O'#FgOOQO'#Do'#DoO!A`Q`O1G/sOOQUAN?PAN?PO!AeQ^OAN=fOOQU7+%O7+%OO!B}Q`O,59vOOQU7+%W7+%WO!:^QYO,5:WO$qQYO'#EoO!CYQ`O,5<POOQU7+%Z7+%ZO!:^QYO'#EpO!CbQ`O,5<RO!CjQ`O7+%_OOQO1G/r1G/rOOQO,5;Z,5;ZOOQO-E8m-E8mOOQO,5;[,5;[OOQO-E8n-E8nO!&tQYO<<HyOOQUAN>eAN>eO!CoQ^O'#FQO2sQYO'#ETO2sQYO,59hO2sQYO,59pO2sQYO,59pO2sQYO,59pO2sQYO,59dO2sQYO,59fO!EvQYO,59hO!E}QYO,5:oO2sQYO1G.fO!FqQYO1G/SO!HxQYO1G/[O!ISQYO1G/[O!JXQYO1G/OO!KyQYO1G/QO2sQYO1G.xO!LsQYO7+$QO2sQYO7+$nO!MgQYO7+%yO!MqQYO7+$dO!NeQYO<<HYO$qQYO'#EnO# RQYO'#E]O2sQYO<<IeO2sQYO<<GzO# uQYOAN=fO!:^QYO<<HyO2sQYO'#DUO#!iQ^O'#DQO9vQYO,58zO#$RQYO,59^O#$WQYO1G/SO#$_QWO1G0_O#$dQYO7+$`O#$kQ`O7+%_O$qQYO'#C`O$qQYO'#CrO2sQYO,59hO?fQYO,5:sO2sQYO1G.tO#$pQ`O1G/sO#$uQWO'#EXO#$zQYO,59YO!:xQbO,5:XO2sQYO'#CnO#%RQ`O'#Dm",
  stateData: "#%W~O#pOS#qOSPOSQOS~OTsOZUO[TOctOgvOhvOr}OueO!S{O!T{O!UxO!WzO!b!OO!fdO!hfO!oyO!viO#RmO#lQO#mQO$f[O$g]O$h^O$i_O~OTsO[TOctOgvOhvOr&pOueO!S{O!T{O!UxO!WzO!b!OO!fdO!hfO!oyO!viO#RmO#lQO#mQO$f[O$g]O$h^O$i_O~OZ!SO#Z!UO~P!|O#lQO#mQO~OZ!^O[!^O]!_O^!_O_!lOm!iOo!jOq!]Or!]Os!kOy!`O{!mO!h!fO#x!dOu$_X~O#n!hO$u!hOT#rXc#rXg#rXh#rX!S#rX!T#rX!U#rX!W#rX!b#rX!f#rX!o#rX!v#rX#R#rX#j#rX#l#rX#m#rX$f#rX$g#rX$h#rX$i#rX~P$yO$f!nOT$WXZ$WX[$WXc$WXg$WXh$WXr$WXu$WX!S$WX!T$WX!U$WX!W$WX!b$WX!f$WX!h$WX!o$WX!v$WX#R$WX#l$WX#m$WX$g$WX$h$WX$i$WX~O#lQO#mQOT!PXZ!PX[!PX]!PX^!PX_!PXc!PXg!PXh!PXm!PXo!PXq!PXr!PXs!PXu!PXy!PX{!PX!S!PX!T!PX!U!PX!W!PX!b!PX!f!PX!h!PX!o!PX!v!PX#R!PX#j!PX#n!PX#x!PX$f!PX$g!PX$h!PX$i!PX$u!PX#|!PXw!PXd!PX#{!PXa!PX#Q!PXe!PXk!PX~Ou!qO~O$g]O~OT$jXT$lXc$jXc$lXg$jXg$lXh$jXh$lXr$jXr$lXu$jXu$lX!S$jX!S$lX!T$jX!T$lX!U$jX!U$lX!W$jX!W$lX!b$jX!b$lX!f$jX!f$lX!h$jX!h$lX!o$jX!o$lX!v$jX!v$lX#R$jX#R$lX$f$jX$f$lX$g$jX$g$lX$h$jX$h$lX$i$jX$i$lX~OZ$jXZ$lX[$jX[$lX#l$jX#l$lX#m$jX#m$lX~P,ZOT$jXc$jXg$jXh$jXr$jXu$jX!S$jX!T$jX!U$jX!W$jX!b$jX!f$jX!h$jX!o$jX!v$jX#R$jX$f$jX$g$jX$h$jX$i$jX~OT$oXZ$jXZ$oX[$jX[$oXc$oXg$oXh$oXr$oXu$oX!S$oX!T$oX!U$oX!W$oX!b$oX!f$oX!h$oX!o$oX!v$oX#R$oX#l$jX#l$oX#m$jX#m$oX$f$oX$g$oX$h$oX$i$oX~P/gOZUO~P!|O#n!vOZ#tX[#tX]#tX^#tX_#tXm#tXo#tXq#tXr#tXs#tXu#tXy#tX{#tX!f#tX!h#tX#j#tX#x#tX~OT#tXc#tXg#tXh#tX!S#tX!T#tX!U#tX!W#tX!b#tX!o#tX!v#tX#R#tX#l#tX#m#tX#n#tX$f#tX$g#tX$h#tX$i#tX$u#tX~P2zOZUO!f$bP~P!|Ou!yO~O#k!zO$g]O#Q$tP~Oo#XO~Oo#YOu!tX~OZ!^O[!^O]!_O^!_O_&wOm&uOo&vOq&qOr&qOs'gOy!`O{!mO!h!fO#x!dOu$_X~O#jtX#|tXwtX!ftXdtX#{tXatX#QtXetXktX~P6aO#|#]O#j$SXw$SX~O#j#YX~P'dOu#_O~OZ#`O[#`O]#`O^#`O#lQO#mQO#x#`O#y#`O$YWX~O_WXwWX#|WX~P8mO_#dO~O#|#eOa#vX~Oa#hO~OTsOZUO[TOctOgvOhvOr}O!S{O!T{O!UxO!WzO!b!OO!fdO!hfO!oyO!viO#RmO#lQO#mQO$f[O$g]O$h^O$i_O~Ou#rO~P9{O|#tO~O{!mO!h!fO#x!dOTxaZxa[xa]xa^xa_xacxagxahxamxaoxaqxarxasxau$_Xyxa!Sxa!Txa!Uxa!Wxa!bxa!fxa!oxa!vxa#Rxa#jxa#lxa#mxa#nxa$fxa$gxa$hxa$ixa$uxa#|xawxadxa#{xaaxa#Qxaexakxa~OZUOw$bP~P!|Ow#|O~P6aO#|$OO!f$bXw$bX~P6aO!f$QO~O#lQO#mQOw$rP~OZ#`O[#`O]#`O^#`O#k!zO#x#`O#y#`O~O$Y#VX~P?qO$Y$YO~O#|$ZO#Q$tX~O#Q$]O~Od$^O~P6aO#|$`Ok$QX~Ok$bO~O!V$cO~O!S$dO~O#{$eO~P6aOT!wac!wag!wah!wa!S!wa!T!wa!U!wa!W!wa!b!wa!f!wa!o!wa!v!wa#R!wa#j!wa#l!wa#m!wa#n!wa$f!wa$g!wa$h!wa$i!wa$u!wa~P$yO#|#]O#j$Saw$Sa~OZ#`O[#`O]#`O^#`O#lQO#mQO#x#`O#y#`O~O_Wa$YWawWa#|Wa~PC_O#|#eOa#va~OZ!^O[!^O]!_O^!_Oy!`O{!mO!h!fO#x!dO_pimpiopiqpirpispiu$_X!fpi#jpi~OTpicpigpihpi!Spi!Tpi!Upi!Wpi!bpi!opi!vpi#Rpi#lpi#mpi#npi$fpi$gpi$hpi$ipi$upi~PDcOy!`O{!mO!h!fO#x!dOTxiZxi[xi_xicxigxihximxioxiqxirxisxiu$_X!Sxi!Txi!Uxi!Wxi!bxi!fxi!oxi!vxi#Rxi#jxi#lxi#mxi#nxi$fxi$gxi$hxi$ixi$uxi~O]!_O^!_O~PF|O]xi^xi~PF|O{!mO!h!fO#x!dOZxi[xi]xi^xi_ximxioxiqxirxisxiu$_X!fxi#jxi#|xiwxidxi#{xiaxi#Qxiexikxi~OTxicxigxihxiyxi!Sxi!Txi!Uxi!Wxi!bxi!oxi!vxi#Rxi#lxi#mxi#nxi$fxi$gxi$hxi$ixi$uxi~PIqO!f$oO~P6aOZ!^O[!^O]!_O^!_O_!lOo!jOq!]Or!]Os!kOy!`O{!mO!h!fO#x!dOu$_X~OTlicliglihlimli!Sli!Tli!Uli!Wli!bli!fli!oli!vli#Rli#jli#lli#mli#nli$fli$gli$hli$ili$uli~PL{OZ!^O[!^O]!_O^!_O_!lOq!]Or!]Os!kOy!`O{!mO!h!fO#x!dOu$_X~OTnicnignihnimnioni!Sni!Tni!Uni!Wni!bni!fni!oni!vni#Rni#jni#lni#mni#nni$fni$gni$hni$ini$uni~P! fOZ!^O[!^O]!_O^!_O_&wOm&uOq&qOr&qOs'gOy!`O{!mO!h!fO#x!dOu$_X~Oo$pO~P!$POTsOZUO[TOctOgvOhvOr&pOueO!S{O!T{O!UxO!WzO!b!OO!fdO!hfO!oyO!viO#RmO#lQO#mQO$f[O$g]O$h^O$i_O~P,ZO!R$tO!U$uO!W$vO!Z$wO!^$xO!b$yO#lQO#mQO~OZ#aX[#aX]#aX^#aX_#aXm#aXo#aXq#aXr#aXs#aXu#aXw#aXy#aX{#aX!h#aX#l#aX#m#aX#n#aX#x#aX#|#aX~P8mO$Y${O~O#|$|Ow$aX~Ow%OO~O#|$OO!f$baw$ba~O$Y%ROw!}X#|!}X~O#|%SOw$rX~Ow%UO~O$Y#Va~P?qO#k!zO$g]O~O#|$ZO#Q$ta~O#|$`Ok$Qa~O!T%`O~Ow!TO~O#{%bOa`X#|`X~P6aOTSqcSqgSqhSq!SSq!TSq!USq!WSq!bSq!fSq!oSq!vSq#RSq#jSq#lSq#mSq#nSq$fSq$gSq$hSq$iSq$uSq~P$yOw%dO~O#x%eOT!OXZ!OX[!OX]!OX^!OX_!OXc!OXg!OXh!OXm!OXo!OXq!OXr!OXs!OXu!OXy!OX{!OX!S!OX!T!OX!U!OX!W!OX!b!OX!f!OX!h!OX!o!OX!v!OX#R!OX#j!OX#l!OX#m!OX#n!OX$f!OX$g!OX$h!OX$i!OX$u!OX#|!OXw!OXd!OX#{!OXa!OX#Q!OXe!OXk!OX~Oo%gO~Oo%hO~Oo%iO~O![%jO~O![%kO~O![%lO~O#|$|Ow$aa~O!f#fa#|#faw#fa~P6aO#|%SOw$ra~O#O%uO~P`O#Q#Ti#|#Ti~P6aOe%vO~P6aOk$Ri#|$Ri~P6aOTfqcfqgfqhfq!Sfq!Tfq!Ufq!Wfq!bfq!ffq!ofq!vfq#Rfq#jfq#lfq#mfq#nfq$ffq$gfq$hfq$ifq$ufq~P$yOZ!^O[!^O]!_O^!_O_&wOm&uOo&vOq&qOr&qOs'gOy!`O{!mO#x!dOu$_X~Ow%xO!f%xO!h%wO~P!3YOZ!^O[!^O]!_O^!_Oy!`O{!mO!h!fO#x!dO_pympyopyqpyrpyspyu$_X!fpy#jpy~OTpycpygpyhpy!Spy!Tpy!Upy!Wpy!bpy!opy!vpy#Rpy#lpy#mpy#npy$fpy$gpy$hpy$ipy$upy~P!4eO#x%eOT!OaZ!Oa[!Oa]!Oa^!Oa_!Oac!Oag!Oah!Oam!Oao!Oaq!Oar!Oas!Oau!Oay!Oa{!Oa!S!Oa!T!Oa!U!Oa!W!Oa!b!Oa!f!Oa!h!Oa!o!Oa!v!Oa#R!Oa#j!Oa#l!Oa#m!Oa#n!Oa$f!Oa$g!Oa$h!Oa$i!Oa$u!Oa#|!Oaw!Oad!Oa#{!Oaa!Oa#Q!Oae!Oak!Oa~O!S%}O~O!V%}O~O!S&OO~O!R$tO!U$uO!W$vO!Z$wO!^$xO!b'oO#lQO#mQO~O!X$ZP~P!:^Ow!li#|!li~P6aOT#PXc#PXg#PXh#PX!S#PX!T#PX!U#PX!W#PX!b#PX!f#PX!o#PX!v#PX#R#PX#j#PX#l#PX#m#PX#n#PX$f#PX$g#PX$h#PX$i#PX$u#PX~P$yOT$^XZ$^X[$^X]$kX^$kX_$kXc$^Xg$^Xh$^Xm$kXo$kXq$kXr$^Xs$kXu$^Xy$kX{$kX!S$^X!T$^X!U$^X!W$^X!b$^X!f$^X!h$^X!o$^X!v$^X#R$^X#j$kX#l$^X#m$^X#n$kX#x$kX$f$^X$g$^X$h$^X$i$^X$u$kX#|$kXw$kXd$kX#{$kXa$kX#Q$kXe$kXk$kX~Oa`i#|`i~P6aO!T&^O~O#lQO#mQO!X!PX#x!PX#|!PX~O#x'VO!X!OX#|!OX~O!X&`O~O$Y&aO~O#|&bO!X$XX~O!X&dO~O#|&eO!X$ZX~O!X&gO~OTb!Rcb!Rgb!Rhb!R!Sb!R!Tb!R!Ub!R!Wb!R!bb!R!fb!R!ob!R!vb!R#Rb!R#jb!R#lb!R#mb!R#nb!R$fb!R$gb!R$hb!R$ib!R$ub!R~P$yO#x'VO!X!Oa#|!Oa~O#|&bO!X$Xa~O#|&eO!X$Za~O$[&mO~O#|#tXw#tXd#tX#{#tXa#tX#Q#tXe#tXk#tX~P2zOTsOZUO[TOctOgvOhvOr&pO!S{O!T{O!UxO!WzO!b!OO!fdO!hfO!oyO!viO#RmO#lQO#mQO$f[O$g]O$h^O$i_O~Ou#rO~P!D]O#j!wa#|!waw!wa!f!wad!wa#{!waa!wa#Q!wae!wak!wa~P6aO#|piwpidpi#{piapi#Qpiepikpi~PDcOy!`O{!mO!h!fO#x!dOZxi[xi_ximxioxiqxirxisxiu$_X#jxi#|xiwxi!fxidxi#{xiaxi#Qxiexikxi~O]!_O^!_O~P!G_Oy!`O~PIqOZ!^O[!^O]!_O^!_O_&wOo&vOq&qOr&qOs'gOy!`O{!mO!h!fO#x!dOu$_X~Omli#jli#|liwli!flidli#{liali#Qlielikli~P!IZOZ!^O[!^O]!_O^!_O_&wOq&qOr&qOs'gOy!`O{!mO!h!fO#x!dOu$_X~Omnioni#jni#|niwni!fnidni#{niani#Qnienikni~P!KOO#jSq#|SqwSq!fSqdSq#{SqaSq#QSqeSqkSq~P6aOZUO#O'XO~P!|O#jfq#|fqwfq!ffqdfq#{fqafq#Qfqefqkfq~P6aO#|pywpydpy#{pyapy#Qpyepykpy~P!4eO#j#PX#|#PXw#PX!f#PXd#PX#{#PXa#PX#Q#PXe#PXk#PX~P6aO#jb!R#|b!Rwb!R!fb!Rdb!R#{b!Rab!R#Qb!Reb!Rkb!R~P6aOTtXctXgtXhtX!StX!TtX!UtX!WtX!btX!ftX!otX!vtX#RtX#jtX#ltX#mtX#ntX$ftX$gtX$htX$itX$utX~P$yOk'PO~Oo'RO~P!$POw'SO~Oe'YO~P6aO$['[O~O!X'dO~Ou'hO~Od'iO~P6aO!['mO~O",
  goto: "!$f$uPPPP$vP&Q&W&_&t(sPPPPP(|P$vPPP$vPP)P)VP$vP$vP$vPPP)^P)jP$vP$vPP)s*Y*e*YPPPPPPP*YPP*YP,V,Y*YP,`,f$vP$vP$v,m-w-z.Q-wP.Z/e.Z.Z0v2QP$v3[$v4f4f5p5vP5}PP4f6V6]0r6aP6iP6l6r6y7P7V7]8y9T9Z9a9g9m9s9yPPPPPPPP:P:T=X>c?o?sPP?xPP@O@UAbBnBrBwB|CxDvEvGSPGVPGZHZIZJeJkJn$vJtJtPPPPLOMYM]Ng=XNj! t! w!#T!#X!$c#aiOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nQ![RR'_'eS!YR'eR$l#eU!WR#e'eU#Sw$`'fY#v!q!y$|%S'hT&S%k&b#zWOPVXhkru|}!]!a!b!c!e!g!i!j!k!l#]#_#c#g#r#t$O$Y$^$_$b$e$p${%R%U%b%e%j%l%u%v&P&a&e&m&p&q&r&s&t&u&v&w&y'P'R'S'V'X'Y'[']'g'i'm'nh!VRw!y#e$`$|%S%k&b'e'f'hU#a!V#b#uR#u!qU#a!V#b#uT$W!{$XR$k#cQ#WwR'`'fS#Uw'fR%]$`U!QP#_#rS#s!l&wR$f#]Q!TPQ$h#_R$q#rQ$z#tQ%p%RQ&R%jU&W%l&e'mQ&h&aT&n&m'[c$s#t%R%j%l&a&e&m'['mrjOVr}!]!a!b!c!i!j!l#g$b$p%U%u%vQ#m!eU$r#t%R&mS%{%e'V[&Q%j%l&a&e'['m!m&oPhku|!g!k!q#]#_#c#r$O$Y$^$_$e${%b&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nR&V%kQ&T%kR&i&bQ&Z%lR'j'mS&X%l'mR&k&e#aYOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nR#{!qQ#x!qR%n$|S#w!q$|V$S!y%S'h#abOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'n#`bOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nQ!s_T!|n$Z#a`OPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'n#aaOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'n#agOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'n#aoOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nQ$V!yR'b'hS$T!y'hR%q%SS%t%U'ST&[%u'XQ#OnR%X$ZT!}n$ZS!{n$ZT$W!{$XR!TPQrOR#QrS#b!V#uR$i#bQ#f!YR$m#fQ$a#UR%^$aQ#^!QR$g#^#jXOPVhkru|}!]!a!b!c!e!g!i!j!k!l!q#]#_#c#g#r#t$O$Y$^$_$b$e$p${%R%U%b%e%u%v&m&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nS!pX&P_&P%j%l&a&e'V'['mQ%f$rS%|%f&_R&_&QQ&c&TR&j&cQ&f&XR&l&fQ$}#xR%o$}Q$P!wR%Q$PQ%T$TR%r%TQ$X!{R%V$XQ$[#OR%Y$[TqOrSSOrY!PP#]#_#r&wS!oV']Q!uhS!wk!qQ#RuQ#Z|Q#[}Q#i!]Q#j!aQ#k!bS#l!c&tQ#n!gQ#o!iQ#p!jQ#q!kQ$j#cQ$n#gQ%P$OQ%W$YQ%Z$^Q%[$_Q%_$bQ%a$eQ%c$pQ%m${S%s%U%uQ%z%bQ&]%vQ&x&pQ&z&qQ&{&rQ&|&sQ&}&uQ'O&vQ'Q&yQ'T'PQ'U'RS'W'S'XQ'Z'YQ'^!lQ'a'gQ'c'iR'l'n#apOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nrROVr}!]!a!b!c!i!j!l#g$b$p%U%u%v!m'ePhku|!g!k!q#]#_#c#r$O$Y$^$_$e${%b&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nT!ZR'eV!XR#e'eQ#c!WR$_#SQ#g![R&y'_ruOVr}!]!a!b!c!i!j!l#g$b$p%U%u%v!m'nPhku|!g!k!q#]#_#c#r$O$Y$^$_$e${%b&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nrwOVr}!]!a!b!c!i!j!l#g$b$p%U%u%v!m'fPhku|!g!k!q#]#_#c#r$O$Y$^$_$e${%b&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nT#Vw'fV#Tw$`'fV!RP#_#rf!aS#[#i#o#p$n%_%c%s&]'^!X&r!P!u!w#R#Z#n#q$j%P%W%Z%[%a%m%z&x&z&}'O'Q'T'U'W'Z'a'c'lh!bS#[#i#j#o#p$n%_%c%s&]'^!Z&s!P!u!w#R#Z#n#q$j%P%W%Z%[%a%m%z&x&z&{&}'O'Q'T'U'W'Z'a'c'lj!cS#[#i#j#k#o#p$n%_%c%s&]'^!]&t!P!u!w#R#Z#n#q$j%P%W%Z%[%a%m%z&x&z&{&|&}'O'Q'T'U'W'Z'a'c'lrVOVr}!]!a!b!c!i!j!l#g$b$p%U%u%v!m']Phku|!g!k!q#]#_#c#r$O$Y$^$_$e${%b&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nR&U%kT&Y%l'm!{!eS!P!o!u!w#R#Z#[#i#j#k#l#n#o#p#q$j$n%P%W%Z%[%_%a%c%m%s%z&]&x&z&{&|&}'O'Q'T'U'W'Z'^'a'c'l!{!gS!P!o!u!w#R#Z#[#i#j#k#l#n#o#p#q$j$n%P%W%Z%[%_%a%c%m%s%z&]&x&z&{&|&}'O'Q'T'U'W'Z'^'a'c'l#aZOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nQ!rZR!t`R#y!qQ!xkR#z!q#acOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'n#a|OPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nR%y%a#ahOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nR#}!u#akOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nR$R!xrlOVr}!]!a!b!c!i!j!l#g$b$p%U%u%v!m'kPhku|!g!k!q#]#_#c#r$O$Y$^$_$e${%b&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nT$U!y'h#anOPVhkru|}!]!a!b!c!g!i!j!k!l!q#]#_#c#g#r$O$Y$^$_$b$e$p${%U%b%u%v&p&q&r&s&t&u&v&w&y'P'R'S'X'Y']'g'i'nR#Pn",
  nodeNames: "⚠ LineComment BlockComment Expressions ForExpression for InExpressions InExpression Name Identifier Identifier ArithOp ArithOp ArithOp ArithOp in IterationContext return IfExpression if then else QuantifiedExpression some every InExpressions InExpression satisfies Disjunction or Conjunction and Comparison CompareOp CompareOp between PositiveUnaryTest ( PositiveUnaryTests ) ArithmeticExpression ArithOp InstanceOfExpression instance of Type QualifiedName VariableName SpecialType days time duration years months date > ListType list < ContextType context ContextEntryTypes ContextEntryType FunctionType function ArgumentTypes ArgumentType PathExpression ] FilterExpression [ FunctionInvocation SpecialFunctionName NamedParameters NamedParameter ParameterName PositionalParameters null NumericLiteral StringLiteral BooleanLiteral DateTimeLiteral DateTimeConstructor AtLiteral ? SimplePositiveUnaryTest Interval ParenthesizedExpression List FunctionDefinition FormalParameters FormalParameter external FunctionBody } { Context ContextEntry Key Name Identifier UnaryTests Wildcard not",
  maxTerm: 175,
  context: variableTracker,
  nodeProps: [
    ["group", -17,4,18,22,28,30,32,40,42,67,69,71,84,85,87,88,89,96,"Expression",47,"Expression Expression",-5,77,78,79,80,81,"Expression Literal"],
    ["closedBy", 37,")",70,"]",95,"}"],
    ["openedBy", 39,"(",68,"[",94,"{"]
  ],
  propSources: [feelHighlighting],
  skippedNodes: [0,1,2],
  repeatNodeCount: 14,
  tokenData: "+l~RuXY#fYZ$ZZ[#f]^$Zpq#fqr$`rs$kwx&cxy&hyz&mz{&r{|'P|}'U}!O'Z!O!P'h!P!Q(Q!Q![){![!]*^!]!^*c!^!_*h!_!`$f!`!a*w!b!c+R!}#O+W#P#Q+]#Q#R&z#o#p+b#q#r+g$f$g#f#BY#BZ#f$IS$I_#f$I|$I}$Z$I}$JO$Z$JT$JU#f$KV$KW#f&FU&FV#f?HT?HU#f~#kY#p~XY#fZ[#fpq#f$f$g#f#BY#BZ#f$IS$I_#f$JT$JU#f$KV$KW#f&FU&FV#f?HT?HU#f~$`O#q~~$cP!_!`$f~$kOq~~$pW$g~OY$kZr$krs%Ys#O$k#O#P%_#P;'S$k;'S;=`&]<%lO$k~%_O$g~~%bRO;'S$k;'S;=`%k;=`O$k~%pX$g~OY$kZr$krs%Ys#O$k#O#P%_#P;'S$k;'S;=`&];=`<%l$k<%lO$k~&`P;=`<%l$k~&hO#y~~&mOu~~&rOw~~&wP^~z{&z~'POy~~'UO[~~'ZO#|~R'`PZP!`!a'cQ'hO$[Q~'mQ#x~!O!P's!Q!['x~'xO#{~~'}P$f~!Q!['x~(VQ]~z{(]!P!Q)d~(`TOz(]z{(o{;'S(];'S;=`)^<%lO(]~(rVOz(]z{(o{!P(]!P!Q)X!Q;'S(];'S;=`)^<%lO(]~)^OQ~~)aP;=`<%l(]~)iSP~OY)dZ;'S)d;'S;=`)u<%lO)d~)xP;=`<%l)d~*QQ$f~!O!P*W!Q![){~*ZP!Q!['x~*cO$Y~~*hO$u~R*oP![QrP!_!`*rP*wOrPR+OP!XQrP!_!`*r~+WO$i~~+]O!h~~+bO!f~~+gO#R~~+lO#Q~",
  tokenizers: [propertyIdentifiers, identifiers, insertSemicolon, 0, 1],
  topRules: {"Expressions":[0,3],"UnaryTests":[1,101]},
  dynamicPrecedences: {"30":-1,"71":-1,"73":-1,"126":-1},
  specialized: [{term: 120, get: value => spec_identifier[value] || -1}],
  tokenPrec: 0
});

export { normalizeContextKey, parser, trackVariables };
//# sourceMappingURL=index.es.js.map
