'use strict';

var lr = require('@lezer/lr');
var highlight = require('@lezer/highlight');

// This file was generated by lezer-generator. You probably shouldn't edit it.
const propertyIdentifier = 120,
  identifier = 121,
  nameIdentifier = 122,
  insertSemi = 123,
  expression0 = 127,
  ForExpression = 4,
  forExpressionStart = 130,
  ForInExpression = 7,
  Name = 8,
  Identifier = 9,
  AdditionalIdentifier = 10,
  forExpressionBodyStart = 138,
  IfExpression = 19,
  ifExpressionStart = 139,
  QuantifiedExpression = 23,
  quantifiedExpressionStart = 140,
  QuantifiedInExpression = 27,
  PositiveUnaryTest = 37,
  ArithmeticExpression = 41,
  arithmeticPlusStart = 144,
  arithmeticTimesStart = 145,
  arithmeticExpStart = 146,
  arithmeticUnaryStart = 147,
  VariableName = 47,
  PathExpression = 67,
  pathExpressionStart = 152,
  FilterExpression = 69,
  filterExpressionStart = 153,
  FunctionInvocation = 71,
  functionInvocationStart = 154,
  ParameterName = 75,
  nil = 159,
  NumericLiteral = 78,
  StringLiteral = 79,
  BooleanLiteral = 80,
  List = 88,
  listStart = 170,
  FunctionDefinition = 89,
  functionDefinitionStart = 172,
  Context = 96,
  contextStart = 174,
  ContextEntry = 97,
  PropertyName = 99,
  PropertyIdentifier = 100;

/* global console,process */


const LOG_PARSE = typeof process != 'undefined' && process.env && /\bfparse(:dbg)?\b/.test(process.env.LOG);
const LOG_PARSE_DEBUG = typeof process != 'undefined' && process.env && /\bfparse:dbg\b/.test(process.env.LOG);
const LOG_VARS = typeof process != 'undefined' && process.env && /\bcontext\b/.test(process.env.LOG);

const spaceChars = [
  9, 11, 12, 32, 133, 160,
  5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198,
  8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288
];

const newlineChars = chars('\n\r');

const asterix = '*'.charCodeAt(0);

const additionalNameChars = chars("'./-+*^");

/**
 * @typedef { VariableContext | any } ContextValue
 */

/**
 * @param { string } str
 * @return { number[] }
 */
function chars(str) {
  return Array.from(str).map(s => s.charCodeAt(0));
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isStartChar(ch) {
  return (
    ch === 63 // ?
  ) || (
    ch === 95 // _
  ) || (
    ch >= 65 && ch <= 90 // A-Z
  ) || (
    ch >= 97 && ch <= 122 // a-z
  ) || (
    ch >= 161 && !isPartChar(ch) && !isSpace(ch)
  );
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isAdditional(ch) {
  return additionalNameChars.includes(ch);
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isPartChar(ch) {
  return (
    ch >= 48 && ch <= 57 // 0-9
  ) || (
    ch === 0xB7
  ) || (
    ch >= 0x0300 && ch <= 0x036F
  ) || (
    ch >= 0x203F && ch <= 0x2040
  );
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isSpace(ch) {
  return spaceChars.includes(ch);
}

// eslint-disable-next-line
function indent(str, spaces) {
  return spaces.concat(
    str.split(/\n/g).join('\n' + spaces)
  );
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param  { number } [offset]
 *
 * @return { { token: string, offset: number } | null }
 */
function parseAdditionalSymbol(input, offset = 0) {

  const next = input.peek(offset);

  if (next === asterix && input.peek(offset + 1) === asterix) {

    return {
      offset: 2,
      token: '**'
    };
  }

  if (isAdditional(next)) {
    return {
      offset: 1,
      token: String.fromCharCode(next)
    };
  }

  return null;
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param { number } [offset]
 * @param { boolean } [namePart]
 *
 * @return { { token: string, offset: number } | null }
 */
function parseIdentifier(input, offset = 0, namePart = false) {
  for (let inside = false, chars = [], i = 0;; i++) {
    const next = input.peek(offset + i);

    if (isStartChar(next) || ((inside || namePart) && isPartChar(next))) {
      if (!inside) {
        inside = true;
      }

      chars.push(next);
    } else {

      if (chars.length) {
        return {
          token: String.fromCharCode(...chars),
          offset: i
        };
      }

      return null;
    }
  }
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param  { number } offset
 *
 * @return { { token: string, offset: number } | null }
 */
function parseSpaces(input, offset) {

  for (let inside = false, i = 0;; i++) {
    let next = input.peek(offset + i);

    if (isSpace(next)) {
      if (!inside) {
        inside = true;
      }
    } else {
      if (inside) {
        return {
          token: ' ',
          offset: i
        };
      }

      return null;
    }
  }
}

/**
 * Parse a name from the input and return the first match, if any.
 *
 * @param { import('@lezer/lr').InputStream } input
 * @param { Variables } variables
 *
 * @return { { token: string, offset: number, term: number } | null }
 */
function parseName(input, variables) {
  const contextKeys = variables.contextKeys();

  const start = variables.tokens;

  for (let i = 0, tokens = [], nextMatch = null;;) {

    const namePart = (start.length + tokens.length) > 0;
    const maybeSpace = tokens.length > 0;

    const match = (
      parseIdentifier(input, i, namePart) ||
      namePart && parseAdditionalSymbol(input, i) ||
      maybeSpace && parseSpaces(input, i)
    );

    // match is required
    if (!match) {
      return nextMatch;
    }

    const {
      token,
      offset
    } = match;

    i += offset;

    if (token === ' ') {
      continue;
    }

    tokens = [ ...tokens, token ];

    const name = [ ...start, ...tokens ].join(' ');

    if (contextKeys.some(el => el === name)) {
      const token = tokens[0];

      nextMatch = {
        token,
        offset: token.length,
        term: nameIdentifier
      };
    }

    if (dateTimeIdentifiers.some(el => el === name)) {
      const token = tokens[0];

      // parse date time identifiers as normal
      // identifiers to allow specialization to kick in
      //
      // cf. https://github.com/nikku/lezer-feel/issues/8
      nextMatch = {
        token,
        offset: token.length,
        term: identifier
      };
    }

    if (
      !contextKeys.some(el => el.startsWith(name)) &&
      !dateTimeIdentifiers.some(el => el.startsWith(name))
    ) {
      return nextMatch;
    }
  }

}

const identifiersMap = {
  [ identifier ]: 'identifier',
  [ nameIdentifier ]: 'nameIdentifier'
};

const identifiers = new lr.ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <identifier | nameIdentifier>', input.pos);

  const nameMatch = parseName(input, stack.context);

  const start = stack.context.tokens;

  const match = nameMatch || parseIdentifier(input, 0, start.length > 0);

  if (match) {
    input.advance(match.offset);
    input.acceptToken(nameMatch ? nameMatch.term : identifier);

    LOG_PARSE && console.log('%s: MATCH <%s> <%s>', input.pos, nameMatch ? identifiersMap[nameMatch.term] : 'identifier', match.token);
  }
}, { contextual: true });


const propertyIdentifiers = new lr.ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <propertyIdentifier>', input.pos);

  const start = stack.context.tokens;

  const match = parseIdentifier(input, 0, start.length > 0);

  if (match) {
    input.advance(match.offset);
    input.acceptToken(propertyIdentifier);

    LOG_PARSE && console.log('%s: MATCH <propertyIdentifier> <%s>', input.pos, match.token);
  }
});


const insertSemicolon = new lr.ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <insertSemi>', input.pos);

  let offset;
  let insert = false;

  for (offset = 0;; offset++) {
    const char = input.peek(offset);

    if (spaceChars.includes(char)) {
      continue;
    }

    if (newlineChars.includes(char)) {
      insert = true;
    }

    break;
  }

  if (insert) {

    const identifier = parseIdentifier(input, offset + 1);
    const spaces = parseSpaces(input, offset + 1);

    if (spaces || identifier && /^(then|else|return|satisfies)$/.test(identifier.token)) {
      return;
    }

    LOG_PARSE && console.log('%s: MATCH <insertSemi>', input.pos);
    input.acceptToken(insertSemi);
  }
});

const prefixedContextStarts = {
  [ functionInvocationStart ]: 'FunctionInvocation',
  [ filterExpressionStart ]: 'FilterExpression',
  [ pathExpressionStart ]: 'PathExpression'
};

const contextStarts = {
  [ contextStart ]: 'Context',
  [ functionDefinitionStart ]: 'FunctionDefinition',
  [ forExpressionStart ]: 'ForExpression',
  [ listStart ]: 'List',
  [ ifExpressionStart ]: 'IfExpression',
  [ quantifiedExpressionStart ]: 'QuantifiedExpression'
};

const contextEnds = {
  [ Context ]: 'Context',
  [ FunctionDefinition ]: 'FunctionDefinition',
  [ ForExpression ]: 'ForExpression',
  [ List ]: 'List',
  [ IfExpression ]: 'IfExpression',
  [ QuantifiedExpression ]: 'QuantifiedExpression',
  [ PathExpression ]: 'PathExpression',
  [ FunctionInvocation ]: 'FunctionInvocation',
  [ FilterExpression ]: 'FilterExpression',
  [ ArithmeticExpression ]: 'ArithmeticExpression'
};

class ValueProducer {

  /**
   * @param { Function } fn
   */
  constructor(fn) {
    this.fn = fn;
  }

  get(variables) {
    return this.fn(variables);
  }

  /**
   * @param { Function }
   *
   * @return { ValueProducer }
   */
  static of(fn) {
    return new ValueProducer(fn);
  }

}

const dateTimeLiterals = {
  'date and time': 1,
  'date': 1,
  'time': 1,
  'duration': 1
};

const dateTimeIdentifiers = Object.keys(dateTimeLiterals);


/**
 * A basic key-value store to hold context values.
 */
class VariableContext {

  /**
   * Creates a new context from a JavaScript object.
   *
   * @param {any} value
   */
  constructor(value = {}) {

    /**
     * @protected
     */
    this.value = value;
  }

  /**
   * Return all defined keys of the context.
   *
   * @returns {Array<string>} the keys of the context
   */
  getKeys() {
    return Object.keys(this.value);
  }

  /**
   * Returns the value of the given key.
   *
   * If the value represents a context itself, it should be wrapped in a
   * context class.
   *
   * @param {String} key
   * @returns {VariableContext|ValueProducer|null}
   */
  get(key) {
    const result = this.value[key];

    if (this.constructor.isAtomic(result)) {
      return result;
    }

    return this.constructor.of(result);
  }

  /**
   * Creates a new context with the given key added.
   *
   * @param {String} key
   * @param {any} value
   * @returns {VariableContext} new context with the given key added
   */
  set(key, value) {
    return this.constructor.of({
      ...this.value,
      [key]: value
    });
  }

  /**
   * Wether the given value is atomic. Non-atomic values need to be wrapped in a
   * context Class.
   *
   * @param {any} value
   * @returns {Boolean}
   */
  static isAtomic(value) {
    return !value ||
          value instanceof this ||
          value instanceof ValueProducer ||
          typeof value !== 'object';
  }

  /**
   * Takes any number of Contexts and merges them into a single Context.
   *
   * @param  {...Context} contexts
   * @returns {VariableContext}
   */
  static of(...contexts) {
    const unwrap = (context) => {
      if (!context || typeof context !== 'object') {
        return {};
      }

      if (context instanceof this) {
        return context.value;
      }

      return { ...context };
    };

    const merged = contexts.reduce((merged, context) => {
      return {
        ...merged,
        ...unwrap(context)
      };
    }, {});

    return new this(merged);
  }

}

class Variables {

  constructor({
    name = 'Expressions',
    tokens = [],
    children = [],
    parent = null,
    context,
    value,
    raw
  } = {}) {
    this.name = name;
    this.tokens = tokens;
    this.children = children;
    this.parent = parent;
    this.context = context;
    this.value = value;
    this.raw = raw;
  }

  enterScope(name) {

    const childScope = this.of({
      name,
      parent: this
    });

    LOG_VARS && console.log('[%s] enter', childScope.path, childScope.context);

    return childScope;
  }

  exitScope(str) {

    if (!this.parent) {
      LOG_VARS && console.log('[%s] NO exit %o\n%s', this.path, this.context, indent(str, '  '));

      return this;
    }

    LOG_VARS && console.log('[%s] exit %o\n%s', this.path, this.context, indent(str, '  '));

    return this.parent.pushChild(this);
  }

  token(part) {

    LOG_VARS && console.log('[%s] token <%s> + <%s>', this.path, this.tokens.join(' '), part);

    return this.assign({
      tokens: [ ...this.tokens, part ]
    });
  }

  literal(value) {

    LOG_VARS && console.log('[%s] literal %o', this.path, value);

    return this.pushChild(this.of({
      name: 'Literal',
      value
    }));
  }

  /**
   * Return computed scope value
   *
   * @return {any}
   */
  computedValue() {
    for (let scope = this;;scope = last(scope.children)) {

      if (!scope) {
        return null;
      }

      if (scope.value) {
        return scope.value;
      }
    }
  }

  contextKeys() {
    return this.context.getKeys().map(normalizeContextKey);
  }

  get path() {
    return this.parent?.path?.concat(' > ', this.name) || this.name;
  }

  /**
   * Return value of variable.
   *
   * @param { string } variable
   * @return { any } value
   */
  get(variable) {

    const names = [ variable, variable && normalizeContextKey(variable) ];

    const contextKey = this.context.getKeys().find(
      key => names.includes(normalizeContextKey(key))
    );

    if (typeof contextKey === 'undefined') {
      return undefined;
    }

    const val = this.context.get(contextKey);

    if (val instanceof ValueProducer) {
      return val.get(this);
    } else {
      return val;
    }
  }

  resolveName() {

    const variable = this.tokens.join(' ');
    const tokens = [];

    const parentScope = this.assign({
      tokens
    });

    const variableScope = this.of({
      name: 'VariableName',
      parent: parentScope,
      value: this.get(variable),
      raw: variable
    });

    LOG_VARS && console.log('[%s] resolve name <%s=%s>', variableScope.path, variable, this.get(variable));

    return parentScope.pushChild(variableScope);
  }

  pushChild(child) {

    if (!child) {
      return this;
    }

    const parent = this.assign({
      children: [ ...this.children, child ]
    });

    child.parent = parent;

    return parent;
  }

  pushChildren(children) {

    let parent = this;

    for (const child of children) {
      parent = parent.pushChild(child);
    }

    return parent;
  }

  declareName() {

    if (this.tokens.length === 0) {
      throw Error('no tokens to declare name');
    }

    const variableName = this.tokens.join(' ');

    LOG_VARS && console.log('[%s] declareName <%s>', this.path, variableName);

    return this.assign({
      tokens: []
    }).pushChild(
      this.of({
        name: 'Name',
        value: variableName
      })
    );
  }

  define(name, value) {

    if (typeof name !== 'string') {
      LOG_VARS && console.log('[%s] no define <%s=%s>', this.path, name, value);

      return this;
    }

    LOG_VARS && console.log('[%s] define <%s=%s>', this.path, name, value);

    const context = this.context.set(name, value);

    return this.assign({
      context
    });
  }

  /**
   * @param { Record<string, any> } [options]
   *
   * @return { Variables }
   */
  assign(options = {}) {

    return Variables.of({
      ...this,
      ...options
    });
  }

  /**
   * @param { Record<string, any> } [options]
   *
   * @return { Variables }
   */
  of(options = {}) {

    const defaultOptions = {
      context: this.context,
      parent: this.parent
    };

    return Variables.of({
      ...defaultOptions,
      ...options
    });
  }

  static of(options) {

    const {
      name,
      tokens = [],
      children = [],
      parent = null,
      context,
      value,
      raw
    } = options;

    if (!context) {
      throw new Error('must provide <context>');
    }

    return new Variables({
      name,
      tokens: [ ...tokens ],
      children: [ ...children ],
      context,
      parent,
      value,
      raw
    });
  }

}

/**
 * @param { string } name
 *
 * @return { string } normalizedName
 */
function normalizeContextKey(name) {
  return name.replace(/\s*([./\-'+]|\*\*?)\s*/g, ' $1 ').replace(/\s{2,}/g, ' ').trim();
}

/**
 * Wrap children of variables under the given named child.
 *
 * @param { Variables } variables
 * @param { string } name
 * @param { string } code
 * @return { Variables }
 */
function wrap(variables, scopeName, code) {

  const parts = variables.children.filter(c => c.name !== scopeName);
  const children = variables.children.filter(c => c.name === scopeName);

  const namePart = parts[0];
  const valuePart = parts[Math.max(1, parts.length - 1)];

  const name = namePart.computedValue();
  const value = valuePart?.computedValue() || null;

  return variables
    .assign({
      children
    })
    .enterScope(scopeName)
    .pushChildren(parts)
    .exitScope(code)
    .define(name, value);
}

/**
 * @param { ContextValue } [context]
 * @param { typeof VariableContext } [Context]
 *
 * @return { ContextTracker<Variables> }
 */
function trackVariables(context = {}, Context = VariableContext) {

  const start = Variables.of({
    context: Context.of(context)
  });

  return new lr.ContextTracker({
    start,
    reduce(variables, term, stack, input) {

      if (term === IfExpression) {
        const [ thenPart, elsePart ] = variables.children.slice(-2);

        variables = variables.assign({
          value: Context.of(
            thenPart?.computedValue(),
            elsePart?.computedValue()
          )
        });
      }

      if (term === List) {
        variables = variables.assign({
          value: Context.of(
            ...variables.children.map(
              c => c?.computedValue()
            )
          )
        });
      }

      if (term === FilterExpression) {
        const [ sourcePart, _ ] = variables.children.slice(-2);

        variables = variables.assign({
          value: sourcePart?.computedValue()
        });
      }

      if (term === FunctionInvocation) {

        const [
          name,
          ...args
        ] = variables.children;

        // preserve type information through `get value(context, key)` utility
        if (name?.raw === 'get value') {
          variables = getContextValue(variables, args);
        }
      }

      const start = contextStarts[term];

      if (start) {
        return variables.enterScope(start);
      }

      const prefixedStart = prefixedContextStarts[term];

      // pull <expression> into new <prefixedStart> context
      if (prefixedStart) {

        const {
          children: currentChildren,
          context: currentContext,
        } = variables;

        const children = currentChildren.slice(0, -1);
        const lastChild = last(currentChildren);

        let newContext = null;

        if (term === pathExpressionStart) {
          newContext = Context.of(lastChild?.computedValue());
        }

        if (term === filterExpressionStart) {
          newContext = Context.of(
            currentContext,
            lastChild?.computedValue()
          ).set('item', lastChild?.computedValue());
        }

        return variables
          .assign({ children })
          .enterScope(prefixedStart)
          .pushChild(lastChild)
          .assign({ context: newContext || currentContext });
      }

      const code = input.read(input.pos, stack.pos);

      const end = contextEnds[term];

      if (end) {
        return variables.exitScope(code);
      }

      if (term === ContextEntry) {
        const parts = variables.children.filter(c => c.name !== 'ContextEntry');

        const name = parts[0];
        const value = last(parts);

        return wrap(variables, 'ContextEntry', code).assign(
          {
            value: Context
              .of(variables.value)
              .set(name.computedValue(), value?.computedValue())
          }
        );
      }

      if (
        term === ForInExpression ||
        term === QuantifiedInExpression
      ) {
        return wrap(variables, 'InExpression', code);
      }

      // define <partial> within ForExpression body
      if (term === forExpressionBodyStart) {

        return variables.define(
          'partial',
          ValueProducer.of(variables => {
            return last(variables.children)?.computedValue();
          })
        );
      }

      if (
        term === ParameterName
      ) {
        const name = last(variables.children).computedValue();

        // TODO: attach type information
        return variables.define(name, 1);
      }

      // pull <expression> into ArithmeticExpression child
      if (
        term === arithmeticPlusStart ||
        term === arithmeticTimesStart ||
        term === arithmeticExpStart
      ) {
        const children = variables.children.slice(0, -1);
        const lastChild = last(variables.children);

        return variables.assign({
          children
        }).enterScope('ArithmeticExpression').pushChild(lastChild);
      }

      if (term === arithmeticUnaryStart) {
        return variables.enterScope('ArithmeticExpression');
      }

      if (
        term === Identifier ||
        term === AdditionalIdentifier ||
        term === PropertyIdentifier
      ) {
        return variables.token(code);
      }

      if (
        term === StringLiteral
      ) {
        return variables.literal(code.replace(/^"|"$/g, ''));
      }

      if (term === BooleanLiteral) {
        return variables.literal(code === 'true' ? true : false);
      }

      if (term === NumericLiteral) {
        return variables.literal(parseFloat(code));
      }

      if (term === nil) {
        return variables.literal(null);
      }

      if (
        term === VariableName
      ) {
        return variables.resolveName();
      }

      if (
        term === Name ||
        term === PropertyName
      ) {
        return variables.declareName();
      }

      if (
        term === expression0 ||
        term === PositiveUnaryTest
      ) {
        if (variables.tokens.length > 0) {
          throw new Error('uncleared name');
        }
      }

      if (term === expression0) {

        let parent = variables;

        while (parent.parent) {
          parent = parent.exitScope(code);
        }

        return parent;
      }

      return variables;
    }
  });
}

const variableTracker = trackVariables({});


// helpers //////////////

function getContextValue(variables, args) {

  if (!args.length) {
    return variables.assign({
      value: null
    });
  }

  if (args[0].name === 'Name') {
    args = extractNamedArgs(args, [ 'm', 'key' ]);
  }

  if (args.length !== 2) {
    return variables.assign({
      value: null
    });
  }

  const [
    context,
    key
  ] = args;

  const keyValue = key?.computedValue();
  const contextValue = context?.computedValue();

  if (
    (!contextValue || typeof contextValue !== 'object') || typeof keyValue !== 'string'
  ) {
    return variables.assign({
      value: null
    });
  }

  return variables.assign({
    value: [ normalizeContextKey(keyValue), keyValue ].reduce((value, keyValue) => {
      return contextValue.get(keyValue) || value;
    }, null)
  });
}

function extractNamedArgs(args, argNames) {

  const context = {};

  for (let i = 0; i < args.length; i += 2) {
    const [ name, value ] = args.slice(i, i + 2);

    context[name.value] = value;
  }

  return argNames.map(name => context[name]);
}

function last(arr) {
  return arr[arr.length - 1];
}

const feelHighlighting = highlight.styleTags({
  StringLiteral: highlight.tags.string,
  NumericLiteral: highlight.tags.number,
  BooleanLiteral: highlight.tags.bool,
  'AtLiteral!': highlight.tags.special(highlight.tags.string),
  CompareOp: highlight.tags.compareOperator,
  ArithOp: highlight.tags.arithmeticOperator,
  'for if then else some every satisfies between return': highlight.tags.controlKeyword,
  'in instance of and or': highlight.tags.operatorKeyword,
  function: highlight.tags.definitionKeyword,
  as: highlight.tags.keyword,
  'Type/...': highlight.tags.typeName,
  Wildcard: highlight.tags.special,
  null: highlight.tags.null,
  LineComment: highlight.tags.lineComment,
  BlockComment: highlight.tags.blockComment,
  'VariableName! "?"': highlight.tags.variableName,
  'DateTimeConstructor! SpecialFunctionName!': highlight.tags.function(highlight.tags.special(highlight.tags.variableName)),
  'List Interval': highlight.tags.list,
  Context: highlight.tags.definition(highlight.tags.literal),
  'Name!': highlight.tags.definition(highlight.tags.variableName),
  'Key/Name! ContextEntryType/Name!': highlight.tags.definition(highlight.tags.propertyName),
  'PathExpression/VariableName!': highlight.tags.function(highlight.tags.propertyName),
  'FormalParameter/ParameterName!': highlight.tags.function(highlight.tags.definition(highlight.tags.variableName)),
  '( )': highlight.tags.paren,
  '[ ]': highlight.tags.squareBracket,
  '{ }': highlight.tags.brace,
  '.': highlight.tags.derefOperator,
  ', ;': highlight.tags.separator,
  '..': highlight.tags.punctuation
});

// This file was generated by lezer-generator. You probably shouldn't edit it.
const spec_identifier = {__proto__:null,for:10, in:32, return:36, if:40, then:42, else:44, some:48, every:50, satisfies:57, or:60, and:64, between:72, instance:86, of:89, days:99, time:101, duration:103, years:105, months:107, date:109, list:115, context:121, function:128, null:154, true:326, false:326, "?":168, external:184, not:209};
const parser = lr.LRParser.deserialize({
  version: 14,
  states: "DSO`QYOOO`QYOOO$gQYOOOOQU'#Ce'#CeO$qQYO'#C`O%zQYO'#FPOOQQ'#Fe'#FeO&UQYO'#FeO`QYO'#DVOOQU'#Em'#EmO'rQ^O'#D]OOQO'#Fl'#FlO)oQWO'#DuOOQQ'#D|'#D|OOQQ'#D}'#D}OOQQ'#EO'#EOO)tOWO'#ERO)oQWO'#EPOOQQ'#EP'#EPOOQQ'#Fr'#FrOOQQ'#Fp'#FpOOQQ'#Fw'#FwO,iQYO'#FwO.gQYO'#FwOOQQ'#ET'#ETO`QYO'#EVOOQQ'#FR'#FRO0cQ^O'#FRO2YQYO'#EWO2aQWO'#EXOOQP'#GQ'#GQO2fQXO'#E`OOQQ'#F{'#F{OOQQ'#FQ'#FQQOQWOOOOQQ'#FS'#FSOOQQ'#F]'#F]O`QYO'#CoOOQQ'#F^'#F^O$qQYO'#CsO2qQYO'#DvOOQQ'#Fq'#FqO2vQYO'#EQOOQO'#EQ'#EQO`QYO'#EUO`QYO'#ETOOQO'#GO'#GOQ3OQWOOO3TQYO'#DRO3zQWO'#FaOOQO'#DT'#DTO4VQYO'#FeO4^QWOOO5TQYO'#CdO5bQYO'#FUOOQQ'#Cc'#CcO5gQYO'#FTOOQQ'#Cb'#CbO5oQYO,58zO`QYO,59iOOQQ'#Fb'#FbOOQQ'#Fc'#FcOOQQ'#Fd'#FdO`QYO,59qO`QYO,59qO`QYO,59qOOQQ'#Fj'#FjO$qQYO,5:]OOQQ'#Fk'#FkO`QYO,5:_O`QYO,59eO`QYO,59gO`QYO,59iO7_QYO,59iO7fQYO,59rOOQQ,5:h,5:hO7kQYO,59qOOQU-E8k-E8kO9_QYO'#FmOOQQ,5:a,5:aOOQQ,5:m,5:mOOQQ,5:k,5:kO9fQYO,5:qOOQQ,5;m,5;mO9mQYO'#FoO9zQWO,5:rO:PQYO,5:sOOQP'#Ed'#EdO:vQXO'#EcOOQO'#Eb'#EbO:}QWO'#EaO;SQWO'#GRO;[QWO,5:zO;aQYO,59ZO5bQYO'#F`OOQQ'#Cw'#CwO;hQYO'#F_OOQQ'#Cv'#CvO;pQYO,59_O;uQYO,5:bO;zQYO,5:lO<PQYO,5:pO<WQYO,5:oO`QYO'#EvQ3OQWOOO`QYO'#ElO<}QWO,5;{O`QYOOOOQR'#Cf'#CfOOQQ'#Ei'#EiO=wQYO,59OO`QYO,5;pOOQQ'#FX'#FXO$qQYO'#EjO>XQYO,5;oO`QYO1G.fOOQQ'#F['#F[O?OQYO1G/TOAuQYO1G/]OBPQYO1G/]OBZQYO1G/]OOQQ1G/w1G/wOC}QYO1G/yODUQYO1G/POE_QYO1G/ROFhQYO1G/TOGOQYO1G/TOOQQ1G/T1G/TOHnQYO1G/^OIYQ^O'#CdOOQO'#Dy'#DyOJlQWO'#DxOJqQWO'#FnOOQO'#Dw'#DwOOQO'#Dz'#DzOJyQWO,5<XOOQQ'#Fz'#FzOOQQ1G0]1G0]O`QYO'#ErOKOQWO,5<ZOOQQ'#F}'#F}OOQQ1G0^1G0^OKZQWO'#EZOKfQWO'#GPOOQO'#EY'#EYOKnQWO1G0_OOQP'#Et'#EtOKsQXO,5:}O`QYO,5:{OKzQXO'#EuOLSQWO,5<mOOQQ1G0f1G0fO`QYO1G.uO`QYO,5;zO$qQYO'#EkOL[QYO,5;yO`QYO1G.yOLdQYO1G/|OOQO1G0W1G0WO`QYO1G0[OOQO,5;b,5;bOOQO-E8t-E8tOOQO,5;W,5;WOOQO-E8j-E8jOLiQWOOOOQQ-E8g-E8gOLnQYO'#CmOOQQ1G1[1G1[OOQQ,5;U,5;UOOQQ-E8h-E8hOL{QYO7+$QOOQQ7+%e7+%eO`QYO7+$oOMrQWO7+$oOMwQYO'#D[OOQQ'#DZ'#DZO! kQYO'#D^O! pQYO'#D^O! uQYO'#D^O! zQ`O'#DfO!!PQ`O'#DiO!!UQ`O'#DmOOQQ7+$x7+$xO`QYO,5:dO$qQYO'#EqO!!ZQWO,5<YOOQQ1G1s1G1sO!!cQYO,5;^OOQO-E8p-E8pOHnQYO,5:uO$qQYO'#EsO!!pQWO,5<kO!!xQYO7+%yOOQP-E8r-E8rO!#PQYO1G0gOOQO,5;a,5;aOOQO-E8s-E8sO!#ZQYO7+$aO!#bQYO1G1fOOQQ,5;V,5;VOOQQ-E8i-E8iO!#lQYO7+$eOOQO7+%h7+%hO!%aQYO7+%vO`QYO,59XO!%nQYO<<HZOOQQ<<HZ<<HZO$qQYO'#EnO!&wQYO,59vO!(kQYO,59xO!(pQYO,59xO!(uQYO,59xO!(zQYO,5:QO$qQYO,5:TO!)fQbO,5:XO!)mQYO1G0OOOQO,5;],5;]OOQO-E8o-E8oOOQO1G0a1G0aOOQO,5;_,5;_OOQO-E8q-E8qO!)wQYO'#E]OOQQ<<Ie<<IeO`QYO<<IeO`QYO<<G{O!*nQYO'#FkOOQQ'#Fx'#FxOOQQ<<Ib<<IbO!-jQYO1G.sOOQQ,5;Y,5;YOOQQ-E8l-E8lO!-tQYO1G/dOOQQ1G/d1G/dO!-yQbO'#D]O!.[Q`O'#D[O!.gQ`O1G/lO!.lQWO'#DlO!.qQ`O'#FfOOQO'#Dk'#DkO!.yQ`O1G/oOOQO'#Dp'#DpO!/OQ`O'#FhOOQO'#Do'#DoO!/WQ`O1G/sOOQQAN?PAN?PO!/]QYOAN=gOOQQ7+%O7+%OO!0SQ`O,59vOOQQ7+%W7+%WO!(zQYO,5:WO$qQYO'#EoO!0_Q`O,5<QOOQQ7+%Z7+%ZO!(zQYO'#EpO!0gQ`O,5<SO!0oQ`O7+%_OOQO1G/r1G/rOOQO,5;Z,5;ZOOQO-E8m-E8mOOQO,5;[,5;[OOQO-E8n-E8nOHnQYO<<HyOOQQAN>eAN>eO$qQYO'#EnO!(zQYO<<HyO!0tQ`O7+%_O!0yQ`O1G/sO!)fQbO,5:XO!1OQ`O'#Dm",
  stateData: "!1]~O#qOS#rOSPOSQOS~OTsOZVO[UOdtOhvOivOs}OvfO!S{O!T{O!UxO!WzO!b!OO!feO!hgO!oyO!vjO#RnO#mRO#nRO$g]O$h^O$i_O$j`O~OTsO[UOdtOhvOivOs}OvfO!S{O!T{O!UxO!WzO!b!OO!feO!hgO!oyO!vjO#RnO#mRO#nRO$g]O$h^O$i_O$j`O~OZ!TO#[!UO~P!|O#mRO#nRO~OZ!^O[!^O]!_O^!_O_!`O`!kOn!hOp!iOr!]Os!]Ot!jO{!lO!h!fO#y!dOv$`X~O#k#sX$v#sX~P$yO$g!mOT$XXZ$XX[$XXd$XXh$XXi$XXs$XXv$XX!S$XX!T$XX!U$XX!W$XX!b$XX!f$XX!h$XX!o$XX!v$XX#R$XX#m$XX#n$XX$h$XX$i$XX$j$XX~O#mRO#nROZ!PX[!PX]!PX^!PX_!PX`!PXn!PXp!PXr!PXs!PXt!PXv!PX{!PX!h!PX#k!PX#o!PX#y!PX$v!PX#}!PXx!PX!f!PXe!PX#|!PXb!PX#Q!PXf!PXl!PX~Ov!pO~O$h^O~OT$kXT$mXd$kXd$mXh$kXh$mXi$kXi$mXs$kXs$mXv$kXv$mX!S$kX!S$mX!T$kX!T$mX!U$kX!U$mX!W$kX!W$mX!b$kX!b$mX!f$kX!f$mX!h$kX!h$mX!o$kX!o$mX!v$kX!v$mX#R$kX#R$mX$g$kX$g$mX$h$kX$h$mX$i$kX$i$mX$j$kX$j$mX~OZ$kXZ$mX[$kX[$mX#m$kX#m$mX#n$kX#n$mX~P)yOT$kXd$kXh$kXi$kXs$kXv$kX!S$kX!T$kX!U$kX!W$kX!b$kX!f$kX!h$kX!o$kX!v$kX#R$kX$g$kX$h$kX$i$kX$j$kX~OT$pXZ$kXZ$pX[$kX[$pXd$pXh$pXi$pXs$pXv$pX!S$pX!T$pX!U$pX!W$pX!b$pX!f$pX!h$pX!o$pX!v$pX#R$pX#m$kX#m$pX#n$kX#n$pX$g$pX$h$pX$i$pX$j$pX~P-VO#o!uOZ#uX[#uX]#uX^#uX_#uX`#uXn#uXp#uXr#uXs#uXt#uXv#uX{#uX!h#uX#k#uX#y#uX$v#uX#}#uXx#uX!f#uXe#uX#|#uXb#uX#Q#uXf#uXl#uX~O!f$cP~P`Ov!xO~O#l!yO$h^O#Q$uP~Op#VO~Op#WOv!tX~O$v#ZO~O#kuX#}uX$vuXxuX!fuXeuX#|uXbuX#QuXfuXluX~P$yO#}#]O#k$TXx$TX~O#k#ZX~P&UOv#_O~OZ#`O[#`O]#`O^#`O_#`O#mRO#nRO#y#`O#z#`O$ZWX~O`WXxWX#}WX~P4cO`#dO~O#}#eOb#wX~Ob#hO~OTsOZVO[UOdtOhvOivOs}O!S{O!T{O!UxO!WzO!b!OO!feO!hgO!oyO!vjO#RnO#mRO#nRO$g]O$h^O$i_O$j`O~Ov#rO~P5tO|#tO~O{!lO!h!fO#y!dOZya[ya]ya^ya_ya`yanyapyaryasyatyav$`X#kya$vya#}yaxya!fyaeya#|yabya#Qyafyalya~Ox$cP~P`Ox#|O~P$yO#}$OO!f$cXx$cX~P$yO!f$QO~O#mRO#nROx$sP~OZ#`O[#`O]#`O^#`O_#`O#l!yO#y#`O#z#`O~O$Z#VX~P:[O$Z$YO~O#}$ZO#Q$uX~O#Q$]O~Oe$^O~P$yO#}$`Ol$RX~Ol$bO~O!V$cO~O!S$dO~O#|$eO~P$yO#k!wa$v!wa#}!wax!wa!f!wae!wa#|!wab!wa#Q!waf!wal!wa~P$yO#}#]O#k$Tax$Ta~OZ#`O[#`O]#`O^#`O_#`O#mRO#nRO#y#`O#z#`O~O`Wa$ZWaxWa#}Wa~P=YO#}#eOb#wa~OZ!^O[!^O]!_O^!_O_!`O{!lO!h!fO#y!dOv$`X~O`qinqipqirqisqitqi#kqi$vqi#}qixqi!fqieqi#|qibqi#Qqifqilqi~P>aO_!`O{!lO!h!fO#y!dOZyi[yi`yinyipyiryisyityiv$`X#kyi$vyi#}yixyi!fyieyi#|yibyi#Qyifyilyi~O]!_O^!_O~P@XO]yi^yi~P@XO{!lO!h!fO#y!dOZyi[yi]yi^yi_yi`yinyipyiryisyityiv$`X#kyi$vyi#}yixyi!fyieyi#|yibyi#Qyifyilyi~O!f$qO~P$yO`!kOp!iOr!]Os!]Ot!jOnmi#kmi$vmi#}mixmi!fmiemi#|mibmi#Qmifmilmi~P>aO`!kOr!]Os!]Ot!jOnoipoi#koi$voi#}oixoi!foieoi#|oiboi#Qoifoiloi~P>aO`!kOn!hOp$rOr!]Os!]Ot!jO~P>aOTsOZVO[UOdtOhvOivOs}OvfO!S{O!T{O!UxO!WzO!b!OO!feO!hgO!oyO!vjO#RnO#mRO#nRO$g]O$h^O$i_O$j`O~P)yO!R$vO!U$wO!W$xO!Z$yO!^$zO!b${O#mRO#nRO~OZ#aX[#aX]#aX^#aX_#aX`#aXn#aXp#aXr#aXs#aXt#aXv#aXx#aX{#aX!h#aX#m#aX#n#aX#o#aX#y#aX#}#aX~P4cO$Z$}O~O#}%OOx$bX~Ox%QO~O#}$OO!f$cax$ca~O$Z%TOx!}X#}!}X~O#}%UOx$sX~Ox%WO~O$Z#Va~P:[O#l!yO$h^O~O#}$ZO#Q$ua~O#}$`Ol$Ra~O!T%bO~OxrO~O#|%dObaX#}aX~P$yO#kSq$vSq#}SqxSq!fSqeSq#|SqbSq#QSqfSqlSq~P$yOx%fO~O#y%gOZ!OX[!OX]!OX^!OX_!OX`!OXn!OXp!OXr!OXs!OXt!OXv!OX{!OX!h!OX#k!OX$v!OX#}!OXx!OX!f!OXe!OX#|!OXb!OX#Q!OXf!OXl!OX~Op%iO~Op%jO~Op%kO~O![%lO~O![%mO~O![%nO~O#}%OOx$ba~O!f#fa#}#fax#fa~P$yO#}%UOx$sa~O#O%wO~P`O#Q#Ti#}#Ti~P$yOf%xO~P$yOl$Si#}$Si~P$yO#kgq$vgq#}gqxgq!fgqegq#|gqbgq#Qgqfgqlgq~P$yOZ!^O[!^O]!_O^!_O_!`O`!kOn!hOp!iOr!]Os!]Ot!jO{!lO#y!dOv$`X~Ox%zO!f%zO!h%yO~P!$cO`qynqypqyrqysqytqy#kqy$vqy#}qyxqy!fqyeqy#|qybqy#Qqyfqylqy~P>aO#y%gOZ!Oa[!Oa]!Oa^!Oa_!Oa`!Oan!Oap!Oar!Oas!Oat!Oav!Oa{!Oa!h!Oa#k!Oa$v!Oa#}!Oax!Oa!f!Oae!Oa#|!Oab!Oa#Q!Oaf!Oal!Oa~O!S&PO~O!V&PO~O!S&QO~O!R$vO!U$wO!W$xO!Z$yO!^$zO!b&vO#mRO#nRO~O!X$[P~P!(zOx!li#}!li~P$yO#k#PX$v#PX#}#PXx#PX!f#PXe#PX#|#PXb#PX#Q#PXf#PXl#PX~P$yOT$_XZ$_X[$_X]$lX^$lX_$lX`$lXd$_Xh$_Xi$_Xn$lXp$lXr$lXs$_Xt$lXv$_X{$lX!S$_X!T$_X!U$_X!W$_X!b$_X!f$_X!h$_X!o$_X!v$_X#R$_X#k$lX#m$_X#n$_X#y$lX$g$_X$h$_X$i$_X$j$_X$v$lX#}$lXx$lXe$lX#|$lXb$lX#Q$lXf$lXl$lX~Obai#}ai~P$yO!T&`O~O#mRO#nRO!X!PX#y!PX#}!PX~O#y&qO!X!OX#}!OX~O!X&bO~O$Z&cO~O#}&dO!X$YX~O!X&fO~O#}&gO!X$[X~O!X&iO~O#kc!R$vc!R#}c!Rxc!R!fc!Rec!R#|c!Rbc!R#Qc!Rfc!Rlc!R~P$yO#y&qO!X!Oa#}!Oa~O#}&dO!X$Ya~O#}&gO!X$[a~O$]&oO~O$]&rO~O!X&sO~O![&uO~OQP_^$g]#y~",
  goto: "Ff$vPPPP$wP%p%s%y&]'vPPPPPP(PP$wPPP$wPP(S(VP$wP$wP$wPPP(]P(hP$w$wPP(q)W)c)WPPPPPPP)WPP)WP*p*s)WP*y+P$wP$wP$w+W,P,S,Y,PP,b-Z,b,b.Z/SP$w/{$w0t0t1m1pP1vPP0t1|2S.V2WPP2`P2c2j2p2v2|4X4c4i4o4u4{5R5X5_PPPPPPPP5e5n7q8j9c9fPP9jPP9p9s:l;e;h;l;q<^<z=i>bP>eP>i?Y?y@r@x@{$wARARPPPPAzBsBvCo7qCrDkDnEgEjFc!mjOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR![SQ!YSR$n#eS!WS#eS#Qw$`W#v!p!x%O%UT&U%m&d#WXOPQWYilu|}!]!a!b!c!e!g!h!i!j!k#Z#]#_#c#g#r#t$O$Y$^$_$b$e$r$}%T%W%d%g%l%n%w%x&R&c&g&o&q&r&ub!VSw!x#e$`%O%U%m&dU#a!V#b#uR#u!pU#a!V#b#uT$W!z$XR$m#cR#UwQ#SwR%_$`U!RQ#_#rQ#s!kR$h#]QrQQ$j#_R$s#rQ$|#tQ%r%TQ&T%lU&Y%n&g&uQ&j&cT&p&o&rc$u#t%T%l%n&c&g&o&r&u!lkOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xQ#m!eU$t#t%T&oS%}%g&q]&S%l%n&c&g&r&uR&X%mQ&V%mR&k&dQ&]%nR&t&uS&Z%n&uR&m&g!mZOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR#{!pQ#x!pR%p%OS#w!p%OT$S!x%U!mcOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%x!lcOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xQ!r`T!{o$Z!maOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%x!mbOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%x!mhOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%x!mpOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR$V!xQ$T!xR%s%UQ%v%WR&^%wQ!}oR%Z$ZT!|o$ZS!zo$ZT$W!z$XRrQS#b!V#uR$k#bQ#f!YR$o#fQ$a#SR%`$aQ#^!RR$i#^!vYOPQWilu|}!]!a!b!c!e!g!h!i!j!k!p#Z#]#_#c#g#r#t$O$Y$^$_$b$e$r$}%T%W%d%g%w%x&oS!oY&R_&R%l%n&c&g&q&r&uQ%h$tS&O%h&aR&a&SQ&e&VR&l&eQ&h&ZR&n&hQ%P#xR%q%PQ$P!vR%S$PQ%V$TR%t%VQ$X!zR%X$XQ$[!}R%[$[Q#[!PR$g#[QrOQ!PPR$f#ZUTOP#ZY!QQ!k#]#_#rQ!nWQ!tiS!vl!pQ#PuQ#X|Q#Y}Q#i!]Q#j!aQ#k!bQ#l!cQ#n!gQ#o!hQ#p!iQ#q!jQ$l#cQ$p#gQ%R$OQ%Y$YQ%]$^Q%^$_Q%a$bQ%c$eQ%e$rQ%o$}S%u%W%wQ%|%dR&_%x!mqOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%x!mSOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR!ZST!XS#eQ#c!WR$_#QR#g![!muOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%x!mwOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR#TwT#Rw$`V!SQ#_#r!T!aT!Q!t!v#P#X#Y#i#n#o#p#q$l$p%R%Y%]%^%a%c%e%o%u%|&_!V!bT!Q!t!v#P#X#Y#i#j#n#o#p#q$l$p%R%Y%]%^%a%c%e%o%u%|&_!X!cT!Q!t!v#P#X#Y#i#j#k#n#o#p#q$l$p%R%Y%]%^%a%c%e%o%u%|&_!mWOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR&W%mT&[%n&u!]!eT!Q!n!t!v#P#X#Y#i#j#k#l#n#o#p#q$l$p%R%Y%]%^%a%c%e%o%u%|&_!]!gT!Q!n!t!v#P#X#Y#i#j#k#l#n#o#p#q$l$p%R%Y%]%^%a%c%e%o%u%|&_!m[OPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xQ!q[R!saR#y!pQ!wlR#z!p!mdOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%x!m|OPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR%{%c!miOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR#}!t!mlOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR$R!w!mmOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR$U!x!moOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$Y$^$_$b$e$r$}%W%d%w%xR#Oo",
  nodeNames: "⚠ LineComment BlockComment Expression ForExpression for InExpressions InExpression Name Identifier Identifier ArithOp ArithOp ArithOp ArithOp ArithOp in IterationContext return IfExpression if then else QuantifiedExpression some every InExpressions InExpression satisfies Disjunction or Conjunction and Comparison CompareOp CompareOp between PositiveUnaryTest ( PositiveUnaryTests ) ArithmeticExpression InstanceOfExpression instance of Type QualifiedName VariableName SpecialType days time duration years months date > ListType list < ContextType context ContextEntryTypes ContextEntryType FunctionType function ArgumentTypes ArgumentType PathExpression ] FilterExpression [ FunctionInvocation SpecialFunctionName NamedParameters NamedParameter ParameterName PositionalParameters null NumericLiteral StringLiteral BooleanLiteral DateTimeLiteral DateTimeConstructor AtLiteral ? SimplePositiveUnaryTest Interval ParenthesizedExpression List FunctionDefinition FormalParameters FormalParameter external FunctionBody } { Context ContextEntry Key Name Identifier Expressions UnaryTests Wildcard not",
  maxTerm: 176,
  context: variableTracker,
  nodeProps: [
    ["closedBy", 38,")",70,"]",95,"}"],
    ["openedBy", 40,"(",68,"[",94,"{"],
    ["group", -5,77,78,79,80,81,"Literal"]
  ],
  propSources: [feelHighlighting],
  skippedNodes: [0,1,2],
  repeatNodeCount: 14,
  tokenData: "+l~RuXY#fYZ$ZZ[#f]^$Zpq#fqr$`rs$kwx&cxy&hyz&mz{&r{|'P|}'U}!O'Z!O!P'h!P!Q(Q!Q![){![!]*^!]!^*c!^!_*h!_!`$f!`!a*w!b!c+R!}#O+W#P#Q+]#Q#R&z#o#p+b#q#r+g$f$g#f#BY#BZ#f$IS$I_#f$I|$I}$Z$I}$JO$Z$JT$JU#f$KV$KW#f&FU&FV#f?HT?HU#f~#kY#q~XY#fZ[#fpq#f$f$g#f#BY#BZ#f$IS$I_#f$JT$JU#f$KV$KW#f&FU&FV#f?HT?HU#f~$`O#r~~$cP!_!`$f~$kOr~~$pW$h~OY$kZr$krs%Ys#O$k#O#P%_#P;'S$k;'S;=`&]<%lO$k~%_O$h~~%bRO;'S$k;'S;=`%k;=`O$k~%pX$h~OY$kZr$krs%Ys#O$k#O#P%_#P;'S$k;'S;=`&];=`<%l$k<%lO$k~&`P;=`<%l$k~&hO#z~~&mOv~~&rOx~~&wP^~z{&z~'PO_~~'UO[~~'ZO#}~R'`PZP!`!a'cQ'hO$]Q~'mQ#y~!O!P's!Q!['x~'xO#|~~'}P$g~!Q!['x~(VQ]~z{(]!P!Q)d~(`TOz(]z{(o{;'S(];'S;=`)^<%lO(]~(rVOz(]z{(o{!P(]!P!Q)X!Q;'S(];'S;=`)^<%lO(]~)^OQ~~)aP;=`<%l(]~)iSP~OY)dZ;'S)d;'S;=`)u<%lO)d~)xP;=`<%l)d~*QQ$g~!O!P*W!Q![){~*ZP!Q!['x~*cO$Z~~*hO$v~R*oP![QsP!_!`*rP*wOsPR+OP!XQsP!_!`*r~+WO$j~~+]O!h~~+bO!f~~+gO#R~~+lO#Q~",
  tokenizers: [propertyIdentifiers, identifiers, insertSemicolon, 0, 1],
  topRules: {"Expression":[0,3],"Expressions":[1,101],"UnaryTests":[2,102]},
  dynamicPrecedences: {"31":-1,"71":-1,"73":-1},
  specialized: [{term: 121, get: (value) => spec_identifier[value] || -1}],
  tokenPrec: 2857
});

exports.VariableContext = VariableContext;
exports.normalizeContextKey = normalizeContextKey;
exports.parser = parser;
exports.trackVariables = trackVariables;
//# sourceMappingURL=index.cjs.map
