import { ExternalTokenizer, ContextTracker, LRParser } from '@lezer/lr';
import { styleTags, tags } from '@lezer/highlight';

// This file was generated by lezer-generator. You probably shouldn't edit it.
const propertyIdentifier = 120,
  identifier = 121,
  nameIdentifier = 122,
  insertSemi = 123,
  expression0 = 127,
  ForExpression = 4,
  forExpressionStart = 130,
  ForInExpression = 7,
  Name = 8,
  Identifier = 9,
  AdditionalIdentifier = 10,
  forExpressionBodyStart = 138,
  IfExpression = 19,
  ifExpressionStart = 139,
  QuantifiedExpression = 23,
  quantifiedExpressionStart = 140,
  QuantifiedInExpression = 27,
  PositiveUnaryTest = 37,
  ArithmeticExpression = 41,
  arithmeticPlusStart = 144,
  arithmeticTimesStart = 145,
  arithmeticExpStart = 146,
  arithmeticUnaryStart = 147,
  VariableName = 47,
  PathExpression = 67,
  pathExpressionStart = 152,
  FilterExpression = 69,
  filterExpressionStart = 153,
  FunctionInvocation = 71,
  functionInvocationStart = 154,
  ParameterName = 75,
  nil = 159,
  NumericLiteral = 78,
  StringLiteral = 79,
  BooleanLiteral = 80,
  listStart = 165,
  List = 88,
  FunctionDefinition = 89,
  functionDefinitionStart = 167,
  Context = 96,
  contextStart = 169,
  ContextEntry = 97,
  PropertyName = 99,
  PropertyIdentifier = 100;

/* global console,process */


// @ts-expect-error env access
const LOG_PARSE = typeof process != 'undefined' && process.env && /\bfparse(:dbg)?\b/.test(process.env.LOG);

// @ts-expect-error env access
const LOG_PARSE_DEBUG = typeof process != 'undefined' && process.env && /\bfparse:dbg\b/.test(process.env.LOG);

// @ts-expect-error env access
const LOG_VARS = typeof process != 'undefined' && process.env && /\bcontext\b/.test(process.env.LOG);

const spaceChars = [
  9, 11, 12, 32, 133, 160,
  5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198,
  8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288
];

const newlineChars = chars('\n\r');

const asterix = '*'.charCodeAt(0);

const additionalNameChars = chars("'./-+*^");

/**
 * @typedef { VariableContext | any } ContextValue
 */

/**
 * @param { string } str
 * @return { number[] }
 */
function chars(str) {
  return Array.from(str).map(s => s.charCodeAt(0));
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isStartChar(ch) {
  return (
    ch === 63 // ?
  ) || (
    ch >= 65 && ch <= 90 // A-Z
  ) || (
    ch === 95 // _
  ) || (
    ch >= 97 && ch <= 122 // a-z
  ) || (
    ch >= 0xC0 && ch <= 0xD6
  ) || (
    ch >= 0xD8 && ch <= 0xF6
  ) || (
    ch >= 0xF8 && ch <= 0x2FF
  ) || (
    ch >= 0x370 && ch <= 0x37D
  ) || (
    ch >= 0x37F && ch <= 0x1FFF
  ) || (
    ch >= 0x200C && ch <= 0x200D
  ) || (
    ch >= 0x2070 && ch <= 0x218F
  ) || (
    ch >= 0x2C00 && ch <= 0x2FEF
  ) || (
    ch >= 0x3001 && ch <= 0xD7FF
  ) || (
    ch >= 0xF900 && ch <= 0xFDCF
  ) || (
    ch >= 0xFDF0 && ch <= 0xFFFD
  ) || (
    ch >= 0xD800 && ch <= 0xDBFF // upper surrogate
  ) || (
    ch >= 0xDC00 && ch <= 0xDFFF // lower surrogate
  );
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isAdditional(ch) {
  return additionalNameChars.includes(ch);
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isPartChar(ch) {
  return (
    ch >= 48 && ch <= 57 // 0-9
  ) || (
    ch === 0xB7
  ) || (
    ch >= 0x0300 && ch <= 0x036F
  ) || (
    ch >= 0x203F && ch <= 0x2040
  );
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isSpace(ch) {
  return spaceChars.includes(ch);
}

// eslint-disable-next-line
function indent(str, spaces) {
  return spaces.concat(
    str.split(/\n/g).join('\n' + spaces)
  );
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param  { number } [offset]
 *
 * @return { { token: string, offset: number } | null }
 */
function parseAdditionalSymbol(input, offset = 0) {

  const next = input.peek(offset);

  if (next === asterix && input.peek(offset + 1) === asterix) {

    return {
      offset: 2,
      token: '**'
    };
  }

  if (isAdditional(next)) {
    return {
      offset: 1,
      token: String.fromCharCode(next)
    };
  }

  return null;
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param { number } [offset]
 * @param { boolean } [namePart]
 *
 * @return { { token: string, offset: number } | null }
 */
function parseIdentifier(input, offset = 0, namePart = false) {
  for (let inside = false, chars = [], i = 0;; i++) {
    const next = input.peek(offset + i);

    if (isStartChar(next) || ((inside || namePart) && isPartChar(next))) {
      if (!inside) {
        inside = true;
      }

      chars.push(next);
    } else {

      if (chars.length) {
        return {
          token: String.fromCharCode(...chars),
          offset: i
        };
      }

      return null;
    }
  }
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param  { number } offset
 *
 * @return { { token: string, offset: number } | null }
 */
function parseSpaces(input, offset) {

  for (let inside = false, i = 0;; i++) {
    let next = input.peek(offset + i);

    if (isSpace(next)) {
      if (!inside) {
        inside = true;
      }
    } else {
      if (inside) {
        return {
          token: ' ',
          offset: i
        };
      }

      return null;
    }
  }
}

/**
 * Parse a name from the input and return the first match, if any.
 *
 * @param { import('@lezer/lr').InputStream } input
 * @param { Variables } variables
 *
 * @return { { token: string, offset: number, term: number } | null }
 */
function parseName(input, variables) {
  const contextKeys = variables.contextKeys();

  const start = variables.tokens;

  for (let i = 0, tokens = [], nextMatch = null;;) {

    const namePart = (start.length + tokens.length) > 0;
    const maybeSpace = tokens.length > 0;

    const match = (
      parseIdentifier(input, i, namePart) ||
      namePart && parseAdditionalSymbol(input, i) ||
      maybeSpace && parseSpaces(input, i)
    );

    // match is required
    if (!match) {
      return nextMatch;
    }

    const {
      token,
      offset
    } = match;

    i += offset;

    if (token === ' ') {
      continue;
    }

    tokens = [ ...tokens, token ];

    const name = [ ...start, ...tokens ].join(' ');

    if (contextKeys.some(el => el === name)) {
      const token = tokens[0];

      nextMatch = {
        token,
        offset: token.length,
        term: nameIdentifier
      };
    }

    if (contextKeys.some(el => el.startsWith(name))) {
      continue;
    }

    if (dateTimeIdentifiers.some(el => el === name)) {
      const token = tokens[0];

      // parse date time identifiers as normal
      // identifiers to allow specialization to kick in
      //
      // cf. https://github.com/nikku/lezer-feel/issues/8
      nextMatch = {
        token,
        offset: token.length,
        term: identifier
      };
    }

    if (dateTimeIdentifiers.some(el => el.startsWith(name))) {
      continue;
    }

    return nextMatch;
  }

}

const identifiersMap = {
  [ identifier ]: 'identifier',
  [ nameIdentifier ]: 'nameIdentifier'
};

const identifiers = new ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <identifier | nameIdentifier>', input.pos);

  const nameMatch = parseName(input, stack.context);

  const start = stack.context.tokens;

  const match = nameMatch || parseIdentifier(input, 0, start.length > 0);

  if (match) {
    input.advance(match.offset);
    input.acceptToken(nameMatch ? nameMatch.term : identifier);

    LOG_PARSE && console.log('%s: MATCH <%s> <%s>', input.pos, nameMatch ? identifiersMap[nameMatch.term] : 'identifier', match.token);
  }
}, { contextual: true });


const propertyIdentifiers = new ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <propertyIdentifier>', input.pos);

  const start = stack.context.tokens;

  const match = parseIdentifier(input, 0, start.length > 0);

  if (match) {
    input.advance(match.offset);
    input.acceptToken(propertyIdentifier);

    LOG_PARSE && console.log('%s: MATCH <propertyIdentifier> <%s>', input.pos, match.token);
  }
});


const insertSemicolon = new ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <insertSemi>', input.pos);

  let offset;
  let insert = false;

  for (offset = 0;; offset++) {
    const char = input.peek(offset);

    if (spaceChars.includes(char)) {
      continue;
    }

    if (newlineChars.includes(char)) {
      insert = true;
    }

    break;
  }

  if (insert) {

    const identifier = parseIdentifier(input, offset + 1);
    const spaces = parseSpaces(input, offset + 1);

    if (spaces || identifier && /^(then|else|return|satisfies)$/.test(identifier.token)) {
      return;
    }

    LOG_PARSE && console.log('%s: MATCH <insertSemi>', input.pos);
    input.acceptToken(insertSemi);
  }
});

const prefixedContextStarts = {
  [ functionInvocationStart ]: 'FunctionInvocation',
  [ filterExpressionStart ]: 'FilterExpression',
  [ pathExpressionStart ]: 'PathExpression'
};

const contextStarts = {
  [ contextStart ]: 'Context',
  [ functionDefinitionStart ]: 'FunctionDefinition',
  [ forExpressionStart ]: 'ForExpression',
  [ listStart ]: 'List',
  [ ifExpressionStart ]: 'IfExpression',
  [ quantifiedExpressionStart ]: 'QuantifiedExpression'
};

const contextEnds = {
  [ Context ]: 'Context',
  [ FunctionDefinition ]: 'FunctionDefinition',
  [ ForExpression ]: 'ForExpression',
  [ List ]: 'List',
  [ IfExpression ]: 'IfExpression',
  [ QuantifiedExpression ]: 'QuantifiedExpression',
  [ PathExpression ]: 'PathExpression',
  [ FunctionInvocation ]: 'FunctionInvocation',
  [ FilterExpression ]: 'FilterExpression',
  [ ArithmeticExpression ]: 'ArithmeticExpression'
};

class ValueProducer {

  /**
   * @param { Function } fn
   */
  constructor(fn) {
    this.fn = fn;
  }

  get(variables) {
    return this.fn(variables);
  }

  /**
   * @param { Function } fn
   *
   * @return { ValueProducer }
   */
  static of(fn) {
    return new ValueProducer(fn);
  }

}

const dateTimeLiterals = {
  'date and time': 1,
  'date': 1,
  'time': 1,
  'duration': 1
};

const dateTimeIdentifiers = Object.keys(dateTimeLiterals);


/**
 * A basic key-value store to hold context values.
 */
class VariableContext {

  /**
   * Creates a new context from a JavaScript object.
   *
   * @param {any} value
   */
  constructor(value = {}) {

    /**
     * @protected
     */
    this.value = value;
  }

  /**
   * Return all defined keys of the context.
   *
   * @returns {Array<string>} the keys of the context
   */
  getKeys() {
    return Object.keys(this.value);
  }

  /**
   * Returns the value of the given key.
   *
   * If the value represents a context itself, it should be wrapped in a
   * context class.
   *
   * @param {String} key
   * @returns {VariableContext|ValueProducer|null}
   */
  get(key) {
    const result = this.value[key];

    const constructor = /** @type { typeof VariableContext } */ (this.constructor);

    if (constructor.isAtomic(result)) {
      return result;
    }

    return constructor.of(result);
  }

  /**
   * Creates a new context with the given key added.
   *
   * @param {String} key
   * @param {any} value
   *
   * @returns {VariableContext} new context with the given key added
   */
  set(key, value) {

    const constructor = /** @type { typeof VariableContext } */ (this.constructor);

    return constructor.of({
      ...this.value,
      [key]: value
    });
  }

  /**
   * Wether the given value is atomic. Non-atomic values need to be wrapped in a
   * context Class.
   *
   * @param {any} value
   * @returns {Boolean}
   */
  static isAtomic(value) {
    return !value ||
          value instanceof this ||
          value instanceof ValueProducer ||
          typeof value !== 'object';
  }

  /**
   * Takes any number of Contexts and merges them into a single Context.
   *
   * @param  {...Context} contexts
   * @returns {VariableContext}
   */
  static of(...contexts) {
    const unwrap = (context) => {
      if (!context || typeof context !== 'object') {
        return {};
      }

      if (context instanceof this) {
        return context.value;
      }

      return { ...context };
    };

    const merged = contexts.reduce((merged, context) => {
      return {
        ...merged,
        ...unwrap(context)
      };
    }, {});

    return new this(merged);
  }

}

class Variables {

  constructor({
    name = 'Expressions',
    tokens = [],
    children = [],
    parent = null,
    context = null,
    value = null,
    raw = null
  } = {}) {
    this.name = name;
    this.tokens = tokens;
    this.children = children;
    this.parent = parent;
    this.context = context;
    this.value = value;
    this.raw = raw;
  }

  enterScope(name) {

    const childScope = this.of({
      name,
      parent: this
    });

    LOG_VARS && console.log('[%s] enter', childScope.path, childScope.context);

    return childScope;
  }

  exitScope(str) {

    if (!this.parent) {
      LOG_VARS && console.log('[%s] NO exit %o\n%s', this.path, this.context, indent(str, '  '));

      return this;
    }

    LOG_VARS && console.log('[%s] exit %o\n%s', this.path, this.context, indent(str, '  '));

    return this.parent.pushChild(this);
  }

  token(part) {

    LOG_VARS && console.log('[%s] token <%s> + <%s>', this.path, this.tokens.join(' '), part);

    return this.assign({
      tokens: [ ...this.tokens, part ]
    });
  }

  literal(value) {

    LOG_VARS && console.log('[%s] literal %o', this.path, value);

    return this.pushChild(this.of({
      name: 'Literal',
      value
    }));
  }

  /**
   * Return computed scope value
   *
   * @return {any}
   */
  computedValue() {
    for (let scope = this;;scope = last(scope.children)) {

      if (!scope) {
        return null;
      }

      if (scope.value) {
        return scope.value;
      }
    }
  }

  contextKeys() {
    return this.context.getKeys().map(normalizeContextKey);
  }

  get path() {
    return this.parent?.path?.concat(' > ', this.name) || this.name;
  }

  /**
   * Return value of variable.
   *
   * @param { string } variable
   * @return { any } value
   */
  get(variable) {

    const names = [ variable, variable && normalizeContextKey(variable) ];

    const contextKey = this.context.getKeys().find(
      key => names.includes(normalizeContextKey(key))
    );

    if (typeof contextKey === 'undefined') {
      return undefined;
    }

    const val = this.context.get(contextKey);

    if (val instanceof ValueProducer) {
      return val.get(this);
    } else {
      return val;
    }
  }

  resolveName() {

    const variable = this.tokens.join(' ');
    const tokens = [];

    const parentScope = this.assign({
      tokens
    });

    const variableScope = this.of({
      name: 'VariableName',
      parent: parentScope,
      value: this.get(variable),
      raw: variable
    });

    LOG_VARS && console.log('[%s] resolve name <%s=%s>', variableScope.path, variable, this.get(variable));

    return parentScope.pushChild(variableScope);
  }

  pushChild(child) {

    if (!child) {
      return this;
    }

    const parent = this.assign({
      children: [ ...this.children, child ]
    });

    child.parent = parent;

    return parent;
  }

  pushChildren(children) {

    /**
     * @type {Variables}
     */
    let parent = this;

    for (const child of children) {
      parent = parent.pushChild(child);
    }

    return parent;
  }

  declareName() {

    if (this.tokens.length === 0) {
      throw Error('no tokens to declare name');
    }

    const variableName = this.tokens.join(' ');

    LOG_VARS && console.log('[%s] declareName <%s>', this.path, variableName);

    return this.assign({
      tokens: []
    }).pushChild(
      this.of({
        name: 'Name',
        value: variableName
      })
    );
  }

  define(name, value) {

    if (typeof name !== 'string') {
      LOG_VARS && console.log('[%s] no define <%s=%s>', this.path, name, value);

      return this;
    }

    LOG_VARS && console.log('[%s] define <%s=%s>', this.path, name, value);

    const context = this.context.set(name, value);

    return this.assign({
      context
    });
  }

  /**
   * @param { Record<string, any> } [options]
   *
   * @return { Variables }
   */
  assign(options = {}) {

    return Variables.of({
      ...this,
      ...options
    });
  }

  /**
   * @param { Record<string, any> } [options]
   *
   * @return { Variables }
   */
  of(options = {}) {

    const defaultOptions = {
      context: this.context,
      parent: this.parent
    };

    return Variables.of({
      ...defaultOptions,
      ...options
    });
  }

  static of(options) {

    const {
      name,
      tokens = [],
      children = [],
      parent = null,
      context,
      value,
      raw
    } = options;

    if (!context) {
      throw new Error('must provide <context>');
    }

    return new Variables({
      name,
      tokens: [ ...tokens ],
      children: [ ...children ],
      context,
      parent,
      value,
      raw
    });
  }

}

/**
 * @param { string } name
 *
 * @return { string } normalizedName
 */
function normalizeContextKey(name) {
  return name.replace(/\s*([./\-'+]|\*\*?)\s*/g, ' $1 ').replace(/\s{2,}/g, ' ').trim();
}

/**
 * Wrap children of variables under the given named child.
 *
 * @param { Variables } variables
 * @param { string } scopeName
 * @param { string } code
 * @return { Variables }
 */
function wrap(variables, scopeName, code) {

  const parts = variables.children.filter(c => c.name !== scopeName);
  const children = variables.children.filter(c => c.name === scopeName);

  const namePart = parts[0];
  const valuePart = parts[Math.max(1, parts.length - 1)];

  const name = namePart?.computedValue();
  const value = valuePart?.computedValue() || null;

  return variables
    .assign({
      children
    })
    .enterScope(scopeName)
    .pushChildren(parts)
    .exitScope(code)
    .define(name, value);
}

/**
 * @param { ContextValue } [context]
 * @param { typeof VariableContext } [Context]
 *
 * @return { ContextTracker<Variables> }
 */
function trackVariables(context = {}, Context = VariableContext) {

  const start = Variables.of({
    context: Context.of(context)
  });

  return new ContextTracker({
    start,
    reduce(variables, term, stack, input) {

      if (term === IfExpression) {
        const [ thenPart, elsePart ] = variables.children.slice(-2);

        variables = variables.assign({
          value: Context.of(
            thenPart?.computedValue(),
            elsePart?.computedValue()
          )
        });
      }

      if (term === List) {
        variables = variables.assign({
          value: Context.of(
            ...variables.children.map(
              c => c?.computedValue()
            )
          )
        });
      }

      if (term === FilterExpression) {
        const [ sourcePart, _ ] = variables.children.slice(-2);

        variables = variables.assign({
          value: sourcePart?.computedValue()
        });
      }

      if (term === FunctionInvocation) {

        const [
          name,
          ...args
        ] = variables.children;

        // preserve type information through `get value(context, key)` utility
        if (name?.raw === 'get value') {
          variables = getContextValue(variables, args);
        }
      }

      const start = contextStarts[term];

      if (start) {
        return variables.enterScope(start);
      }

      const prefixedStart = prefixedContextStarts[term];

      // pull <expression> into new <prefixedStart> context
      if (prefixedStart) {

        const {
          children: currentChildren,
          context: currentContext,
        } = variables;

        const children = currentChildren.slice(0, -1);
        const lastChild = last(currentChildren);

        let newContext = null;

        if (term === pathExpressionStart) {
          newContext = Context.of(lastChild?.computedValue());
        }

        if (term === filterExpressionStart) {
          newContext = Context.of(
            currentContext,
            lastChild?.computedValue()
          ).set('item', lastChild?.computedValue());
        }

        return variables
          .assign({ children })
          .enterScope(prefixedStart)
          .pushChild(lastChild)
          .assign({ context: newContext || currentContext });
      }

      // @ts-expect-error internal method
      const code = input.read(input.pos, stack.pos);

      const end = contextEnds[term];

      if (end) {
        return variables.exitScope(code);
      }

      if (term === ContextEntry) {
        const parts = variables.children.filter(c => c.name !== 'ContextEntry');

        const name = parts[0];
        const value = last(parts);

        return wrap(variables, 'ContextEntry', code).assign(
          {
            value: Context
              .of(variables.value)
              .set(name?.computedValue(), value?.computedValue())
          }
        );
      }

      if (
        term === ForInExpression ||
        term === QuantifiedInExpression
      ) {
        return wrap(variables, 'InExpression', code);
      }

      // define <partial> within ForExpression body
      if (term === forExpressionBodyStart) {

        return variables.define(
          'partial',
          ValueProducer.of(variables => {
            return last(variables.children)?.computedValue();
          })
        );
      }

      if (
        term === ParameterName
      ) {
        const name = last(variables.children).computedValue();

        // TODO: attach type information
        return variables.define(name, 1);
      }

      // pull <expression> into ArithmeticExpression child
      if (
        term === arithmeticPlusStart ||
        term === arithmeticTimesStart ||
        term === arithmeticExpStart
      ) {
        const children = variables.children.slice(0, -1);
        const lastChild = last(variables.children);

        return variables.assign({
          children
        }).enterScope('ArithmeticExpression').pushChild(lastChild);
      }

      if (term === arithmeticUnaryStart) {
        return variables.enterScope('ArithmeticExpression');
      }

      if (
        term === Identifier ||
        term === AdditionalIdentifier ||
        term === PropertyIdentifier
      ) {
        return variables.token(code);
      }

      if (
        term === StringLiteral
      ) {
        return variables.literal(code.replace(/^"|"$/g, ''));
      }

      if (term === BooleanLiteral) {
        return variables.literal(code === 'true' ? true : false);
      }

      if (term === NumericLiteral) {
        return variables.literal(parseFloat(code));
      }

      if (term === nil) {
        return variables.literal(null);
      }

      if (
        term === VariableName
      ) {
        return variables.resolveName();
      }

      if (
        term === Name ||
        term === PropertyName
      ) {
        return variables.declareName();
      }

      if (
        term === expression0 ||
        term === PositiveUnaryTest
      ) {
        if (variables.tokens.length > 0) {
          throw new Error('uncleared name');
        }
      }

      if (term === expression0) {

        let parent = variables;

        while (parent.parent) {
          parent = parent.exitScope(code);
        }

        return parent;
      }

      return variables;
    }
  });
}

const variableTracker = trackVariables({});


// helpers //////////////

function getContextValue(variables, args) {

  if (!args.length) {
    return variables.assign({
      value: null
    });
  }

  if (args[0].name === 'Name') {
    args = extractNamedArgs(args, [ 'm', 'key' ]);
  }

  if (args.length !== 2) {
    return variables.assign({
      value: null
    });
  }

  const [
    context,
    key
  ] = args;

  const keyValue = key?.computedValue();
  const contextValue = context?.computedValue();

  if (
    (!contextValue || typeof contextValue !== 'object') || typeof keyValue !== 'string'
  ) {
    return variables.assign({
      value: null
    });
  }

  return variables.assign({
    value: [ normalizeContextKey(keyValue), keyValue ].reduce((value, keyValue) => {
      return contextValue.get(keyValue) || value;
    }, null)
  });
}

function extractNamedArgs(args, argNames) {

  const context = {};

  for (let i = 0; i < args.length; i += 2) {
    const [ name, value ] = args.slice(i, i + 2);

    context[name.value] = value;
  }

  return argNames.map(name => context[name]);
}

function last(arr) {
  return arr[arr.length - 1];
}

const feelHighlighting = styleTags({
  StringLiteral: tags.string,
  NumericLiteral: tags.number,
  BooleanLiteral: tags.bool,
  'AtLiteral!': tags.special(tags.string),
  CompareOp: tags.compareOperator,
  ArithOp: tags.arithmeticOperator,
  'for if then else some every satisfies between return': tags.controlKeyword,
  'in instance of and or': tags.operatorKeyword,
  function: tags.definitionKeyword,
  as: tags.keyword,
  'Type/...': tags.typeName,
  Wildcard: tags.special(tags.variableName),
  null: tags.null,
  LineComment: tags.lineComment,
  BlockComment: tags.blockComment,
  'VariableName! "?"': tags.variableName,
  'DateTimeConstructor! SpecialFunctionName!': tags.function(tags.special(tags.variableName)),
  'List Interval': tags.list,
  Context: tags.definition(tags.literal),
  'Name!': tags.definition(tags.variableName),
  'Key/Name! ContextEntryType/Name!': tags.definition(tags.propertyName),
  'PathExpression/VariableName!': tags.function(tags.propertyName),
  'FormalParameter/ParameterName!': tags.function(tags.definition(tags.variableName)),
  '( )': tags.paren,
  '[ ]': tags.squareBracket,
  '{ }': tags.brace,
  '.': tags.derefOperator,
  ', ;': tags.separator,
  '..': tags.punctuation
});

// This file was generated by lezer-generator. You probably shouldn't edit it.
const spec_identifier = {__proto__:null,for:10, in:32, return:36, if:40, then:42, else:44, some:48, every:50, satisfies:56, or:60, and:64, between:72, instance:86, of:89, days:99, time:101, duration:103, years:105, months:107, date:109, list:115, context:121, function:128, null:154, true:326, false:326, "?":168, external:184, not:209};
const parser = LRParser.deserialize({
  version: 14,
  states: "CpO`QYOOO`QYOOO$gQYOOOOQU'#Ce'#CeO$qQYO'#C`O%zQYO'#FPOOQQ'#Fe'#FeO&UQYO'#FeO`QYO'#DVOOQU'#Em'#EmO'rQ^O'#D]OOQO'#Fl'#FlO)oQWO'#DuOOQQ'#D|'#D|OOQQ'#D}'#D}OOQQ'#EO'#EOO)tOWO'#ERO)oQWO'#EPOOQQ'#EP'#EPOOQQ'#Fr'#FrOOQQ'#Fp'#FpOOQQ'#Fw'#FwOOQQ'#ET'#ETO`QYO'#EVOOQQ'#FR'#FRO)yQ^O'#FRO+pQYO'#EWO+wQWO'#EXOOQP'#F{'#F{O+|QXO'#E`OOQQ'#Fx'#FxOOQQ'#FQ'#FQQOQWOOOOQQ'#FS'#FSOOQQ'#F]'#F]O`QYO'#CoOOQQ'#F^'#F^O$qQYO'#CsO,XQYO'#DvOOQQ'#Fq'#FqO,^QYO'#EQOOQO'#EQ'#EQO`QYO'#EUO`QYO'#ETOOQO'#Fy'#FyQ,fQWOOO,kQYO'#DRO-bQWO'#FaOOQO'#DT'#DTO-mQYO'#FeO-tQWOOO.kQYO'#CdO.xQYO'#FUOOQQ'#Cc'#CcO.}QYO'#FTOOQQ'#Cb'#CbO/VQYO,58zO`QYO,59iOOQQ'#Fb'#FbOOQQ'#Fc'#FcOOQQ'#Fd'#FdO`QYO,59qO`QYO,59qO`QYO,59qOOQQ'#Fj'#FjO$qQYO,5:]OOQQ'#Fk'#FkO`QYO,5:_O`QYO,59eO`QYO,59gO`QYO,59iO0uQYO,59iO0|QYO,59rOOQQ,5:h,5:hO1RQYO,59qOOQU-E8k-E8kO2uQYO'#FmOOQQ,5:a,5:aOOQQ,5:m,5:mOOQQ,5:k,5:kO2|QYO,5:qOOQQ,5;m,5;mO3WQYO,5:pO3eQWO,5:rO3jQYO,5:sOOQP'#Ed'#EdO4aQXO'#EcOOQO'#Eb'#EbO4hQWO'#EaO4mQWO'#F|O4uQWO,5:zO4zQYO,59ZO.xQYO'#F`OOQQ'#Cw'#CwO5RQYO'#F_OOQQ'#Cv'#CvO5ZQYO,59_O5`QYO,5:bO5eQYO,5:lO3PQYO,5:pO5jQYO,5:oO`QYO'#EvQ,fQWOOO`QYO'#ElO6aQWO,5;{O`QYOOOOQR'#Cf'#CfOOQQ'#Ei'#EiO7ZQYO,59OO`QYO,5;pOOQQ'#FX'#FXO$qQYO'#EjO7kQYO,5;oO`QYO1G.fOOQQ'#F['#F[O8bQYO1G/TO;XQYO1G/]O;cQYO1G/]O;mQYO1G/]OOQQ1G/w1G/wO=aQYO1G/yO=hQYO1G/PO>qQYO1G/RO?zQYO1G/TO`QYO1G/TOOQQ1G/T1G/TO@bQYO1G/^O@|Q^O'#CdOB`QYO'#FoOOQO'#Dy'#DyOBjQWO'#DxOBoQWO'#FnOOQO'#Dw'#DwOOQO'#Dz'#DzOBwQWO,5<XOOQQ1G0]1G0]O`QYO1G0[O`QYO'#ErOB|QWO,5<ZOOQQ1G0^1G0^OCXQWO'#EZOCdQWO'#FzOOQO'#EY'#EYOClQWO1G0_OOQP'#Et'#EtOCqQXO,5:}O`QYO,5:{OCxQXO'#EuODQQWO,5<hOOQQ1G0f1G0fO`QYO1G.uO`QYO,5;zO$qQYO'#EkODYQYO,5;yO`QYO1G.yODbQYO1G/|OOQO1G0W1G0WOOQO,5;b,5;bOOQO-E8t-E8tOOQO,5;W,5;WOOQO-E8j-E8jODgQWOOOOQQ-E8g-E8gODlQYO'#CmOOQQ1G1[1G1[OOQQ,5;U,5;UOOQQ-E8h-E8hODyQYO7+$QOOQQ7+%e7+%eO`QYO7+$oOEpQYO,5:qOE}QWO7+$oOFSQYO'#D[OOQQ'#DZ'#DZOGvQYO'#D^OG{QYO'#D^OHQQYO'#D^OHVQ`O'#DfOH[Q`O'#DiOHaQ`O'#DmOOQQ7+$x7+$xO`QYO,5:dO$qQYO'#EqOHfQWO,5<YOOQQ1G1s1G1sOIlQYO7+%vOIyQYO,5;^OOQO-E8p-E8pO@bQYO,5:uO$qQYO'#EsOJWQWO,5<fOJ`QYO7+%yOOQP-E8r-E8rOJgQYO1G0gOOQO,5;a,5;aOOQO-E8s-E8sOJqQYO7+$aOJxQYO1G1fOOQQ,5;V,5;VOOQQ-E8i-E8iOKSQYO7+$eOOQO7+%h7+%hO`QYO,59XOKyQYO<<HZOOQQ<<HZ<<HZO$qQYO'#EnOMSQYO,59vONvQYO,59xON{QYO,59xO! QQYO,59xO! VQYO,5:QO$qQYO,5:TO! qQbO,5:XO! xQYO1G0OOOQO,5;],5;]OOQO-E8o-E8oO!!SQYO<<IbOOQQ<<Ib<<IbOOQO1G0a1G0aOOQO,5;_,5;_OOQO-E8q-E8qO!%OQYO'#E]OOQQ<<Ie<<IeO`QYO<<IeO`QYO<<G{O!%uQYO1G.sOOQQ,5;Y,5;YOOQQ-E8l-E8lO!&PQYO1G/dOOQQ1G/d1G/dO!&UQbO'#D]O!&gQ`O'#D[O!&rQ`O1G/lO!&wQWO'#DlO!&|Q`O'#FfOOQO'#Dk'#DkO!'UQ`O1G/oOOQO'#Dp'#DpO!'ZQ`O'#FhOOQO'#Do'#DoO!'cQ`O1G/sOOQQAN?PAN?PO!'hQYOAN=gOOQQ7+%O7+%OO!(_Q`O,59vOOQQ7+%W7+%WO! VQYO,5:WO$qQYO'#EoO!(jQ`O,5<QOOQQ7+%Z7+%ZO! VQYO'#EpO!(rQ`O,5<SO!(zQ`O7+%_OOQO1G/r1G/rOOQO,5;Z,5;ZOOQO-E8m-E8mOOQO,5;[,5;[OOQO-E8n-E8nO@bQYO<<HyOOQQAN>eAN>eO$qQYO'#EnO! VQYO<<HyO!)PQ`O7+%_O!)UQ`O1G/sO! qQbO,5:XO!)ZQ`O'#Dm",
  stateData: "!)h~O#qOS#rOSPOSQOS~OTqOZVO[UOdrOhtOitOs{OvgO!SyO!TyO!UvO!WxO!b|O!fzO!heO!owO!vhO#RlO#mRO#nRO$g]O$h^O$i_O$j`O~OTqO[UOdrOhtOitOs{OvgO!SyO!TyO!UvO!WxO!b|O!fzO!heO!owO!vhO#RlO#mRO#nRO$g]O$h^O$i_O$j`O~OZ!RO#[!SO~P!|O#mRO#nRO~OZ![O[![O]!]O^!]O_!^O`!iOn!fOp!gOr!ZOs!ZOt!hO{!jO!h!dO#y!bOv$`X~O#k#sX$q#sX~P$yO$g!kOT$XXZ$XX[$XXd$XXh$XXi$XXs$XXv$XX!S$XX!T$XX!U$XX!W$XX!b$XX!f$XX!h$XX!o$XX!v$XX#R$XX#m$XX#n$XX$h$XX$i$XX$j$XX~O#mRO#nROZ!PX[!PX]!PX^!PX_!PX`!PXn!PXp!PXr!PXs!PXt!PXv!PX{!PX!h!PX#k!PX#o!PX#y!PX$q!PX#}!PXx!PX#|!PX!f!PXe!PXb!PX#Q!PXf!PXl!PX~Ov!nO~O$h^O~O#o!sOZ#uX[#uX]#uX^#uX_#uX`#uXn#uXp#uXr#uXs#uXt#uXv#uX{#uX!h#uX#k#uX#y#uX$q#uX#}#uXx#uX#|#uX!f#uXe#uXb#uX#Q#uXf#uXl#uX~O!f$cP~P`Ov!vO~O#l!wO$h^O#Q$pP~Op#TO~Op#UOv!tX~O$q#XO~O#kuX#}uX$quXxuX#|uX!fuXeuXbuX#QuXfuXluX~P$yO#}#ZO#k$TXx$TX~O#k#ZX~P&UOv#]O~OZ#^O[#^O]#^O^#^O_#^O#mRO#nRO#y#^O#z#^O$ZWX~O`WXxWX#}WX~P-yO`#bO~O#}#cOb#wX~Ob#fO~OTqOZVO[UOdrOhtOitOs{O!SyO!TyO!UvO!WxO!b|O!fzO!heO!owO!vhO#RlO#mRO#nRO$g]O$h^O$i_O$j`O~Ov#pO~P/[O|#rO~O{!jO!h!dO#y!bOZya[ya]ya^ya_ya`yanyapyaryasyatyav$`X#kya$qya#}yaxya#|ya!fyaeyabya#Qyafyalya~Ox$cP~P`Ox#{O#|#|O~P$yO#|#|O#}#}O!f$cX~P$yO!f$PO~O#mRO#nROx$nP~OZ#^O[#^O]#^O^#^O_#^O#l!wO#y#^O#z#^O~O$Z#VX~P3uO$Z$WO~O#}$XO#Q$pX~O#Q$ZO~Oe$[O~P$yO#}$^Ol$RX~Ol$`O~O!V$aO~O!S$bO~O#k!wa$q!wa#}!wax!wa#|!wa!f!wae!wab!wa#Q!waf!wal!wa~P$yO#}#ZO#k$Tax$Ta~OZ#^O[#^O]#^O^#^O_#^O#mRO#nRO#y#^O#z#^O~O`Wa$ZWaxWa#}Wa~P6lO#}#cOb#wa~OZ![O[![O]!]O^!]O_!^O{!jO!h!dO#y!bOv$`X~O`qinqipqirqisqitqi#kqi$qqi#}qixqi#|qi!fqieqibqi#Qqifqilqi~P7sO_!^O{!jO!h!dO#y!bOZyi[yi`yinyipyiryisyityiv$`X#kyi$qyi#}yixyi#|yi!fyieyibyi#Qyifyilyi~O]!]O^!]O~P9kO]yi^yi~P9kO{!jO!h!dO#y!bOZyi[yi]yi^yi_yi`yinyipyiryisyityiv$`X#kyi$qyi#}yixyi#|yi!fyieyibyi#Qyifyilyi~O!f$nO~P$yO`!iOp!gOr!ZOs!ZOt!hOnmi#kmi$qmi#}mixmi#|mi!fmiemibmi#Qmifmilmi~P7sO`!iOr!ZOs!ZOt!hOnoipoi#koi$qoi#}oixoi#|oi!foieoiboi#Qoifoiloi~P7sO`!iOn!fOp$oOr!ZOs!ZOt!hO~P7sO!R$tO!U$uO!W$vO!Z$wO!^$xO!b$yO#mRO#nRO~OZ#aX[#aX]#aX^#aX_#aX`#aXn#aXp#aXr#aXs#aXt#aXv#aXx#aX{#aX!h#aX#m#aX#n#aX#o#aX#y#aX#}#aX~P-yO#}#}Ox$cX~P$yO$Z${O~O#}$|Ox$bX~Ox%OO~O#}#}O!f$cax$ca~O$Z%SOx!}X#}!}X~O#}%TOx$nX~Ox%VO~O$Z#Va~P3uO#l!wO$h^O~O#}$XO#Q$pa~O#}$^Ol$Ra~O!T%aO~OxpO~O#|%bObaX#}aX~P$yO#kSq$qSq#}SqxSq#|Sq!fSqeSqbSq#QSqfSqlSq~P$yOx#{O#|#|O#}uX~P$yOx%dO~O#y%eOZ!OX[!OX]!OX^!OX_!OX`!OXn!OXp!OXr!OXs!OXt!OXv!OX{!OX!h!OX#k!OX$q!OX#}!OXx!OX#|!OX!f!OXe!OXb!OX#Q!OXf!OXl!OX~Op%gO~Op%hO~Op%iO~O![%jO~O![%kO~O![%lO~O#}$|Ox$ba~OZ![O[![O]!]O^!]O_!^O`!iOn!fOp!gOr!ZOs!ZOt!hO{!jO#y!bOv$`X~Ox%qO!f%qO!h%pO~PHnO!f#fa#}#fax#fa~P$yO#}%TOx$na~O#O%wO~P`O#Q#Ti#}#Ti~P$yOf%xO~P$yOl$Si#}$Si~P$yO#kgq$qgq#}gqxgq#|gq!fgqegqbgq#Qgqfgqlgq~P$yO`qynqypqyrqysqytqy#kqy$qqy#}qyxqy#|qy!fqyeqybqy#Qqyfqylqy~P7sO#y%eOZ!Oa[!Oa]!Oa^!Oa_!Oa`!Oan!Oap!Oar!Oas!Oat!Oav!Oa{!Oa!h!Oa#k!Oa$q!Oa#}!Oax!Oa#|!Oa!f!Oae!Oab!Oa#Q!Oaf!Oal!Oa~O!S%|O~O!V%|O~O!S%}O~O!R$tO!U$uO!W$vO!Z$wO!^$xO!b&sO#mRO#nRO~O!X$[P~P! VOx!li#}!li~P$yOT$_XZ$_X[$_X]!xy^!xy_!xy`!xyd$_Xh$_Xi$_Xn!xyp!xyr!xys$_Xt!xyv$_X{!xy!S$_X!T$_X!U$_X!W$_X!b$_X!f$_X!h$_X!o$_X!v$_X#R$_X#k!xy#m$_X#n$_X#y!xy$g$_X$h$_X$i$_X$j$_X$q!xy#}!xyx!xy#|!xye!xyb!xy#Q!xyf!xyl!xy~O#k#PX$q#PX#}#PXx#PX#|#PX!f#PXe#PXb#PX#Q#PXf#PXl#PX~P$yObai#}ai~P$yO!T&]O~O#mRO#nRO!X!PX#y!PX#}!PX~O#y&nO!X!OX#}!OX~O!X&_O~O$Z&`O~O#}&aO!X$YX~O!X&cO~O#}&dO!X$[X~O!X&fO~O#kc!R$qc!R#}c!Rxc!R#|c!R!fc!Rec!Rbc!R#Qc!Rfc!Rlc!R~P$yO#y&nO!X!Oa#}!Oa~O#}&aO!X$Ya~O#}&dO!X$[a~O$]&lO~O$]&oO~O!X&pO~O![&rO~OQP_^$g]#y~",
  goto: "Du$qPPPP$rP%k%n%t&W'qPPPPPP'zP$rPPP$rPP'}(QP$rP$rP$rPPP(WP(cP$r$rPP(l)R)^)RPPPPPPP)RPP)RP*k*n)RP*t*z$rP$rP$r+R+z+},T+zP,]-U,],].U.}P$r/v$r0o0o1h1kP1qPP0o1w1}.Q2RPP2ZP2^2e2k2q2w4S4^4d4j4p4w4}5T5ZPPPPPPPP5a5j7q8j9c9fPP9jPP9p9s:l;e;h;l;q<`=O=o>hP>kP>o?b@T@|ASAV$rA]A]PPPPBU7qB}CvCyDr!mhOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xR!YSQ!WSR$k#cS!US#cS#Ou$^W#u!n!v$|%TT&R%k&a#WXOPQWYgjsz{!Z!_!`!a!c!e!f!g!h!i#X#Z#]#a#e#p#r#|#}$W$[$]$`$o${%S%V%b%e%j%l%w%x&O&`&d&l&n&o&rb!TSu!v#c$^$|%T%k&aU#_!T#`#sR#s!nU#_!T#`#sT$U!x$VR$j#aR#SuQ#QuR%^$^U!PQ#]#pQ#q!iR$e#ZQpQQ$g#]R$q#pQ$z#rQ%r%SQ&Q%jU&V%l&d&rQ&g&`T&m&l&oc$s#r%S%j%l&`&d&l&o&r!liOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xQ#k!cU$r#r%S&lS%z%e&n]&P%j%l&`&d&o&rR&U%kQ&S%kR&h&aQ&Y%lR&q&rS&W%l&rR&j&d!mZOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xR#z!nQ#w!nR%n$|S#v!n$|T$Q!v%T!mcOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%x!lcOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xQ!p`T!ym$X!maOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%x!mbOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%x!mfOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%x!mnOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xR$T!vQ$R!vR%s%TQ%v%VR&Z%wQ!{mR%Y$XT!zm$XS!xm$XT$U!x$VRpQS#`!T#sR$h#`Q#d!WR$l#dQ$_#QR%_$_Q#[!PR$f#[!vYOPQWgjsz{!Z!_!`!a!c!e!f!g!h!i!n#X#Z#]#a#e#p#r#|#}$W$[$]$`$o${%S%V%b%e%w%x&lS!mY&O_&O%j%l&`&d&n&o&rQ%f$rS%{%f&^R&^&PQ&b&SR&i&bQ&e&WR&k&eQ$}#wR%o$}S$O!t#tR%R$OQ%U$RR%t%UQ$V!xR%W$VQ$Y!{R%Z$YQ#Y}R$d#YQpOQ}PR$c#XUTOP#XW!OQ!i#Z#]Q!lWQ!rgQ!tjQ!}sQ#VzQ#W{Q#g!ZQ#h!_Q#i!`Q#j!aQ#l!eQ#m!fQ#n!gQ#o!hQ#t!nQ$i#aQ$m#eQ$p#pQ%P#|Q%Q#}Q%X$WQ%[$[Q%]$]Q%`$`Q%c$oQ%m${S%u%V%wQ%y%bR&[%x!moOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%x!mSOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xR!XST!VS#cQ#a!UR$]#OR#e!Y!msOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%x!muOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xR#RuT#Pu$^V!QQ#]#p!X!_T!O!r!t!}#V#W#g#l#m#n#o#t$i$m$p%P%Q%X%[%]%`%c%m%u%y&[!Z!`T!O!r!t!}#V#W#g#h#l#m#n#o#t$i$m$p%P%Q%X%[%]%`%c%m%u%y&[!]!aT!O!r!t!}#V#W#g#h#i#l#m#n#o#t$i$m$p%P%Q%X%[%]%`%c%m%u%y&[!mWOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xR&T%kT&X%l&r!a!cT!O!l!r!t!}#V#W#g#h#i#j#l#m#n#o#t$i$m$p%P%Q%X%[%]%`%c%m%u%y&[!a!eT!O!l!r!t!}#V#W#g#h#i#j#l#m#n#o#t$i$m$p%P%Q%X%[%]%`%c%m%u%y&[!m[OPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xQ!o[R!qaR#x!nQ!ujR#y!n!mdOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%x!mjOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%x!mkOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xR$S!v!mmOPQWgjsz{!Z!_!`!a!e!f!g!h!i!n#X#Z#]#a#e#p#|#}$W$[$]$`$o${%V%b%w%xR!|m",
  nodeNames: "⚠ LineComment BlockComment Expression ForExpression for InExpressions InExpression Name Identifier Identifier ArithOp ArithOp ArithOp ArithOp ArithOp in IterationContext return IfExpression if then else QuantifiedExpression some every InExpressions InExpression satisfies Disjunction or Conjunction and Comparison CompareOp CompareOp between PositiveUnaryTest ( PositiveUnaryTests ) ArithmeticExpression InstanceOfExpression instance of Type QualifiedName VariableName SpecialType days time duration years months date > ListType list < ContextType context ContextEntryTypes ContextEntryType FunctionType function ArgumentTypes ArgumentType PathExpression ] FilterExpression [ FunctionInvocation SpecialFunctionName NamedParameters NamedParameter ParameterName PositionalParameters null NumericLiteral StringLiteral BooleanLiteral DateTimeLiteral DateTimeConstructor AtLiteral ? SimplePositiveUnaryTest Interval ParenthesizedExpression List FunctionDefinition FormalParameters FormalParameter external FunctionBody } { Context ContextEntry Key Name Identifier Expressions UnaryTests Wildcard not",
  maxTerm: 171,
  context: variableTracker,
  nodeProps: [
    ["closedBy", 38,")",70,"]",95,"}"],
    ["openedBy", 40,"(",68,"[",94,"{"],
    ["group", -5,77,78,79,80,81,"Literal"]
  ],
  propSources: [feelHighlighting],
  skippedNodes: [0,1,2],
  repeatNodeCount: 14,
  tokenData: "+l~RuXY#fYZ$ZZ[#f]^$Zpq#fqr$`rs$kwx&cxy&hyz&mz{&r{|'P|}'U}!O'Z!O!P'h!P!Q(Q!Q![){![!]*^!]!^*c!^!_*h!_!`$f!`!a*w!b!c+R!}#O+W#P#Q+]#Q#R&z#o#p+b#q#r+g$f$g#f#BY#BZ#f$IS$I_#f$I|$I}$Z$I}$JO$Z$JT$JU#f$KV$KW#f&FU&FV#f?HT?HU#f~#kY#q~XY#fZ[#fpq#f$f$g#f#BY#BZ#f$IS$I_#f$JT$JU#f$KV$KW#f&FU&FV#f?HT?HU#f~$`O#r~~$cP!_!`$f~$kOr~~$pW$h~OY$kZr$krs%Ys#O$k#O#P%_#P;'S$k;'S;=`&]<%lO$k~%_O$h~~%bRO;'S$k;'S;=`%k;=`O$k~%pX$h~OY$kZr$krs%Ys#O$k#O#P%_#P;'S$k;'S;=`&];=`<%l$k<%lO$k~&`P;=`<%l$k~&hO#z~~&mOv~~&rOx~~&wP^~z{&z~'PO_~~'UO[~~'ZO#}~R'`PZP!`!a'cQ'hO$]Q~'mQ#y~!O!P's!Q!['x~'xO#|~~'}P$g~!Q!['x~(VQ]~z{(]!P!Q)d~(`TOz(]z{(o{;'S(];'S;=`)^<%lO(]~(rVOz(]z{(o{!P(]!P!Q)X!Q;'S(];'S;=`)^<%lO(]~)^OQ~~)aP;=`<%l(]~)iSP~OY)dZ;'S)d;'S;=`)u<%lO)d~)xP;=`<%l)d~*QQ$g~!O!P*W!Q![){~*ZP!Q!['x~*cO$Z~~*hO$q~R*oP![QsP!_!`*rP*wOsPR+OP!XQsP!_!`*r~+WO$j~~+]O!h~~+bO!f~~+gO#R~~+lO#Q~",
  tokenizers: [propertyIdentifiers, identifiers, insertSemicolon, 0, 1],
  topRules: {"Expression":[0,3],"Expressions":[1,101],"UnaryTests":[2,102]},
  dynamicPrecedences: {"31":-1,"67":1,"71":-1,"73":-1},
  specialized: [{term: 121, get: (value) => spec_identifier[value] || -1}],
  tokenPrec: 2500
});

export { VariableContext, normalizeContextKey, parser, trackVariables };
//# sourceMappingURL=index.js.map
