import { ExternalTokenizer, ContextTracker, LRParser } from '@lezer/lr';
import { reduce, has } from 'min-dash';
import { styleTags, tags } from '@lezer/highlight';

// This file was generated by lezer-generator. You probably shouldn't edit it.
const propertyIdentifier = 121,
  identifier = 122,
  nameIdentifier = 123,
  insertSemi = 124,
  expression0 = 128,
  ForExpression = 4,
  forExpressionStart = 131,
  ForInExpression = 7,
  Name = 8,
  Identifier = 9,
  AdditionalIdentifier = 10,
  forExpressionBodyStart = 139,
  IfExpression = 19,
  ifExpressionStart = 140,
  QuantifiedExpression = 23,
  quantifiedExpressionStart = 141,
  QuantifiedInExpression = 27,
  PositiveUnaryTest = 37,
  ArithmeticExpression = 41,
  arithmeticPlusStart = 145,
  arithmeticTimesStart = 146,
  arithmeticExpStart = 147,
  arithmeticUnaryStart = 148,
  VariableName = 47,
  PathExpression = 68,
  pathExpressionStart = 154,
  FilterExpression = 70,
  filterExpressionStart = 155,
  FunctionInvocation = 72,
  functionInvocationStart = 156,
  ParameterName = 76,
  nil = 161,
  NumericLiteral = 79,
  StringLiteral = 80,
  BooleanLiteral = 81,
  listStart = 167,
  List = 89,
  FunctionDefinition = 90,
  functionDefinitionStart = 169,
  Context = 97,
  contextStart = 171,
  ContextEntry = 98,
  PropertyName = 100,
  PropertyIdentifier = 101;

/* global console,process */


// @ts-expect-error env access
const LOG_PARSE = typeof process != 'undefined' && process.env && /\bfparse(:dbg)?\b/.test(process.env.LOG);

// @ts-expect-error env access
const LOG_PARSE_DEBUG = typeof process != 'undefined' && process.env && /\bfparse:dbg\b/.test(process.env.LOG);

// @ts-expect-error env access
const LOG_VARS = typeof process != 'undefined' && process.env && /\bcontext\b/.test(process.env.LOG);

const spaceChars = [
  9, 11, 12, 32, 133, 160,
  5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198,
  8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288
];

const newlineChars = chars('\n\r');

const asterix = '*'.charCodeAt(0);

const additionalNameChars = chars("'./-+*^");

/**
 * @typedef { VariableContext | any } ContextValue
 */

/**
 * @param { string } str
 * @return { number[] }
 */
function chars(str) {
  return Array.from(str).map(s => s.charCodeAt(0));
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isStartChar(ch) {
  return (
    ch === 63 // ?
  ) || (
    ch >= 65 && ch <= 90 // A-Z
  ) || (
    ch === 95 // _
  ) || (
    ch >= 97 && ch <= 122 // a-z
  ) || (
    ch >= 0xC0 && ch <= 0xD6
  ) || (
    ch >= 0xD8 && ch <= 0xF6
  ) || (
    ch >= 0xF8 && ch <= 0x2FF
  ) || (
    ch >= 0x370 && ch <= 0x37D
  ) || (
    ch >= 0x37F && ch <= 0x1FFF
  ) || (
    ch >= 0x200C && ch <= 0x200D
  ) || (
    ch >= 0x2070 && ch <= 0x218F
  ) || (
    ch >= 0x2C00 && ch <= 0x2FEF
  ) || (
    ch >= 0x3001 && ch <= 0xD7FF
  ) || (
    ch >= 0xF900 && ch <= 0xFDCF
  ) || (
    ch >= 0xFDF0 && ch <= 0xFFFD
  ) || (
    ch >= 0xD800 && ch <= 0xDBFF // upper surrogate
  ) || (
    ch >= 0xDC00 && ch <= 0xDFFF // lower surrogate
  );
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isAdditional(ch) {
  return additionalNameChars.includes(ch);
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isPartChar(ch) {
  return (
    ch >= 48 && ch <= 57 // 0-9
  ) || (
    ch === 0xB7
  ) || (
    ch >= 0x0300 && ch <= 0x036F
  ) || (
    ch >= 0x203F && ch <= 0x2040
  );
}

/**
 * @param { number } ch
 * @return { boolean }
 */
function isSpace(ch) {
  return spaceChars.includes(ch);
}

function indent(str, spaces) {
  return spaces.concat(
    str.split(/\n/g).join('\n' + spaces)
  );
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param  { number } [offset]
 *
 * @return { { token: string, offset: number } | null }
 */
function parseAdditionalSymbol(input, offset = 0) {

  const next = input.peek(offset);

  if (next === asterix && input.peek(offset + 1) === asterix) {

    return {
      offset: 2,
      token: '**'
    };
  }

  if (isAdditional(next)) {
    return {
      offset: 1,
      token: String.fromCharCode(next)
    };
  }

  return null;
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param { number } [offset]
 * @param { boolean } [namePart]
 *
 * @return { { token: string, offset: number } | null }
 */
function parseIdentifier(input, offset = 0, namePart = false) {
  for (let inside = false, chars = [], i = 0;; i++) {
    const next = input.peek(offset + i);

    if (isStartChar(next) || ((inside || namePart) && isPartChar(next))) {
      if (!inside) {
        inside = true;
      }

      chars.push(next);
    } else {

      if (chars.length) {
        return {
          token: String.fromCharCode(...chars),
          offset: i
        };
      }

      return null;
    }
  }
}

/**
 * @param { import('@lezer/lr').InputStream } input
 * @param  { number } offset
 *
 * @return { { token: string, offset: number } | null }
 */
function parseSpaces(input, offset) {

  for (let inside = false, i = 0;; i++) {
    let next = input.peek(offset + i);

    if (isSpace(next)) {
      if (!inside) {
        inside = true;
      }
    } else {
      if (inside) {
        return {
          token: ' ',
          offset: i
        };
      }

      return null;
    }
  }
}

/**
 * Parse a name from the input and return the first match, if any.
 *
 * @param { import('@lezer/lr').InputStream } input
 * @param { Variables } variables
 *
 * @return { { token: string, offset: number, term: number } | null }
 */
function parseName(input, variables) {
  const contextKeys = variables.contextKeys();

  const start = variables.tokens;

  for (let i = 0, tokens = [], nextMatch = null;;) {

    const namePart = (start.length + tokens.length) > 0;
    const maybeSpace = tokens.length > 0;

    const match = (
      parseIdentifier(input, i, namePart) ||
      namePart && parseAdditionalSymbol(input, i) ||
      maybeSpace && parseSpaces(input, i)
    );

    // match is required
    if (!match) {
      return nextMatch;
    }

    const {
      token,
      offset
    } = match;

    i += offset;

    if (token === ' ') {
      continue;
    }

    tokens = [ ...tokens, token ];

    const name = [ ...start, ...tokens ].join(' ');

    if (contextKeys.some(el => el === name)) {
      const token = tokens[0];

      nextMatch = {
        token,
        offset: token.length,
        term: nameIdentifier
      };
    }

    if (contextKeys.some(el => el.startsWith(name))) {
      continue;
    }

    if (dateTimeIdentifiers.some(el => el === name)) {
      const token = tokens[0];

      // parse date time identifiers as normal
      // identifiers to allow specialization to kick in
      //
      // cf. https://github.com/nikku/lezer-feel/issues/8
      nextMatch = {
        token,
        offset: token.length,
        term: identifier
      };
    }

    if (dateTimeIdentifiers.some(el => el.startsWith(name))) {
      continue;
    }

    return nextMatch;
  }

}

const identifiersMap = {
  [ identifier ]: 'identifier',
  [ nameIdentifier ]: 'nameIdentifier'
};

const identifiers = new ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <identifier | nameIdentifier>', input.pos);

  const nameMatch = parseName(input, stack.context);

  const start = stack.context.tokens;

  const match = nameMatch || parseIdentifier(input, 0, start.length > 0);

  if (match) {
    input.advance(match.offset);
    input.acceptToken(nameMatch ? nameMatch.term : identifier);

    LOG_PARSE && console.log('%s: MATCH <%s> <%s>', input.pos, nameMatch ? identifiersMap[nameMatch.term] : 'identifier', match.token);
  }
}, { contextual: true });


const propertyIdentifiers = new ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <propertyIdentifier>', input.pos);

  const start = stack.context.tokens;

  const match = parseIdentifier(input, 0, start.length > 0);

  if (match) {
    input.advance(match.offset);
    input.acceptToken(propertyIdentifier);

    LOG_PARSE && console.log('%s: MATCH <propertyIdentifier> <%s>', input.pos, match.token);
  }
});


const insertSemicolon = new ExternalTokenizer((input, stack) => {

  LOG_PARSE_DEBUG && console.log('%s: T <insertSemi>', input.pos);

  let offset;
  let insert = false;

  for (offset = 0;; offset++) {
    const char = input.peek(offset);

    if (spaceChars.includes(char)) {
      continue;
    }

    if (newlineChars.includes(char)) {
      insert = true;
    }

    break;
  }

  if (insert) {

    const identifier = parseIdentifier(input, offset + 1);
    const spaces = parseSpaces(input, offset + 1);

    if (spaces || identifier && /^(then|else|return|satisfies)$/.test(identifier.token)) {
      return;
    }

    LOG_PARSE && console.log('%s: MATCH <insertSemi>', input.pos);
    input.acceptToken(insertSemi);
  }
});

const prefixedContextStarts = {
  [ functionInvocationStart ]: 'FunctionInvocation',
  [ filterExpressionStart ]: 'FilterExpression',
  [ pathExpressionStart ]: 'PathExpression'
};

const contextStarts = {
  [ contextStart ]: 'Context',
  [ functionDefinitionStart ]: 'FunctionDefinition',
  [ forExpressionStart ]: 'ForExpression',
  [ listStart ]: 'List',
  [ ifExpressionStart ]: 'IfExpression',
  [ quantifiedExpressionStart ]: 'QuantifiedExpression'
};

const contextEnds = {
  [ Context ]: 'Context',
  [ FunctionDefinition ]: 'FunctionDefinition',
  [ ForExpression ]: 'ForExpression',
  [ List ]: 'List',
  [ IfExpression ]: 'IfExpression',
  [ QuantifiedExpression ]: 'QuantifiedExpression',
  [ PathExpression ]: 'PathExpression',
  [ FunctionInvocation ]: 'FunctionInvocation',
  [ FilterExpression ]: 'FilterExpression',
  [ ArithmeticExpression ]: 'ArithmeticExpression'
};

/**
 * A simple producer that retrievs a value from
 * a given context. Used to lazily take things.
 */
class ValueProducer {

  /**
   * @param { Function } fn
   */
  constructor(fn) {
    this.fn = fn;
  }

  get(variables) {
    return this.fn(variables);
  }

  /**
   * @param { Function } fn
   *
   * @return { ValueProducer }
   */
  static of(fn) {
    return new ValueProducer(fn);
  }

}

const dateTimeLiterals = {
  'date and time': 1,
  'date': 1,
  'time': 1,
  'duration': 1
};

const dateTimeIdentifiers = Object.keys(dateTimeLiterals);


/**
 * A basic key-value store to hold context values.
 */
class VariableContext {

  /**
   * Creates a new context from a JavaScript object.
   *
   * @param {any} [value]
   */
  constructor(value = {}) {

    /**
     * @protected
     */
    this.value = value;
  }

  /**
   * Return all defined keys of the context.
   *
   * @returns {Array<string>} the keys of the context
   */
  getKeys() {
    return Object.keys(this.value);
  }

  /**
   * Returns the value of the given key.
   *
   * If the value represents a context itself, it should be wrapped in a
   * context class.
   *
   * @param {String} key
   * @returns {VariableContext|ValueProducer|null}
   */
  get(key) {
    const result = this.value[key];

    const constructor = /** @type { typeof VariableContext } */ (this.constructor);

    if (constructor.isAtomic(result)) {
      return result;
    }

    return constructor.of(result);
  }

  /**
   * Creates a new context with the given key added.
   *
   * @param {String} key
   * @param {any} value
   *
   * @returns {VariableContext} new context with the given key added
   */
  set(key, value) {

    const constructor = /** @type { typeof VariableContext } */ (this.constructor);

    return constructor.of({
      ...this.value,
      [key]: value
    });
  }

  /**
   * Non-destructively merge another context into this one,
   * and return the result.
   *
   * @param {ContextValue} other
   *
   * @return {VariableContext}
   */
  merge(other) {
    const constructor = /** @type { typeof VariableContext } */ (this.constructor);

    return new constructor(
      constructor.__merge(this.value, other)
    );
  }

  /**
   * Wether the given value is atomic. Non-atomic values need to be wrapped in a
   * context Class.
   *
   * @param {any} value
   * @returns {Boolean}
   */
  static isAtomic(value) {
    return !value ||
          value instanceof this ||
          value instanceof ValueProducer ||
          typeof value !== 'object';
  }

  /**
   * Takes any number of Contexts and merges them into a single context.
   *
   * @param { ...VariableContext } contexts
   * @returns { VariableContext }
   */
  static of(...contexts) {
    return contexts.reduce((context, otherContext) => {
      return context.merge(otherContext);
    }, new this({}));
  }

  /**
   * Returns the raw representation of the given context.
   *
   * @param {VariableContext | any} context
   *
   * @return {any}
   */
  static __unwrap(context) {
    if (!context) {
      return {};
    }

    if (context instanceof this) {
      return context.value;
    }

    if (typeof context !== 'object') {
      return {};
    }

    return { ...context };
  }

  /**
   * Non-destructively merges two contexts (or their values)
   * with each other, returning the result.
   *
   * @param {ContextValue} context
   * @param {ContextValue} other
   *
   * @return {any}
   */
  static __merge(context, other) {

    return reduce(this.__unwrap(other), (merged, value, key) => {
      if (value instanceof ValueProducer) {

        // keep value producers in tact
        return {
          ...merged,
          [key]: value
        };
      }

      value = this.__unwrap(value);

      if (has(merged, key)) {
        value = this.__merge(this.__unwrap(merged[key]), value);
      }

      return {
        ...merged,
        [key]: value
      };
    }, this.__unwrap(context));
  }

}

class Variables {

  /**
   * @param { {
   *   name?: string,
   *   tokens?: string[],
   *   children?: Variables[],
   *   parent: Variables | null
   *   context: VariableContext,
   *   value?: any,
   *   raw?: any
   * } } options
   */
  constructor({
    name = 'Expressions',
    tokens = [],
    children = [],
    parent = null,
    context,
    value,
    raw
  }) {
    this.name = name;
    this.tokens = tokens;
    this.children = children;
    this.parent = parent;
    this.context = context;
    this.value = value;
    this.raw = raw;
  }

  enterScope(name) {

    const childScope = this.of({
      name,
      parent: this
    });

    LOG_VARS && console.log('[%s] enter', childScope.path, childScope.context);

    return childScope;
  }

  exitScope(str) {

    if (!this.parent) {
      LOG_VARS && console.log('[%s] NO exit %o\n%s', this.path, this.context, indent(str, '  '));

      return this;
    }

    LOG_VARS && console.log('[%s] exit %o\n%s', this.path, this.context, indent(str, '  '));

    return this.parent.pushChild(this);
  }

  token(part) {

    LOG_VARS && console.log('[%s] token <%s> + <%s>', this.path, this.tokens.join(' '), part);

    return this.assign({
      tokens: [ ...this.tokens, part ]
    });
  }

  literal(value) {

    LOG_VARS && console.log('[%s] literal %o', this.path, value);

    return this.pushChild(this.of({
      name: 'Literal',
      value
    }));
  }

  /**
   * Return computed scope value
   *
   * @return {any}
   */
  computedValue() {
    for (let scope = this;;scope = last(scope.children)) {

      if (!scope) {
        return null;
      }

      if (scope.value) {
        return scope.value;
      }
    }
  }

  contextKeys() {
    return this.context.getKeys().map(normalizeContextKey);
  }

  get path() {
    return this.parent?.path?.concat(' > ', this.name) || this.name;
  }

  /**
   * Return value of variable.
   *
   * @param { string } variable
   * @return { any } value
   */
  get(variable) {

    const names = [ variable, variable && normalizeContextKey(variable) ];

    const contextKey = this.context.getKeys().find(
      key => names.includes(normalizeContextKey(key))
    );

    if (typeof contextKey === 'undefined') {
      return undefined;
    }

    const val = this.context.get(contextKey);

    if (val instanceof ValueProducer) {
      return val.get(this);
    } else {
      return val;
    }
  }

  resolveName() {

    const variable = this.tokens.join(' ');
    const tokens = [];

    const parentScope = this.assign({
      tokens
    });

    const variableScope = this.of({
      name: 'VariableName',
      parent: parentScope,
      value: this.get(variable),
      raw: variable
    });

    LOG_VARS && console.log('[%s] resolve name <%s=%s>', variableScope.path, variable, this.get(variable));

    return parentScope.pushChild(variableScope);
  }

  pushChild(child) {

    if (!child) {
      return this;
    }

    const parent = this.assign({
      children: [ ...this.children, child ]
    });

    child.parent = parent;

    return parent;
  }

  pushChildren(children) {

    /**
     * @type {Variables}
     */
    let parent = this;

    for (const child of children) {
      parent = parent.pushChild(child);
    }

    return parent;
  }

  declareName() {

    if (this.tokens.length === 0) {
      throw Error('no tokens to declare name');
    }

    const variableName = this.tokens.join(' ');

    LOG_VARS && console.log('[%s] declareName <%s>', this.path, variableName);

    return this.assign({
      tokens: []
    }).pushChild(
      this.of({
        name: 'Name',
        value: variableName
      })
    );
  }

  define(name, value) {

    if (typeof name !== 'string') {
      LOG_VARS && console.log('[%s] no define <%s=%s>', this.path, name, value);

      return this;
    }

    LOG_VARS && console.log('[%s] define <%s=%s>', this.path, name, value);

    const context = this.context.set(name, value);

    return this.assign({
      context
    });
  }

  /**
   * @param { Record<string, any> } [options]
   *
   * @return { Variables }
   */
  assign(options = {}) {

    return Variables.of({
      ...this,
      ...options
    });
  }

  /**
   * @param { Record<string, any> } [options]
   *
   * @return { Variables }
   */
  of(options = {}) {

    const defaultOptions = {
      context: this.context,
      parent: this.parent
    };

    return Variables.of({
      ...defaultOptions,
      ...options
    });
  }

  /**
   * @param { {
   *   name?: string,
   *   tokens?: string[],
   *   children?: Variables[],
   *   parent?: Variables | null
   *   context: VariableContext,
   *   value?: any,
   *   raw?: any
   * } } options
   *
   * @return {Variables}
   */
  static of(options) {

    const {
      name,
      tokens = [],
      children = [],
      parent = null,
      context,
      value,
      raw
    } = options;

    if (!context) {
      throw new Error('must provide <context>');
    }

    return new Variables({
      name,
      tokens: [ ...tokens ],
      children: [ ...children ],
      context,
      parent,
      value,
      raw
    });
  }

}

/**
 * @param { string } name
 *
 * @return { string } normalizedName
 */
function normalizeContextKey(name) {
  return name.replace(/\s*([./\-'+]|\*\*?)\s*/g, ' $1 ').replace(/\s{2,}/g, ' ').trim();
}

/**
 * Wrap children of variables under the given named child.
 *
 * @param { Variables } variables
 * @param { string } scopeName
 * @param { string } code
 * @return { Variables }
 */
function wrap(variables, scopeName, code) {

  const parts = variables.children.filter(c => c.name !== scopeName);
  const children = variables.children.filter(c => c.name === scopeName);

  const namePart = parts[0];
  const valuePart = parts[Math.max(1, parts.length - 1)];

  const name = namePart?.computedValue();
  const value = valuePart?.computedValue() || null;

  return variables
    .assign({
      children
    })
    .enterScope(scopeName)
    .pushChildren(parts)
    .exitScope(code)
    .define(name, value);
}

/**
 * @param { ContextValue } [context]
 * @param { typeof VariableContext } [Context]
 *
 * @return { ContextTracker<Variables> }
 */
function trackVariables(context = {}, Context = VariableContext) {

  const start = Variables.of({
    context: Context.of(context)
  });

  return new ContextTracker({
    start,
    reduce(variables, term, stack, input) {

      if (term === IfExpression) {
        const [ thenPart, elsePart ] = variables.children.slice(-2);

        variables = variables.assign({
          value: Context.of(
            thenPart?.computedValue(),
            elsePart?.computedValue()
          )
        });
      }

      if (term === List) {
        variables = variables.assign({
          value: Context.of(
            ...variables.children.map(
              c => c?.computedValue()
            )
          )
        });
      }

      if (term === FilterExpression) {
        const [ sourcePart, _ ] = variables.children.slice(-2);

        variables = variables.assign({
          value: sourcePart?.computedValue()
        });
      }

      if (term === FunctionInvocation) {

        const [
          name,
          ...args
        ] = variables.children;

        // preserve type information through `get value(context, key)` utility
        if (name?.raw === 'get value') {
          variables = getContextValue(variables, args);
        }
      }

      const start = contextStarts[term];

      if (start) {
        return variables.enterScope(start);
      }

      const prefixedStart = prefixedContextStarts[term];

      // pull <expression> into new <prefixedStart> context
      if (prefixedStart) {

        const {
          children: currentChildren,
          context: currentContext,
        } = variables;

        const children = currentChildren.slice(0, -1);
        const lastChild = last(currentChildren);

        let newContext = null;

        if (term === pathExpressionStart) {
          newContext = Context.of(lastChild?.computedValue());
        }

        if (term === filterExpressionStart) {
          newContext = Context.of(
            currentContext,
            lastChild?.computedValue()
          ).set('item', lastChild?.computedValue());
        }

        return variables
          .assign({ children })
          .enterScope(prefixedStart)
          .pushChild(lastChild)
          .assign({ context: newContext || currentContext });
      }

      // @ts-expect-error internal method
      const code = input.read(input.pos, stack.pos);

      const end = contextEnds[term];

      if (end) {
        return variables.exitScope(code);
      }

      if (term === ContextEntry) {
        const parts = variables.children.filter(c => c.name !== 'ContextEntry');

        const name = parts[0];
        const value = last(parts);

        return wrap(variables, 'ContextEntry', code).assign(
          {
            value: Context
              .of(variables.value)
              .set(name?.computedValue(), value?.computedValue())
          }
        );
      }

      if (
        term === ForInExpression ||
        term === QuantifiedInExpression
      ) {
        return wrap(variables, 'InExpression', code);
      }

      // define <partial> within ForExpression body
      if (term === forExpressionBodyStart) {

        return variables.define(
          'partial',
          ValueProducer.of(variables => {
            return last(variables.children)?.computedValue();
          })
        );
      }

      if (
        term === ParameterName
      ) {
        const name = last(variables.children).computedValue();

        // TODO: attach type information
        return variables.define(name, 1);
      }

      // pull <expression> into ArithmeticExpression child
      if (
        term === arithmeticPlusStart ||
        term === arithmeticTimesStart ||
        term === arithmeticExpStart
      ) {
        const children = variables.children.slice(0, -1);
        const lastChild = last(variables.children);

        return variables.assign({
          children
        }).enterScope('ArithmeticExpression').pushChild(lastChild);
      }

      if (term === arithmeticUnaryStart) {
        return variables.enterScope('ArithmeticExpression');
      }

      if (
        term === Identifier ||
        term === AdditionalIdentifier ||
        term === PropertyIdentifier
      ) {
        return variables.token(code);
      }

      if (
        term === StringLiteral
      ) {
        return variables.literal(code.replace(/^"|"$/g, ''));
      }

      if (term === BooleanLiteral) {
        return variables.literal(code === 'true' ? true : false);
      }

      if (term === NumericLiteral) {
        return variables.literal(parseFloat(code));
      }

      if (term === nil) {
        return variables.literal(null);
      }

      if (
        term === VariableName
      ) {
        return variables.resolveName();
      }

      if (
        term === Name ||
        term === PropertyName
      ) {
        return variables.declareName();
      }

      if (
        term === expression0 ||
        term === PositiveUnaryTest
      ) {
        if (variables.tokens.length > 0) {
          throw new Error('uncleared name');
        }
      }

      if (term === expression0) {

        let parent = variables;

        while (parent.parent) {
          parent = parent.exitScope(code);
        }

        return parent;
      }

      return variables;
    }
  });
}

const variableTracker = trackVariables({});


// helpers //////////////

function getContextValue(variables, args) {

  if (!args.length) {
    return variables.assign({
      value: null
    });
  }

  if (args[0].name === 'Name') {
    args = extractNamedArgs(args, [ 'm', 'key' ]);
  }

  if (args.length !== 2) {
    return variables.assign({
      value: null
    });
  }

  const [
    context,
    key
  ] = args;

  const keyValue = key?.computedValue();
  const contextValue = context?.computedValue();

  if (
    (!contextValue || typeof contextValue !== 'object') || typeof keyValue !== 'string'
  ) {
    return variables.assign({
      value: null
    });
  }

  return variables.assign({
    value: [ normalizeContextKey(keyValue), keyValue ].reduce((value, keyValue) => {
      return contextValue.get(keyValue) || value;
    }, null)
  });
}

function extractNamedArgs(args, argNames) {

  const context = {};

  for (let i = 0; i < args.length; i += 2) {
    const [ name, value ] = args.slice(i, i + 2);

    context[name.value] = value;
  }

  return argNames.map(name => context[name]);
}

function last(arr) {
  return arr[arr.length - 1];
}

const feelHighlighting = styleTags({
  StringLiteral: tags.string,
  NumericLiteral: tags.number,
  BooleanLiteral: tags.bool,
  'AtLiteral!': tags.special(tags.string),
  CompareOp: tags.compareOperator,
  ArithOp: tags.arithmeticOperator,
  'for if then else some every satisfies between return': tags.controlKeyword,
  'in instance of and or': tags.operatorKeyword,
  function: tags.definitionKeyword,
  as: tags.keyword,
  'Type/...': tags.typeName,
  Wildcard: tags.special(tags.variableName),
  null: tags.null,
  LineComment: tags.lineComment,
  BlockComment: tags.blockComment,
  'VariableName! "?"': tags.variableName,
  'DateTimeConstructor! SpecialFunctionName!': tags.function(tags.special(tags.variableName)),
  'List Interval': tags.list,
  Context: tags.definition(tags.literal),
  'Name!': tags.definition(tags.variableName),
  'Key/Name! ContextEntryType/Name!': tags.definition(tags.propertyName),
  'PathExpression/VariableName!': tags.function(tags.propertyName),
  'FormalParameter/ParameterName!': tags.function(tags.definition(tags.variableName)),
  '( )': tags.paren,
  '[ ]': tags.squareBracket,
  '{ }': tags.brace,
  '.': tags.derefOperator,
  ', ;': tags.separator,
  '..': tags.punctuation
});

// This file was generated by lezer-generator. You probably shouldn't edit it.
const spec_identifier = {__proto__:null,for:10, in:32, return:36, if:40, then:42, else:44, some:48, every:50, satisfies:56, or:60, and:64, between:72, instance:86, of:89, days:101, time:103, duration:105, years:107, months:109, date:111, list:117, context:123, function:130, null:156, true:330, false:330, "?":170, external:186, not:211};
const parser = LRParser.deserialize({
  version: 14,
  states: "C|O`QYOOO`QYOOO$sQYOOOOQU'#Ce'#CeO$}QYO'#C`O&WQYO'#FQOOQQ'#Ff'#FfO&bQYO'#FfO`QYO'#DVOOQU'#En'#EnO(UQ^O'#D]OOQU'#D^'#D^OOQU'#D]'#D]OOQO'#Fn'#FnO*RQWO'#DvOOQQ'#D}'#D}OOQQ'#EO'#EOOOQQ'#EP'#EPO*WOWO'#ESO*RQWO'#EQOOQQ'#EQ'#EQOOQQ'#Ft'#FtOOQQ'#Fr'#FrOOQQ'#Fy'#FyOOQQ'#EU'#EUO`QYO'#EWOOQQ'#FS'#FSO*]Q^O'#FSO,SQYO'#EXO,ZQWO'#EYOOQP'#F}'#F}O,`QXO'#EaOOQQ'#Fz'#FzOOQQ'#FR'#FRQOQWOOOOQQ'#FT'#FTOOQQ'#F^'#F^O`QYO'#CoOOQQ'#F_'#F_O$}QYO'#CsO,kQYO'#DwOOQQ'#Fs'#FsO,pQYO'#EROOQO'#ER'#ERO`QYO'#EVO`QYO'#EUOOQO'#F{'#F{Q,xQWOOO,}QYO'#DRO-tQWO'#FbOOQO'#DT'#DTO.PQYO'#FfO.WQWOOO.}QYO'#CdO/[QYO'#FVOOQQ'#Cc'#CcO/aQYO'#FUOOQQ'#Cb'#CbO/iQYO,58zO`QYO,59iOOQQ'#Fc'#FcOOQQ'#Fd'#FdOOQQ'#Fe'#FeO`QYO,59qO`QYO,59qO`QYO,59qOOQQ'#Fl'#FlO/nQYO,5:^OOQQ'#Fm'#FmO`QYO,5:`O`QYO,59eO`QYO,59gO`QYO,59iO1jQYO,59iO1qQYO,59rOOQQ,5:i,5:iO1vQYO,59qOOQU-E8l-E8lO3jQYO'#FoOOQQ,5:b,5:bOOQQ,5:n,5:nOOQQ,5:l,5:lO3qQYO,5:rOOQQ,5;n,5;nO3{QYO,5:qO4YQWO,5:sO4_QYO,5:tOOQP'#Ee'#EeO5UQXO'#EdOOQO'#Ec'#EcO5]QWO'#EbO5bQWO'#GOO5jQWO,5:{O5oQYO,59ZO/[QYO'#FaOOQQ'#Cw'#CwO5vQYO'#F`OOQQ'#Cv'#CvO6OQYO,59_O6TQYO,5:cO6YQYO,5:mO3tQYO,5:qO6_QYO,5:pO`QYO'#EwQ,xQWOOO`QYO'#EmO7UQWO,5;|O`QYOOOOQR'#Cf'#CfOOQQ'#Ej'#EjO8OQYO,59OO`QYO,5;qOOQQ'#FY'#FYO$}QYO'#EkO8`QYO,5;pO`QYO1G.fOOQQ'#F]'#F]O9VQYO1G/TO;|QYO1G/]O<WQYO1G/]O<bQYO1G/]OOQQ1G/x1G/xO>UQYO1G/zO>]QYO1G/PO?fQYO1G/RO@oQYO1G/TO`QYO1G/TOOQQ1G/T1G/TOAVQYO1G/^OAtQ^O'#CdOCWQYO'#FqOOQO'#Dz'#DzOCbQWO'#DyOCgQWO'#FpOOQO'#Dx'#DxOOQO'#D{'#D{OCoQWO,5<ZOOQQ1G0^1G0^O`QYO1G0]O`QYO'#EsOCtQWO,5<]OOQQ1G0_1G0_ODPQWO'#E[OD[QWO'#F|OOQO'#EZ'#EZODdQWO1G0`OOQP'#Eu'#EuODiQXO,5;OO`QYO,5:|ODpQXO'#EvODxQWO,5<jOOQQ1G0g1G0gO`QYO1G.uO`QYO,5;{O$}QYO'#ElOEQQYO,5;zO`QYO1G.yOEYQYO1G/}OOQO1G0X1G0XOOQO,5;c,5;cOOQO-E8u-E8uOOQO,5;X,5;XOOQO-E8k-E8kOE_QWOOOOQQ-E8h-E8hOEdQYO'#CmOOQQ1G1]1G1]OOQQ,5;V,5;VOOQQ-E8i-E8iOEqQYO7+$QOOQQ7+%f7+%fO`QYO7+$oOFhQYO,5:rOFuQWO7+$oOFzQYO'#D[OOQQ'#DZ'#DZOHnQYO'#D_OHsQYO'#D_OHxQYO'#D_OH}Q`O'#DgOISQ`O'#DjOIXQ`O'#DnOOQQ7+$x7+$xO`QYO,5:eO$}QYO'#ErOI^QWO,5<[OOQQ1G1u1G1uOJdQYO7+%wOJqQYO,5;_OOQO-E8q-E8qOAVQYO,5:vO$}QYO'#EtOKOQWO,5<hOKWQYO7+%zOOQP-E8s-E8sOK_QYO1G0hOOQO,5;b,5;bOOQO-E8t-E8tOKiQYO7+$aOKpQYO1G1gOOQQ,5;W,5;WOOQQ-E8j-E8jOKzQYO7+$eOOQO7+%i7+%iO`QYO,59XOLqQYO<<HZOOQQ<<HZ<<HZO/nQYO'#EoOMzQYO,59vO! nQYO,59yO! sQYO,59yO! xQYO,59yO! }QYO,5:RO$}QYO,5:UO!!lQbO,5:YO!!sQYO1G0POOQO,5;^,5;^OOQO-E8p-E8pO!!}QYO<<IcOOQQ<<Ic<<IcOOQO1G0b1G0bOOQO,5;`,5;`OOQO-E8r-E8rO!%|QYO'#E^OOQQ<<If<<IfO`QYO<<IfO`QYO<<G{O!&sQYO1G.sOOQQ,5;Z,5;ZOOQQ-E8m-E8mO!&}QYO1G/eOOQQ1G/e1G/eO!'SQbO'#D]O!'eQ`O'#D[O!'pQ`O1G/mO!'uQWO'#DmO!'zQ`O'#FhOOQO'#Dl'#DlO!(SQ`O1G/pOOQO'#Dq'#DqO!(XQ`O'#FjOOQO'#Dp'#DpO!(aQ`O1G/tOOQQAN?QAN?QO!(fQYOAN=gOOQQ7+%P7+%PO!)]Q`O,59vOOQQ7+%X7+%XO! }QYO,5:XO$}QYO'#EpO!)hQ`O,5<SOOQQ7+%[7+%[O! }QYO'#EqO!)pQ`O,5<UO!)xQ`O7+%`OOQO1G/s1G/sOOQO,5;[,5;[OOQO-E8n-E8nOOQO,5;],5;]OOQO-E8o-E8oOAVQYO<<HzOOQQAN>fAN>fO/nQYO'#EoO! }QYO<<HzO!)}Q`O7+%`O!*SQ`O1G/tO!!lQbO,5:YO!*XQ`O'#Dn",
  stateData: "!*h~O#rOS#sOSPOSQOS~OTsOZVO[UOdtOhvOivOr}Os}OviO!T{O!U{O!VxO!XzO!c!OO!g|O!igO!pyO!wjO#SnO#nRO#oRO$ZZO$i_O$j`O$kaO$lbO~OTsO[UOdtOhvOivOr}Os}OviO!T{O!U{O!VxO!XzO!c!OO!g|O!igO!pyO!wjO#SnO#nRO#oRO$ZZO$i_O$j`O$kaO$lbO~OZ!TO#]!UO~P#SO#nRO#oRO~OZ!^O[!^O]!_O^!_O_!`O`!kOn!hOp!iOr!]Os!]Ot!jO{!lO!i!fO#z!dOv$bX~O#l#tX$s#tX~P%VO$i!mOT$YXZ$YX[$YXd$YXh$YXi$YXr$YXs$YXv$YX!T$YX!U$YX!V$YX!X$YX!c$YX!g$YX!i$YX!p$YX!w$YX#S$YX#n$YX#o$YX$Z$YX$j$YX$k$YX$l$YX~O#nRO#oROZ!PX[!PX]!PX^!PX_!PX`!PXn!PXp!PXr!PXs!PXt!PXv!PX{!PX!i!PX#l!PX#p!PX#z!PX$s!PX$O!PXx!PX#}!PX!g!PXe!PXb!PX#R!PXf!PXl!PX~Ov!pO~O$j`O~O#p!uOZ#vX[#vX]#vX^#vX_#vX`#vXn#vXp#vXr#vXs#vXt#vXv#vX{#vX!i#vX#l#vX#z#vX$s#vX$O#vXx#vX#}#vX!g#vXe#vXb#vX#R#vXf#vXl#vX~O!g$eP~P`Ov!xO~O#m!yO$j`O#R$rP~Op#VO~Op#WOv!uX~O$s#ZO~O#luX$OuX$suXxuX#}uX!guXeuXbuX#RuXfuXluX~P%VO$O#]O#l$UXx$UX~O#l#[X~P&bOv#_O~OZ#`O[#`O]#`O^#`O_#`O#nRO#oRO#z#`O#{#`O$]WX~O`WXxWX$OWX~P.]O`#dO~O$O#eOb#xX~Ob#hO~O#nRO#oRO$ZZO~OTsOZVO[UOdtOhvOivOr}Os}O!T{O!U{O!VxO!XzO!c!OO!g|O!igO!pyO!wjO#SnO#nRO#oRO$ZZO$i_O$j`O$kaO$lbO~Ov#rO~P/yO|#tO~O{!lO!i!fO#z!dOZya[ya]ya^ya_ya`yanyapyaryasyatyav$bX#lya$sya$Oyaxya#}ya!gyaeyabya#Ryafyalya~Ox$eP~P`Ox#}O#}$OO~P%VO#}$OO$O$PO!g$eX~P%VO!g$RO~O#nRO#oROx$pP~OZ#`O[#`O]#`O^#`O_#`O#m!yO#z#`O#{#`O~O$]#WX~P4jO$]$YO~O$O$ZO#R$rX~O#R$]O~Oe$^O~P%VO$O$`Ol$SX~Ol$bO~O!W$cO~O!T$dO~O#l!xa$s!xa$O!xax!xa#}!xa!g!xae!xab!xa#R!xaf!xal!xa~P%VO$O#]O#l$Uax$Ua~OZ#`O[#`O]#`O^#`O_#`O#nRO#oRO#z#`O#{#`O~O`Wa$]WaxWa$OWa~P7aO$O#eOb#xa~OZ!^O[!^O]!_O^!_O_!`O{!lO!i!fO#z!dOv$bX~O`qinqipqirqisqitqi#lqi$sqi$Oqixqi#}qi!gqieqibqi#Rqifqilqi~P8hO_!`O{!lO!i!fO#z!dOZyi[yi`yinyipyiryisyityiv$bX#lyi$syi$Oyixyi#}yi!gyieyibyi#Ryifyilyi~O]!_O^!_O~P:`O]yi^yi~P:`O{!lO!i!fO#z!dOZyi[yi]yi^yi_yi`yinyipyiryisyityiv$bX#lyi$syi$Oyixyi#}yi!gyieyibyi#Ryifyilyi~O!g$pO~P%VO`!kOp!iOr!]Os!]Ot!jOnmi#lmi$smi$Omixmi#}mi!gmiemibmi#Rmifmilmi~P8hO`!kOr!]Os!]Ot!jOnoipoi#loi$soi$Ooixoi#}oi!goieoiboi#Roifoiloi~P8hO`!kOn!hOp$qOr!]Os!]Ot!jO~P8hO!S$vO!V$wO!X$xO![$yO!_$zO!c${O#nRO#oRO$ZZO~OZ#bX[#bX]#bX^#bX_#bX`#bXn#bXp#bXr#bXs#bXt#bXv#bXx#bX{#bX!i#bX#n#bX#o#bX#p#bX#z#bX$O#bX~P.]O$O$POx$eX~P%VO$]$}O~O$O%OOx$dX~Ox%QO~O$O$PO!g$eax$ea~O$]%UOx#OX$O#OX~O$O%VOx$pX~Ox%XO~O$]#Wa~P4jO#m!yO$j`O~O$O$ZO#R$ra~O$O$`Ol$Sa~O!U%cO~OxrO~O#}%dObaX$OaX~P%VO#lSq$sSq$OSqxSq#}Sq!gSqeSqbSq#RSqfSqlSq~P%VOx#}O#}$OO$OuX~P%VOx%fO~O#z%gOZ!OX[!OX]!OX^!OX_!OX`!OXn!OXp!OXr!OXs!OXt!OXv!OX{!OX!i!OX#l!OX$s!OX$O!OXx!OX#}!OX!g!OXe!OXb!OX#R!OXf!OXl!OX~Op%iO~Op%jO~Op%kO~O!]%lO~O!]%mO~O!]%nO~O$O%OOx$da~OZ!^O[!^O]!_O^!_O_!`O`!kOn!hOp!iOr!]Os!]Ot!jO{!lO#z!dOv$bX~Ox%sO!g%sO!i%rO~PIfO!g#ga$O#gax#ga~P%VO$O%VOx$pa~O#P%yO~P`O#R#Ui$O#Ui~P%VOf%zO~P%VOl$Ti$O$Ti~P%VO#lgq$sgq$Ogqxgq#}gq!ggqegqbgq#Rgqfgqlgq~P%VO`qynqypqyrqysqytqy#lqy$sqy$Oqyxqy#}qy!gqyeqybqy#Rqyfqylqy~P8hO#z%gOZ!Oa[!Oa]!Oa^!Oa_!Oa`!Oan!Oap!Oar!Oas!Oat!Oav!Oa{!Oa!i!Oa#l!Oa$s!Oa$O!Oax!Oa#}!Oa!g!Oae!Oab!Oa#R!Oaf!Oal!Oa~O!T&OO~O!W&OO~O!T&PO~O!S$vO!V$wO!X$xO![$yO!_$zO!c&uO#nRO#oRO$ZZO~O!Y$^P~P! }Ox!mi$O!mi~P%VOT$aXZ$aX[$aX]!yy^!yy_!yy`!yyd$aXh$aXi$aXn!yyp!yyr$aXs$aXt!yyv$aX{!yy!T$aX!U$aX!V$aX!X$aX!c$aX!g$aX!i$aX!p$aX!w$aX#S$aX#l!yy#n$aX#o$aX#z!yy$Z$aX$i$aX$j$aX$k$aX$l$aX$s!yy$O!yyx!yy#}!yye!yyb!yy#R!yyf!yyl!yy~O#l#QX$s#QX$O#QXx#QX#}#QX!g#QXe#QXb#QX#R#QXf#QXl#QX~P%VObai$Oai~P%VO!U&_O~O#nRO#oRO!Y!PX#z!PX$O!PX~O#z&pO!Y!OX$O!OX~O!Y&aO~O$]&bO~O$O&cO!Y$[X~O!Y&eO~O$O&fO!Y$^X~O!Y&hO~O#lc!R$sc!R$Oc!Rxc!R#}c!R!gc!Rec!Rbc!R#Rc!Rfc!Rlc!R~P%VO#z&pO!Y!Oa$O!Oa~O$O&cO!Y$[a~O$O&fO!Y$^a~O$_&nO~O$_&qO~O!Y&rO~O!]&tO~O$Z~QP_^$i]#z~",
  goto: "E|$sPPPP$tP%m%p%v&Y'sPPPPPP'|P$tPPP$tPP(P(SP$tP$tP$tPPP(YP(eP$t$tPP(n)T)`*m)TPPPPPPP)TPP)TP+r+u)TP+{,R$tP$tP$t,Y-R-U-[-RP-d.]-d-d/]0UP$t0}$t1v1v2o2rP2xPP1v3O3U/X3YPP3bP3e3l3r3x4O5Z5e5k5q5w6O6U6[6bPPPPPPPP6h6q8x9q:j:mPP:qPP:w:z;s<l<o<s<x=g>V>vP?oP?rP?v@iA[BTBZB^$tBdBdPPPPC]8xDUD}EQEy!mjOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zR![SQ!YSR$m#eS!WS#eS#Qw$`W#w!p!x%O%VT&T%m&c#WXOPQWYilu|}!]!a!b!c!e!g!h!i!j!k#Z#]#_#c#g#r#t$O$P$Y$^$_$b$q$}%U%X%d%g%l%n%y%z&Q&b&f&n&p&q&tb!VSw!x#e$`%O%V%m&cU#a!V#b#uR#u!pU#a!V#b#uT$W!z$XR$l#cR#UwQ#SwR%`$`U!RQ#_#rQ#s!kR$g#]QrQQ$i#_R$s#rQ$|#tQ%t%UQ&S%lU&X%n&f&tQ&i&bT&o&n&qc$u#t%U%l%n&b&f&n&q&t!lkOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zQ#m!eU$t#t%U&nS%|%g&p]&R%l%n&b&f&q&t#V[OPQWilu|}!]!a!b!c!e!g!h!i!j!k!p#Z#]#_#c#g#r#t$O$P$Y$^$_$b$q$}%U%X%d%g%l%n%y%z&b&f&n&p&q&tR&W%mQ&U%mR&j&cQ&[%nR&s&tS&Y%n&tR&l&f!m]OPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zR#|!pQ#y!pR%p%OS#x!p%OT$S!x%V!meOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%z!leOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zQ!rbT!{o$Z!mcOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%z!mdOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%z!mhOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%z!mpOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zR$V!xQ$T!xR%u%VQ%x%XR&]%yQ!}oR%[$ZT!|o$ZS!zo$ZT$W!z$XRrQS#b!V#uR$j#bQ#f!YR$n#fQ$a#SR%a$aQ#^!RR$h#^!vYOPQWilu|}!]!a!b!c!e!g!h!i!j!k!p#Z#]#_#c#g#r#t$O$P$Y$^$_$b$q$}%U%X%d%g%y%z&nS!oY&Q_&Q%l%n&b&f&p&q&tQ%h$tS%}%h&`R&`&RQ&d&UR&k&dQ&g&YR&m&gQ%P#yR%q%PS$Q!v#vR%T$QQ%W$TR%v%WQ$X!zR%Y$XQ$[!}R%]$[Q#[!PR$f#[QrOQ!PPR$e#ZUTOP#ZW!QQ!k#]#_Q!nWQ!tiQ!vlQ#PuQ#X|Q#Y}Q#i!]Q#j!aQ#k!bQ#l!cQ#n!gQ#o!hQ#p!iQ#q!jQ#v!pQ$k#cQ$o#gQ$r#rQ%R$OQ%S$PQ%Z$YQ%^$^Q%_$_Q%b$bQ%e$qQ%o$}S%w%X%yQ%{%dR&^%z!mqOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%z!mSOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zR!ZST!XS#eQ#c!WR$_#QR#g![!muOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%z!mwOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zR#TwT#Rw$`V!SQ#_#r!X!aT!Q!t!v#P#X#Y#i#n#o#p#q#v$k$o$r%R%S%Z%^%_%b%e%o%w%{&^!Z!bT!Q!t!v#P#X#Y#i#j#n#o#p#q#v$k$o$r%R%S%Z%^%_%b%e%o%w%{&^!]!cT!Q!t!v#P#X#Y#i#j#k#n#o#p#q#v$k$o$r%R%S%Z%^%_%b%e%o%w%{&^!mWOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zR&V%mT&Z%n&t!a!eT!Q!n!t!v#P#X#Y#i#j#k#l#n#o#p#q#v$k$o$r%R%S%Z%^%_%b%e%o%w%{&^!a!gT!Q!n!t!v#P#X#Y#i#j#k#l#n#o#p#q#v$k$o$r%R%S%Z%^%_%b%e%o%w%{&^!m^OPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zQ!q^R!scR#z!pQ!wlR#{!p!mfOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%z!mlOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%z!mmOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zR$U!x!moOPQWilu|}!]!a!b!c!g!h!i!j!k!p#Z#]#_#c#g#r$O$P$Y$^$_$b$q$}%X%d%y%zR#Oo",
  nodeNames: "⚠ LineComment BlockComment Expression ForExpression for InExpressions InExpression Name Identifier Identifier ArithOp ArithOp ArithOp ArithOp ArithOp in IterationContext return IfExpression if then else QuantifiedExpression some every InExpressions InExpression satisfies Disjunction or Conjunction and Comparison CompareOp CompareOp between PositiveUnaryTest ( PositiveUnaryTests ) ArithmeticExpression InstanceOfExpression instance of Type QualifiedName VariableName BacktickIdentifier SpecialType days time duration years months date > ListType list < ContextType context ContextEntryTypes ContextEntryType FunctionType function ArgumentTypes ArgumentType PathExpression ] FilterExpression [ FunctionInvocation SpecialFunctionName NamedParameters NamedParameter ParameterName PositionalParameters null NumericLiteral StringLiteral BooleanLiteral DateTimeLiteral DateTimeConstructor AtLiteral ? SimplePositiveUnaryTest Interval ParenthesizedExpression List FunctionDefinition FormalParameters FormalParameter external FunctionBody } { Context ContextEntry Key Name Identifier Expressions UnaryTests Wildcard not",
  maxTerm: 173,
  context: variableTracker,
  nodeProps: [
    ["group", -17,4,19,23,29,31,33,41,42,68,70,72,85,86,88,89,90,97,"Expr",47,"Expr Expr",-5,78,79,80,81,82,"Expr Literal"],
    ["closedBy", 38,")",71,"]",96,"}"],
    ["openedBy", 40,"(",69,"[",95,"{"]
  ],
  propSources: [feelHighlighting],
  skippedNodes: [0,1,2],
  repeatNodeCount: 14,
  tokenData: ".V~RvXY#iYZ$^Z[#i]^$^pq#iqr$crs$nwx&bxy&gyz&lz{&q{|'O|}'T}!O'Y!O!P'g!P!Q(q!Q![*l![!]+T!]!^+Y!^!_+_!_!`$i!`!a+n!b!c+x!}#O+}#P#Q,S#Q#R&y#S#T,X#o#p-{#q#r.Q$f$g#i#BY#BZ#i$IS$I_#i$I|$I}$^$I}$JO$^$JT$JU#i$KV$KW#i&FU&FV#i?HT?HU#i~#nY#r~XY#iZ[#ipq#i$f$g#i#BY#BZ#i$IS$I_#i$JT$JU#i$KV$KW#i&FU&FV#i?HT?HU#i~$cO#s~~$fP!_!`$i~$nOr~~$qWOY$nZr$nrs%Zs#O$n#O#P%`#P;'S$n;'S;=`&[<%lO$n~%`O$j~~%cRO;'S$n;'S;=`%l;=`O$n~%oXOY$nZr$nrs%Zs#O$n#O#P%`#P;'S$n;'S;=`&[;=`<%l$n<%lO$n~&_P;=`<%l$n~&gO#{~~&lOv~~&qOx~~&vP^~z{&y~'OO_~~'TO[~~'YO$O~R'_PZP!`!a'bQ'gO$_Q~'lQ#z~!O!P'r!Q!['w~'wO#}~~'|R$i~!Q!['w!g!h(V#X#Y(V~(YR{|(c}!O(c!Q![(i~(fP!Q![(i~(nP$i~!Q![(i~(vQ]~z{(|!P!Q*T~)PTOz(|z{)`{;'S(|;'S;=`)}<%lO(|~)cVOz(|z{)`{!P(|!P!Q)x!Q;'S(|;'S;=`)}<%lO(|~)}OQ~~*QP;=`<%l(|~*YSP~OY*TZ;'S*T;'S;=`*f<%lO*T~*iP;=`<%l*T~*qS$i~!O!P*}!Q![*l!g!h(V#X#Y(V~+QP!Q!['w~+YO$]~~+_O$s~R+fP!]QsP!_!`+iP+nOsPR+uP!YQsP!_!`+i~+}O$l~~,SO!i~~,XO!g~~,[WOY,XZ#O,X#O#P,t#P#S,X#S#T-p#T;'S,X;'S;=`-u<%lO,X~,wRO;'S,X;'S;=`-Q;=`O,X~-TXOY,XZ#O,X#O#P,t#P#S,X#S#T-p#T;'S,X;'S;=`-u;=`<%l,X<%lO,X~-uO$Z~~-xP;=`<%l,X~.QO#S~~.VO#R~",
  tokenizers: [propertyIdentifiers, identifiers, insertSemicolon, 0, 1],
  topRules: {"Expression":[0,3],"Expressions":[1,102],"UnaryTests":[2,103]},
  dialects: {camunda: 2544},
  dynamicPrecedences: {"31":-1,"68":1,"72":-1,"74":-1},
  specialized: [{term: 122, get: (value) => spec_identifier[value] || -1}],
  tokenPrec: 2546
});

export { VariableContext, normalizeContextKey, parser, trackVariables };
//# sourceMappingURL=index.js.map
