import { Tree, SyntaxNode } from "./tree";
import { Parser, PartialParse, TreeFragment, Input } from "./parse";
export declare class SubtreeRange {
    constructor(from: number, to: number, parser: Parser, cont?: any);
}
export declare class CompositeParser extends Parser {
    private subtreeRanges;
    private subtreeCache;
    constructor(main: Parser, subtreeRanges: {
        [nodeID: number]: (node: SyntaxNode, input: Input) => (readonly SubtreeRange[] | null);
    });
    startParseInner(input: Input, fragments: readonly TreeFragment[], ranges: readonly {
        from: number;
        to: number;
    }[]): CompositeParse;
}
declare class CompositeParse implements PartialParse {
    readonly input: Input;
    readonly fragments: readonly TreeFragment[];
    readonly ranges: readonly {
        from: number;
        to: number;
    }[];
    readonly parser: CompositeParser;
    main: PartialParse;
    mainResult: Tree | null;
    mainSub: Tree[];
    inner: PartialParse[];
    subtrees: Tree[];
    stoppedAt: number | null;
    constructor(input: Input, fragments: readonly TreeFragment[], ranges: readonly {
        from: number;
        to: number;
    }[], parser: CompositeParser);
    advance(): Tree | null;
    private startSub;
    private startInner;
    private reuseInner;
    stopAt(pos: number): void;
    get parsedPos(): number;
}
export {};
