import { Parser, ParseSpec, FullParseSpec, PartialParse } from "./parse";
import { Tree, NodeType } from "./tree";
export declare class FramingParser extends Parser {
    constructor(config: {
        frame: Parser;
        fill: Parser;
        frameNodes: readonly NodeType[];
    });
    startParse(spec: ParseSpec): FramingParse;
}
declare class FramingParse implements PartialParse {
    readonly parser: FramingParser;
    readonly spec: FullParseSpec;
    outerTree: Tree | null;
    outer: PartialParse;
    inner: PartialParse | null;
    stoppedAt: null | number;
    constructor(parser: FramingParser, spec: FullParseSpec);
    get parsedPos(): number;
    advance(): Tree;
    stopAt(pos: number): void;
    private startInner;
    private finishParse;
}
export {};
