import { Parser, ParseSpec, FullParseSpec, PartialParse } from "./parse";
import { Tree, NodeType } from "./tree";
export declare class ScaffoldParser extends Parser {
    constructor(config: {
        scaffold: Parser;
        fill: Parser;
        scaffoldNodes: readonly NodeType[];
    });
    startParse(spec: ParseSpec): ScaffoldParse;
}
declare class ScaffoldParse implements PartialParse {
    readonly parser: ScaffoldParser;
    readonly spec: FullParseSpec;
    outerTree: Tree | null;
    outer: PartialParse;
    inner: PartialParse | null;
    stoppedAt: null | number;
    constructor(parser: ScaffoldParser, spec: FullParseSpec);
    get parsedPos(): number;
    advance(): Tree;
    stopAt(pos: number): void;
    private startInner;
    private finishParse;
}
export {};
