export function last<L>(arr: L[]): L;
export function create<C>(): C[];
export function copy<D>(a: D[]): D[];
export function appendTo<M>(dest: M[], src: M[]): void;
/**
 * Transforms something array-like to an actual Array.
 *
 * @function
 * @template T
 * @param {ArrayLike<T>|Iterable<T>} arraylike
 * @return {T}
 */
export const from: {
    <T_1>(arrayLike: ArrayLike<T_1>): T_1[];
    <T_2, U>(arrayLike: ArrayLike<T_2>, mapfn: (v: T_2, k: number) => U, thisArg?: any): U[];
    <T_3>(iterable: Iterable<T_3> | ArrayLike<T_3>): T_3[];
    <T_4, U_1>(iterable: Iterable<T_4> | ArrayLike<T_4>, mapfn: (v: T_4, k: number) => U_1, thisArg?: any): U_1[];
};
export function every<ITEM>(arr: ITEM[], f: (arg0: ITEM, arg1: number, arg2: ITEM[]) => boolean): boolean;
export function some<S>(arr: S[], f: (arg0: S, arg1: number, arg2: S[]) => boolean): boolean;
export function equalFlat<ELEM>(a: ELEM[], b: ELEM[]): boolean;
export function flatten<ELEM>(arr: ELEM[][]): ELEM[];
export const isArray: (arg: any) => arg is any[];
//# sourceMappingURL=array.d.ts.map