'use strict';

/* eslint-env browser */

/**
 * Binary data constants.
 *
 * @module binary
 */

/**
 * n-th bit activated.
 *
 * @type {number}
 */
const BIT1 = 1;
const BIT2 = 2;
const BIT3 = 4;
const BIT4 = 8;
const BIT5 = 16;
const BIT6 = 32;
const BIT7 = 64;
const BIT8 = 128;
const BIT9 = 256;
const BIT10 = 512;
const BIT11 = 1024;
const BIT12 = 2048;
const BIT13 = 4096;
const BIT14 = 8192;
const BIT15 = 16384;
const BIT16 = 32768;
const BIT17 = 65536;
const BIT18 = 1 << 17;
const BIT19 = 1 << 18;
const BIT20 = 1 << 19;
const BIT21 = 1 << 20;
const BIT22 = 1 << 21;
const BIT23 = 1 << 22;
const BIT24 = 1 << 23;
const BIT25 = 1 << 24;
const BIT26 = 1 << 25;
const BIT27 = 1 << 26;
const BIT28 = 1 << 27;
const BIT29 = 1 << 28;
const BIT30 = 1 << 29;
const BIT31 = 1 << 30;
const BIT32 = 1 << 31;

/**
 * First n bits activated.
 *
 * @type {number}
 */
const BITS0 = 0;
const BITS1 = 1;
const BITS2 = 3;
const BITS3 = 7;
const BITS4 = 15;
const BITS5 = 31;
const BITS6 = 63;
const BITS7 = 127;
const BITS8 = 255;
const BITS9 = 511;
const BITS10 = 1023;
const BITS11 = 2047;
const BITS12 = 4095;
const BITS13 = 8191;
const BITS14 = 16383;
const BITS15 = 32767;
const BITS16 = 65535;
const BITS17 = BIT18 - 1;
const BITS18 = BIT19 - 1;
const BITS19 = BIT20 - 1;
const BITS20 = BIT21 - 1;
const BITS21 = BIT22 - 1;
const BITS22 = BIT23 - 1;
const BITS23 = BIT24 - 1;
const BITS24 = BIT25 - 1;
const BITS25 = BIT26 - 1;
const BITS26 = BIT27 - 1;
const BITS27 = BIT28 - 1;
const BITS28 = BIT29 - 1;
const BITS29 = BIT30 - 1;
const BITS30 = BIT31 - 1;
/**
 * @type {number}
 */
const BITS31 = 0x7FFFFFFF;
/**
 * @type {number}
 */
const BITS32 = 0xFFFFFFFF;

var binary = /*#__PURE__*/Object.freeze({
	__proto__: null,
	BIT1: BIT1,
	BIT2: BIT2,
	BIT3: BIT3,
	BIT4: BIT4,
	BIT5: BIT5,
	BIT6: BIT6,
	BIT7: BIT7,
	BIT8: BIT8,
	BIT9: BIT9,
	BIT10: BIT10,
	BIT11: BIT11,
	BIT12: BIT12,
	BIT13: BIT13,
	BIT14: BIT14,
	BIT15: BIT15,
	BIT16: BIT16,
	BIT17: BIT17,
	BIT18: BIT18,
	BIT19: BIT19,
	BIT20: BIT20,
	BIT21: BIT21,
	BIT22: BIT22,
	BIT23: BIT23,
	BIT24: BIT24,
	BIT25: BIT25,
	BIT26: BIT26,
	BIT27: BIT27,
	BIT28: BIT28,
	BIT29: BIT29,
	BIT30: BIT30,
	BIT31: BIT31,
	BIT32: BIT32,
	BITS0: BITS0,
	BITS1: BITS1,
	BITS2: BITS2,
	BITS3: BITS3,
	BITS4: BITS4,
	BITS5: BITS5,
	BITS6: BITS6,
	BITS7: BITS7,
	BITS8: BITS8,
	BITS9: BITS9,
	BITS10: BITS10,
	BITS11: BITS11,
	BITS12: BITS12,
	BITS13: BITS13,
	BITS14: BITS14,
	BITS15: BITS15,
	BITS16: BITS16,
	BITS17: BITS17,
	BITS18: BITS18,
	BITS19: BITS19,
	BITS20: BITS20,
	BITS21: BITS21,
	BITS22: BITS22,
	BITS23: BITS23,
	BITS24: BITS24,
	BITS25: BITS25,
	BITS26: BITS26,
	BITS27: BITS27,
	BITS28: BITS28,
	BITS29: BITS29,
	BITS30: BITS30,
	BITS31: BITS31,
	BITS32: BITS32
});

exports.BIT1 = BIT1;
exports.BIT10 = BIT10;
exports.BIT11 = BIT11;
exports.BIT12 = BIT12;
exports.BIT13 = BIT13;
exports.BIT14 = BIT14;
exports.BIT15 = BIT15;
exports.BIT16 = BIT16;
exports.BIT17 = BIT17;
exports.BIT18 = BIT18;
exports.BIT19 = BIT19;
exports.BIT2 = BIT2;
exports.BIT20 = BIT20;
exports.BIT21 = BIT21;
exports.BIT22 = BIT22;
exports.BIT23 = BIT23;
exports.BIT24 = BIT24;
exports.BIT25 = BIT25;
exports.BIT26 = BIT26;
exports.BIT27 = BIT27;
exports.BIT28 = BIT28;
exports.BIT29 = BIT29;
exports.BIT3 = BIT3;
exports.BIT30 = BIT30;
exports.BIT31 = BIT31;
exports.BIT32 = BIT32;
exports.BIT4 = BIT4;
exports.BIT5 = BIT5;
exports.BIT6 = BIT6;
exports.BIT7 = BIT7;
exports.BIT8 = BIT8;
exports.BIT9 = BIT9;
exports.BITS0 = BITS0;
exports.BITS1 = BITS1;
exports.BITS10 = BITS10;
exports.BITS11 = BITS11;
exports.BITS12 = BITS12;
exports.BITS13 = BITS13;
exports.BITS14 = BITS14;
exports.BITS15 = BITS15;
exports.BITS16 = BITS16;
exports.BITS17 = BITS17;
exports.BITS18 = BITS18;
exports.BITS19 = BITS19;
exports.BITS2 = BITS2;
exports.BITS20 = BITS20;
exports.BITS21 = BITS21;
exports.BITS22 = BITS22;
exports.BITS23 = BITS23;
exports.BITS24 = BITS24;
exports.BITS25 = BITS25;
exports.BITS26 = BITS26;
exports.BITS27 = BITS27;
exports.BITS28 = BITS28;
exports.BITS29 = BITS29;
exports.BITS3 = BITS3;
exports.BITS30 = BITS30;
exports.BITS31 = BITS31;
exports.BITS32 = BITS32;
exports.BITS4 = BITS4;
exports.BITS5 = BITS5;
exports.BITS6 = BITS6;
exports.BITS7 = BITS7;
exports.BITS8 = BITS8;
exports.BITS9 = BITS9;
exports.binary = binary;
//# sourceMappingURL=binary-ac8e39e2.cjs.map
