'use strict';

var math = require('./math-08e068f9.cjs');
var binary = require('./binary-ac8e39e2.cjs');

/**
 * Utility helpers for working with numbers.
 *
 * @module number
 */

const MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER;
const MIN_SAFE_INTEGER = Number.MIN_SAFE_INTEGER;

const LOWEST_INT32 = 1 << 31;
/**
 * @type {number}
 */
const HIGHEST_INT32 = binary.BITS31;

/**
 * @module number
 */

/* istanbul ignore next */
const isInteger = Number.isInteger || (num => typeof num === 'number' && isFinite(num) && math.floor(num) === num);
const isNaN = Number.isNaN;
const parseInt = Number.parseInt;

var number = /*#__PURE__*/Object.freeze({
	__proto__: null,
	MAX_SAFE_INTEGER: MAX_SAFE_INTEGER,
	MIN_SAFE_INTEGER: MIN_SAFE_INTEGER,
	LOWEST_INT32: LOWEST_INT32,
	HIGHEST_INT32: HIGHEST_INT32,
	isInteger: isInteger,
	isNaN: isNaN,
	parseInt: parseInt
});

exports.HIGHEST_INT32 = HIGHEST_INT32;
exports.LOWEST_INT32 = LOWEST_INT32;
exports.MAX_SAFE_INTEGER = MAX_SAFE_INTEGER;
exports.MIN_SAFE_INTEGER = MIN_SAFE_INTEGER;
exports.isInteger = isInteger;
exports.isNaN = isNaN;
exports.number = number;
exports.parseInt = parseInt;
//# sourceMappingURL=number-e62129bc.cjs.map
