'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _metadata2 = require('./metadata');

var _metadata3 = _interopRequireDefault(_metadata2);

var _isPossibleNumber_ = require('./isPossibleNumber_');

var _isPossibleNumber_2 = _interopRequireDefault(_isPossibleNumber_);

var _validate_ = require('./validate_');

var _validate_2 = _interopRequireDefault(_validate_);

var _isValidNumberForRegion_ = require('./isValidNumberForRegion_');

var _isValidNumberForRegion_2 = _interopRequireDefault(_isValidNumberForRegion_);

var _getNumberType_ = require('./getNumberType_');

var _getNumberType_2 = _interopRequireDefault(_getNumberType_);

var _format_ = require('./format_');

var _format_2 = _interopRequireDefault(_format_);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var PhoneNumber = function () {
	function PhoneNumber(countryCallingCode, nationalNumber, metadata) {
		_classCallCheck(this, PhoneNumber);

		if (!countryCallingCode) {
			throw new TypeError('`countryCallingCode` not passed');
		}
		if (!nationalNumber) {
			throw new TypeError('`nationalNumber` not passed');
		}
		// If country code is passed then derive `countryCallingCode` from it.
		// Also store the country code as `.country`.
		if (isCountryCode(countryCallingCode)) {
			this.country = countryCallingCode;
			var _metadata = new _metadata3.default(metadata);
			_metadata.country(countryCallingCode);
			countryCallingCode = _metadata.countryCallingCode();
		}
		this.countryCallingCode = countryCallingCode;
		this.nationalNumber = nationalNumber;
		this.number = '+' + this.countryCallingCode + this.nationalNumber;
		this.metadata = metadata;
	}

	_createClass(PhoneNumber, [{
		key: 'isPossible',
		value: function isPossible() {
			return (0, _isPossibleNumber_2.default)(this, { v2: true }, this.metadata);
		}
	}, {
		key: 'isValid',
		value: function isValid() {
			return (0, _validate_2.default)(this, { v2: true }, this.metadata);
		}

		// // Is just an alias for `this.isValid() && this.country === country`.
		// // https://github.com/googlei18n/libphonenumber/blob/master/FAQ.md#when-should-i-use-isvalidnumberforregion
		// isValidForRegion(country) {
		// 	return isValidNumberForRegion(this, country, { v2: true }, this.metadata)
		// }

	}, {
		key: 'getType',
		value: function getType() {
			return (0, _getNumberType_2.default)(this, { v2: true }, this.metadata);
		}
	}, {
		key: 'format',
		value: function format(_format, options) {
			return (0, _format_2.default)(this, _format, options ? _extends({}, options, { v2: true }) : { v2: true }, this.metadata);
		}
	}, {
		key: 'formatNational',
		value: function formatNational(options) {
			return this.format('NATIONAL', options);
		}
	}, {
		key: 'formatInternational',
		value: function formatInternational(options) {
			return this.format('INTERNATIONAL', options);
		}
	}, {
		key: 'getURI',
		value: function getURI(options) {
			return this.format('RFC3966', options);
		}
	}]);

	return PhoneNumber;
}();

exports.default = PhoneNumber;


var isCountryCode = function isCountryCode(value) {
	return (/^[A-Z]{2}$/.test(value)
	);
};
//# sourceMappingURL=PhoneNumber.js.map