var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import Metadata from './metadata';
import isPossibleNumber from './isPossibleNumber_';
import isValidNumber from './validate_';
import isValidNumberForRegion from './isValidNumberForRegion_';
import getNumberType from './getNumberType_';
import formatNumber from './format_';

var PhoneNumber = function () {
	function PhoneNumber(countryCallingCode, nationalNumber, metadata) {
		_classCallCheck(this, PhoneNumber);

		if (!countryCallingCode) {
			throw new TypeError('`countryCallingCode` not passed');
		}
		if (!nationalNumber) {
			throw new TypeError('`nationalNumber` not passed');
		}
		// If country code is passed then derive `countryCallingCode` from it.
		// Also store the country code as `.country`.
		if (isCountryCode(countryCallingCode)) {
			this.country = countryCallingCode;
			var _metadata = new Metadata(metadata);
			_metadata.country(countryCallingCode);
			countryCallingCode = _metadata.countryCallingCode();
		}
		this.countryCallingCode = countryCallingCode;
		this.nationalNumber = nationalNumber;
		this.number = '+' + this.countryCallingCode + this.nationalNumber;
		this.metadata = metadata;
	}

	_createClass(PhoneNumber, [{
		key: 'isPossible',
		value: function isPossible() {
			return isPossibleNumber(this, { v2: true }, this.metadata);
		}
	}, {
		key: 'isValid',
		value: function isValid() {
			return isValidNumber(this, { v2: true }, this.metadata);
		}

		// // Is just an alias for `this.isValid() && this.country === country`.
		// // https://github.com/googlei18n/libphonenumber/blob/master/FAQ.md#when-should-i-use-isvalidnumberforregion
		// isValidForRegion(country) {
		// 	return isValidNumberForRegion(this, country, { v2: true }, this.metadata)
		// }

	}, {
		key: 'getType',
		value: function getType() {
			return getNumberType(this, { v2: true }, this.metadata);
		}
	}, {
		key: 'format',
		value: function format(_format, options) {
			return formatNumber(this, _format, options ? _extends({}, options, { v2: true }) : { v2: true }, this.metadata);
		}
	}, {
		key: 'formatNational',
		value: function formatNational(options) {
			return this.format('NATIONAL', options);
		}
	}, {
		key: 'formatInternational',
		value: function formatInternational(options) {
			return this.format('INTERNATIONAL', options);
		}
	}, {
		key: 'getURI',
		value: function getURI(options) {
			return this.format('RFC3966', options);
		}
	}]);

	return PhoneNumber;
}();

export default PhoneNumber;


var isCountryCode = function isCountryCode(value) {
	return (/^[A-Z]{2}$/.test(value)
	);
};
//# sourceMappingURL=PhoneNumber.js.map