'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});
exports.default = parseNumber;

var _parse_ = require('./parse_');

var _parse_2 = _interopRequireDefault(_parse_);

var _parsePhoneNumber = require('./parsePhoneNumber');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// `options`:
//  {
//    country:
//    {
//      restrict - (a two-letter country code)
//                 the phone number must be in this country
//
//      default - (a two-letter country code)
//                default country to use for phone number parsing and validation
//                (if no country code could be derived from the phone number)
//    }
//  }
//
// Returns `{ country, number }`
//
// Example use cases:
//
// ```js
// parse('8 (800) 555-35-35', 'RU')
// parse('8 (800) 555-35-35', 'RU', metadata)
// parse('8 (800) 555-35-35', { country: { default: 'RU' } })
// parse('8 (800) 555-35-35', { country: { default: 'RU' } }, metadata)
// parse('+7 800 555 35 35')
// parse('+7 800 555 35 35', metadata)
// ```
//
function parseNumber() {
	var _normalizeArguments = (0, _parsePhoneNumber.normalizeArguments)(arguments),
	    text = _normalizeArguments.text,
	    options = _normalizeArguments.options,
	    metadata = _normalizeArguments.metadata;

	return (0, _parse_2.default)(text, options, metadata);
}
//# sourceMappingURL=parse.js.map