// Generated by dts-bundle-generator v7.2.0

/**
 * Represents a type of color.
 */
export declare enum ColorType {
	/** Solid color */
	Solid = "solid",
	/** Vertical gradient color */
	VerticalGradient = "gradient"
}
/**
 * Represents the crosshair mode.
 */
export declare enum CrosshairMode {
	/**
	 * This mode allows crosshair to move freely on the chart.
	 */
	Normal = 0,
	/**
	 * This mode sticks crosshair's horizontal line to the price value of a single-value series or to the close price of OHLC-based series.
	 */
	Magnet = 1
}
/**
 * Represents the type of the last price animation for series such as area or line.
 */
export declare enum LastPriceAnimationMode {
	/**
	 * Animation is always disabled
	 */
	Disabled = 0,
	/**
	 * Animation is always enabled.
	 */
	Continuous = 1,
	/**
	 * Animation is active after new data.
	 */
	OnDataUpdate = 2
}
/**
 * Represents the possible line styles.
 */
export declare enum LineStyle {
	/**
	 * A solid line.
	 */
	Solid = 0,
	/**
	 * A dotted line.
	 */
	Dotted = 1,
	/**
	 * A dashed line.
	 */
	Dashed = 2,
	/**
	 * A dashed line with bigger dashes.
	 */
	LargeDashed = 3,
	/**
	 * A dottled line with more space between dots.
	 */
	SparseDotted = 4
}
/**
 * Represents the possible line types.
 */
export declare enum LineType {
	/**
	 * A line.
	 */
	Simple = 0,
	/**
	 * A stepped line.
	 */
	WithSteps = 1,
	/**
	 * A curved line.
	 */
	Curved = 2
}
/**
 * Search direction if no data found at provided index
 */
export declare enum MismatchDirection {
	/**
	 * Search the nearest left item
	 */
	NearestLeft = -1,
	/**
	 * Do not search
	 */
	None = 0,
	/**
	 * Search the nearest right item
	 */
	NearestRight = 1
}
/**
 * Represents the source of data to be used for the horizontal price line.
 */
export declare enum PriceLineSource {
	/**
	 * Use the last bar data.
	 */
	LastBar = 0,
	/**
	 * Use the last visible data of the chart viewport.
	 */
	LastVisible = 1
}
/**
 * Represents the price scale mode.
 */
export declare enum PriceScaleMode {
	/**
	 * Price scale shows prices. Price range changes linearly.
	 */
	Normal = 0,
	/**
	 * Price scale shows prices. Price range changes logarithmically.
	 */
	Logarithmic = 1,
	/**
	 * Price scale shows percentage values according the first visible value of the price scale.
	 * The first visible value is 0% in this mode.
	 */
	Percentage = 2,
	/**
	 * The same as percentage mode, but the first value is moved to 100.
	 */
	IndexedTo100 = 3
}
/**
 * Represents the type of a tick mark on the time axis.
 */
export declare enum TickMarkType {
	/**
	 * The start of the year (e.g. it's the first tick mark in a year).
	 */
	Year = 0,
	/**
	 * The start of the month (e.g. it's the first tick mark in a month).
	 */
	Month = 1,
	/**
	 * A day of the month.
	 */
	DayOfMonth = 2,
	/**
	 * A time without seconds.
	 */
	Time = 3,
	/**
	 * A time with seconds.
	 */
	TimeWithSeconds = 4
}
/**
 * Determine how to exit the tracking mode.
 *
 * By default, mobile users will long press to deactivate the scroll and have the ability to check values and dates.
 * Another press is required to activate the scroll, be able to move left/right, zoom, etc.
 */
export declare enum TrackingModeExitMode {
	/**
	 * Tracking Mode will be deactivated on touch end event.
	 */
	OnTouchEnd = 0,
	/**
	 * Tracking Mode will be deactivated on the next tap event.
	 */
	OnNextTap = 1
}
/**
 * This function is the main entry point of the Lightweight Charting Library.
 *
 * @param container - ID of HTML element or element itself
 * @param options - Any subset of options to be applied at start.
 * @returns An interface to the created chart
 */
export declare function createChart(container: string | HTMLElement, options?: DeepPartial<ChartOptions>): IChartApi;
/**
 * Check if a time value is a business day object.
 *
 * @param time - The time to check.
 * @returns `true` if `time` is a {@link BusinessDay} object, false otherwise.
 */
export declare function isBusinessDay(time: Time): time is BusinessDay;
/**
 * Check if a time value is a UTC timestamp number.
 *
 * @param time - The time to check.
 * @returns `true` if `time` is a {@link UTCTimestamp} number, false otherwise.
 */
export declare function isUTCTimestamp(time: Time): time is UTCTimestamp;
/**
 * Returns the current version as a string. For example `'3.3.0'`.
 */
export declare function version(): string;
/**
 * Structure describing a single item of data for area series
 */
export interface AreaData extends SingleValueData {
	/**
	 * Optional line color value for certain data item. If missed, color from options is used
	 */
	lineColor?: string;
	/**
	 * Optional top color value for certain data item. If missed, color from options is used
	 */
	topColor?: string;
	/**
	 * Optional bottom color value for certain data item. If missed, color from options is used
	 */
	bottomColor?: string;
}
/**
 * Represents style options for an area series.
 */
export interface AreaStyleOptions {
	/**
	 * Color of the top part of the area.
	 *
	 * @defaultValue `'rgba( 46, 220, 135, 0.4)'`
	 */
	topColor: string;
	/**
	 * Color of the bottom part of the area.
	 *
	 * @defaultValue `'rgba( 40, 221, 100, 0)'`
	 */
	bottomColor: string;
	/**
	 * Invert the filled area. Fills the area above the line if set to true.
	 *
	 * @defaultValue `false`
	 */
	invertFilledArea: boolean;
	/**
	 * Line color.
	 *
	 * @defaultValue `'#33D778'`
	 */
	lineColor: string;
	/**
	 * Line style.
	 *
	 * @defaultValue {@link LineStyle.Solid}
	 */
	lineStyle: LineStyle;
	/**
	 * Line width in pixels.
	 *
	 * @defaultValue `3`
	 */
	lineWidth: LineWidth;
	/**
	 * Line type.
	 *
	 * @defaultValue {@link LineType.Simple}
	 */
	lineType: LineType;
	/**
	 * Show the crosshair marker.
	 *
	 * @defaultValue `true`
	 */
	crosshairMarkerVisible: boolean;
	/**
	 * Crosshair marker radius in pixels.
	 *
	 * @defaultValue `4`
	 */
	crosshairMarkerRadius: number;
	/**
	 * Crosshair marker border color. An empty string falls back to the the color of the series under the crosshair.
	 *
	 * @defaultValue `''`
	 */
	crosshairMarkerBorderColor: string;
	/**
	 * The crosshair marker background color. An empty string falls back to the the color of the series under the crosshair.
	 *
	 * @defaultValue `''`
	 */
	crosshairMarkerBackgroundColor: string;
	/**
	 * Crosshair marker border width in pixels.
	 *
	 * @defaultValue `2`
	 */
	crosshairMarkerBorderWidth: number;
	/**
	 * Last price animation mode.
	 *
	 * @defaultValue {@link LastPriceAnimationMode.Disabled}
	 */
	lastPriceAnimation: LastPriceAnimationMode;
}
/**
 * Represents the margin used when updating a price scale.
 */
export interface AutoScaleMargins {
	/** The number of pixels for bottom margin */
	below: number;
	/** The number of pixels for top margin */
	above: number;
}
/**
 * Represents information used to update a price scale.
 */
export interface AutoscaleInfo {
	/**
	 * Price range.
	 */
	priceRange: PriceRange;
	/**
	 * Scale margins.
	 */
	margins?: AutoScaleMargins;
}
/**
 * Represents options for how the time and price axes react to mouse double click.
 */
export interface AxisDoubleClickOptions {
	/**
	 * Enable resetting scaling the time axis by double-clicking the left mouse button.
	 *
	 * @defaultValue `true`
	 */
	time: boolean;
	/**
	 * Enable reseting scaling the price axis by by double-clicking the left mouse button.
	 *
	 * @defaultValue `true`
	 */
	price: boolean;
}
/**
 * Represents options for how the time and price axes react to mouse movements.
 */
export interface AxisPressedMouseMoveOptions {
	/**
	 * Enable scaling the time axis by holding down the left mouse button and moving the mouse.
	 *
	 * @defaultValue `true`
	 */
	time: boolean;
	/**
	 * Enable scaling the price axis by holding down the left mouse button and moving the mouse.
	 *
	 * @defaultValue `true`
	 */
	price: boolean;
}
/**
 * Structure describing a single item of data for bar series
 */
export interface BarData extends OhlcData {
	/**
	 * Optional color value for certain data item. If missed, color from options is used
	 */
	color?: string;
}
/**
 * Represents style options for a bar series.
 */
export interface BarStyleOptions {
	/**
	 * Color of rising bars.
	 *
	 * @defaultValue `'#26a69a'`
	 */
	upColor: string;
	/**
	 * Color of falling bars.
	 *
	 * @defaultValue `'#ef5350'`
	 */
	downColor: string;
	/**
	 * Show open lines on bars.
	 *
	 * @defaultValue `true`
	 */
	openVisible: boolean;
	/**
	 * Show bars as sticks.
	 *
	 * @defaultValue `true`
	 */
	thinBars: boolean;
}
/**
 * Represents a range of bars and the number of bars outside the range.
 */
export interface BarsInfo extends Partial<Range<Time>> {
	/**
	 * The number of bars before the start of the range.
	 * Positive value means that there are some bars before (out of logical range from the left) the {@link Range.from} logical index in the series.
	 * Negative value means that the first series' bar is inside the passed logical range, and between the first series' bar and the {@link Range.from} logical index are some bars.
	 */
	barsBefore: number;
	/**
	 * The number of bars after the end of the range.
	 * Positive value in the `barsAfter` field means that there are some bars after (out of logical range from the right) the {@link Range.to} logical index in the series.
	 * Negative value means that the last series' bar is inside the passed logical range, and between the last series' bar and the {@link Range.to} logical index are some bars.
	 */
	barsAfter: number;
}
/**
 * Represents a type of priced base value of baseline series type.
 */
export interface BaseValuePrice {
	/**
	 * Distinguished type value.
	 */
	type: "price";
	/**
	 * Price value.
	 */
	price: number;
}
/**
 * Structure describing a single item of data for baseline series
 */
export interface BaselineData extends SingleValueData {
	/**
	 * Optional top area top fill color value for certain data item. If missed, color from options is used
	 */
	topFillColor1?: string;
	/**
	 * Optional top area bottom fill color value for certain data item. If missed, color from options is used
	 */
	topFillColor2?: string;
	/**
	 * Optional top area line color value for certain data item. If missed, color from options is used
	 */
	topLineColor?: string;
	/**
	 * Optional bottom area top fill color value for certain data item. If missed, color from options is used
	 */
	bottomFillColor1?: string;
	/**
	 * Optional bottom area bottom fill color value for certain data item. If missed, color from options is used
	 */
	bottomFillColor2?: string;
	/**
	 * Optional bottom area line color value for certain data item. If missed, color from options is used
	 */
	bottomLineColor?: string;
}
/**
 * Represents style options for a baseline series.
 */
export interface BaselineStyleOptions {
	/**
	 * Base value of the series.
	 *
	 * @defaultValue `{ type: 'price', price: 0 }`
	 */
	baseValue: BaseValueType;
	/**
	 * The first color of the top area.
	 *
	 * @defaultValue `'rgba(38, 166, 154, 0.28)'`
	 */
	topFillColor1: string;
	/**
	 * The second color of the top area.
	 *
	 * @defaultValue `'rgba(38, 166, 154, 0.05)'`
	 */
	topFillColor2: string;
	/**
	 * The line color of the top area.
	 *
	 * @defaultValue `'rgba(38, 166, 154, 1)'`
	 */
	topLineColor: string;
	/**
	 * The first color of the bottom area.
	 *
	 * @defaultValue `'rgba(239, 83, 80, 0.05)'`
	 */
	bottomFillColor1: string;
	/**
	 * The second color of the bottom area.
	 *
	 * @defaultValue `'rgba(239, 83, 80, 0.28)'`
	 */
	bottomFillColor2: string;
	/**
	 * The line color of the bottom area.
	 *
	 * @defaultValue `'rgba(239, 83, 80, 1)'`
	 */
	bottomLineColor: string;
	/**
	 * Line width.
	 *
	 * @defaultValue `3`
	 */
	lineWidth: LineWidth;
	/**
	 * Line style.
	 *
	 * @defaultValue {@link LineStyle.Solid}
	 */
	lineStyle: LineStyle;
	/**
	 * Line type.
	 *
	 * @defaultValue {@link LineType.Simple}
	 */
	lineType: LineType;
	/**
	 * Show the crosshair marker.
	 *
	 * @defaultValue `true`
	 */
	crosshairMarkerVisible: boolean;
	/**
	 * Crosshair marker radius in pixels.
	 *
	 * @defaultValue `4`
	 */
	crosshairMarkerRadius: number;
	/**
	 * Crosshair marker border color. An empty string falls back to the the color of the series under the crosshair.
	 *
	 * @defaultValue `''`
	 */
	crosshairMarkerBorderColor: string;
	/**
	 * The crosshair marker background color. An empty string falls back to the the color of the series under the crosshair.
	 *
	 * @defaultValue `''`
	 */
	crosshairMarkerBackgroundColor: string;
	/**
	 * Crosshair marker border width in pixels.
	 *
	 * @defaultValue `2`
	 */
	crosshairMarkerBorderWidth: number;
	/**
	 * Last price animation mode.
	 *
	 * @defaultValue {@link LastPriceAnimationMode.Disabled}
	 */
	lastPriceAnimation: LastPriceAnimationMode;
}
/**
 * Represents a time as a day/month/year.
 *
 * @example
 * ```js
 * const day = { year: 2019, month: 6, day: 1 }; // June 1, 2019
 * ```
 */
export interface BusinessDay {
	/**
	 * The year.
	 */
	year: number;
	/**
	 * The month.
	 */
	month: number;
	/**
	 * The day.
	 */
	day: number;
}
/**
 * Structure describing a single item of data for candlestick series
 */
export interface CandlestickData extends OhlcData {
	/**
	 * Optional color value for certain data item. If missed, color from options is used
	 */
	color?: string;
	/**
	 * Optional border color value for certain data item. If missed, color from options is used
	 */
	borderColor?: string;
	/**
	 * Optional wick color value for certain data item. If missed, color from options is used
	 */
	wickColor?: string;
}
/**
 * Represents style options for a candlestick series.
 */
export interface CandlestickStyleOptions {
	/**
	 * Color of rising candles.
	 *
	 * @defaultValue `'#26a69a'`
	 */
	upColor: string;
	/**
	 * Color of falling candles.
	 *
	 * @defaultValue `'#ef5350'`
	 */
	downColor: string;
	/**
	 * Enable high and low prices candle wicks.
	 *
	 * @defaultValue `true`
	 */
	wickVisible: boolean;
	/**
	 * Enable candle borders.
	 *
	 * @defaultValue `true`
	 */
	borderVisible: boolean;
	/**
	 * Border color.
	 *
	 * @defaultValue `'#378658'`
	 */
	borderColor: string;
	/**
	 * Border color of rising candles.
	 *
	 * @defaultValue `'#26a69a'`
	 */
	borderUpColor: string;
	/**
	 * Border color of falling candles.
	 *
	 * @defaultValue `'#ef5350'`
	 */
	borderDownColor: string;
	/**
	 * Wick color.
	 *
	 * @defaultValue `'#737375'`
	 */
	wickColor: string;
	/**
	 * Wick color of rising candles.
	 *
	 * @defaultValue `'#26a69a'`
	 */
	wickUpColor: string;
	/**
	 * Wick color of falling candles.
	 *
	 * @defaultValue `'#ef5350'`
	 */
	wickDownColor: string;
}
/**
 * Structure describing options of the chart. Series options are to be set separately
 */
export interface ChartOptions {
	/**
	 * Width of the chart in pixels
	 *
	 * @defaultValue If `0` (default) or none value provided, then a size of the widget will be calculated based its container's size.
	 */
	width: number;
	/**
	 * Height of the chart in pixels
	 *
	 * @defaultValue If `0` (default) or none value provided, then a size of the widget will be calculated based its container's size.
	 */
	height: number;
	/**
	 * Setting this flag to `true` will make the chart watch the chart container's size and automatically resize the chart to fit its container whenever the size changes.
	 *
	 * This feature requires [`ResizeObserver`](https://developer.mozilla.org/en-US/docs/Web/API/ResizeObserver) class to be available in the global scope.
	 * Note that calling code is responsible for providing a polyfill if required. If the global scope does not have `ResizeObserver`, a warning will appear and the flag will be ignored.
	 *
	 * Please pay attention that `autoSize` option and explicit sizes options `width` and `height` don't conflict with one another.
	 * If you specify `autoSize` flag, then `width` and `height` options will be ignored unless `ResizeObserver` has failed. If it fails then the values will be used as fallback.
	 *
	 * The flag `autoSize` could also be set with and unset with `applyOptions` function.
	 * ```js
	 * const chart = LightweightCharts.createChart(document.body, {
	 *     autoSize: true,
	 * });
	 * ```
	 */
	autoSize: boolean;
	/**
	 * Watermark options.
	 *
	 * A watermark is a background label that includes a brief description of the drawn data. Any text can be added to it.
	 *
	 * Please make sure you enable it and set an appropriate font color and size to make your watermark visible in the background of the chart.
	 * We recommend a semi-transparent color and a large font. Also note that watermark position can be aligned vertically and horizontally.
	 */
	watermark: WatermarkOptions;
	/**
	 * Layout options
	 */
	layout: LayoutOptions;
	/**
	 * Left price scale options
	 */
	leftPriceScale: VisiblePriceScaleOptions;
	/**
	 * Right price scale options
	 */
	rightPriceScale: VisiblePriceScaleOptions;
	/**
	 * Overlay price scale options
	 */
	overlayPriceScales: OverlayPriceScaleOptions;
	/**
	 * Time scale options
	 */
	timeScale: TimeScaleOptions;
	/**
	 * The crosshair shows the intersection of the price and time scale values at any point on the chart.
	 *
	 */
	crosshair: CrosshairOptions;
	/**
	 * A grid is represented in the chart background as a vertical and horizontal lines drawn at the levels of visible marks of price and the time scales.
	 */
	grid: GridOptions;
	/**
	 * Localization options.
	 */
	localization: LocalizationOptions;
	/**
	 * Scroll options, or a boolean flag that enables/disables scrolling
	 */
	handleScroll: HandleScrollOptions | boolean;
	/**
	 * Scale options, or a boolean flag that enables/disables scaling
	 */
	handleScale: HandleScaleOptions | boolean;
	/**
	 * Kinetic scroll options
	 */
	kineticScroll: KineticScrollOptions;
	/** @inheritDoc TrackingModeOptions
	 */
	trackingMode: TrackingModeOptions;
}
/** Structure describing a crosshair line (vertical or horizontal) */
export interface CrosshairLineOptions {
	/**
	 * Crosshair line color.
	 *
	 * @defaultValue `'#758696'`
	 */
	color: string;
	/**
	 * Crosshair line width.
	 *
	 * @defaultValue `1`
	 */
	width: LineWidth;
	/**
	 * Crosshair line style.
	 *
	 * @defaultValue {@link LineStyle.LargeDashed}
	 */
	style: LineStyle;
	/**
	 * Display the crosshair line.
	 *
	 * Note that disabling crosshair lines does not disable crosshair marker on Line and Area series.
	 * It can be disabled by using `crosshairMarkerVisible` option of a relevant series.
	 *
	 * @see {@link LineStyleOptions.crosshairMarkerVisible}
	 * @see {@link AreaStyleOptions.crosshairMarkerVisible}
	 * @see {@link BaselineStyleOptions.crosshairMarkerVisible}
	 * @defaultValue `true`
	 */
	visible: boolean;
	/**
	 * Display the crosshair label on the relevant scale.
	 *
	 * @defaultValue `true`
	 */
	labelVisible: boolean;
	/**
	 * Crosshair label background color.
	 *
	 * @defaultValue `'#4c525e'`
	 */
	labelBackgroundColor: string;
}
/** Structure describing crosshair options  */
export interface CrosshairOptions {
	/**
	 * Crosshair mode
	 *
	 * @defaultValue {@link CrosshairMode.Magnet}
	 */
	mode: CrosshairMode;
	/**
	 * Vertical line options.
	 */
	vertLine: CrosshairLineOptions;
	/**
	 * Horizontal line options.
	 */
	horzLine: CrosshairLineOptions;
}
/** Grid line options. */
export interface GridLineOptions {
	/**
	 * Line color.
	 *
	 * @defaultValue `'#D6DCDE'`
	 */
	color: string;
	/**
	 * Line style.
	 *
	 * @defaultValue {@link LineStyle.Solid}
	 */
	style: LineStyle;
	/**
	 * Display the lines.
	 *
	 * @defaultValue `true`
	 */
	visible: boolean;
}
/** Structure describing grid options. */
export interface GridOptions {
	/**
	 * Vertical grid line options.
	 */
	vertLines: GridLineOptions;
	/**
	 * Horizontal grid line options.
	 */
	horzLines: GridLineOptions;
}
/**
 * Represents options for how the chart is scaled by the mouse and touch gestures.
 */
export interface HandleScaleOptions {
	/**
	 * Enable scaling with the mouse wheel.
	 *
	 * @defaultValue `true`
	 */
	mouseWheel: boolean;
	/**
	 * Enable scaling with pinch/zoom gestures.
	 *
	 * @defaultValue `true`
	 */
	pinch: boolean;
	/**
	 * Enable scaling the price and/or time scales by holding down the left mouse button and moving the mouse.
	 */
	axisPressedMouseMove: AxisPressedMouseMoveOptions | boolean;
	/**
	 * Enable resetting scaling by double-clicking the left mouse button.
	 */
	axisDoubleClickReset: AxisDoubleClickOptions | boolean;
}
/**
 * Represents options for how the chart is scrolled by the mouse and touch gestures.
 */
export interface HandleScrollOptions {
	/**
	 * Enable scrolling with the mouse wheel.
	 *
	 * @defaultValue `true`
	 */
	mouseWheel: boolean;
	/**
	 * Enable scrolling by holding down the left mouse button and moving the mouse.
	 *
	 * @defaultValue `true`
	 */
	pressedMouseMove: boolean;
	/**
	 * Enable horizontal touch scrolling.
	 *
	 * When enabled the chart handles touch gestures that would normally scroll the webpage horizontally.
	 *
	 * @defaultValue `true`
	 */
	horzTouchDrag: boolean;
	/**
	 * Enable vertical touch scrolling.
	 *
	 * When enabled the chart handles touch gestures that would normally scroll the webpage vertically.
	 *
	 * @defaultValue `true`
	 */
	vertTouchDrag: boolean;
}
/**
 * Structure describing a single item of data for histogram series
 */
export interface HistogramData extends SingleValueData {
	/**
	 * Optional color value for certain data item. If missed, color from options is used
	 */
	color?: string;
}
/**
 * Represents style options for a histogram series.
 */
export interface HistogramStyleOptions {
	/**
	 * Column color.
	 *
	 * @defaultValue `'#26a69a'`
	 */
	color: string;
	/**
	 * Initial level of histogram columns.
	 *
	 * @defaultValue `0`
	 */
	base: number;
}
/**
 * The main interface of a single chart.
 */
export interface IChartApi {
	/**
	 * Removes the chart object including all DOM elements. This is an irreversible operation, you cannot do anything with the chart after removing it.
	 */
	remove(): void;
	/**
	 * Sets fixed size of the chart. By default chart takes up 100% of its container.
	 *
	 * If chart has the `autoSize` option enabled, and the ResizeObserver is available then
	 * the width and height values will be ignored.
	 *
	 * @param width - Target width of the chart.
	 * @param height - Target height of the chart.
	 * @param forceRepaint - True to initiate resize immediately. One could need this to get screenshot immediately after resize.
	 */
	resize(width: number, height: number, forceRepaint?: boolean): void;
	/**
	 * Creates an area series with specified parameters.
	 *
	 * @param areaOptions - Customization parameters of the series being created.
	 * @returns An interface of the created series.
	 * @example
	 * ```js
	 * const series = chart.addAreaSeries();
	 * ```
	 */
	addAreaSeries(areaOptions?: AreaSeriesPartialOptions): ISeriesApi<"Area">;
	/**
	 * Creates a baseline series with specified parameters.
	 *
	 * @param baselineOptions - Customization parameters of the series being created.
	 * @returns An interface of the created series.
	 * @example
	 * ```js
	 * const series = chart.addBaselineSeries();
	 * ```
	 */
	addBaselineSeries(baselineOptions?: BaselineSeriesPartialOptions): ISeriesApi<"Baseline">;
	/**
	 * Creates a bar series with specified parameters.
	 *
	 * @param barOptions - Customization parameters of the series being created.
	 * @returns An interface of the created series.
	 * @example
	 * ```js
	 * const series = chart.addBarSeries();
	 * ```
	 */
	addBarSeries(barOptions?: BarSeriesPartialOptions): ISeriesApi<"Bar">;
	/**
	 * Creates a candlestick series with specified parameters.
	 *
	 * @param candlestickOptions - Customization parameters of the series being created.
	 * @returns An interface of the created series.
	 * @example
	 * ```js
	 * const series = chart.addCandlestickSeries();
	 * ```
	 */
	addCandlestickSeries(candlestickOptions?: CandlestickSeriesPartialOptions): ISeriesApi<"Candlestick">;
	/**
	 * Creates a histogram series with specified parameters.
	 *
	 * @param histogramOptions - Customization parameters of the series being created.
	 * @returns An interface of the created series.
	 * @example
	 * ```js
	 * const series = chart.addHistogramSeries();
	 * ```
	 */
	addHistogramSeries(histogramOptions?: HistogramSeriesPartialOptions): ISeriesApi<"Histogram">;
	/**
	 * Creates a line series with specified parameters.
	 *
	 * @param lineOptions - Customization parameters of the series being created.
	 * @returns An interface of the created series.
	 * @example
	 * ```js
	 * const series = chart.addLineSeries();
	 * ```
	 */
	addLineSeries(lineOptions?: LineSeriesPartialOptions): ISeriesApi<"Line">;
	/**
	 * Removes a series of any type. This is an irreversible operation, you cannot do anything with the series after removing it.
	 *
	 * @example
	 * ```js
	 * chart.removeSeries(series);
	 * ```
	 */
	removeSeries(seriesApi: ISeriesApi<SeriesType>): void;
	/**
	 * Subscribe to the chart click event.
	 *
	 * @param handler - Handler to be called on mouse click.
	 * @example
	 * ```js
	 * function myClickHandler(param) {
	 *     if (!param.point) {
	 *         return;
	 *     }
	 *
	 *     console.log(`Click at ${param.point.x}, ${param.point.y}. The time is ${param.time}.`);
	 * }
	 *
	 * chart.subscribeClick(myClickHandler);
	 * ```
	 */
	subscribeClick(handler: MouseEventHandler): void;
	/**
	 * Unsubscribe a handler that was previously subscribed using {@link subscribeClick}.
	 *
	 * @param handler - Previously subscribed handler
	 * @example
	 * ```js
	 * chart.unsubscribeClick(myClickHandler);
	 * ```
	 */
	unsubscribeClick(handler: MouseEventHandler): void;
	/**
	 * Subscribe to the crosshair move event.
	 *
	 * @param handler - Handler to be called on crosshair move.
	 * @example
	 * ```js
	 * function myCrosshairMoveHandler(param) {
	 *     if (!param.point) {
	 *         return;
	 *     }
	 *
	 *     console.log(`Crosshair moved to ${param.point.x}, ${param.point.y}. The time is ${param.time}.`);
	 * }
	 *
	 * chart.subscribeCrosshairMove(myCrosshairMoveHandler);
	 * ```
	 */
	subscribeCrosshairMove(handler: MouseEventHandler): void;
	/**
	 * Unsubscribe a handler that was previously subscribed using {@link subscribeCrosshairMove}.
	 *
	 * @param handler - Previously subscribed handler
	 * @example
	 * ```js
	 * chart.unsubscribeCrosshairMove(myCrosshairMoveHandler);
	 * ```
	 */
	unsubscribeCrosshairMove(handler: MouseEventHandler): void;
	/**
	 * Returns API to manipulate a price scale.
	 *
	 * @param priceScaleId - ID of the price scale.
	 * @returns Price scale API.
	 */
	priceScale(priceScaleId: string): IPriceScaleApi;
	/**
	 * Returns API to manipulate the time scale
	 *
	 * @returns Target API
	 */
	timeScale(): ITimeScaleApi;
	/**
	 * Applies new options to the chart
	 *
	 * @param options - Any subset of options.
	 */
	applyOptions(options: DeepPartial<ChartOptions>): void;
	/**
	 * Returns currently applied options
	 *
	 * @returns Full set of currently applied options, including defaults
	 */
	options(): Readonly<ChartOptions>;
	/**
	 * Make a screenshot of the chart with all the elements excluding crosshair.
	 *
	 * @returns A canvas with the chart drawn on. Any `Canvas` methods like `toDataURL()` or `toBlob()` can be used to serialize the result.
	 */
	takeScreenshot(): HTMLCanvasElement;
	/**
	 * Returns the active state of the `autoSize` option. This can be used to check
	 * whether the chart is handling resizing automatically with a `ResizeObserver`.
	 *
	 * @returns Whether the `autoSize` option is enabled and the active.
	 */
	autoSizeActive(): boolean;
}
/** Interface to be implemented by the object in order to be used as a price formatter */
export interface IPriceFormatter {
	/**
	 * Formatting function
	 *
	 * @param price - Original price to be formatted
	 * @returns Formatted price
	 */
	format(price: number): string;
}
/**
 * Represents the interface for interacting with price lines.
 */
export interface IPriceLine {
	/**
	 * Apply options to the price line.
	 *
	 * @param options - Any subset of options.
	 * @example
	 * ```js
	 * priceLine.applyOptions({
	 *     price: 90.0,
	 *     color: 'red',
	 *     lineWidth: 3,
	 *     lineStyle: LightweightCharts.LineStyle.Dashed,
	 *     axisLabelVisible: false,
	 *     title: 'P/L 600',
	 * });
	 * ```
	 */
	applyOptions(options: Partial<PriceLineOptions>): void;
	/**
	 * Get the currently applied options.
	 */
	options(): Readonly<PriceLineOptions>;
}
/** Interface to control chart's price scale */
export interface IPriceScaleApi {
	/**
	 * Applies new options to the price scale
	 *
	 * @param options - Any subset of options.
	 */
	applyOptions(options: DeepPartial<PriceScaleOptions>): void;
	/**
	 * Returns currently applied options of the price scale
	 *
	 * @returns Full set of currently applied options, including defaults
	 */
	options(): Readonly<PriceScaleOptions>;
	/**
	 * Returns a width of the price scale if it's visible or 0 if invisible.
	 */
	width(): number;
}
/**
 * Represents the interface for interacting with series.
 */
export interface ISeriesApi<TSeriesType extends SeriesType> {
	/**
	 * Returns current price formatter
	 *
	 * @returns Interface to the price formatter object that can be used to format prices in the same way as the chart does
	 */
	priceFormatter(): IPriceFormatter;
	/**
	 * Converts specified series price to pixel coordinate according to the series price scale
	 *
	 * @param price - Input price to be converted
	 * @returns Pixel coordinate of the price level on the chart
	 */
	priceToCoordinate(price: number): Coordinate | null;
	/**
	 * Converts specified coordinate to price value according to the series price scale
	 *
	 * @param coordinate - Input coordinate to be converted
	 * @returns Price value of the coordinate on the chart
	 */
	coordinateToPrice(coordinate: number): BarPrice | null;
	/**
	 * Returns bars information for the series in the provided [logical range](/time-scale.md#logical-range) or `null`, if no series data has been found in the requested range.
	 * This method can be used, for instance, to implement downloading historical data while scrolling to prevent a user from seeing empty space.
	 *
	 * @param range - The [logical range](/time-scale.md#logical-range) to retrieve info for.
	 * @returns The bars info for the given logical range.
	 * @example Getting bars info for current visible range
	 * ```js
	 * const barsInfo = series.barsInLogicalRange(chart.timeScale().getVisibleLogicalRange());
	 * console.log(barsInfo);
	 * ```
	 * @example Implementing downloading historical data while scrolling
	 * ```js
	 * function onVisibleLogicalRangeChanged(newVisibleLogicalRange) {
	 *     const barsInfo = series.barsInLogicalRange(newVisibleLogicalRange);
	 *     // if there less than 50 bars to the left of the visible area
	 *     if (barsInfo !== null && barsInfo.barsBefore < 50) {
	 *         // try to load additional historical data and prepend it to the series data
	 *     }
	 * }
	 *
	 * chart.timeScale().subscribeVisibleLogicalRangeChange(onVisibleLogicalRangeChanged);
	 * ```
	 */
	barsInLogicalRange(range: Range<number>): BarsInfo | null;
	/**
	 * Applies new options to the existing series
	 * You can set options initially when you create series or use the `applyOptions` method of the series to change the existing options.
	 * Note that you can only pass options you want to change.
	 *
	 * @param options - Any subset of options.
	 */
	applyOptions(options: SeriesPartialOptionsMap[TSeriesType]): void;
	/**
	 * Returns currently applied options
	 *
	 * @returns Full set of currently applied options, including defaults
	 */
	options(): Readonly<SeriesOptionsMap[TSeriesType]>;
	/**
	 * Returns interface of the price scale the series is currently attached
	 *
	 * @returns IPriceScaleApi object to control the price scale
	 */
	priceScale(): IPriceScaleApi;
	/**
	 * Sets or replaces series data.
	 *
	 * @param data - Ordered (earlier time point goes first) array of data items. Old data is fully replaced with the new one.
	 * @example Setting data to a line series
	 * ```js
	 * lineSeries.setData([
	 *     { time: '2018-12-12', value: 24.11 },
	 *     { time: '2018-12-13', value: 31.74 },
	 * ]);
	 * ```
	 * @example Setting data to a bars (or candlestick) series
	 * ```js
	 * barSeries.setData([
	 *     { time: '2018-12-19', open: 141.77, high: 170.39, low: 120.25, close: 145.72 },
	 *     { time: '2018-12-20', open: 145.72, high: 147.99, low: 100.11, close: 108.19 },
	 * ]);
	 * ```
	 */
	setData(data: SeriesDataItemTypeMap[TSeriesType][]): void;
	/**
	 * Adds new data item to the existing set (or updates the latest item if times of the passed/latest items are equal).
	 *
	 * @param bar - A single data item to be added. Time of the new item must be greater or equal to the latest existing time point.
	 * If the new item's time is equal to the last existing item's time, then the existing item is replaced with the new one.
	 * @example Updating line series data
	 * ```js
	 * lineSeries.update({
	 *     time: '2018-12-12',
	 *     value: 24.11,
	 * });
	 * ```
	 * @example Updating bar (or candlestick) series data
	 * ```js
	 * barSeries.update({
	 *     time: '2018-12-19',
	 *     open: 141.77,
	 *     high: 170.39,
	 *     low: 120.25,
	 *     close: 145.72,
	 * });
	 * ```
	 */
	update(bar: SeriesDataItemTypeMap[TSeriesType]): void;
	/**
	 * Returns a bar data by provided logical index.
	 *
	 * @param logicalIndex - Logical index
	 * @param mismatchDirection - Search direction if no data found at provided logical index.
	 * @returns Original data item provided via setData or update methods.
	 * @example
	 * ```js
	 * const originalData = series.dataByIndex(10, LightweightCharts.MismatchDirection.NearestLeft);
	 * ```
	 */
	dataByIndex(logicalIndex: number, mismatchDirection?: MismatchDirection): SeriesDataItemTypeMap[TSeriesType] | null;
	/**
	 * Allows to set/replace all existing series markers with new ones.
	 *
	 * @param data - An array of series markers. This array should be sorted by time. Several markers with same time are allowed.
	 * @example
	 * ```js
	 * series.setMarkers([
	 *     {
	 *         time: '2019-04-09',
	 *         position: 'aboveBar',
	 *         color: 'black',
	 *         shape: 'arrowDown',
	 *     },
	 *     {
	 *         time: '2019-05-31',
	 *         position: 'belowBar',
	 *         color: 'red',
	 *         shape: 'arrowUp',
	 *         id: 'id3',
	 *     },
	 *     {
	 *         time: '2019-05-31',
	 *         position: 'belowBar',
	 *         color: 'orange',
	 *         shape: 'arrowUp',
	 *         id: 'id4',
	 *         text: 'example',
	 *         size: 2,
	 *     },
	 * ]);
	 *
	 * chart.subscribeCrosshairMove(param => {
	 *     console.log(param.hoveredObjectId);
	 * });
	 *
	 * chart.subscribeClick(param => {
	 *     console.log(param.hoveredObjectId);
	 * });
	 * ```
	 */
	setMarkers(data: SeriesMarker<Time>[]): void;
	/**
	 * Returns an array of series markers.
	 */
	markers(): SeriesMarker<Time>[];
	/**
	 * Creates a new price line
	 *
	 * @param options - Any subset of options, however `price` is required.
	 * @example
	 * ```js
	 * const priceLine = series.createPriceLine({
	 *     price: 80.0,
	 *     color: 'green',
	 *     lineWidth: 2,
	 *     lineStyle: LightweightCharts.LineStyle.Dotted,
	 *     axisLabelVisible: true,
	 *     title: 'P/L 500',
	 * });
	 * ```
	 */
	createPriceLine(options: CreatePriceLineOptions): IPriceLine;
	/**
	 * Removes the price line that was created before.
	 *
	 * @param line - A line to remove.
	 * @example
	 * ```js
	 * const priceLine = series.createPriceLine({ price: 80.0 });
	 * series.removePriceLine(priceLine);
	 * ```
	 */
	removePriceLine(line: IPriceLine): void;
	/**
	 * Return current series type.
	 *
	 * @returns Type of the series.
	 * @example
	 * ```js
	 * const lineSeries = chart.addLineSeries();
	 * console.log(lineSeries.seriesType()); // "Line"
	 *
	 * const candlestickSeries = chart.addCandlestickSeries();
	 * console.log(candlestickSeries.seriesType()); // "Candlestick"
	 * ```
	 */
	seriesType(): TSeriesType;
}
/** Interface to chart time scale */
export interface ITimeScaleApi {
	/**
	 * Return the distance from the right edge of the time scale to the lastest bar of the series measured in bars.
	 */
	scrollPosition(): number;
	/**
	 * Scrolls the chart to the specified position.
	 *
	 * @param position - Target data position
	 * @param animated - Setting this to true makes the chart scrolling smooth and adds animation
	 */
	scrollToPosition(position: number, animated: boolean): void;
	/**
	 * Restores default scroll position of the chart. This process is always animated.
	 */
	scrollToRealTime(): void;
	/**
	 * Returns current visible time range of the chart.
	 *
	 * Note that this method cannot extrapolate time and will use the only currently existent data.
	 * To get complete information about current visible range, please use {@link getVisibleLogicalRange} and {@link ISeriesApi.barsInLogicalRange}.
	 *
	 * @returns Visible range or null if the chart has no data at all.
	 */
	getVisibleRange(): TimeRange | null;
	/**
	 * Sets visible range of data.
	 *
	 * Note that this method cannot extrapolate time and will use the only currently existent data.
	 * Thus, for example, if currently a chart doesn't have data prior `2018-01-01` date and you set visible range with `from` date `2016-01-01`, it will be automatically adjusted to `2018-01-01` (and the same for `to` date).
	 *
	 * But if you can approximate indexes on your own - you could use {@link setVisibleLogicalRange} instead.
	 *
	 * @param range - Target visible range of data.
	 * @example
	 * ```js
	 * chart.timeScale().setVisibleRange({
	 *     from: (new Date(Date.UTC(2018, 0, 1, 0, 0, 0, 0))).getTime() / 1000,
	 *     to: (new Date(Date.UTC(2018, 1, 1, 0, 0, 0, 0))).getTime() / 1000,
	 * });
	 * ```
	 */
	setVisibleRange(range: TimeRange): void;
	/**
	 * Returns the current visible [logical range](/time-scale.md#logical-range) of the chart as an object with the first and last time points of the logical range, or returns `null` if the chart has no data.
	 *
	 * @returns Visible range or null if the chart has no data at all.
	 */
	getVisibleLogicalRange(): LogicalRange | null;
	/**
	 * Sets visible [logical range](/time-scale.md#logical-range) of data.
	 *
	 * @param range - Target visible logical range of data.
	 * @example
	 * ```js
	 * chart.timeScale().setVisibleLogicalRange({ from: 0, to: Date.now() / 1000 });
	 * ```
	 */
	setVisibleLogicalRange(range: Range<number>): void;
	/**
	 * Restores default zoom level and scroll position of the time scale.
	 */
	resetTimeScale(): void;
	/**
	 * Automatically calculates the visible range to fit all data from all series.
	 */
	fitContent(): void;
	/**
	 * Converts a logical index to local x coordinate.
	 *
	 * @param logical - Logical index needs to be converted
	 * @returns x coordinate of that time or `null` if the chart doesn't have data
	 */
	logicalToCoordinate(logical: Logical): Coordinate | null;
	/**
	 * Converts a coordinate to logical index.
	 *
	 * @param x - Coordinate needs to be converted
	 * @returns Logical index that is located on that coordinate or `null` if the chart doesn't have data
	 */
	coordinateToLogical(x: number): Logical | null;
	/**
	 * Converts a time to local x coordinate.
	 *
	 * @param time - Time needs to be converted
	 * @returns X coordinate of that time or `null` if no time found on time scale
	 */
	timeToCoordinate(time: Time): Coordinate | null;
	/**
	 * Converts a coordinate to time.
	 *
	 * @param x - Coordinate needs to be converted.
	 * @returns Time of a bar that is located on that coordinate or `null` if there are no bars found on that coordinate.
	 */
	coordinateToTime(x: number): Time | null;
	/**
	 * Returns a width of the time scale.
	 */
	width(): number;
	/**
	 * Returns a height of the time scale.
	 */
	height(): number;
	/**
	 * Subscribe to the visible time range change events.
	 *
	 * The argument passed to the handler function is an object with `from` and `to` properties of type {@link Time}, or `null` if there is no visible data.
	 *
	 * @param handler - Handler (function) to be called when the visible indexes change.
	 * @example
	 * ```js
	 * function myVisibleTimeRangeChangeHandler(newVisibleTimeRange) {
	 *     if (newVisibleTimeRange === null) {
	 *         // handle null
	 *     }
	 *
	 *     // handle new logical range
	 * }
	 *
	 * chart.timeScale().subscribeVisibleTimeRangeChange(myVisibleTimeRangeChangeHandler);
	 * ```
	 */
	subscribeVisibleTimeRangeChange(handler: TimeRangeChangeEventHandler): void;
	/**
	 * Unsubscribe a handler that was previously subscribed using {@link subscribeVisibleTimeRangeChange}.
	 *
	 * @param handler - Previously subscribed handler
	 * @example
	 * ```js
	 * chart.timeScale().unsubscribeVisibleTimeRangeChange(myVisibleTimeRangeChangeHandler);
	 * ```
	 */
	unsubscribeVisibleTimeRangeChange(handler: TimeRangeChangeEventHandler): void;
	/**
	 * Subscribe to the visible logical range change events.
	 *
	 * The argument passed to the handler function is an object with `from` and `to` properties of type `number`, or `null` if there is no visible data.
	 *
	 * @param handler - Handler (function) to be called when the visible indexes change.
	 * @example
	 * ```js
	 * function myVisibleLogicalRangeChangeHandler(newVisibleLogicalRange) {
	 *     if (newVisibleLogicalRange === null) {
	 *         // handle null
	 *     }
	 *
	 *     // handle new logical range
	 * }
	 *
	 * chart.timeScale().subscribeVisibleLogicalRangeChange(myVisibleLogicalRangeChangeHandler);
	 * ```
	 */
	subscribeVisibleLogicalRangeChange(handler: LogicalRangeChangeEventHandler): void;
	/**
	 * Unsubscribe a handler that was previously subscribed using {@link subscribeVisibleLogicalRangeChange}.
	 *
	 * @param handler - Previously subscribed handler
	 * @example
	 * ```js
	 * chart.timeScale().unsubscribeVisibleLogicalRangeChange(myVisibleLogicalRangeChangeHandler);
	 * ```
	 */
	unsubscribeVisibleLogicalRangeChange(handler: LogicalRangeChangeEventHandler): void;
	/**
	 * Adds a subscription to time scale size changes
	 *
	 * @param handler - Handler (function) to be called when the time scale size changes
	 */
	subscribeSizeChange(handler: SizeChangeEventHandler): void;
	/**
	 * Removes a subscription to time scale size changes
	 *
	 * @param handler - Previously subscribed handler
	 */
	unsubscribeSizeChange(handler: SizeChangeEventHandler): void;
	/**
	 * Applies new options to the time scale.
	 *
	 * @param options - Any subset of options.
	 */
	applyOptions(options: DeepPartial<TimeScaleOptions>): void;
	/**
	 * Returns current options
	 *
	 * @returns Currently applied options
	 */
	options(): Readonly<TimeScaleOptions>;
}
/**
 * Represents options for enabling or disabling kinetic scrolling with mouse and touch gestures.
 */
export interface KineticScrollOptions {
	/**
	 * Enable kinetic scroll with touch gestures.
	 *
	 * @defaultValue `true`
	 */
	touch: boolean;
	/**
	 * Enable kinetic scroll with the mouse.
	 *
	 * @defaultValue `false`
	 */
	mouse: boolean;
}
/** Represents layout options */
export interface LayoutOptions {
	/**
	 * Chart and scales background color.
	 *
	 * @defaultValue `{ type: ColorType.Solid, color: '#FFFFFF' }`
	 */
	background: Background;
	/**
	 * Color of text on the scales.
	 *
	 * @defaultValue `'#191919'`
	 */
	textColor: string;
	/**
	 * Font size of text on scales in pixels.
	 *
	 * @defaultValue `11`
	 */
	fontSize: number;
	/**
	 * Font family of text on the scales.
	 *
	 * @defaultValue `-apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif`
	 */
	fontFamily: string;
}
/**
 * Structure describing a single item of data for line series
 */
export interface LineData extends SingleValueData {
	/**
	 * Optional color value for certain data item. If missed, color from options is used
	 */
	color?: string;
}
/**
 * Represents style options for a line series.
 */
export interface LineStyleOptions {
	/**
	 * Line color.
	 *
	 * @defaultValue `'#2196f3'`
	 */
	color: string;
	/**
	 * Line style.
	 *
	 * @defaultValue {@link LineStyle.Solid}
	 */
	lineStyle: LineStyle;
	/**
	 * Line width in pixels.
	 *
	 * @defaultValue `3`
	 */
	lineWidth: LineWidth;
	/**
	 * Line type.
	 *
	 * @defaultValue {@link LineType.Simple}
	 */
	lineType: LineType;
	/**
	 * Show the crosshair marker.
	 *
	 * @defaultValue `true`
	 */
	crosshairMarkerVisible: boolean;
	/**
	 * Crosshair marker radius in pixels.
	 *
	 * @defaultValue `4`
	 */
	crosshairMarkerRadius: number;
	/**
	 * Crosshair marker border color. An empty string falls back to the the color of the series under the crosshair.
	 *
	 * @defaultValue `''`
	 */
	crosshairMarkerBorderColor: string;
	/**
	 * The crosshair marker background color. An empty string falls back to the the color of the series under the crosshair.
	 *
	 * @defaultValue `''`
	 */
	crosshairMarkerBackgroundColor: string;
	/**
	 * Crosshair marker border width in pixels.
	 *
	 * @defaultValue `2`
	 */
	crosshairMarkerBorderWidth: number;
	/**
	 * Last price animation mode.
	 *
	 * @defaultValue {@link LastPriceAnimationMode.Disabled}
	 */
	lastPriceAnimation: LastPriceAnimationMode;
}
/**
 * Represents options for formatting dates, times, and prices according to a locale.
 */
export interface LocalizationOptions {
	/**
	 * Current locale used to format dates. Uses the browser's language settings by default.
	 *
	 * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl#Locale_identification_and_negotiation
	 * @defaultValue `navigator.language`
	 */
	locale: string;
	/**
	 * Override formatting of the price scale crosshair label. Can be used for cases that can't be covered with built-in price formats.
	 *
	 * @see {@link PriceFormatCustom}
	 * @defaultValue `undefined`
	 */
	priceFormatter?: PriceFormatterFn;
	/**
	 * Override formatting of the time scale crosshair label.
	 *
	 * @defaultValue `undefined`
	 */
	timeFormatter?: TimeFormatterFn;
	/**
	 * Date formatting string.
	 *
	 * Can contain `yyyy`, `yy`, `MMMM`, `MMM`, `MM` and `dd` literals which will be replaced with corresponding date's value.
	 *
	 * Ignored if {@link timeFormatter} has been specified.
	 *
	 * @defaultValue `'dd MMM \'yy'`
	 */
	dateFormat: string;
}
/**
 * Represents a mouse event.
 */
export interface MouseEventParams {
	/**
	 * Time of the data at the location of the mouse event.
	 *
	 * The value will be `undefined` if the location of the event in the chart is outside the range of available data.
	 */
	time?: Time;
	/**
	 * Logical index
	 */
	logical?: Logical;
	/**
	 * Location of the event in the chart.
	 *
	 * The value will be `undefined` if the event is fired outside the chart, for example a mouse leave event.
	 */
	point?: Point;
	/**
	 * Data of all series at the location of the event in the chart.
	 *
	 * Keys of the map are {@link ISeriesApi} instances. Values are prices.
	 * Values of the map are original data items
	 */
	seriesData: Map<ISeriesApi<SeriesType>, BarData | LineData | HistogramData>;
	/**
	 * The {@link ISeriesApi} for the series at the point of the mouse event.
	 */
	hoveredSeries?: ISeriesApi<SeriesType>;
	/**
	 * The ID of the object at the point of the mouse event.
	 */
	hoveredObjectId?: unknown;
	/**
	 * The underlying source mouse or touch event data, if available
	 */
	sourceEvent?: TouchMouseEventData;
}
/**
 * Represents a bar with a {@link Time} and open, high, low, and close prices.
 */
export interface OhlcData {
	/**
	 * The bar time.
	 */
	time: Time;
	/**
	 * The open price.
	 */
	open: number;
	/**
	 * The high price.
	 */
	high: number;
	/**
	 * The low price.
	 */
	low: number;
	/**
	 * The close price.
	 */
	close: number;
}
/**
 * Represents a point on the chart.
 */
export interface Point {
	/**
	 * The x coordinate.
	 */
	readonly x: Coordinate;
	/**
	 * The y coordinate.
	 */
	readonly y: Coordinate;
}
/**
 * Represents series value formatting options.
 * The precision and minMove properties allow wide customization of formatting.
 *
 * @example
 * `minMove=0.01`, `precision` is not specified - prices will change like 1.13, 1.14, 1.15 etc.
 * @example
 * `minMove=0.01`, `precision=3` - prices will change like 1.130, 1.140, 1.150 etc.
 * @example
 * `minMove=0.05`, `precision` is not specified - prices will change like 1.10, 1.15, 1.20 etc.
 */
export interface PriceFormatBuiltIn {
	/**
	 * Built-in price formats:
	 * - `'price'` is the most common choice; it allows customization of precision and rounding of prices.
	 * - `'volume'` uses abbreviation for formatting prices like `1.2K` or `12.67M`.
	 * - `'percent'` uses `%` sign at the end of prices.
	 */
	type: "price" | "volume" | "percent";
	/**
	 * Number of digits after the decimal point.
	 * If it is not set, then its value is calculated automatically based on minMove.
	 *
	 * @defaultValue `2` if both {@link minMove} and {@link precision} are not provided, calculated automatically based on {@link minMove} otherwise.
	 */
	precision: number;
	/**
	 * The minimum possible step size for price value movement. This value shouldn't have more decimal digits than the precision.
	 *
	 * @defaultValue `0.01`
	 */
	minMove: number;
}
/**
 * Represents series value formatting options.
 */
export interface PriceFormatCustom {
	/**
	 * The custom price format.
	 */
	type: "custom";
	/**
	 * Override price formatting behaviour. Can be used for cases that can't be covered with built-in price formats.
	 */
	formatter: PriceFormatterFn;
	/**
	 * The minimum possible step size for price value movement.
	 *
	 * @defaultValue `0.01`
	 */
	minMove: number;
}
/**
 * Represents a price line options.
 */
export interface PriceLineOptions {
	/**
	 * The optional ID of this price line.
	 */
	id?: string;
	/**
	 * Price line's value.
	 *
	 * @defaultValue `0`
	 */
	price: number;
	/**
	 * Price line's color.
	 *
	 * @defaultValue `''`
	 */
	color: string;
	/**
	 * Price line's width in pixels.
	 *
	 * @defaultValue `1`
	 */
	lineWidth: LineWidth;
	/**
	 * Price line's style.
	 *
	 * @defaultValue {@link LineStyle.Solid}
	 */
	lineStyle: LineStyle;
	/**
	 * Display line.
	 *
	 * @defaultValue `true`
	 */
	lineVisible: boolean;
	/**
	 * Display the current price value in on the price scale.
	 *
	 * @defaultValue `true`
	 */
	axisLabelVisible: boolean;
	/**
	 * Price line's on the chart pane.
	 *
	 * @defaultValue `''`
	 */
	title: string;
	/**
	 * Background color for the axis label.
	 * Will default to the price line color if unspecified.
	 *
	 * @defaultValue `''`
	 */
	axisLabelColor: string;
	/**
	 * Text color for the axis label.
	 *
	 * @defaultValue `''`
	 */
	axisLabelTextColor: string;
}
/**
 * Represents a price range.
 */
export interface PriceRange {
	/**
	 * Maximum value in the range.
	 */
	minValue: number;
	/**
	 * Minimum value in the range.
	 */
	maxValue: number;
}
/** Defines margins of the price scale. */
export interface PriceScaleMargins {
	/**
	 * Top margin in percentages. Must be greater or equal to 0 and less than 1.
	 */
	top: number;
	/**
	 * Bottom margin in percentages. Must be greater or equal to 0 and less than 1.
	 */
	bottom: number;
}
/** Structure that describes price scale options */
export interface PriceScaleOptions {
	/**
	 * Autoscaling is a feature that automatically adjusts a price scale to fit the visible range of data.
	 * Note that overlay price scales are always auto-scaled.
	 *
	 * @defaultValue `true`
	 */
	autoScale: boolean;
	/**
	 * Price scale mode.
	 *
	 * @defaultValue {@link PriceScaleMode.Normal}
	 */
	mode: PriceScaleMode;
	/**
	 * Invert the price scale, so that a upwards trend is shown as a downwards trend and vice versa.
	 * Affects both the price scale and the data on the chart.
	 *
	 * @defaultValue `false`
	 */
	invertScale: boolean;
	/**
	 * Align price scale labels to prevent them from overlapping.
	 *
	 * @defaultValue `true`
	 */
	alignLabels: boolean;
	/**
	 * Price scale margins.
	 *
	 * @defaultValue `{ bottom: 0.1, top: 0.2 }`
	 * @example
	 * ```js
	 * chart.priceScale('right').applyOptions({
	 *     scaleMargins: {
	 *         top: 0.8,
	 *         bottom: 0,
	 *     },
	 * });
	 * ```
	 */
	scaleMargins: PriceScaleMargins;
	/**
	 * Set true to draw a border between the price scale and the chart area.
	 *
	 * @defaultValue `true`
	 */
	borderVisible: boolean;
	/**
	 * Price scale border color.
	 *
	 * @defaultValue `'#2B2B43'`
	 */
	borderColor: string;
	/**
	 * Price scale text color.
	 * If not provided {@link LayoutOptions.textColor} is used.
	 *
	 * @defaultValue `undefined`
	 */
	textColor?: string;
	/**
	 * Show top and bottom corner labels only if entire text is visible.
	 *
	 * @defaultValue `false`
	 */
	entireTextOnly: boolean;
	/**
	 * Indicates if this price scale visible. Ignored by overlay price scales.
	 *
	 * @defaultValue `true` for the right price scale and `false` for the left
	 */
	visible: boolean;
	/**
	 * Draw small horizontal line on price axis labels.
	 *
	 * @defaultValue `false`
	 */
	ticksVisible: boolean;
}
/**
 * Represents a generic range `from` one value `to` another.
 */
export interface Range<T> {
	/**
	 * The from value. The start of the range.
	 */
	from: T;
	/**
	 * The to value. The end of the range.
	 */
	to: T;
}
/**
 * Represents the type of data that a series contains.
 *
 * For example a bar series contains {@link BarData} or {@link WhitespaceData}.
 */
export interface SeriesDataItemTypeMap {
	/**
	 * The types of bar series data.
	 */
	Bar: BarData | WhitespaceData;
	/**
	 * The types of candlestick series data.
	 */
	Candlestick: CandlestickData | WhitespaceData;
	/**
	 * The types of area series data.
	 */
	Area: AreaData | WhitespaceData;
	/**
	 * The types of baseline series data.
	 */
	Baseline: BaselineData | WhitespaceData;
	/**
	 * The types of line series data.
	 */
	Line: LineData | WhitespaceData;
	/**
	 * The types of histogram series data.
	 */
	Histogram: HistogramData | WhitespaceData;
}
/**
 * Represents a series marker.
 */
export interface SeriesMarker<TimeType> {
	/**
	 * The time of the marker.
	 */
	time: TimeType;
	/**
	 * The position of the marker.
	 */
	position: SeriesMarkerPosition;
	/**
	 * The shape of the marker.
	 */
	shape: SeriesMarkerShape;
	/**
	 * The color of the marker.
	 */
	color: string;
	/**
	 * The ID of the marker.
	 */
	id?: string;
	/**
	 * The optional text of the marker.
	 */
	text?: string;
	/**
	 * The optional size of the marker.
	 *
	 * @defaultValue `1`
	 */
	size?: number;
}
/**
 * Represents options common for all types of series
 */
export interface SeriesOptionsCommon {
	/**
	 * Visibility of the label with the latest visible price on the price scale.
	 *
	 * @defaultValue `true`
	 */
	lastValueVisible: boolean;
	/**
	 * You can name series when adding it to a chart. This name will be displayed on the label next to the last value label.
	 *
	 * @defaultValue `''`
	 */
	title: string;
	/**
	 * Target price scale to bind new series to.
	 *
	 * @defaultValue `'right'` if right scale is visible and `'left'` otherwise
	 */
	priceScaleId?: string;
	/**
	 * Visibility of the series.
	 * If the series is hidden, everything including price lines, baseline, price labels and markers, will also be hidden.
	 * Please note that hiding a series is not equivalent to deleting it, since hiding does not affect the timeline at all, unlike deleting where the timeline can be changed (some points can be deleted).
	 *
	 * @defaultValue `true`
	 */
	visible: boolean;
	/**
	 * Show the price line. Price line is a horizontal line indicating the last price of the series.
	 *
	 * @defaultValue `true`
	 */
	priceLineVisible: boolean;
	/**
	 * The source to use for the value of the price line.
	 *
	 * @defaultValue {@link PriceLineSource.LastBar}
	 */
	priceLineSource: PriceLineSource;
	/**
	 * Width of the price line.
	 *
	 * @defaultValue `1`
	 */
	priceLineWidth: LineWidth;
	/**
	 * Color of the price line.
	 * By default, its color is set by the last bar color (or by line color on Line and Area charts).
	 *
	 * @defaultValue `''`
	 */
	priceLineColor: string;
	/**
	 * Price line style.
	 *
	 * @defaultValue {@link LineStyle.Dashed}
	 */
	priceLineStyle: LineStyle;
	/**
	 * Price format.
	 *
	 * @defaultValue `{ type: 'price', precision: 2, minMove: 0.01 }`
	 */
	priceFormat: PriceFormat;
	/**
	 * Visibility of base line. Suitable for percentage and `IndexedTo100` scales.
	 *
	 * @defaultValue `true`
	 */
	baseLineVisible: boolean;
	/**
	 * Color of the base line in `IndexedTo100` mode.
	 *
	 * @defaultValue `'#B2B5BE'`
	 */
	baseLineColor: string;
	/**
	 * Base line width. Suitable for percentage and `IndexedTo10` scales.
	 *
	 * @defaultValue `1`
	 */
	baseLineWidth: LineWidth;
	/**
	 * Base line style. Suitable for percentage and indexedTo100 scales.
	 *
	 * @defaultValue {@link LineStyle.Solid}
	 */
	baseLineStyle: LineStyle;
	/**
	 * Override the default {@link AutoscaleInfo} provider.
	 * By default, the chart scales data automatically based on visible data range.
	 * However, for some reasons one could require overriding this behavior.
	 *
	 * @defaultValue `undefined`
	 * @example Use price range from 0 to 100 regardless the current visible range
	 * ```js
	 * const firstSeries = chart.addLineSeries({
	 *     autoscaleInfoProvider: () => ({
	 *         priceRange: {
	 *             minValue: 0,
	 *             maxValue: 100,
	 *         },
	 *     }),
	 * });
	 * ```
	 * @example Adding a small pixel margins to the price range
	 * ```js
	 * const firstSeries = chart.addLineSeries({
	 *     autoscaleInfoProvider: () => ({
	 *         priceRange: {
	 *             minValue: 0,
	 *             maxValue: 100,
	 *         },
	 *         margins: {
	 *             above: 10,
	 *             below: 10,
	 *         },
	 *     }),
	 * });
	 * ```
	 * @example Using the default implementation to adjust the result
	 * ```js
	 * const firstSeries = chart.addLineSeries({
	 *     autoscaleInfoProvider: original => {
	 *         const res = original();
	 *         if (res !== null) {
	 *             res.priceRange.minValue -= 10;
	 *             res.priceRange.maxValue += 10;
	 *         }
	 *         return res;
	 *     },
	 * });
	 * ```
	 */
	autoscaleInfoProvider?: AutoscaleInfoProvider;
}
/**
 * Represents the type of options for each series type.
 *
 * For example a bar series has options represented by {@link BarSeriesOptions}.
 */
export interface SeriesOptionsMap {
	/**
	 * The type of bar series options.
	 */
	Bar: BarSeriesOptions;
	/**
	 * The type of candlestick series options.
	 */
	Candlestick: CandlestickSeriesOptions;
	/**
	 * The type of area series options.
	 */
	Area: AreaSeriesOptions;
	/**
	 * The type of baseline series options.
	 */
	Baseline: BaselineSeriesOptions;
	/**
	 * The type of line series options.
	 */
	Line: LineSeriesOptions;
	/**
	 * The type of histogram series options.
	 */
	Histogram: HistogramSeriesOptions;
}
/**
 * Represents the type of partial options for each series type.
 *
 * For example a bar series has options represented by {@link BarSeriesPartialOptions}.
 */
export interface SeriesPartialOptionsMap {
	/**
	 * The type of bar series partial options.
	 */
	Bar: BarSeriesPartialOptions;
	/**
	 * The type of candlestick series partial options.
	 */
	Candlestick: CandlestickSeriesPartialOptions;
	/**
	 * The type of area series partial options.
	 */
	Area: AreaSeriesPartialOptions;
	/**
	 * The type of baseline series partial options.
	 */
	Baseline: BaselineSeriesPartialOptions;
	/**
	 * The type of line series partial options.
	 */
	Line: LineSeriesPartialOptions;
	/**
	 * The type of histogram series partial options.
	 */
	Histogram: HistogramSeriesPartialOptions;
}
/**
 * A base interface for a data point of single-value series.
 */
export interface SingleValueData {
	/**
	 * The time of the data.
	 */
	time: Time;
	/**
	 * Price value of the data.
	 */
	value: number;
}
/**
 * Represents a solid color.
 */
export interface SolidColor {
	/**
	 * Type of color.
	 */
	type: ColorType.Solid;
	/**
	 * Color.
	 */
	color: string;
}
/**
 * Options for the time scale; the horizontal scale at the bottom of the chart that displays the time of data.
 */
export interface TimeScaleOptions {
	/**
	 * The margin space in bars from the right side of the chart.
	 *
	 * @defaultValue `0`
	 */
	rightOffset: number;
	/**
	 * The space between bars in pixels.
	 *
	 * @defaultValue `6`
	 */
	barSpacing: number;
	/**
	 * The minimum space between bars in pixels.
	 *
	 * @defaultValue `0.5`
	 */
	minBarSpacing: number;
	/**
	 * Prevent scrolling to the left of the first bar.
	 *
	 * @defaultValue `false`
	 */
	fixLeftEdge: boolean;
	/**
	 * Prevent scrolling to the right of the most recent bar.
	 *
	 * @defaultValue `false`
	 */
	fixRightEdge: boolean;
	/**
	 * Prevent changing the visible time range during chart resizing.
	 *
	 * @defaultValue `false`
	 */
	lockVisibleTimeRangeOnResize: boolean;
	/**
	 * Prevent the hovered bar from moving when scrolling.
	 *
	 * @defaultValue `false`
	 */
	rightBarStaysOnScroll: boolean;
	/**
	 * Show the time scale border.
	 *
	 * @defaultValue `true`
	 */
	borderVisible: boolean;
	/**
	 * The time scale border color.
	 *
	 * @defaultValue `'#2B2B43'`
	 */
	borderColor: string;
	/**
	 * Show the time scale.
	 *
	 * @defaultValue `true`
	 */
	visible: boolean;
	/**
	 * Show the time, not just the date, in the time scale and vertical crosshair label.
	 *
	 * @defaultValue `false`
	 */
	timeVisible: boolean;
	/**
	 * Show seconds in the time scale and vertical crosshair label in `hh:mm:ss` format for intraday data.
	 *
	 * @defaultValue `true`
	 */
	secondsVisible: boolean;
	/**
	 * Shift the visible range to the right (into the future) by the number of new bars when new data is added.
	 *
	 * Note that this only applies when the last bar is visible.
	 *
	 * @defaultValue `true`
	 */
	shiftVisibleRangeOnNewBar: boolean;
	/**
	 * Tick marks formatter can be used to customize tick marks labels on the time axis.
	 *
	 * @defaultValue `undefined`
	 */
	tickMarkFormatter?: TickMarkFormatter;
	/**
	 * Draw small vertical line on time axis labels.
	 *
	 * @defaultValue `false`
	 */
	ticksVisible: boolean;
}
/**
 * The TouchMouseEventData interface represents events that occur due to the user interacting with a
 * pointing device (such as a mouse).
 * See {@link https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent | MouseEvent}
 */
export interface TouchMouseEventData {
	/**
	 * The X coordinate of the mouse pointer in local (DOM content) coordinates.
	 */
	readonly clientX: Coordinate;
	/**
	 * The Y coordinate of the mouse pointer in local (DOM content) coordinates.
	 */
	readonly clientY: Coordinate;
	/**
	 * The X coordinate of the mouse pointer relative to the whole document.
	 */
	readonly pageX: Coordinate;
	/**
	 * The Y coordinate of the mouse pointer relative to the whole document.
	 */
	readonly pageY: Coordinate;
	/**
	 * The X coordinate of the mouse pointer in global (screen) coordinates.
	 */
	readonly screenX: Coordinate;
	/**
	 * The Y coordinate of the mouse pointer in global (screen) coordinates.
	 */
	readonly screenY: Coordinate;
	/**
	 * The X coordinate of the mouse pointer relative to the chart / price axis / time axis canvas element.
	 */
	readonly localX: Coordinate;
	/**
	 * The Y coordinate of the mouse pointer relative to the chart / price axis / time axis canvas element.
	 */
	readonly localY: Coordinate;
	/**
	 * Returns a boolean value that is true if the Ctrl key was active when the key event was generated.
	 */
	readonly ctrlKey: boolean;
	/**
	 * Returns a boolean value that is true if the Alt (Option or ⌥ on macOS) key was active when the
	 * key event was generated.
	 */
	readonly altKey: boolean;
	/**
	 * Returns a boolean value that is true if the Shift key was active when the key event was generated.
	 */
	readonly shiftKey: boolean;
	/**
	 * Returns a boolean value that is true if the Meta key (on Mac keyboards, the ⌘ Command key; on
	 * Windows keyboards, the Windows key (⊞)) was active when the key event was generated.
	 */
	readonly metaKey: boolean;
}
/**
 * Represent options for the tracking mode's behavior.
 *
 * Mobile users will not have the ability to see the values/dates like they do on desktop.
 * To see it, they should enter the tracking mode. The tracking mode will deactivate the scrolling
 * and make it possible to check values and dates.
 */
export interface TrackingModeOptions {
	/** @inheritDoc TrackingModeExitMode
	 *
	 * @defaultValue {@link TrackingModeExitMode.OnNextTap}
	 */
	exitMode: TrackingModeExitMode;
}
/**
 * Represents a vertical gradient of two colors.
 */
export interface VerticalGradientColor {
	/**
	 * Type of color.
	 */
	type: ColorType.VerticalGradient;
	/**
	 * Top color
	 */
	topColor: string;
	/**
	 * Bottom color
	 */
	bottomColor: string;
}
/** Watermark options. */
export interface WatermarkOptions {
	/**
	 * Watermark color.
	 *
	 * @defaultValue `'rgba(0, 0, 0, 0)'`
	 */
	color: string;
	/**
	 * Display the watermark.
	 *
	 * @defaultValue `false`
	 */
	visible: boolean;
	/**
	 * Text of the watermark. Word wrapping is not supported.
	 *
	 * @defaultValue `''`
	 */
	text: string;
	/**
	 * Font size in pixels.
	 *
	 * @defaultValue `48`
	 */
	fontSize: number;
	/**
	 * Font family.
	 *
	 * @defaultValue `-apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif`
	 */
	fontFamily: string;
	/**
	 * Font style.
	 *
	 * @defaultValue `''`
	 */
	fontStyle: string;
	/**
	 * Horizontal alignment inside the chart area.
	 *
	 * @defaultValue `'center'`
	 */
	horzAlign: HorzAlign;
	/**
	 * Vertical alignment inside the chart area.
	 *
	 * @defaultValue `'center'`
	 */
	vertAlign: VertAlign;
}
/**
 * Represents a whitespace data item, which is a data point without a value.
 *
 * @example
 * ```js
 * const data = [
 *     { time: '2018-12-03', value: 27.02 },
 *     { time: '2018-12-04' }, // whitespace
 *     { time: '2018-12-05' }, // whitespace
 *     { time: '2018-12-06' }, // whitespace
 *     { time: '2018-12-07' }, // whitespace
 *     { time: '2018-12-08', value: 23.92 },
 *     { time: '2018-12-13', value: 30.74 },
 * ];
 * ```
 */
export interface WhitespaceData {
	/**
	 * The time of the data.
	 */
	time: Time;
}
/**
 * Represents area series options.
 */
export type AreaSeriesOptions = SeriesOptions<AreaStyleOptions>;
/**
 * Represents area series options where all properties are optional.
 */
export type AreaSeriesPartialOptions = SeriesPartialOptions<AreaStyleOptions>;
/**
 * A custom function used to get autoscale information.
 *
 * @param baseImplementation - The default implementation of autoscale algorithm, you can use it to adjust the result.
 */
export type AutoscaleInfoProvider = (baseImplementation: () => AutoscaleInfo | null) => AutoscaleInfo | null;
/**
 * Represents the background color of the chart.
 */
export type Background = SolidColor | VerticalGradientColor;
/**
 * Represents a price as a `number`.
 */
export type BarPrice = Nominal<number, "BarPrice">;
/**
 * Represents bar series options.
 */
export type BarSeriesOptions = SeriesOptions<BarStyleOptions>;
/**
 * Represents bar series options where all properties are options.
 */
export type BarSeriesPartialOptions = SeriesPartialOptions<BarStyleOptions>;
/**
 * Represents a type of a base value of baseline series type.
 */
export type BaseValueType = BaseValuePrice;
/**
 * Structure describing baseline series options.
 */
export type BaselineSeriesOptions = SeriesOptions<BaselineStyleOptions>;
/**
 * Represents baseline series options where all properties are options.
 */
export type BaselineSeriesPartialOptions = SeriesPartialOptions<BaselineStyleOptions>;
/**
 * Represents candlestick series options.
 */
export type CandlestickSeriesOptions = SeriesOptions<CandlestickStyleOptions>;
/**
 * Represents candlestick series options where all properties are optional.
 */
export type CandlestickSeriesPartialOptions = SeriesPartialOptions<CandlestickStyleOptions>;
/**
 * Represents a coordiate as a `number`.
 */
export type Coordinate = Nominal<number, "Coordinate">;
/**
 * Price line options for the {@link ISeriesApi.createPriceLine} method.
 *
 * `price` is required, while the rest of the options are optional.
 */
export type CreatePriceLineOptions = Partial<PriceLineOptions> & Pick<PriceLineOptions, "price">;
/**
 * Represents a type `T` where every property is optional.
 */
export type DeepPartial<T> = {
	[P in keyof T]?: T[P] extends (infer U)[] ? DeepPartial<U>[] : T[P] extends readonly (infer X)[] ? readonly DeepPartial<X>[] : DeepPartial<T[P]>;
};
/**
 * Represents histogram series options.
 */
export type HistogramSeriesOptions = SeriesOptions<HistogramStyleOptions>;
/**
 * Represents histogram series options where all properties are optional.
 */
export type HistogramSeriesPartialOptions = SeriesPartialOptions<HistogramStyleOptions>;
/**
 * Represents a horizontal alignment.
 */
export type HorzAlign = "left" | "center" | "right";
/**
 * Represents line series options.
 */
export type LineSeriesOptions = SeriesOptions<LineStyleOptions>;
/**
 * Represents line series options where all properties are optional.
 */
export type LineSeriesPartialOptions = SeriesPartialOptions<LineStyleOptions>;
/**
 * Represents the width of a line.
 */
export type LineWidth = 1 | 2 | 3 | 4;
/**
 * Represents the `to` or `from` number in a logical range.
 */
export type Logical = Nominal<number, "Logical">;
/**
 * A logical range is an object with 2 properties: `from` and `to`, which are numbers and represent logical indexes on the time scale.
 *
 * The starting point of the time scale's logical range is the first data item among all series.
 * Before that point all indexes are negative, starting from that point - positive.
 *
 * Indexes might have fractional parts, for instance 4.2, due to the time-scale being continuous rather than discrete.
 *
 * Integer part of the logical index means index of the fully visible bar.
 * Thus, if we have 5.2 as the last visible logical index (`to` field), that means that the last visible bar has index 5, but we also have partially visible (for 20%) 6th bar.
 * Half (e.g. 1.5, 3.5, 10.5) means exactly a middle of the bar.
 */
export type LogicalRange = Range<Logical>;
/**
 * A custom function used to handle changes to the time scale's logical range.
 */
export type LogicalRangeChangeEventHandler = (logicalRange: LogicalRange | null) => void;
/**
 * A custom function use to handle mouse events.
 */
export type MouseEventHandler = (param: MouseEventParams) => void;
/**
 * This is the generic type useful for declaring a nominal type,
 * which does not structurally matches with the base type and
 * the other types declared over the same base type
 *
 * @example
 * ```ts
 * type Index = Nominal<number, 'Index'>;
 * // let i: Index = 42; // this fails to compile
 * let i: Index = 42 as Index; // OK
 * ```
 * @example
 * ```ts
 * type TagName = Nominal<string, 'TagName'>;
 * ```
 */
export type Nominal<T, Name extends string> = T & {
	/** The 'name' or species of the nominal. */
	[Symbol.species]: Name;
};
/**
 * Represents overlay price scale options.
 */
export type OverlayPriceScaleOptions = Omit<PriceScaleOptions, "visible" | "autoScale">;
/**
 * Represents information used to format prices.
 */
export type PriceFormat = PriceFormatBuiltIn | PriceFormatCustom;
/**
 * A function used to format a {@link BarPrice} as a string.
 */
export type PriceFormatterFn = (priceValue: BarPrice) => string;
/**
 * Represents the position of a series marker relative to a bar.
 */
export type SeriesMarkerPosition = "aboveBar" | "belowBar" | "inBar";
/**
 * Represents the shape of a series marker.
 */
export type SeriesMarkerShape = "circle" | "square" | "arrowUp" | "arrowDown";
/**
 * Represents the intersection of a series type `T`'s options and common series options.
 *
 * @see {@link SeriesOptionsCommon} for common options.
 */
export type SeriesOptions<T> = T & SeriesOptionsCommon;
/**
 * Represents a {@link SeriesOptions} where every property is optional.
 */
export type SeriesPartialOptions<T> = DeepPartial<T & SeriesOptionsCommon>;
/**
 * Represents a type of series.
 *
 * @see {@link SeriesOptionsMap}
 */
export type SeriesType = keyof SeriesOptionsMap;
/**
 * A custom function used to handle changes to the time scale's size.
 */
export type SizeChangeEventHandler = (width: number, height: number) => void;
/**
 * The `TickMarkFormatter` is used to customize tick mark labels on the time scale.
 *
 * This function should return `time` as a string formatted according to `tickMarkType` type (year, month, etc) and `locale`.
 *
 * Note that the returned string should be the shortest possible value and should have no more than 8 characters.
 * Otherwise, the tick marks will overlap each other.
 *
 * If the formatter function returns `null` then the default tick mark formatter will be used as a fallback.
 *
 * @example
 * ```js
 * const customFormatter = (time, tickMarkType, locale) => {
 *     // your code here
 * };
 * ```
 */
export type TickMarkFormatter = (time: Time, tickMarkType: TickMarkType, locale: string) => string | null;
/**
 * The Time type is used to represent the time of data items.
 *
 * Values can be a {@link UTCTimestamp}, a {@link BusinessDay}, or a business day string in ISO format.
 *
 * @example
 * ```js
 * const timestamp = 1529899200; // Literal timestamp representing 2018-06-25T04:00:00.000Z
 * const businessDay = { year: 2019, month: 6, day: 1 }; // June 1, 2019
 * const businessDayString = '2021-02-03'; // Business day string literal
 * ```
 */
export type Time = UTCTimestamp | BusinessDay | string;
/**
 * A custom function used to override formatting of a time to a string.
 */
export type TimeFormatterFn = (time: Time) => string;
/**
 * Represents a {@link Time} range.
 */
export type TimeRange = Range<Time>;
/**
 * A custom function used to handle changes to the time scale's time range.
 */
export type TimeRangeChangeEventHandler = (timeRange: TimeRange | null) => void;
/**
 * Represents a time as a UNIX timestamp.
 *
 * If your chart displays an intraday interval you should use a UNIX Timestamp.
 *
 * Note that JavaScript Date APIs like `Date.now` return a number of milliseconds but UTCTimestamp expects a number of seconds.
 *
 * Note that to prevent errors, you should cast the numeric type of the time to `UTCTimestamp` type from the package (`value as UTCTimestamp`) in TypeScript code.
 *
 * @example
 * ```ts
 * const timestamp = 1529899200 as UTCTimestamp; // Literal timestamp representing 2018-06-25T04:00:00.000Z
 * const timestamp2 = (Date.now() / 1000) as UTCTimestamp;
 * ```
 */
export type UTCTimestamp = Nominal<number, "UTCTimestamp">;
/**
 * Represents a vertical alignment.
 */
export type VertAlign = "top" | "center" | "bottom";
/**
 * Represents a visible price scale's options.
 *
 * @see {@link PriceScaleOptions}
 */
export type VisiblePriceScaleOptions = PriceScaleOptions;

export {};
