const $div = document.createElement('div')

function finder (criteria) {
  return function (node) {
    return Object.keys(criteria).every(key => {
      if (key === 'text') {
        const c = criteria[key]
        let val = node[key]

        // remove html tags
        $div.innerHTML = val
        val = $div.innerText

        if (isRegExp(c)) {
          return c.test(val)
        } else {
          return c === val
        }
      }

      const states = criteria[key]

      // it is possible to pass 'states' or 'state'
      if (key === 'state') {
        key = 'states'
      }

      return Object.keys(states).every(s => node[key][s] === states[s])
    })
  }
}

function isRegExp (val) {
  return val instanceof RegExp
}

function getAllChildren (source) {
  const result = []

  source.forEach(function collect (node) {
    result.push(node)

    if (node.children) {
      node.children.forEach(collect)
    }
  })

  return result
}

export default function find (source, criteria, deep = true) {
  if (!source || !source.length || !criteria) {
    return null
  }

  if (deep) {
    source = getAllChildren(source)
  }

  // find by index
  if (typeof criteria === 'number') {
    return source[criteria] || null
  }

  if (typeof criteria === 'string' || criteria instanceof RegExp) {
    criteria = {
      text: criteria
    }
  }

  if (typeof criteria !== 'function') {
    criteria = finder(criteria)
  }

  const result = source.filter(criteria)

  if (result.length) {
    return result
  }

  return null
}
